class TableConsejeros {
	constructor(service, excelTitle) {
		this.service = service;
		this.excelTitle = excelTitle;
		this.data = null;
		this.consejeros = [];
		this.listId = '';
		this.all = false;
	}

	setEvents(modality = 'tableModal') {
		let self = this;

		self.modality = modality;
		if(self.data) {
			self.renderTable();
		} else {
			self.requestData();
		}
	}

	requestData() {
		let self = this;

		// Valores de configuración
		let config = JSON.parse(atob(sessionStorage.getItem('STCMBackEnd:config')));
		let allowedCountries = JSON.parse(atob(sessionStorage['STCMBackEnd:userCountries']));

		let parameters = {
			admin: config.SYSNotifUser,
			country: allowedCountries.toString()
		};
		ajaxComunCallWithCallback(self.service, parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				self.data = ajaxReturn.result;
				self.listId = ajaxReturn.listId;
				self.renderTable();
			}
		});
	}

	markAll() {
		let self = this;

		self.all = true;
		self.renderTable();
		self.consejeros = [];
		for(let i = 0; i < self.data.length; i++) {
			// Obtener países permitidos
			let allowedCountries = JSON.parse(atob(sessionStorage['STCMBackEnd:userCountries']));
			if(allowedCountries.indexOf(self.data[i].country) == -1) {
				continue;
			}

			self.consejeros.push(self.data[i])
		}
	}

	unmarkAll() {
		let self = this;

		self.all = false;
		self.renderTable();
		self.consejeros = [];
	}

	renderTable() {
		let self = this;

		let gdpr = sessionStorage['STCMBackEnd:GDPR'];

		let nameSurnameHead = `
			<th scope="col" title="${pf.const.language.RSC123}">${pf.const.language.RSC123}</th>
			<th scope="col" title="${pf.const.language.RSC1626}">${pf.const.language.RSC1626}</th>
			<th scope="col" title="${pf.const.language.RSC1627}">${pf.const.language.RSC1627}</th>
		`;
		let nameSurnameFilter = `
			<td>userNombre</td>
			<td>userApellidos</td>
			<td>userApellidos2</td>
		`;

		// Control GDPR
		if(gdpr == '1') {
			nameSurnameHead = '';
			nameSurnameFilter = '';
		}

		let table = `
			<table id="tableConsejeros" class="table table-hover tRegs">
				<thead>
					<tr>
						<th scope="col" title="${pf.const.language.RSC366}">${pf.const.language.RSC366}</th>
						<th scope="col" title="${pf.const.language.RSC136}">${pf.const.language.RSC136}</th>
						${nameSurnameHead}
						<th scope="col" title="${pf.const.language.RSC550}">${pf.const.language.RSC550}</th>
					</tr>
				</thead>

				<thead class="filtersUser">
					<tr>
						<td>id</td>
						<td>userEmail</td>
						${nameSurnameFilter}
						<td>pais</td>
					</tr>
				</thead>

				<tbody>
		`;

		// El servicio 'getConsejerosSinClabe' solo devuelve un apellido
		// Obtener países permitidos
		let allowedCountries = JSON.parse(atob(sessionStorage['STCMBackEnd:userCountries']));
		let size = self.data.length;
		for(let i = 0; i < size; i++) {
			// Control de países permitidos
			if(allowedCountries.indexOf(self.data[i].country) == -1) {
				continue;
			}

			let nameSurnameBody = `
				<td class="text-truncate" title="${self.data[i].userNombre}">${((self.data[i].userNombre == '' || !self.data[i].userNombre) ? '-' : self.data[i].userNombre)}</td>
				<td class="text-truncate" title="${self.data[i].userApellidos}">${((self.data[i].userApellidos == '' || !self.data[i].userApellidos) ? '-' : self.data[i].userApellidos)}</td>
				<td class="text-truncate" title="${self.data[i].userApellidos2}">${((self.data[i].userApellidos2 == '' || !self.data[i].userApellidos2) ? '-' : self.data[i].userApellidos2)}</td>
			`;

			// Control GDPR
			if(gdpr == '1') {
				nameSurnameBody = '';
			}

			table += `
				<tr id="${self.data[i].id}" class="user_selected edit-group" data-id="${i}">
					<td class="text-truncate" title="${self.data[i].id}">${(self.data[i].id != '' ? self.data[i].id : '-')}</td>
					<td class="text-truncate" title="${self.data[i].userEmail}">${(self.data[i].userEmail != '' ? self.data[i].userEmail : '-')}</td>
					${nameSurnameBody}
					<td class="text-truncate" title="${self.data[i].country}">${((self.data[i].country == '' || !self.data[i].country) ? '-' : self.data[i].country)}</td>
				</tr>
			`;
		}

		table += `
				</tbody>
			</table>
		`;

		$('#resultTable').html(table);

		// Setup - add a text input to each footer cell
		$('#tableConsejeros .filtersUser td').each(function() {
			let title = $(this).text();
			let value = `<input type="text" class="form-control form-control-sm">`;

			if(title == 'enviar') {
				value = `<input type="text" class="form-control form-control-sm" disabled>`;
			}

			$(this).html(value);
		});

		let tableUsers = '';

		let columnDefs = [
			{width: '50px', targets: 5}
		];

		// Control GDPR
		if(gdpr == '1') {
			columnDefs = [
				{width: '50px', targets: 2}
			];
		}

		tableUsers = $('#tableConsejeros').DataTable({
			language: pf.const.language_table,
			autoWidth: false,
			aaSorting: [],
			columnDefs: columnDefs,
			pageLength: 25,
			dom: 'Bfrtip',
			buttons: [{
				extend: 'excelHtml5',
				text: pf.const.language.RSC129,
				className: 'btn secondary-button ma-le-5',
				title: self.excelTitle,
				customize(xlsx) {
					dataTablesExcelCustomize(xlsx);
				}
			}]
		});

		setTimeout(function() {
			tableUsers.columns.adjust();
		}, 200);

		$('.dataTables_filter').hide();

		$('#btn-actions').html(tableUsers.buttons().container());

		// Dar estilo al boton de excel
		$('.buttons-excel').removeClass('btn-secondary');
		$('.buttons-excel').attr('title', pf.const.language.RSC47);

		$('.buttons-excel').html(
			stcmbackend.svg.download + 
			`<span>${pf.const.language.RSC47}</span>`
		);

		// Apply the search
		applyTheSearch(tableUsers, 'filtersUser');
	}
}