class TableDictionary {
	constructor(actions, system = false) {
		this.actionsTable = actions;
		this.system = system;
		this.data = null;
	}

	setEvents() {
		let self = this;

		clearGeneralModal();

		if(self.data) {
			self.renderTable();
		} else {
			self.requestData();
		}
	}

	requestData() {
		let self = this;

		ajaxComunCallWithCallback('getAllVoiceassistantDictionary', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				self.data = ajaxReturn.result;

				self.renderTable();
			}
		});
	}

	renderTable() {
		let self = this;

		let table = `
			<table id="tableModal" class="table table-hover tRegs" >
				<thead>
					<tr>
						<th scope="col" title="${pf.const.language.RSC123}">${pf.const.language.RSC123}</th>
						<th scope="col" title="${pf.const.language.RSC550}">${pf.const.language.RSC550}</th>
					</tr>
				</thead>

				<thead class="filters">
					<tr>
						<td>nombre</td>
						<td>pais</td>
					</tr>
				</thead>

				<tbody>
		`;

		// Obtener países permitidos
		let allowedCountries = JSON.parse(atob(sessionStorage['STCMBackEnd:userCountries']));
		let size = self.data.length;
		for(let i = 0; i < size; i++) {
			// Control de países permitidos y/o si es de solo sistema
			if((self.data[i].country != '' && allowedCountries.indexOf(self.data[i].country) == -1) || (self.system && self.data[i].sistema != '1')) {
				continue;
			}

			table += `
				<tr id="${self.data[i].idDictionary}" class="mission_selected c-pointer" data-id="${i}" data-dismiss="modal">
					<td class="text-truncate" title="${self.data[i].description}">${self.data[i].description}</td>
					<td class="text-truncate" title="${self.data[i].country}">${self.data[i].country}</td>
				</tr>
			`;
		}

		table += `
				</tbody>
			</table>
		`;

		$('#headerModalTitle').text(pf.const.language.RSC2493);
		$('#divTableModal').html(table);

		// Setup - add a text input to each footer cell
		$('#tableModal .filters td').each(function() {
			let value = `<input type="text" class="form-control form-control-sm">`;

			$(this).html(value);
		});

		let tableModal = $('#tableModal').DataTable({
			language: pf.const.language_table,
			scrollY: 300,
			scroller: false,
			paging: true,
			pageLength: 25,
			autoWidth: false,
			aaSorting: []
		});

		setTimeout(function() {
			tableModal.columns.adjust();
		}, 200);

		// Ocultar botones de tabla
		hideTableButtons('tableModal');

		// Apply the search
		applyTheSearch(tableModal, 'filters');

		// Detectar click
		$('.mission_selected').click(function() {
			self.eventsTable($(this).data('id'));
		});
	}

	eventsTable(id) {
		let self = this;

		switch(self.actionsTable) {
			case 'UsuariosNuevoController':
				UsuariosNuevoController.clickEvents(self.data[id]);
				break;
			case 'UsuariosEditarController':
				UsuariosEditarController.clickEvents(self.data[id]);
				break;
			case 'VoiceAssistantNewController':
				VoiceAssistantNewController.clickEvents(self.data[id]);
				break;
			case 'VoiceAssistantEditController':
				VoiceAssistantEditController.clickEvents(self.data[id]);
				break;
		}
	}
}