class TableLists {
	constructor(type = 0, actions) {
		this.type = type;
		this.actionsTable = actions;
		this.data = null;
		this.modality = null;
	}

	setEvents(modality = 'tableModal', admin = null) {
		let self = this;

		self.modality = modality;
		if(admin) {
			self.data = admin
			self.renderTable();
		} else if(self.data) {
			self.renderTable();
		} else {
			self.requestData();
		}
	}

	requestData() {
		let self = this;

		clearGeneralModal();

		ajaxComunCallWithCallback('getAllDistributionList', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				self.data = ajaxReturn.result;
				self.renderTable();
			}
		});
	}

	renderTable() {
		let self = this;

		let table = `
			<table id="${this.modality}" class="table table-hover tr-pointer">
				<thead>
					<tr>
						<th scope="col" title="${pf.const.language.RSC366}">${pf.const.language.RSC366}</th>
						<th scope="col" title="${pf.const.language.RSC178}">${pf.const.language.RSC178}</th>
						<th scope="col" title="${pf.const.language.RSC163}">${pf.const.language.RSC163}</th>
						<th scope="col" title="${pf.const.language.RSC114}">${pf.const.language.RSC114}</th>
					</tr>
				</thead>

				<thead class="filtersUser">
					<tr>
						<td>id</td>
						<td>descripcion</td>
						<td>admin</td>
						<td>activa</td>
					</tr>
				</thead>

				<tbody>
		`;

		let size = self.data.length;
		for(let i = 0; i < size; i++) {
			table += `
				<tr id="${self.data[i].id}" class="user_selected edit-group" data-id="${i}">
					<td class="text-truncate" title="${self.data[i].id}">${self.data[i].id}</td>
					<td class="text-truncate" title="${self.data[i].Descripcion}">${self.data[i].Descripcion}</td>
					<td class="text-truncate" title="${self.data[i].Admin}">${self.data[i].Admin}</td>
					<td class="text-center">
						<span class="d-none">${(self.data[i].Activa == '1' ? pf.const.language.RSC120 : pf.const.language.RSC121)}</span>
						<input type="checkbox" disabled ${(self.data[i].Activa == '1' ? 'checked' : '')}>
					</td>
				</tr>
			`;
		}

		table += `
				</tbody>
			</table>
		`;

		if(this.modality == 'tableModal') {
			$('#headerModalTitle').text(pf.const.language.RSC12);
			$('#divTableModal').html(table);
		} else {
			$('#resultTable').html(table);
		}

		// Setup - add a text input to each footer cell
		$('#' + this.modality + ' .filtersUser td').each(function() {
			let title = $(this).text();
			let value = `<input type="text" class="form-control form-control-sm">`;

			if(title == 'activa') {
				value = optionsSelectAllYesNo();
			}

			$(this).html(value);
		});

		let tableUsers = '';
		if(self.modality != 'tableModal') {
			tableUsers = $('#' + this.modality).DataTable({
				language: pf.const.language_table,
				autoWidth: false,
				aaSorting: [],
				columnDefs: [
					{width: '30px', orderable: false, targets: 0}
				],
				retrieve: true,
				pageLength: 25,
				dom: 'Bfrtip',
				buttons: [{
					extend: 'excelHtml5',
					text: pf.const.language.RSC129,
					className: 'd-none',
					title: pf.const.language.RSC2,
					customize(xlsx) {
						dataTablesExcelCustomize(xlsx);
					}
				}]
			});
		} else {
			tableUsers = $('#' + this.modality).DataTable({
				language: pf.const.language_table,
				scrollY: 300,
				scroller: false,
				paging: true,
				pageLength: 25,
				autoWidth: false,
				aaSorting: [],
			});
		}

		setTimeout(function() {
			tableUsers.columns.adjust();
		}, 200);

		// Ocultar botones de tabla
		hideTableButtons(this.modality);

		// Apply the search
		applyTheSearch(tableUsers, 'filtersUser');

		if(self.modality != 'tableModal') {
			// Exportar tabla
			$('#exportUsers').off().on('click', function() {
				$('#resultTable .buttons-excel').trigger('click');
			});
		}

		if(self.type === 0) {
			// Detectar click
			$('#' + this.modality + ' tbody').off().on('click', 'tr', function() {
				self.eventsTable($(this).data('id'));
				$('#closeUser').trigger('click');
			});
		} else {
			// Si se necesitase el caso de selección múltiple
		}
	}

	eventsTable(id) {
		let self = this;

		let response = '';
		if(self.type === 0) {
			response = self.data[id];
		} else {
			response = self.members;
		}

		switch(self.actionsTable) {
			case 'newNotification':
				NotificacionesNuevaController.clickList(response);
				break;
			case 'editNotification':
				NotificacionesEditarController.clickList(response);
				break;
			case 'pagosAutomatizadosNew':
				PagosAutomatizadosNewController.clickList(response);
				break;
			case 'pagosAutomatizadosEdit':
				PagosAutomatizadosEditController.clickList(response);
				break;
		}
	}
}