class TableNoSystemRSC {
	constructor(type = 0, actions) {
		this.type = type;
		this.actionsTable = actions;
		this.data = null;
		this.modality = null;
	}

	setEvents(modality = 'tableModal') {
		let self = this;

		self.modality = modality;
		if(self.data) {
			self.renderTable();
		} else {
			self.requestRSC();
		}
	}

	requestRSC() {
		let self = this;

		clearGeneralModal();

		ajaxComunCallWithCallback('getAllRSC', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				self.data = ajaxReturn.result;
				self.renderTable();
			}
		});
	}

	renderTable() {
		let self = this;

		let language = sessionStorage['STCMBackEnd:lenguage'];

		let table = `
			<table id="${this.modality}" class="table table-hover tr-pointer tRegs">
				<thead>
					<tr>
						<th scope="col" title="${pf.const.language.RSC366}">${pf.const.language.RSC366}</th>
						<th scope="col" title="${language}">${language}</th>
					</tr>
				</thead>

				<thead class="filtersResult">
					<tr>
						<td>id</td>
						<td>language</td>
					</tr>
				</thead>

				<tbody>
		`;

		// Solo se mostrarán los RSC que no sean de sistema, excepto en PopUps
		if(self.actionsTable != 'PopUpsController') {
			self.data = self.data.filter((rsc) => rsc.system != 1);
		}

		let size = self.data.length;
		for(let i = 0; i < size; i++) {

			let languageRSC = self.data[i][language];

			table += `
				<tr id="id-${self.data[i].idRSC}" class="c-pointer rscElement" data-id="${self.data[i].idRSC}" data-text="${languageRSC}">
					<td title="${self.data[i].idRSC}">${self.data[i].idRSC}</td>
					<td title="${languageRSC}">${languageRSC}</td>
				</tr>
			`;
		}

		table += `
				</tbody>
			</table>
		`;

		if(this.modality == 'tableModal') {
			$('#headerModalTitle').text('RSC');
			$('#divTableModal').html(table);
		} else {
			$('#div' + this.modality).html(table);
		}

		// Setup - add a text input to each footer cell
		$('#' + this.modality + ' .filtersResult td').each(function() {
			let value = `<input type="text" class="form-control form-control-sm">`;

			$(this).html(value);
		});

		let scroll = 300;
		if(self.modality != 'tableModal') {
			scroll = 600;
		}

		let tableRSC = $('#' + this.modality).DataTable({
			language: pf.const.language_table,
			pageLength: 25,
			scrollY: scroll,
			scrollCollapse: true,
			autoWidth: false,
			aaSorting: []
		});

		setTimeout(function() {
			tableRSC.columns.adjust();
		}, 200);

		// Ocultar botones de tabla
		hideTableButtons(this.modality);

		// Apply the search
		applyTheSearch(tableRSC, 'filtersResult');

		// Detectar click
		$('#' + this.modality + ' tbody').off().on('click', 'tr', function() {
			self.eventsTable($(this).data('id'));
			$('#closeUser').trigger('click');
		});
	}

	eventsTable(id) {
		let self = this;
		let language = sessionStorage['STCMBackEnd:lenguage'];

		let response = self.data.find(rsc => rsc.idRSC == id);

		if(response) {
			response = {
				id: response.idRSC,
				descripcion: response[language]
			}
		}

		switch(self.actionsTable) {
			case 'openRSCWelcomeTour':
				WelcomeTourController.clickEvents(response);
				break;
			case 'PopUpsController':
				PopUpsController.clickEventsRSC(response);
				break;
		}
	}
}