class TablePayments {
	constructor(isImport = false) {
		this.data = null;
		this.receivedData = false;
		this.excel = true;
		this.clabe = false;
		this.isImport = isImport;
		this.stamps = [];
		this.tableUsers = null;
		this.import = false;
		this.exportedPayments = true;
		this.dataExcelHead = [];
		this.dataExcelBody = [];
		this.tableFlag = false;
	}

	setEvents() {
		let self = this;

		if(self.receivedData) {
			addLoader();
			self.renderTable();
			removeLoader();
		} else {
			self.requestData();
		}
	}

	getData() {
		return this.data;
	}

	requestData() {
		let self = this;

		let parameters = {
			country: PagosController.country,
			dateinit: PagosController.startDate + ' ' + PagosController.startTime,
			datefin: PagosController.endDate + ' ' + PagosController.endTime
		};
		ajaxComunCallWithCallback('getPagosPendientesByCountry', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				self.data = ajaxReturn.result;
				self.receivedData = true;

				$('#export').attr('disabled', false);
				$('#filterClabe').attr('disabled', false);

				self.renderTable();
			}
		});
	}

	renderTable() {
		let self = this;

		if(self.tableFlag) {
			$('#tablePaymenyts').dataTable().fnDestroy();
		} else {
			self.tableFlag = true;
		}

		let currentURL = window.location.href;

		let columnsHead = `
			<th scope="col" title="${pf.const.language.RSC308}">${pf.const.language.RSC308}</th>
			<th scope="col" title="${pf.const.language.RSC609}">${pf.const.language.RSC609}</th>
			<th scope="col" title="${pf.const.language.RSC610}">${pf.const.language.RSC610}</th>
		`;
		let columnsFilter = `
			<td class="d-none">clabeInte</td>
			<td class="d-none">tipoIdentificacion</td>
			<td class="d-none">identificacion</td>
		`;
		let yastasHead = '';
		let yastasFilter = '';
		if(currentURL.indexOf('yastas') != -1) {
			columnsHead = '';
			columnsFilter = '';
			yastasHead = `
				<th scope="col" title="CMR">CMR</th>
				<th scope="col" title="COB">COB</th>
				<th scope="col" title="SAHUAYO">SAHUAYO</th>
				<th scope="col" title="Comercio">Comercio</th>
				<th scope="col" title="Comisionista">Comisionista</th>
			`;
			yastasFilter = `
				<td class="d-none">cmr</td>
				<td class="d-none">cob</td>
				<td class="d-none">sahuayo</td>
				<td class="d-none">comercio</td>
				<td class="d-none">comisionista</td>
			`;
		}

		let table = `
			<table id="tablePaymenyts" class="table table-hover tRegs">
				<thead>
					<tr>
						<th scope="col" title="${pf.const.language.RSC1315}">${pf.const.language.RSC1315}</th>
						<th scope="col" title="${pf.const.language.RSC68}">${pf.const.language.RSC68}</th>
						<th scope="col" title="${pf.const.language.RSC560}">${pf.const.language.RSC560}</th>
						<th scope="col" title="${pf.const.language.RSC134}">${pf.const.language.RSC134}</th>
						<th scope="col" title="${pf.const.language.RSC123}">${pf.const.language.RSC123}</th>
						${columnsHead}
						<th scope="col" title="${pf.const.language.RSC348}">${pf.const.language.RSC348}</th>
						<th scope="col" title="${pf.const.language.RSC178}">${pf.const.language.RSC178}</th>
						<th scope="col" title="${pf.const.language.RSC349}">${pf.const.language.RSC349}</th>
						<th scope="col" title="${pf.const.language.RSC550}">${pf.const.language.RSC550}</th>
						<th scope="col" title="${pf.const.language.RSC607}">${pf.const.language.RSC607}</th>
						<th scope="col" title="${pf.const.language.RSC1229}">${pf.const.language.RSC1229}</th>
						<th scope="col" title="${pf.const.language.RSC1228}">${pf.const.language.RSC1228}</th>
						<th scope="col" title="${pf.const.language.RSC1235}">${pf.const.language.RSC1235}</th>
						<th scope="col" title="${pf.const.language.RSC1236}">${pf.const.language.RSC1236}</th>
						<th scope="col" title="${pf.const.language.RSC1227}">${pf.const.language.RSC1227}</th>
						${yastasHead}
						<th scope="col" title="${pf.const.language.RSC334}">${pf.const.language.RSC334}</th>
						<th scope="col" title="${pf.const.language.RSC350}">${pf.const.language.RSC350}</th>
						<th scope="col" title="${pf.const.language.RSC1240}">${pf.const.language.RSC1240}</th>
						<th scope="col" title="${pf.const.language.RSC1770}">${pf.const.language.RSC1770}</th>
						<th scope="col" title="${pf.const.language.RSC1335}">${pf.const.language.RSC1335}</th>
					</tr>
				</thead>

				<thead class="filtersUser">
					<tr>
						<td class="d-none">stamp</td>
						<td>user</td>
						<td>asesor</td>
						<td>perfil</td>
						<td>nombre</td>
						${columnsFilter}
						<td>concepto</td>
						<td>conceptoDesc</td>
						<td>valor</td>
						<td>Pais</td>
						<td class="d-none">ciudad</td>
						<td class="d-none">direccion</td>
						<td class="d-none">telefono</td>
						<td class="d-none">bancoReceptor</td>
						<td class="d-none">bancoReceptorDesc</td>
						<td class="d-none">tipoCuentaBancaria</td>
						${yastasFilter}
						<td>fecha</td>
						<td class="d-none">confirmacion</td>
						<td class="d-none">Comentarios</td>
						<td>estadoPago</td>
						<td>fechaExportacion</td>
					</tr>
				</thead>

				<tbody>
		`;

		// Información de administrador
		let JSONuser = sessionStorage['STCMBackEnd:user'];
		let userA = JSON.parse(JSONuser);
		let dateFormat = userA.formatoFecha;

		let size = self.data.length;
		for(let i = 0; i < size; i++) {

			if(!self.exportedPayments && self.data[i].exported == '1') {
				continue;
			}

			if(!self.clabe || self.data[i].clabeInterbancaria.length > 0) {
				let columnsBody = `
					<td class="text-truncate" title="${self.data[i].clabeInterbancaria}">${(self.data[i].clabeInterbancaria != '' ? self.data[i].clabeInterbancaria : '-')}</td>
					<td class="text-truncate" title="${PagosController.rscDataAll[self.data[i].tipoIdentificacionDesc]}">
						${PagosController.rscDataAll[self.data[i].tipoIdentificacionDesc]}
					</td>
					<td class="text-truncate" title="${self.data[i].userIdentificador}">
						${(self.data[i].userIdentificador != '' && self.data[i].userIdentificador != undefined ? self.data[i].userIdentificador : '-')}
					</td>
				`;
				let yastasBody = '';
				if(currentURL.indexOf('yastas') != -1) {
					columnsBody = '';
					yastasBody = `
						<td class="text-truncate" title="${self.data[i].yastas_id_cmr}">${(self.data[i].yastas_id_cmr != '' && self.data[i].yastas_id_cmr != undefined ? self.data[i].yastas_id_cmr : '-')}</td>
						<td class="text-truncate" title="${self.data[i].yastas_id_cob}">${(self.data[i].yastas_id_cob != '' && self.data[i].yastas_id_cob != undefined ? self.data[i].yastas_id_cob : '-')}</td>
						<td class="text-truncate" title="${self.data[i].yastas_id_sahuayo}">${(self.data[i].yastas_id_sahuayo != '' && self.data[i].yastas_id_sahuayo != undefined ? self.data[i].yastas_id_sahuayo : '-')}</td>
						<td class="text-truncate" title="${self.data[i].yastas_nombre_comercio}">${(self.data[i].yastas_nombre_comercio != '' && self.data[i].yastas_nombre_comercio != undefined ? self.data[i].yastas_nombre_comercio : '-')}</td>
						<td class="text-truncate" title="${self.data[i].yastas_nombre_comisionista}">${(self.data[i].yastas_nombre_comisionista != '' && self.data[i].yastas_nombre_comisionista != undefined ? self.data[i].yastas_nombre_comisionista : '-')}</td>
					`;
				}

				// Formato de fecha, el servicio devuelve DD/MM/AAAA HH:MM:SS
				let fechaMision = '-';
				let fechaMisionOrder = '-';
				if(self.data[i].fechaMision != '' && self.data[i].fechaMision != undefined) {
					let fechaMisionOrderArray = '';
					if(self.data[i].fechaMision.includes(' ')) {
						fechaMisionOrderArray = self.data[i].fechaMision.split(' ');
					} else {
						fechaMisionOrderArray = self.data[i].fechaMision;
					}

					// Para ordenación en columna
					fechaMisionOrder = modifyDateFormat(fechaMisionOrderArray[0]).replace(/\//g, '-');

					let fechaMisionArray = self.data[i].fechaMision;
					if(self.data[i].fechaMision.includes(' ')) {
						fechaMisionArray = self.data[i].fechaMision.split(' ');
					}
					let date = fechaMisionArray[0].replace(/-/g, '/');
					if(dateFormat === 'AAAAMMDD') {
						fechaMision = modifyDateFormat(date);
					} else {
						fechaMision = date;
					}
				}
				
				// Formato de fecha, el servicio devuelve AAAA-MM-DD HH:MM:SS
				let fecha = '';
				let fechaArray = '';
				if(self.data[i].fecha.includes(' ')) {
					fechaArray = self.data[i].fecha.split(' ');
				} else {
					fechaArray = self.data[i].fecha;
				}

				let fechaOrder = '';
				if(self.data[i].fecha.includes('/')) {
					// Para valores importados con el formato DD/MM/AAAA
					if(dateFormat === 'AAAAMMDD') {
						fecha = modifyDateFormat(fechaArray);

						// Para ordenación en columna
						fechaOrder = fecha;
					} else {
						fecha = self.data[i].fecha;

						// Para ordenación en columna
						fechaOrder = modifyDateFormat(fechaArray);
					}
				} else {
					let date = fechaArray[0].replace(/-/g, '/');
					if(dateFormat === 'DDMMAAAA') {
						fecha = modifyDateFormat(date) + ' ' + fechaArray[1];
					} else {
						fecha = date + ' ' + fechaArray[1];
					}
	
					// Para ordenación en columna
					fechaOrder = self.data[i].fecha.replace(' ', '');
				}

				table += `
					<tr class="c-pointer" data-id="${i}" data-stamp="${self.data[i].stamp}">
						<td class="text-truncate" title="${self.data[i].stamp}">${(self.data[i].stamp != '' ? self.data[i].stamp : '-')}</td>
						<td class="text-truncate" title="${self.data[i].user}" data-stamp="${self.data[i].stamp}">
							<input type="checkbox" class="selection mx-1"${(self.import ? ' checked disabled' : '')}>
							${(self.data[i].user != '' ? self.data[i].user : '-')}
						</td>
						<td class="text-center">
							<span class="d-none">${(self.data[i].enabled == '1' ? pf.const.language.RSC120 : pf.const.language.RSC121)}</span>
							<input type="checkbox" class="activa" disabled ${(self.data[i].enabled == '1' ? 'checked' : '')}>
						</td>
						<td class="text-truncate" title="${self.data[i].perfil}">${(self.data[i].perfil != '' ? self.data[i].perfil : '-')}</td>
						<td class="text-truncate" title="${self.data[i].name}">${(self.data[i].name != '' ? self.data[i].name : '-')}</td>
						${columnsBody}
						<td class="text-truncate" title="${self.data[i].sid}">${(self.data[i].sid != '' ? self.data[i].sid : '-')}</td>
						<td class="text-truncate" title="${self.data[i].concepto}">${(self.data[i].concepto != '' ? self.data[i].concepto : '-')}</td>
						<td class="text-truncate" title="${self.data[i].valor}">${(self.data[i].valor != '' ? self.data[i].valor : '-')}</td>
						<td class="text-truncate" title="${self.data[i].countrydesc}">${((self.data[i].countrydesc != '' && self.data[i].countrydesc) ? self.data[i].countrydesc : '-')}</td>
						<td class="text-truncate" title="${self.data[i].ciudad}">${(self.data[i].ciudad != '' ? self.data[i].ciudad : '-')}</td>
						<td class="text-truncate" title="${self.data[i].direccion}">${(self.data[i].direccion != '' ? self.data[i].direccion : '-')}</td>
						<td class="text-truncate" title="${self.data[i].telefono}">${(self.data[i].telefono != '' ? self.data[i].telefono : '-')}</td>
						<td class="text-truncate" title="${self.data[i].bancoReceptor}">${(self.data[i].bancoReceptor != '' && self.data[i].bancoReceptor != null ? self.data[i].bancoReceptor : '-')}</td>
						<td class="text-truncate" title="${self.data[i].bancoReceptorDesc}">${(self.data[i].bancoReceptorDesc != '' && self.data[i].bancoReceptorDesc != undefined ? self.data[i].bancoReceptorDesc : '-')}</td>
						<td class="text-truncate" title="${PagosController.rscDataAll[self.data[i].tipoCuentaBancariaDesc]}">${PagosController.rscDataAll[self.data[i].tipoCuentaBancariaDesc]}</td>
						${yastasBody}
						<td class="text-truncate" title="${fechaMision}">
							<span class="d-none">${fechaMisionOrder}</span>
							${fechaMision}
						</td>
						<td class="text-center">
							<span class="d-none">${(self.data[i].cobrado == '1' ? pf.const.language.RSC120 : pf.const.language.RSC121)}</span>
							<input type="checkbox" class="activa" disabled ${(self.data[i].cobrado == '1' ? 'checked' : '')}>
						</td>
						<td></td>
						<td class="text-truncate" title="${(self.data[i].exported == '1' ? pf.const.language.RSC1334 : pf.const.language.RSC1771)}">${(self.data[i].exported == '1' ? pf.const.language.RSC1334 : pf.const.language.RSC1771)}</td>
						<td class="text-truncate" title="${fecha}">
							<span class="d-none">${fechaOrder}</span>
							${fecha}
						</td>
					</tr>
				`;
			}
		}

		table += `
				</tbody>
			</table>
		`;

		$('#resultTable').html(table);

		// Setup - add a text input to each footer cell
		$('#tablePaymenyts .filtersUser td').each(function() {
			let title = $(this).text();
			let value = `<input type="text" class="form-control form-control-sm">`;

			if(title === 'confirmacion' || title === 'asesor') {
				value = optionsSelectAllYesNo();
			}

			$(this).html(value);
		});

		let cVisibility = [
			{visible: false},
			null,
			null,
			null,
			null,
			{visible: false},
			{visible: false},
			{visible: false},
			null,
			null,
			null,
			null,
			{visible: false},
			{visible: false},
			{visible: false},
			{visible: false},
			{visible: false},
			{visible: false},
			null,
			{visible: false},
			{visible: false},
			null,
			null
		];

		if(currentURL.indexOf('yastas') != -1) {
			cVisibility = [
				{visible: false},
				null,
				null,
				null,
				null,
				null,
				null,
				null,
				null,
				{visible: false},
				{visible: false},
				{visible: false},
				{visible: false},
				{visible: false},
				{visible: false},
				{visible: false},
				{visible: false},
				{visible: false},
				{visible: false},
				{visible: false},
				null,
				{visible: false},
				{visible: false},
				null,
				null
			];
		}

		self.tableUsers = $('#tablePaymenyts').DataTable({
			retrieve: true,
			language: pf.const.language_table,
			pageLength: 25,
			scrollCollapse: true,
			scroller: false,
			paging: true,
			autoWidth: false,
			columnDefs: [
				{width: '65', targets: 0},
				{width: '55', targets: 2}
			],
			aaSorting: [],
			lengthChange: false,
			columns: cVisibility
		});

		$('.dataTables_filter').hide();

		$('#btn-actions').html(self.tableUsers.buttons().container());

		// Activación de botón de exportar del navegador
		$('#export').off().on('click', function() {
			let data = self.tableUsers.rows().data();
			data.each(function(value, index) {
				if(value[1].indexOf('checked') !== -1) {
					if(self.stamps.indexOf(value[0].toString()) === -1) {
						self.stamps.push(value[0].toString());
					}
				}
			});

			let usersCheck = [];
			let size = self.data.length;
			for(let i = 0; i < size; i++) {
				if(self.stamps.indexOf(self.data[i].stamp.toString()) != -1) {
					usersCheck.push(self.data[i]);
				}
			}

			// Imprimir solo los seleccionados
			if(usersCheck.length > 0) {
				self.renderExport(usersCheck);
				self.setPagosPendientesExportados();
			} else {
				let warningTitle = pf.const.language.RSC16;
				let warningContent = pf.const.language.RSC1620;
				pf.utils.showInfoDialog(warningTitle, warningContent);
			}
		});

		// Activación de botón de pagos no procesables
		$('#pagosNoCobro').off().on('click', function() {
			let data = self.tableUsers.rows().data();
			data.each(function(value, index) {
				if(value[1].indexOf('checked') !== -1) {
					if(self.stamps.indexOf(value[0].toString()) === -1) {
						self.stamps.push(value[0].toString());
					}
				}
			});

			let usersCheck = [];
			let size = self.data.length;
			for(let i = 0; i < size; i++) {
				if(self.stamps.indexOf(self.data[i].stamp.toString()) != -1) {
					usersCheck.push(self.data[i]);
				}
			}

			// Imprimir solo los seleccionados
			if(usersCheck.length > 0) {
				let content = `
					<div class="form-group">
						<p>${pf.const.language.RSC1632}: ${usersCheck.length}</p>
						<label for="motivoNoCobro" class="fw-500">${pf.const.language.RSC382}</label>
						<input id="motivoNoCobro" type="text" class="form-control">
						<small class="form-text text-muted">${pf.const.language.RSC1637}</small>
					</div>
				`;

				let objInfo = {
					accept: {
						text: pf.const.language.RSC78
					},
					cancel: {
						text: pf.const.language.RSC57
					}
				};

				let alertTitle = pf.const.language.RSC1635;
				pf.utils.showInfoDialogAcceptCancel(alertTitle, content, objInfo, function() {
					let motivoText = $('#motivoNoCobro').val().trim();
						if(motivoText != '' && motivoText.length > 4) {
							// Envío de usuarios/pagos no procesables
							let noCobrablesArray = [];
							let size = usersCheck.length;
							for(let i = 0; i < size; i++) {
								if(usersCheck[i].user != '' && usersCheck[i].sid !== '') {
									let userString = usersCheck[i].user + '#' + usersCheck[i].sid + '#' + usersCheck[i].valor + '#' + usersCheck[i].concepto + '#' + usersCheck[i].stamp + '#1';
									noCobrablesArray.push(userString);
								}
							}
							self.setPagosNoCobrables(noCobrablesArray, motivoText);
						} else {
							let warningTitle = pf.const.language.RSC1635;
							let warningContent = pf.const.language.RSC1637;
							pf.utils.showInfoDialog(warningTitle, warningContent);
						}
				}, function() {});
			} else {
				let warningTitle = pf.const.language.RSC1635;
				let warningContent = pf.const.language.RSC1620;
				pf.utils.showInfoDialog(warningTitle, warningContent);
			}
		});

		// Apply the search
		applyTheSearch(self.tableUsers, 'filtersUser');

		// Marcar todo
		$('#checkFiltersRows').off().on('click', function() {
			self.tableUsers.rows({filter: 'applied'}).every(function(rowIdx, tableLoop, rowLoop) {
				let value = self.tableUsers.cell(rowIdx, 1).data();
				value = value.replace('<input type="checkbox" class="selection mx-1">', '<input type="checkbox" class="selection mx-1" checked>');
				self.tableUsers.cell(rowIdx, 1).data(value);
			}).draw();
		});

		// Desmarcar todo
		$('#uncheckRows').off().on('click', function() {
			self.tableUsers.rows().every(function(rowIdx, tableLoop, rowLoop) {
				let value = self.tableUsers.cell(rowIdx, 1).data();
				value = value.replace(/ checked=""| checked/g, '');
				self.tableUsers.cell(rowIdx, 1).data(value);
			}).draw();
			self.stamps = [];
		});

		// Inicialmente todos los registros marcados
		$('#checkFiltersRows').trigger('click');

		self.tableEvents();

		$('#tablePaymenyts').on('draw.dt', function() {
			self.tableEvents();
		});
	}

	tableEvents() {
		let self = this;

		// Seleccionar pago por tr
		$('#resultTable tbody tr').off().on('click', function() {
			let stamp = $(this).data('stamp');
			let checked = $(this).find('.selection').prop('checked');
			if(checked) {
				$(this).find('.selection').prop('checked', false);
				let index = self.stamps.indexOf(stamp);
				self.stamps.splice(index, 1);
			} else {
				$(this).find('.selection').prop('checked', true);
				self.stamps.push(stamp.toString());
			}
		});

		// Seleccionar pago por checbox
		$('.selection').off().on('click', function() {
			let checked = $(this).prop('checked');

			if(checked) {
				$(this).prop('checked', false);
			} else {
				$(this).prop('checked', true);
			}
		});
	}

	renderExport(usersCheck) {
		let self = this;

		let currentURL = window.location.href;
		// Limpieza de arrays
		self.dataExcelHead = [];
		self.dataExcelBody = [];

		let columnsHead = `
			<th>${pf.const.language.RSC308}</th>
			<th>${pf.const.language.RSC609}</th>
			<th>${pf.const.language.RSC610}</th>
		`;
		let columnsHeadExcel = [pf.const.language.RSC308, pf.const.language.RSC609, pf.const.language.RSC610];

		let yastasHead = '';
		let yastasHeadExcel = [];
		if(currentURL.indexOf('yastas') != -1) {
			columnsHead = '';
			columnsHeadExcel = [];
			yastasHead = `
				<th>CMR</th>
				<th>COB</th>
				<th>SAHUAYO</th>
				<th>Comercio</th>
				<th>Comisionista</th>
			`;
			yastasHeadExcel = ['CMR', 'COB', 'SAHUAYO', 'Comercio', 'Comisionista'];
		}

		let table = `
			<table id="tablePaymenytsExport">
				<thead>
					<tr>
						<th>${pf.const.language.RSC1315}</th>
						<th>${pf.const.language.RSC68}</th>
						<th>${pf.const.language.RSC134}</th>
						<th>${pf.const.language.RSC123}</th>
						${columnsHead}
						<th>${pf.const.language.RSC348}</th>
						<th>${pf.const.language.RSC178}</th>
						<th>${pf.const.language.RSC349}</th>
						<th>${pf.const.language.RSC550}</th>
						<th>${pf.const.language.RSC607}</th>
						<th>${pf.const.language.RSC1229}</th>
						<th>${pf.const.language.RSC1228}</th>
						<th>${pf.const.language.RSC1235}</th>
						<th>${pf.const.language.RSC1236}</th>
						<th>${pf.const.language.RSC1227}</th>
						${yastasHead}
						<th>${pf.const.language.RSC165}</th>
						<th>${pf.const.language.RSC350}</th>
						<th>${pf.const.language.RSC1240}</th>
					</tr>
				</thead>

				<tbody>
		`;

		// Creación de cabeceras para el excel
		let dataExcelHead_1 = [
			pf.const.language.RSC1315,
			pf.const.language.RSC68,
			pf.const.language.RSC134,
			pf.const.language.RSC123
		];
		let dataExcelHead_3 = [
			pf.const.language.RSC348,
			pf.const.language.RSC178,
			pf.const.language.RSC349,
			pf.const.language.RSC550,
			pf.const.language.RSC607,
			pf.const.language.RSC1229,
			pf.const.language.RSC1228,
			pf.const.language.RSC1235,
			pf.const.language.RSC1236,
			pf.const.language.RSC1227
		];
		let dataExcelHead_5 = [
			pf.const.language.RSC165,
			pf.const.language.RSC350,
			pf.const.language.RSC1240
		];

		self.dataExcelHead = dataExcelHead_1.concat(columnsHeadExcel, dataExcelHead_3, yastasHeadExcel, dataExcelHead_5);

		// Información de administrador
		let JSONuser = sessionStorage['STCMBackEnd:user'];
		let userA = JSON.parse(JSONuser);
		let dateFormat = userA.formatoFecha;

		let size = usersCheck.length;
		for(let i = 0; i < size; i++) {
			if(!self.clabe || usersCheck[i].clabeInterbancaria.length > 0) {
				let dataExcelBodyRow = [];

				// Formato de fecha, el servicio devuelve AAAA-MM-DD HH:MM:SS
				let startDate = '';
				let dateTimeArray = usersCheck[i].fecha.split(' ');
				let date = dateTimeArray[0].replace(/-/g, '/');
				if(dateFormat === 'DDMMAAAA') {
					startDate = modifyDateFormat(date);
				} else {
					startDate = date;
				}

				let columnsBody = `
					<td>${(usersCheck[i].clabeInterbancaria != '' ? usersCheck[i].clabeInterbancaria : '-')}</td>
					<td>${(usersCheck[i].tipoIdentificacionDesc == 'RSC' ? '-' : PagosController.rscDataAll[usersCheck[i].tipoIdentificacionDesc])}</td>
					<td>${(usersCheck[i].userIdentificador != '' && usersCheck[i].userIdentificador != undefined ? usersCheck[i].userIdentificador : '-')}</td>
				`;
				let columnsBodyExcel = [
					(usersCheck[i].clabeInterbancaria != '' ? usersCheck[i].clabeInterbancaria : '-'),
					(usersCheck[i].tipoIdentificacionDesc == 'RSC' ? '-' : PagosController.rscDataAll[usersCheck[i].tipoIdentificacionDesc]),
					(usersCheck[i].userIdentificador != '' && usersCheck[i].userIdentificador != undefined ? usersCheck[i].userIdentificador : '-')
				];

				let yastasBody = '';
				let yastasBodyExcel = [];
				if(currentURL.indexOf('yastas') != -1) {
					columnsBody = '';
					columnsBodyExcel = [];
					yastasBody = `
						<td>${(usersCheck[i].yastas_id_cmr != '' && usersCheck[i].yastas_id_cmr != undefined ? usersCheck[i].yastas_id_cmr : '-')}</td>
						<td>${(usersCheck[i].yastas_id_cob != '' && usersCheck[i].yastas_id_cob != undefined ? usersCheck[i].yastas_id_cob : '-')}</td>
						<td>${(usersCheck[i].yastas_id_sahuayo != '' && usersCheck[i].yastas_id_sahuayo != undefined ? usersCheck[i].yastas_id_sahuayo : '-')}</td>
						<td>${(usersCheck[i].yastas_nombre_comercio != '' && usersCheck[i].yastas_nombre_comercio != undefined ? usersCheck[i].yastas_nombre_comercio : '-')}</td>
						<td>${(usersCheck[i].yastas_nombre_comisionista != '' && usersCheck[i].yastas_nombre_comisionista != undefined ? usersCheck[i].yastas_nombre_comisionista : '-')}</td>
					`;
					yastasBodyExcel = [
						(usersCheck[i].yastas_id_cmr != '' && usersCheck[i].yastas_id_cmr != undefined ? usersCheck[i].yastas_id_cmr : '-'),
						(usersCheck[i].yastas_id_cob != '' && usersCheck[i].yastas_id_cob != undefined ? usersCheck[i].yastas_id_cob : '-'),
						(usersCheck[i].yastas_id_sahuayo != '' && usersCheck[i].yastas_id_sahuayo != undefined ? usersCheck[i].yastas_id_sahuayo : '-'),
						(usersCheck[i].yastas_nombre_comercio != '' && usersCheck[i].yastas_nombre_comercio != undefined ? usersCheck[i].yastas_nombre_comercio : '-'),
						(usersCheck[i].yastas_nombre_comisionista != '' && usersCheck[i].yastas_nombre_comisionista != undefined ? usersCheck[i].yastas_nombre_comisionista : '-')
					];
				}

				table += `
					<tr>
						<td>${(usersCheck[i].stamp != '' ? usersCheck[i].stamp : '-')}</td>
						<td>${(usersCheck[i].user != '' ? usersCheck[i].user : '-')}</td>
						<td>${(usersCheck[i].perfil != '' ? usersCheck[i].perfil : '-')}</td>
						<td>${(usersCheck[i].name != '' ? usersCheck[i].name : '-')}</td>
						${columnsBody}
						<td>${(usersCheck[i].sid != '' ? usersCheck[i].sid : '-')}</td>
						<td>${(usersCheck[i].concepto != '' ? usersCheck[i].concepto : '-')}</td>
						<td>${(usersCheck[i].valor != '' ? usersCheck[i].valor : '-')}</td>
						<td>${((usersCheck[i].countrydesc != '' && usersCheck[i].countrydesc) ? usersCheck[i].countrydesc : '-')}</td>
						<td>${(usersCheck[i].ciudad != '' ? usersCheck[i].ciudad : '-')}</td>
						<td>${(usersCheck[i].direccion != '' ? usersCheck[i].direccion : '-')}</td>
						<td>${(usersCheck[i].telefono != '' ? usersCheck[i].telefono : '-')}</td>
						<td>${(usersCheck[i].bancoReceptor != '' && usersCheck[i].bancoReceptor != null ? usersCheck[i].bancoReceptor : '-')}</td>
						<td>${(usersCheck[i].bancoReceptorDesc != '' && usersCheck[i].bancoReceptorDesc != undefined ? usersCheck[i].bancoReceptorDesc : '-')}</td>
						<td>${(usersCheck[i].tipoCuentaBancariaDesc == 'RSC' ? '-' : PagosController.rscDataAll[usersCheck[i].tipoCuentaBancariaDesc])}</td>
						${yastasBody}
						<td>${(startDate != '' ? startDate : '-')}</td>
						<td>${(usersCheck[i].cobrado == '1' ? '1' : '0')}</td>
						<td></td>
					</tr>
				`;

				// Creación de cuerpo de datos para el excel
				let dataExcelBody_1 = [
					(usersCheck[i].stamp != '' ? usersCheck[i].stamp : '-'),
					(usersCheck[i].user != '' ? usersCheck[i].user : '-'),
					(usersCheck[i].perfil != '' ? usersCheck[i].perfil : '-'),
					(usersCheck[i].name != '' ? usersCheck[i].name : '-')
				];
				let dataExcelBody_3 = [
					(usersCheck[i].sid != '' ? usersCheck[i].sid : '-'),
					(usersCheck[i].concepto != '' ? usersCheck[i].concepto : '-'),
					(usersCheck[i].valor != '' ? usersCheck[i].valor : '-'),
					((usersCheck[i].countrydesc != '' && usersCheck[i].countrydesc) ? usersCheck[i].countrydesc : '-'),
					(usersCheck[i].ciudad != '' ? usersCheck[i].ciudad : '-'),
					(usersCheck[i].direccion != '' ? usersCheck[i].direccion : '-'),
					(usersCheck[i].telefono != '' ? usersCheck[i].telefono : '-'),
					(usersCheck[i].bancoReceptor != '' && usersCheck[i].bancoReceptor != null ? usersCheck[i].bancoReceptor : '-'),
					(usersCheck[i].bancoReceptorDesc != '' && usersCheck[i].bancoReceptorDesc != undefined ? usersCheck[i].bancoReceptorDesc : '-'),
					(usersCheck[i].tipoCuentaBancariaDesc == 'RSC' ? '-' : PagosController.rscDataAll[usersCheck[i].tipoCuentaBancariaDesc])
				];
				let dataExcelBody_5 = [
					(startDate != '' ? startDate : '-'),
					(usersCheck[i].cobrado == '1' ? '1' : '0'),
					''
				];
				dataExcelBodyRow = dataExcelBody_1.concat(columnsBodyExcel, dataExcelBody_3, yastasBodyExcel, dataExcelBody_5);
				self.dataExcelBody.push(dataExcelBodyRow);
			}
		}

		table += `
				</tbody>
			</table>
		`;

		$('#exportTable').html(table);

		let date = new Date();

		let day = date.getDate();
		if(day < 10) {
			day = '0' + day;
		}

		let month = parseInt(date.getMonth()) + 1;
		if(month < 10) {
			month = '0' + month;
		}

		let year = date.getFullYear();

		let filename = 'dispersion_' + stcm.const.name + '_' + year + month + day;

		let tableUsers = $('#tablePaymenytsExport').DataTable({
			retrieve: true,
			language: pf.const.language_table,
			aaSorting: [],
			dom: 'Bfrtip',
			buttons: [{
				extend: 'excelHtml5',
				text: pf.const.language.RSC129,
				className: 'd-none',
				title: null,
				exportOptions: {
					format: {
						body(data, row, column, node) {
							let dev = '';
							if((column === 4 || column === 13) && currentURL.indexOf('yastas') == -1) {
								dev = '\0' + data;
							} else if(column === 1) {
								dev = data.replace(/<\/?[^>]+(>|$)/g, '');
							} else if(column === 18 && currentURL.indexOf('yastas') == -1) {
								dev = data.replace(/<\/?[^>]+(>|$)/g, '');
							} else if(column === 20 && currentURL.indexOf('yastas') != -1) {
								dev = data.replace(/<\/?[^>]+(>|$)/g, '');
							} else {
								dev = data;
							}
							return dev;
						}
					}
				},
				filename: filename,
				/* customize(xlsx) {
					dataTablesExcelCustomize(xlsx);
				} */
			}],
		});

		// Ocultar botones de tabla
		hideTableButtons('tablePaymenytsExport');

		$('#exportTable .buttons-excel').trigger('click');
		$('#exportTable').html('');

		self.sendExcelDataToServer();
	}

	setPagosPendientesExportados() {
		let self = this;

		let parameters = {
			stamp: self.stamps
		};
		ajaxComunCallWithCallback('setPagosPendientesExportados', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				//
			}
		});
	}

	getStampsToPay() {
		let self = this;

		let data = self.tableUsers.rows().data();
		data.each(function(value, index) {
			if(value[1].indexOf('checked') !== -1) {
				if(self.stamps.indexOf(value[0].toString()) === -1) {
					self.stamps.push(value[0].toString());
				}
			}
		});

		return self.stamps;
	}

	setPagosNoCobrables(noCobrablesArray, motivoText) {
		let parameters = {
			motivo: motivoText,
			idUseridSurvey: JSON.stringify(noCobrablesArray)
		};
		ajaxComunCallWithCallback('setPagosNoCobrables', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				// Pagos no cobrables enviados correctamente
				let successTitle = pf.const.language.RSC16;
				let successContent = pf.const.language.RSC1656;
				pf.utils.showInfoDialog(successTitle, successContent);
				loadHTML('inc/pagos/pagos.html', 'wrapper', PagosController);
			}
		});
	}

	sendExcelDataToServer() {
		let self = this;

		let date = new Date();
		let stampName = date.getTime();
		let JSONuser = sessionStorage['STCMBackEnd:user'];
		let user = JSON.parse(JSONuser);
		let userMail = user.email;

		let parameters = {
			stampName: stampName,
			userMail: userMail,
			dataExcelHead: JSON.stringify(self.dataExcelHead),
			dataExcelBody: JSON.stringify(self.dataExcelBody)
		};
		ajaxComunCallWithCallback('sendExcelDataToServer', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				// Archivo guardado correctamente
				console.log('Data excel send.');
			}
		});
	}
}