let TableProductsMision = {
	data: null,
	type: null,
	idRender: null,
	tableProducts: null,
	amount: null,

	resetData() {
		let self = this;

		self.data = null;
		self.type = null;
		self.idRender = null;
		self.tableProducts = null;
		self.amount = null;
	},

	setEvents(data, id, type, amount = false) {
		let self = this;
		self.resetData();

		// Tipo seleccion
		self.data = data;
		self.idRender = id;
		self.type = type;
		self.amount = amount;
		self.renderTable();
	},

	renderTable() {
		let self = this;

		let contentTable = '';
		let colRemove = '<th scope="col"></th>';
		let idTable = 'tableProducts';

		let secondElement = `<th scope="col">${pf.const.language.RSC1045}</th>`;
		if(self.amount) {
			secondElement = `<th scope="col">${pf.const.language.RSC145}</th>`;
		}

		contentTable += `
			<table id="${idTable}" class="table table-hover tRegs">
				<thead>
					<tr>
						<th scope="col">${pf.const.language.RSC1044}</th>
						${secondElement}
						<th scope="col">${pf.const.language.RSC1048}</th>
						${colRemove}
					</tr>
				</thead>

				<tbody>
		`;

		if(self.data) {
			$.each(self.data, function(i, elem) {
				let value = '';
				if(self.amount) {
					if(self.data[i].orderproductnumitems) {
						value = parseFloat(self.data[i].orderproductnumitems);
					} else {
						value = 1;
					}
				} else {
					if(self.data[i].orderproductnumitems) {
						value = parseInt(self.data[i].orderproductnumitems);
					} else {
						value = 1;
					}
				}

				colRemove = `
					<td data-id="${i}" class="remove-product text-center">
						<span class="c-pointer circle-container" data-id="${i}">
							${stcmbackend.svg.trash}
						</span>
					</td>
				`;

				contentTable += `
					<tr class="user_selected c-pointer" data-id="${i}">
						<td class="text-truncate productCode" title="${self.data[i].code}">${self.data[i].code}</td>
						<td class="text-truncate align-middle productNumber">
							<input type="number" class="form-control inputGrid numberProducts" value="${value}" data-index="${i}"> 
						</td>
						<td class="text-truncate productUnit" title="${self.data[i].packaging}">${self.data[i].packaging}</td>
						${colRemove}
					</tr>
				`;
			});
		}

		contentTable += `
				</tbody>
			</table>
		`;

		$('#' + self.idRender).html(contentTable);

		self.tableProducts = '';

		self.tableProducts = $('#' + idTable).DataTable({
			language: pf.const.language_table,
			retrieve: true,
			pageLength: 25,
			autoWidth: false,
			columnDefs: [
				{width: '30px', orderable: false, targets: 3}
			]
		});

		// Ocultar botones de tabla
		hideTableButtons(idTable);

		// Input de número de productos
		$('.numberProducts').off().on('blur', function() {
			let index = $(this).data('index');
			let value = $(this).val();

			if(value < 1) {
				value = 1;
				$(this).val(1);
			}

			self.data[index]['orderproductnumitems'] = value;
		});

		$('.remove-product').click(function() {
			let id = $(this).data('id');
			self.eventsTable(id);
		});
	},

	eventsTable(id) {
		let self = this;
		switch(self.type) {
			case 'newMision':
				MisionesNewController.clickEvents(id, 'removeProduct');
				break;
			case 'newMisionAmount':
				MisionesNewController.clickEvents(id, 'removeProductAmount');
				break;

			case 'newMisionEdit':
				MisionesEditController.clickEvents(id, 'removeProduct');
				break;
			case 'editMisionAmount':
				MisionesEditController.clickEvents(id, 'removeProductAmount');
				break;

			case 'newMissionSBS':
				StepByStepMissionNewController.clickEvents(id, 'removeProduct');
				break;
			case 'newMissionAmountSBS':
				StepByStepMissionNewController.clickEvents(id, 'removeProductAmount');
				break;

			case 'editMissionSBS':
				StepByStepMissionEditController.clickEvents(id, 'removeProduct');
				break;
			case 'editMissionAmountSBS':
				StepByStepMissionEditController.clickEvents(id, 'removeProductAmount');
				break;
		}
	}
};