let TableProyectos = {
	data: null,
	request: null,

	setEvents(request) {
		let self = this;

		// Acciones tabla
		self.request = request;

		if(self.data) {
			self.renderTable();
		} else {
			self.requestData();
		}
	},

	requestData() {
		let self = this;

		ajaxComunCallWithCallback('getCMBPProjects', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				self.data = ajaxReturn.result;
				self.renderTable();
			}
		});
	},

	renderTable() {
		let self = this;

		let table = `
			<table id="tableModal" class="table table-hover tr-pointer" >
				<thead>
					<tr>
						<th scope="col" title="${pf.const.language.RSC123}">${pf.const.language.RSC123}</th>
						<th scope="col" title="${pf.const.language.RSC550}">${pf.const.language.RSC550}</th>
						<th scope="col" title="${pf.const.language.RSC143}">${pf.const.language.RSC143}</th>
						<th scope="col" title="${pf.const.language.RSC144}">${pf.const.language.RSC144}</th>
						<th scope="col" title="${pf.const.language.RSC113}">${pf.const.language.RSC113}</th>
					</tr>
				</thead>

				<thead class="filtersResult">
					<tr>
						<td>name</td>
						<td>pais</td>
						<td>leader</td>
						<td>client</td>
						<td>creationDate</td>
					</tr>
				</thead>

				<tbody>
		`;

		// Obtener países permitidos
		let allowedCountries = JSON.parse(atob(sessionStorage['STCMBackEnd:userCountries']));

		let size = self.data.length;
		for(let i = 0; i < size; i++) {
			// Control de países permitidos
			if(self.data[i].country != '' && allowedCountries.indexOf(self.data[i].country) == -1) {
				continue;
			}

			// Para ordenación en columna
			let fechaDeAltaOrder = self.data[i].FechaDeAlta.replace(' ', '');

			// Formato de fecha, el servicio devuelve AAAA-MM-DD HH:MM:SS
			let dateTime = '';
			let dateTimeArray = self.data[i].FechaDeAlta.split(' ');
			let date = dateTimeArray[0].replace(/-/g, '/');
			if(self.dateFormat === 'DDMMAAAA') {
				dateTime = modifyDateFormat(date);
			} else {
				dateTime = date;
			}

			table += `
				<tr class="project_selected c-pointer" data-id="${i}" data-dismiss="modal">
					<td class="text-truncate" title="${self.data[i].NombreProyecto}">${self.data[i].NombreProyecto}</td>
					<td class="text-truncate" title="${self.data[i].country}">${self.data[i].country}</td>
					<td class="text-truncate" title="${self.data[i].LiderProyecto}">${self.data[i].LiderProyecto}</td>
					<td class="text-truncate" title="${self.data[i].ClienteInterno}">${self.data[i].ClienteInterno}</td>
					<td class="text-truncate" title="${dateTime}">
						<span class="d-none">${fechaDeAltaOrder}</span>
						${dateTime}
					</td>
				</tr>
			`;
		}

		table += `
				</tbody>
			</table>
		`;

		$('#headerModalTitle').text(pf.const.language.RSC10);
		$('#divTableModal').html(table);

		// Setup - add a text input to each footer cell
		$('#tableModal .filtersResult td').each(function() {
			let value = `<input type="text" class="form-control form-control-sm">`;

			$(this).html(value);
		});

		let tableUsers = $('#tableModal').DataTable({
			language: pf.const.language_table,
			scrollY: 300,
			scroller: false,
			paging: true,
			pageLength: 25,
			autoWidth: false,
			order: [[4, 'desc']]
		});

		setTimeout(function() {
			tableUsers.columns.adjust();
		}, 200);

		// Ocultar botones de tabla
		hideTableButtons('tableModal');

		// Apply the search
		applyTheSearch(tableUsers, 'filtersResult');

		// Detectar click
		$('.project_selected').click(function() {
			self.eventsTable($(this).data('id'));
		})
	},

	eventsTable(id) {
		let self = this;

		switch(self.request) {
			case 'proyectStepByStep':
				init.proyectStepByStep(self.data[id]);
				break;
		}
	}
};