class TableQuestions {
	constructor(type = 0, actions, survey) {
		this.type = type;
		this.actionsTable = actions;
		this.survey = survey;
		this.init = false;
		this.data = null;
		this.modality = null;
		this.id = '';
		this.name = '';
		this.qType = '';
	}

	setEvents(modality = 'tableModal') {
		let self = this;

		self.modality = modality;

		if(self.data) {
			self.renderTable();
		} else {
			self.requestData();
		}
	}

	requestData() {
		let self = this;

		clearGeneralModal();

		let parameters = {
			survey: self.survey
		};
		ajaxComunCallWithCallback('getQuestionsSurvey', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				self.data = ajaxReturn.result;
				if(self.data) {
					// Comprobar si es la petición de inicio
					if(self.init) {
						self.numOfQuestions();
					} else {
						self.renderTable();
					}
				}
			}
		});
	}

	renderTable() {
		let self = this;

		let table = `
			<table id="${this.modality}" class="table table-hover tr-pointer tRegs">
				<thead>
					<tr>
						<th scope="col" title="${pf.const.language.RSC366}">${pf.const.language.RSC366}</th>
						<th scope="col" title="${pf.const.language.RSC122}">${pf.const.language.RSC122}</th>
						<th scope="col" title="${pf.const.language.RSC111}">${pf.const.language.RSC111}</th>
					</tr>
				</thead>

				<thead class="filtersQuest">
					<tr>
						<td>columnName</td>
						<td>section</td>
						<td>question</td>
					</tr>
				</thead>

				<tbody>
		`;

		let size = self.data.length;
		for(let i = 0; i < size; i++) {
			let question = self.data[i].question.replace('/...', '');

			// Limpieza de marcas de html
			let textWithTags = self.data[i].question;
			let tagsWithoutTags = textWithTags.replace(/<[^>]*>?/g, '');
			
			if(self.data[i].type == 'H' || self.data[i].type == 'K' || (self.data[i].type == 'F' && self.data[i].valuesSQ.length > 0)) {
				let sizeK = self.data[i].valuesSQ.length;
				for(let j = 0; j < sizeK; j++) {
					let valuesSQArray = self.data[i].valuesSQ[j].split('|');
					let columnNameK = valuesSQArray[0];
					let questionK = tagsWithoutTags.trim() + ' - ' + valuesSQArray[1].replace(';', '');
					table += `
						<tr class="c-pointer" data-order="j${(i + 1)}" data-type="normal" data-id="${columnNameK}" data-name="${questionK}" data-qtype="${self.data[i].type}">
							<td id="${self.data[i].group_name}" class="columnName" title="${columnNameK}">${columnNameK}</td>
							<td title="${self.data[i].group_name}">${self.data[i].group_name}</td>
							<td class="question" title="${questionK}">${questionK}</td>
						</tr>
					`;
				}
			} else if(self.data[i].type == '6') {
				let sizeK = self.data[i].valuesSQ.length - 1;
				let valuesSQArray = self.data[i].valuesSQ[sizeK].split('|');
				let columnNameK = valuesSQArray[0];
				let questionK = tagsWithoutTags.trim() + ' - ' + valuesSQArray[1].replace(';', '');
				table += `
					<tr class="c-pointer" data-order="j${(i + 1)}" data-type="normal" data-id="${columnNameK}" data-name="${questionK}" data-qtype="${self.data[i].type}">
						<td id="${self.data[i].group_name}" class="columnName" title="${columnNameK}">${columnNameK}</td>
						<td title="${self.data[i].group_name}">${self.data[i].group_name}</td>
						<td class="question" title="${questionK}">${questionK}</td>
					</tr>
				`;
			} else if(self.data[i].type == ':') {
				table += `
				<tr class="c-pointer" data-order="${(i + 1)}" data-type="twoPoints" data-id="${self.data[i].columnName}" data-name="${question}" data-qtype="${self.data[i].type}">
					<td id="${self.data[i].title}" class="columnName" title="${self.data[i].columnName}">${self.data[i].columnName}</td>
					<td title="${self.data[i].group_name}">${self.data[i].group_name}</td>
					<td class="question" title="${question}">${question}</td>
				</tr>
			`;
			} else {
				table += `
					<tr class="c-pointer" data-order="${(i + 1)}" data-type="normal" data-id="${self.data[i].columnName}" data-name="${question}" data-qtype="${self.data[i].type}">
						<td id="${self.data[i].title}" class="columnName" title="${self.data[i].columnName}">${self.data[i].columnName}</td>
						<td title="${self.data[i].group_name}">${self.data[i].group_name}</td>
						<td class="question" title="${question}">${question}</td>
					</tr>
				`;
			}
		}

		table += `
				</tbody>
			</table>
		`;

		if(this.modality === 'tableModal') {
			$('#headerModalTitle').text(pf.const.language.RSC109);
			$('#divTableModal').html(table);
		} else {
			$('#resultTable').html(table);
		}

		// Setup - add a text input to each footer cell
		$('#' + this.modality + ' .filtersQuest td').each(function() {
			$(this).html('<input type="text" class="form-control form-control-sm">');
		});

		let tableQuest = '';
		if(self.modality === 'tableModal') {
			tableQuest = $('#' + this.modality).DataTable({
				language: pf.const.language_table,
				scrollY: 300,
				scroller: false,
				paging: true,
				pageLength: 25,
				columnDefs: [
					{width: '200px', targets: 0},
					{width: '200px', targets: 1}
				],
				autoWidth: false,
				aaSorting: []
			});
		} else {
			// Si se necesitase el caso de crear la tabla en página
		}

		setTimeout(function() {
			tableQuest.columns.adjust();
		}, 200);

		// Ocultar botones de tabla
		hideTableButtons(this.modality);

		// Apply the search
		applyTheSearch(tableQuest, 'filtersQuest');

		if(self.type === 0) {
			// Detectar click
			$('#' + this.modality + ' tbody').off().on('click', 'tr', function() {
				self.id = $(this).data('id');
				self.name = $(this).data('name');
				self.qType = $(this).data('qtype');
				self.eventsTable();
				$('#closeUser').trigger('click');
			});
		} else {
			// Si se necesitase el caso de selección múltiple
		}
	}

	eventsTable() {
		let self = this;

		let response = {
			id: self.id,
			name: self.name,
			type: self.qType
		};

		switch(self.actionsTable) {
			case 'KPISurvey':
				KPISurveysController.clickSurvey(response);
				break;
		}
	}

	numOfQuestions() {
		let self = this;

		let number = self.data.length;

		KPISurveysController.numOfQuestions(number);
	}
}