let TableRoles = {
	data: null,
	type: null,
	idRender: null,
	isAdmin: null,

	setEvents(data, id, type) {
		let self = this;

		// Tipo seleccion
		self.data = data;
		self.idRender = id;
		self.type = type;
		self.renderTable();
	},

	renderTable() {
		let self = this;

		let contentTable = stcmbackend.roles.rolesTable(self.data, true);

		$('#' + self.idRender).html(contentTable);

		// Setup - add a text input to each footer cell
		$('#rolesTable .filtersResult td').each(function() {
			let title = $(this).text();
			let value = optionsSelectAllYesNo();

			if(title == 'permission') {
				value = `<input type="text" class="form-control form-control-sm">`;
			}

			$(this).html(value);
		});

		let tableUsers = $('#rolesTable').DataTable({
			retrieve: true,
			language: pf.const.language_table,
			paging: false,
			search: true,
			autoWidth: false,
			columnDefs: [
				{width: '70px', orderable: false, targets: 1}
			],
			dom: 'Bfrtip',
			buttons: [{
				extend: 'excelHtml5',
				text: pf.const.language.RSC224,
				className: 'd-none',
				title: pf.const.language.RSC224,
				customize(xlsx) {
					dataTablesExcelCustomize(xlsx);
				}
			}]
		});

		// Ocultar botones de tabla
		hideTableButtons('rolesTable');

		// Exportar tabla
		$('#exportPermissions').off().on('click', function() {
			$('#' + self.idRender + ' .buttons-excel').trigger('click');
		});

		// Apply the search
		applyTheSearch(tableUsers, 'filtersResult');

		// Si todos los checkbox están seleccionados, se selecciona el checkbox principal, y viceversa
		// Comprobación inicial
		if($('.uSwitch').length == $('.uSwitch:checked').length) {
			$('#allSwitchs').prop('checked', true);
		} else {
			$('#allSwitchs').prop('checked', false);
		}

		// La id del elemento principal modifica los elementos secundarios a través de su clase
		$('#allSwitchs').on('click', function() {
			$('.uSwitch').prop('checked', this.checked);
		});

		// Si todos los checkbox están seleccionados, se selecciona el checkbox principal, y viceversa
		$('.uSwitch').on('click', function() {
			if($('.uSwitch').length == $('.uSwitch:checked').length) {
				$('#allSwitchs').prop('checked', true);
			} else {
				$('#allSwitchs').prop('checked', false);
			}
		});

		$('.remove-member').click(function() {
			let id = $(this).data('id');

			self.eventsTable(id);
		});
	},

	eventsTable(id) {
		let self = this;
		switch(self.type) {
			case 'editUsers':
				UsuariosEditarController.clickEvents(id, 'removeGroup');
				break;
		}
	}
};