class TableSurveys {
	constructor(type = 0, actions) {
		this.type = type;
		this.actionsTable = actions;
		this.data = null;
		this.modality = null;
	}

	setEvents(modality = 'tableModal', admin = null) {
		let self = this;

		clearGeneralModal();

		self.modality = modality;
		if(admin) {
			self.data = admin
			self.renderTable();
		} else if(self.data) {
			self.renderTable();
		} else {
			self.requestData();
		}
	}

	requestData() {
		let self = this;

		clearGeneralModal();

		ajaxComunCallWithCallback('getAllSurveys', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				self.data = ajaxReturn.result;
				self.renderTable();
			}
		});
	}

	renderTable() {
		let self = this;

		let table = `
			<table id="${this.modality}" class="table table-hover tr-pointer tRegs">
				<thead>
					<tr>
						<th scope="col" title="${pf.const.language.RSC366}">${pf.const.language.RSC366}</th>
						<th scope="col" title="${pf.const.language.RSC112}">${pf.const.language.RSC112}</th>
						<th scope="col" title="${pf.const.language.RSC113}">${pf.const.language.RSC113}</th>
						<th scope="col" title="${pf.const.language.RSC114}">${pf.const.language.RSC114}</th>
						<th scope="col" title="${pf.const.language.RSC115}">${pf.const.language.RSC115}</th>
						<th scope="col" title="${pf.const.language.RSC116}">${pf.const.language.RSC116}</th>
						<th scope="col" title="${pf.const.language.RSC163}">${pf.const.language.RSC163}</th>
						<th scope="col" title="${pf.const.language.RSC118}">${pf.const.language.RSC118}</th>

					</tr>
				</thead>

				<thead class="filtersUser">
					<tr>
						<td>sid</td>
						<td>surveyls_title</td>
						<td>datacreated</td>
						<td>active</td>
						<td>perfilacion</td>
						<td>startdate</td>
						<td>expires</td>
						<td>remuneracion</td>
					</tr>
				</thead>

				<tbody>
		`;

		let size = self.data.length;
		for(let i = 0; i < size; i++) {
			table += `
				<tr id="${self.data[i].sid}" data-id="${i}" class="user_selected edit-group">
					<td class="text-truncate" title="${self.data[i].sid}">${self.data[i].sid}</td>
					<td class="text-truncate" title="${self.data[i].surveyls_title}">${self.data[i].surveyls_title}</td>
					<td class="text-truncate" title="${self.data[i].datecreated}">${self.data[i].datecreated}</td>
					<td class="text-center">
						<span class="d-none">${(self.data[i].active == '1' ? pf.const.language.RSC120 : pf.const.language.RSC121)}</span>
						<input type="checkbox" disabled ${(self.data[i].active == '1' ? 'checked' : '')}>
					</td>
					<td class="text-center">
						<span class="d-none">${(self.data[i].perfilacion == '1' ? pf.const.language.RSC120 : pf.const.language.RSC121)}</span>
						<input type="checkbox" disabled ${(self.data[i].perfilacion == '1' ? 'checked' : '')}>
					</td>
					<td class="text-truncate" title="${self.data[i].startdate}">${self.data[i].startdate}</td>
					<td class="text-truncate" title="${self.data[i].expires}">${self.data[i].expires}</td>
					<td class="text-center" title="${self.data[i].remuneracion}">${self.data[i].remuneracion}</td>
				</tr>
			`;
		}

		table += `
				</tbody>
			</table>
		`;

		if(this.modality == 'tableModal') {
			$('#headerModalTitle').text(pf.const.language.RSC1782);
			$('#divTableModal').html(table);
		} else {
			$('#resultTable').html(table);
		}

		// Setup - add a text input to each footer cell
		$('#' + this.modality + ' .filtersUser td').each(function() {
			let title = $(this).text();
			let value = `<input type="text" class="form-control form-control-sm">`;

			if(title == 'active' || title == 'perfilacion') {
				value = optionsSelectAllYesNo();
			}

			$(this).html(value);
		});

		let tableUsers = '';
		if(self.modality != 'tableModal') {
			tableUsers = $('#' + this.modality).DataTable({
				language: pf.const.language_table,
				scrollY: 300,
				scroller: false,
				paging: true,
				pageLength: 25,
				autoWidth: false,
				aaSorting: [],
				columnDefs: [
					{width: '30px', orderable: false, targets: 0}
				],
				retrieve: true,
				dom: 'Bfrtip',
				buttons: [{
					extend: 'excelHtml5',
					text: pf.const.language.RSC129,
					className: 'd-none',
					title: pf.const.language.RSC2,
					customize(xlsx) {
						dataTablesExcelCustomize(xlsx);
					}
				}]
			});
		} else {
			tableUsers = $('#' + this.modality).DataTable({
				language: pf.const.language_table,
				scrollY: 300,
				scroller: false,
				paging: true,
				pageLength: 25,
				columnDefs: [
					{width: '50px', targets: 0},
					{width: '65px', targets: 3},
					{width: '95px', targets: 4},
					{width: '120px', targets: 7}
				],
				autoWidth: false,
				aaSorting: []
			});
		}

		setTimeout(function() {
			tableUsers.columns.adjust();
		}, 200);

		// Ocultar botones de tabla
		hideTableButtons(this.modality);

		// Apply the search
		applyTheSearch(tableUsers, 'filtersUser');

		if(self.modality != 'tableModal') {
			// Exportar tabla
			$('#exportUsers').off().on('click', function() {
				$('#resultTable .buttons-excel').trigger('click');
			});
		}

		if(self.type === 0) {
			// Detectar click
			$('#' + this.modality + ' tbody').off().on('click', 'tr', function() {
				self.eventsTable($(this).data('id'));
				$('#closeUser').trigger('click');
			});
		} else {
			// Si se necesitase el caso de selección múltiple
		}
	}

	eventsTable(id) {
		let self = this;

		let response = '';
		if(self.type === 0) {
			response = self.data[id];
		} else {
			response = self.members;
		}

		switch(self.actionsTable) {
			case 'newNotification':
				NotificacionesNuevaController.clickSurvey(response);
				break;
			case 'editNotification':
				NotificacionesEditarController.clickSurvey(response);
				break;
			case 'editCountries':
				PaisesEditController.clickSurvey(response);
				break;
			case 'newSegmentation':
				SegmentacionesNewController.clickSurvey(response);
				break;
			case 'editSegmentation':
				SegmentacionesEditController.clickSurvey(response);
				break;
			case 'KPISurvey':
				KPISurveysController.clickSurvey(response);
				break;
			case 'CDPSurvey':
				CDPController.clickSurvey(response);
				break;
		}
	}
}