class TableTenant {
	constructor(actions) {
		this.actionsTable = actions;
		this.data = null;
	}

	setEvents() {
		let self = this;

		if(self.data) {
			self.renderTable();
		} else {
			self.requestData();
		}
	}

	requestData() {
		let self = this;

		ajaxComunCallWithCallback('getAllTenants', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				self.data = ajaxReturn.result;
				self.renderTable();
			}
		});
	}

	renderTable() {
		let self = this;

		let table = `
			<table id="tableModal" class="table table-hover tr-pointer" >
				<thead>
					<tr>
						<th scope="col" title="${pf.const.language.RSC366}">${pf.const.language.RSC366}</th>
						<th scope="col" title="${pf.const.language.RSC550}">${pf.const.language.RSC550}</th>
						<th scope="col" title="${pf.const.language.RSC1540}">${pf.const.language.RSC1540}</th>
						<th scope="col" title="${pf.const.language.RSC1541}">${pf.const.language.RSC1541}</th>
						<th scope="col" title="${pf.const.language.RSC1542}">${pf.const.language.RSC1542}</th>
						<th scope="col" title="${pf.const.language.RSC126}">${pf.const.language.RSC126}</th>
					</tr>
				</thead>

				<thead class="filtersTenant">
					<tr>
						<td>id</td>
						<td>pais</td>
						<td>razonSocial</td>
						<td>nombreComercial</td>
						<td>identFiscal</td>
						<td>activo</td>
					</tr>
				</thead>

				<tbody>
		`;

		// Obtener países permitidos
		let allowedCountries = JSON.parse(atob(sessionStorage['STCMBackEnd:userCountries']));
		let size = self.data.length;
		for(let i = 0; i < size; i++) {
			// Control de países permitidos
			if(self.data[i].country != '' && allowedCountries.indexOf(self.data[i].country) == -1) {
				continue;
			}

			table += `
				<tr class="tenant_selected c-pointer" data-id="${i}" data-dismiss="modal">
					<td class="text-truncate" title="${self.data[i].idTenant}">${self.data[i].idTenant}</td>
					<td class="text-truncate" title="${self.data[i].country}">${self.data[i].country}</td>
					<td class="text-truncate" title="${self.data[i].razonSocial}">${self.data[i].razonSocial}</td>
					<td class="text-truncate" title="${self.data[i].nombreComercial}">${self.data[i].nombreComercial}</td>
					<td class="text-truncate" title="${self.data[i].identFiscal}">${self.data[i].identFiscal}</td>
					<td class="text-center">
						<span class="d-none">${(self.data[i].activo == '1' ? pf.const.language.RSC120 : pf.const.language.RSC121)}</span>
						<input type="checkbox" class="activa" disabled ${(self.data[i].activo == '1' ? 'checked' : '')}>
					</td>
				</tr>
			`;
		}

		table += `
				</tbody>
			</table>
		`;

		$('#headerModalTitle').text(pf.const.language.RSC2494);
		$('#divTableModal').html(table);

		// Setup - add a text input to each footer cell
		$('#tableModal .filtersTenant td').each(function() {
			let title = $(this).text();
			let value = `<input type="text" class="form-control form-control-sm">`;

			if(title == 'activo') {
				value = optionsSelectAllYesNo();
			}

			$(this).html(value);
		});

		let tableTenant = $('#tableModal').DataTable({
			language: pf.const.language_table,
			scrollY: 300,
			scroller: false,
			paging: true,
			pageLength: 25,
			columnDefs: [
				{width: '30px', targets: 0},
				{width: '60px', targets: 1}
			],
			autoWidth: false,
			aaSorting: []
		});

		setTimeout(function() {
			tableTenant.columns.adjust();
		}, 200);

		// Ocultar botones de tabla
		hideTableButtons('tableModal');

		// Apply the search
		applyTheSearch(tableTenant, 'filtersTenant');

		// Detectar click
		$('.tenant_selected').click(function() {
			self.eventsTable($(this).data('id'));
		});
	}

	eventsTable(id) {
		let self = this;

		switch(self.actionsTable) {
			case 'newAdministradorTenant':
				AdministradoresNuevoController.clickEvents(self.data[id]);
				break;
			case 'editAdministradorTenant':
				AdministradoresEditarController.clickEvents(self.data[id]);
				break;
		}
	}
}