let TemplatesController = {
	user: null,
	language: null,
	data: null,
	arrayDelMult: [],

	reset() {
		let self = this;

		self.user = null;
		self.language = pf.const.language_table;
		self.data = null;
		self.arrayDelMult = [];
	},

	setEvents() {
		let self = this;
		self.reset();

		let JSONuser = sessionStorage['STCMBackEnd:user'];
		let user = JSON.parse(JSONuser);
		let userMail = user.email;
		let user_split = userMail.split('@');
		self.user = user_split[0].replace('.', '_');

		// Reducción de Header
		headerSectionHeight(0);

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC2049);

		// Opciones de header
		let jsonsubopt = {
			new: 'new',
			importLayout: 'import'
		};

		let nav = `
			<div class="row mx-0">
				${createSubOptionImportTemplate(jsonsubopt.importLayout)}
				${createSubOptionNew(jsonsubopt.new)}
			</div>
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		$('#new svg').css({'width': '24px', 'height': '24px'});

		// Botón principal
		$('#new').addClass('main-button');

		// Botones secundarios
		$('#import').addClass('secondary-button');

		ajaxComunCallWithCallback('getAllTemplates', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				self.data = ajaxReturn.result;
				self.renderData();
			}
		});

		self.loadLang();
		self.applyEvents();

		// Collapse
		addEventArrowTableHeader();
	},

	loadLang() {
		pf.rsc.translateByTag('text');

		// TITLES
		$('.exportTitle').attr('title', pf.const.language.RSC47);
		$('.deleteMultTitle').attr('title', pf.const.language.RSC95);
	},

	applyEvents() {
		// Nuevo
		$('#new').on('click', function() {
			window.location.href = '#!generador_encuestas';
		});

		// Importar
		$('#import').on('click', function() {
			window.location.href = '#!templates_new';
		});
	},

	renderData() {
		let self = this;

		let table = `
			<thead>
				<tr>
					<th class="text-center" scope="col" title="">
						<div class="div-global-selection">
							<input type="checkbox" class="globalSelection">
						</div>
					</th>
					<th scope="col" title="${pf.const.language.RSC123}">${pf.const.language.RSC123}</th>
					<th scope="col" title="${pf.const.language.RSC178}">${pf.const.language.RSC178}</th>
					<th scope="col" title="${pf.const.language.RSC550}">${pf.const.language.RSC550}</th>
					<th scope="col" title="${pf.const.language.RSC167}">${pf.const.language.RSC167}</th>
					<th scope="col" title="${pf.const.language.RSC2516}">${pf.const.language.RSC2516}</th>
				</tr>
			</thead>

			<thead class="filtersResult">
				<tr>
					<td>selector</td>
					<td>nombre</td>
					<td>descripcion</td>
					<td>pais</td>
					<td>archivo</td>
					<td>acciones</td>
				</tr>
			</thead>

			<tbody>
		`;

		// Obtener países permitidos
		let allowedCountries = JSON.parse(atob(sessionStorage['STCMBackEnd:userCountries']));

		let size = self.data.length;
		for(let i = 0; i < size; i++) {
			// Control de países permitidos
			if(self.data[i].country != '' && allowedCountries.indexOf(self.data[i].country) == -1) {
				continue;
			}

			table += `
				<tr data-id="${self.data[i].idTemplate}">
					<td class="text-center">
						<div class="div-single-selection" data-id="${self.data[i].idTemplate}" data-file="${self.data[i].template}">
							<input type="checkbox" class="deleteSelection">
						</div>
					</td>
					<td class="text-truncate c-pointer editRow" title="${self.data[i].name}">${self.data[i].name}</td>
					<td class="text-truncate c-pointer editRow" title="${self.data[i].description}">${self.data[i].description}</td>
					<td class="text-truncate c-pointer editRow" title="${self.data[i].country}">${self.data[i].country}</td>
					<td class="text-truncate c-pointer editRow" title="${self.data[i].template.replace((self.data[i].idTemplate + '_'), '')}">${self.data[i].template.replace((self.data[i].idTemplate + '_'), '')}</td>
					<td class="text-center">
						<div id="dropdownActions${i}" class="div-dd-actions c-pointer" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
							${stcmbackend.svg.threeDotsVertical18}
						</div>

						<div class="dropdown-menu dropdown-menu-right shadow menu-actions" aria-labelledby="dropdownActions${i}" data-id="${self.data[i].idTemplate}" data-file="${self.data[i].template}">
							<p class="dropdown-item editRow">
								${stcmbackend.svg.pencilWithoutColor}
								<span>${pf.const.language.RSC225}</span>
							</p>
							<p class="dropdown-item deleteRow">
								${stcmbackend.svg.trashWithoutColor}
								<span>${pf.const.language.RSC95}</span>
							</p>
						</div>
					</td>
				</tr>
			`;
		}

		table += `
			</tbody>
		`;

		$('#registers').html(table);

		// Setup - add a text input to each footer cell
		$('#registers .filtersResult td').each(function() {
			let title = $(this).text();
			let value = `<input type="text" class="form-control form-control-sm">`;

			if(title == 'selector' || title == 'acciones') {
				value = `<input type="text" class="form-control form-control-sm" disabled>`;
			}

			$(this).html(value);
		});

		let dataTable = $('#registers').DataTable({
			retrieve: true,
			language: self.language,
			pageLength: 25,
			autoWidth: false,
			columnDefs: [
				{width: '25px', orderable: false, targets: 0},
				{width: '50px', targets: 3},
				{width: '60px', orderable: false, targets: 5}
			],
			dom: 'Bfrtip',
			buttons: [{
				extend: 'excelHtml5',
				text: pf.const.language.RSC2049,
				className: 'd-none',
				title: pf.const.language.RSC2049,
				exportOptions: {
					columns: [1, 2, 3, 4]
				},
				customize(xlsx) {
					dataTablesExcelCustomize(xlsx);
				}
			}],
			aaSorting: []
		});

		// Ocultar botones de tabla
		hideTableButtons('registers');

		// Apply the search
		applyTheSearch(dataTable, 'filtersResult');

		// Exportar tabla
		$('#export').off().on('click', function() {
			$('#resultTable .buttons-excel').trigger('click');
		});

		self.tableEvents(dataTable);

		$('#resultTable').on('draw.dt', function() {
			self.tableEvents(dataTable);
		});
	},

	tableEvents(dataTable) {
		let self = this;

		// Eventos del input global
		globalSelectionInputActions();

		// Editar plantilla
		$('.editRow').off().on('click', function() {
			let id = $(this).parent().data('id');

			sessionStorage.setItem('idTemplate', btoa(id));
			window.location.href = '#!templates_edit';
		});

		// Borrar plantilla
		$('.deleteRow').off().on('click', function() {
			let id = $(this).parent().data('id');
			let file = $(this).parent().data('file');

			let objInfo = {
				accept: {
					text: pf.const.language.RSC95
				},
				cancel: {
					text: pf.const.language.RSC57
				}
			};

			let alertTitle = pf.const.language.RSC2049;
			let alertText = pf.const.language.RSC2083;
			pf.utils.showInfoDialogAcceptCancel(alertTitle, alertText, objInfo, function() {
				let element = id + '#' + file;
				self.deleteTemplate(element);
			}, function() {});
		});

		// Array de eliminado múltiple
		$('.deleteSelection').off().on('change', function() {
			let value = $(this).prop('checked');
			let id = $(this).parent().data('id');
			let file = $(this).parent().data('file');

			if(value) {
				let element = id + '#' + file;
				self.arrayDelMult.push(element);
			} else {
				let element = id + '#' + file;
				let index = self.arrayDelMult.indexOf(element);
				self.arrayDelMult.splice(index, 1);
			}

			// Eventos de los inputs individuales
			deleteSelectionInputActions(self.arrayDelMult);
		});

		// Función de borrado múltiple
		$('#multSelecDelete').off().on('click', function() {
			// Aviso de borrado múltiple
			let objInfo = {
				accept: {
					text: pf.const.language.RSC95
				},
				cancel: {
					text: pf.const.language.RSC57
				}
			};

			let alertTitle = pf.const.language.RSC2049;
			let alertText = pf.const.language.RSC2082;
			pf.utils.showInfoDialogAcceptCancel(alertTitle, alertText, objInfo, function() {
				self.deleteTemplate();
			}, function() {});
		});
	},

	deleteTemplate(element = false) {
		let self = this;

		let templates = [];
		if(element !== false) {
			let elementArray = element.split('#');
			let obj = {
				id: elementArray[0],
				file: elementArray[1]
			}
			templates.push(obj);
		} else {
			let delSize = self.arrayDelMult.length;
			for(let i = 0; i < delSize; i++) {
				let elementArray = self.arrayDelMult[i].split('#');
				let obj = {
					id: elementArray[0],
					file: elementArray[1]
				}
				templates.push(obj);
			}
			self.arrayDelMult = [];
		}

		let parameters = {
			templates: JSON.stringify(templates)
		};
		ajaxComunCallWithCallback('deleteTemplate', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let successTitle = pf.const.language.RSC2049;
				let successContent = pf.const.language.RSC2084;
				pf.utils.showInfoDialog(successTitle, successContent);
				loadHTML('inc/templates/templates.html', 'wrapper', TemplatesController);
			}
		});
	}
};