let TemplatesEditController = {
	user: null,
	language: null,
	idTemplate: null,

	reset() {
		let self = this;

		self.user = null;
		self.language = pf.const.language_table;
		self.idTemplate = atob(sessionStorage.getItem('idTemplate'));
	},

	setEvents() {
		let self = this;
		self.reset();

		let JSONuser = sessionStorage['STCMBackEnd:user'];
		let user = JSON.parse(JSONuser);
		let userMail = user.email;
		let user_split = userMail.split('@');
		self.user = user_split[0].replace('.', '_');

		// Reducción de Header
		headerSectionHeight(0);

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC2085);

		// Opciones de header
		let jsonsubopt = {
			back: 'back',
			save: 'save'
		};

		let nav = `
			${createSubOptionSave(jsonsubopt.save)}
			${createSubOptionBack(jsonsubopt.back)}
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		// Botón principal
		$('#save').addClass('main-button');

		// Botones secundarios
		$('#back').addClass('secondary-button');

		// Ocultar cubo de basura
		$('#countryDelete').hide();

		let parameters = {
			idTemplate: self.idTemplate
		};
		ajaxComunCallWithCallback('getTemplatesByID', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				self.data = ajaxReturn.result;
				self.renderForm();
			}
		});

		self.loadLang();
		self.applyEvents();

		// Collapse
		addEventArrowTableHeader();

		// Pintar texto de label
		changeLabelsColor();
	},

	loadLang() {
		pf.rsc.translateByTag('text');
	},

	applyEvents() {
		let self = this;

		stcmbackend.templates.sharedEvents(self, 'templatesEdit');

		// Guardar producto
		$('#save').on('click', function() {
			self.updateTemplate();
		});
	},

	clickEvents(data) {
		$('#country').val(data.isocode);
		$('#countryDelete').show();
	},

	renderForm() {
		let self = this;

		// Archivo actual
		$('#currentFile').val(self.data[0].template.replace((self.data[0].idTemplate + '_'), ''));
		// Nombre
		$('#name').val(self.data[0].name);
		// País
		if(self.data[0].country != '') {
			// Mostrar cubo de basura
			$('#countryDelete').show();
		}
		$('#country').val(self.data[0].country);
		// Descripción
		$('#description').val(self.data[0].description);
	},

	updateTemplate() {
		let self = this;

		// Archivo
		let file = true;
		let inputElement = document.getElementById('file');
		let fileToUpload = null;

		if(!inputElement.files[0]) {
			file = false;
		} else {
			fileToUpload = inputElement.files[0];
		}

		// Nombre
		let name = $('#name').val().trim();
		if(name === '') {
			$('#name').addClass('is-invalid');
			$('[for="name"]').addClass('is-invalid');
		} else {
			$('#name').removeClass('is-invalid');
			$('[for="name"]').removeClass('is-invalid');
		}

		// Descripción
		let description = $('#description').val().trim();
		if(description === '') {
			$('#description').addClass('is-invalid');
			$('[for="description"]').addClass('is-invalid');
		} else {
			$('#description').removeClass('is-invalid');
			$('[for="description"]').removeClass('is-invalid');
		}

		let warning = false;
		let warningText = '';
		if(name === '' || description === '') {
			warning = true;
			warningText += pf.const.language.RSC101;
		}

		if(warning) {
			let alertTitle = pf.const.language.RSC2048;
			pf.utils.showInfoDialog(alertTitle, warningText);
			return false;
		}

		let country = $('#country').val();

		let parameters = {
			idTemplate: self.idTemplate,
			name: name,
			description: description,
			template: fileToUpload,
			templateOld: self.data[0].template,
			country: country
		};
		ajaxComunCallWithCallback('updateTemplate', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let successTitle = pf.const.language.RSC2049;
				let successContent = pf.const.language.RSC2086;
				pf.utils.showInfoDialog(successTitle, successContent);
				window.location.href = '#!templates';
			}
		});
	}
};