let TemplatesNewController = {
	user: null,
	language: null,
	file: null,

	reset() {
		let self = this;

		self.user = null;
		self.language = pf.const.language_table;
		self.file = null;
	},

	setEvents() {
		let self = this;
		self.reset();

		let JSONuser = sessionStorage['STCMBackEnd:user'];
		let user = JSON.parse(JSONuser);
		let userMail = user.email;
		let user_split = userMail.split('@');
		self.user = user_split[0].replace('.', '_');

		// Reducción de Header
		headerSectionHeight(0);

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC2049);

		// Opciones de header
		let jsonsubopt = {
			back: 'back',
			save: 'save'
		};

		let nav = `
			${createSubOptionSave(jsonsubopt.save)}
			${createSubOptionBack(jsonsubopt.back)}
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		// Botón principal
		$('#save').addClass('main-button');

		// Botones secundarios
		$('#back').addClass('secondary-button');

		// Ocultar cubo de basura
		$('#countryDelete').hide();

		self.loadLang();
		self.applyEvents();

		// Collapse
		addEventArrowTableHeader();

		// Pintar texto de label
		changeLabelsColor();
	},

	loadLang() {
		pf.rsc.translateByTag('text');
	},

	applyEvents() {
		let self = this;

		stcmbackend.templates.sharedEvents(self, 'templatesNew');

		// Guardar plantilla
		$('#save').on('click', function() {
			self.insertTemplate();
		});
	},

	clickEvents(data) {
		$('#country').val(data.isocode);
		$('#countryDelete').show();
	},

	insertTemplate() {
		// Archivo
		let file = true;
		let inputElement = document.getElementById('file');

		if(!inputElement.files[0]) {
			file = false;
		}

		let fileToUpload = inputElement.files[0];

		// Nombre
		let name = $('#name').val().trim();
		if(name === '') {
			$('#name').addClass('is-invalid');
			$('[for="name"]').addClass('is-invalid');
		} else {
			$('#name').removeClass('is-invalid');
			$('[for="name"]').removeClass('is-invalid');
		}

		// Descripción
		let description = $('#description').val().trim();
		if(description === '') {
			$('#description').addClass('is-invalid');
			$('[for="description"]').addClass('is-invalid');
		} else {
			$('#description').removeClass('is-invalid');
			$('[for="description"]').removeClass('is-invalid');
		}

		let warning = false;
		let warningText = '';
		if(!file) {
			warning = true;
			warningText += pf.const.language.RSC2080 + '\n';
		}

		if(name === '' || description === '') {
			warning = true;
			warningText += pf.const.language.RSC101;
		}

		if(warning) {
			let alertTitle = pf.const.language.RSC2048;
			pf.utils.showInfoDialog(alertTitle, warningText);
			return false;
		}

		let country = $('#country').val();

		let parameters = {
			name: name,
			description: description,
			template: fileToUpload,
			country: country
		};
		ajaxComunCallWithCallback('insertTemplate', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let successTitle = pf.const.language.RSC2049;
				let successContent = pf.const.language.RSC2081;
				pf.utils.showInfoDialog(successTitle, successContent);
				window.location.href = '#!templates';
			}
		});
	}
};