let SegmentacionesAutomatizadasNewController = {
	language: '',

	resetData() {
		let self = this;

		self.language = pf.const.language_table;
	},

	setEvents() {
		let self = this;
		self.resetData();

		// Reducción de Header
		headerSectionHeight(0);

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC1973 + ' - ' + pf.const.language.RSC7);

		// Opciones de header
		let jsonsubopt = {
			back: 'back',
			save: 'btn-save'
		};

		let nav = `
			${createSubOptionSave(jsonsubopt.save)}
			${createSubOptionBack(jsonsubopt.back)}
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		// Botón principal
		$('#btn-save').addClass('main-button');

		// Botones secundarios
		$('#back').addClass('secondary-button');

		self.loadLanguage();
		self.applyEvents();

		// Control de países permitidos por el administrador si solo hay uno
		let countries = JSON.parse(atob(sessionStorage['STCMBackEnd:userCountries']));
		if(countries.length === 1) {
			$('#pais').val(countries[0]);
		}

		// Collapse
		addEventArrowTableHeader();

		// Pintar texto de label
		changeLabelsColor();
	},

	loadLanguage() {
		pf.rsc.translateByTag('text');
	},

	applyEvents() {
		let self = this;

		stcmbackend.segmentacionesAutomatizadas.sharedEvents(self, 'segmentacionesAutomatizadasNewCountry');

		// Guardar segmentación programada
		$('#btn-save').on('click', function() {
			self.getValues();
		});
	},

	getValues() {
		let self = this;

		let comp = true;

		let activa = ($('#activa').prop('checked') == true ? '1' : '0');
		let contry = $('#pais').val();
		if(contry == '') {
			$('#pais').addClass('is-invalid');
			$('#pais-group').addClass('group-invalid');
			$('[for="pais"]').addClass('is-invalid');
			comp = false;
		} else {
			$('#pais').removeClass('is-invalid');
			$('#pais-group').removeClass('group-invalid');
			$('[for="pais"]').removeClass('is-invalid');
		}
		let tiempoEntreEjecuciones = $('#tiempoEntreEjecuciones').val();
		let unidadDeTiempo = $('#unidadDeTiempo').val();

		if(!comp) {
			pf.utils.alerts.showCompleteAllFields();
			return false;
		}

		let values = {
			Activa: activa,
			country: contry,
			TiempoEntreEjecuciones: tiempoEntreEjecuciones,
			UnidadDeTiempo: unidadDeTiempo
		};

		self.setScheduledSegmentation(values);
	},

	setScheduledSegmentation(values) {
		let parameters = {
			Activa: values.activa,
			country: values.country,
			TiempoEntreEjecuciones: values.TiempoEntreEjecuciones,
			UnidadDeTiempo: values.UnidadDeTiempo
		};
		ajaxComunCallWithCallback('setScheduledSegmentation', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let alertTitle = pf.const.language.RSC1973;
				let alertText = pf.const.language.RSC106;
				let alertBtn = pf.const.language.RSC132;
				pf.utils.showInfoDialog(alertTitle, alertText, alertBtn, function() {
					window.location.href = '#!segmentaciones_automatizadas';
				});
			}
		});
	},

	clickEvents(data) {
		$('#pais').val(data.isocode);
	}
};