let SegmentacionesController = {
	user: null,
	language: '',
	editSegmentation: true,
	data: '',
	arrayDelMult: [],

	reset() {
		let self = this;

		self.user = null;
		self.language = pf.const.language_table;
		self.editSegmentation = true;
		self.data = '';
		self.arrayDelMult = [];
	},

	setEvents() {
		let self = this;
		self.reset();

		let JSONuser = sessionStorage['STCMBackEnd:user'];
		let user = JSON.parse(JSONuser);
		let userMail = user.email;
		let user_split = userMail.split('@');
		self.user = user_split[0].replace('.', '_');

		// Reducción de Header
		headerSectionHeight(0);

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC1741);

		// Opciones de header
		let jsonsubopt = {
			new: 'new'
		};

		let nav = `
			${createSubOptionNew(jsonsubopt.new)}
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		$('#new svg').css({'width': '24px', 'height': '24px'});

		// Botón principal
		$('#new').addClass('main-button');

		ajaxComunCallWithCallback('getAllSegmentaciones', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				removeLoader();
				self.data = ajaxReturn.result;

				// Tabla de resultados
				self.renderData();
			}
		});

		self.loadLang();
		self.applyEvents();

		let editSegmentation = sessionStorage['STCMBackEnd:editSegmentation'];
		if(editSegmentation == '0') {
			self.editSegmentation = false;
		}

		// Collapse
		addEventArrowTableHeader();
	},

	loadLang() {
		pf.rsc.translateByTag('text');

		// TITLES
		$('.exportTitle').attr('title', pf.const.language.RSC47);
		$('.deleteMultTitle').attr('title', pf.const.language.RSC95);
	},

	applyEvents() {
		// Nuevo
		$('#new').on('click', function() {
			window.location.href = '#!segmentaciones_new';
		});
	},

	renderData() {
		let self = this;

		$('#resultTable').show();

		let table = `
			<thead>
				<tr>
					<th class="text-center" scope="col" title="">
						<div class="div-global-selection">
							<input type="checkbox" class="globalSelection">
						</div>
					</th>
					<th scope="col" title="${pf.const.language.RSC123}">${pf.const.language.RSC123}</th>
					<th scope="col" title="${pf.const.language.RSC110}">${pf.const.language.RSC110}</th>
					<th scope="col" title="${pf.const.language.RSC178}">${pf.const.language.RSC178}</th>
					<th scope="col" title="${pf.const.language.RSC550}">${pf.const.language.RSC550}</th>
					<th scope="col" title="${pf.const.language.RSC368}">${pf.const.language.RSC368}</th>
					<th scope="col" title="${pf.const.language.RSC2516}">${pf.const.language.RSC2516}</th>
				</tr>
			</thead>

			<thead class="filtersResult">
				<tr>
					<td>selector</td>
					<td>name</td>
					<td>survey</td>
					<td>description</td>
					<td>country</td>
					<td>lastRun</td>
					<td>acciones</td>
				</tr>
			</thead>

			<tbody>
		`;

		// Obtener países permitidos
		let allowedCountries = JSON.parse(atob(sessionStorage['STCMBackEnd:userCountries']));

		let size = self.data.length;
		for(let i = 0; i < size; i++) {
			// Control de países permitidos
			if(self.data[i].country != '' && allowedCountries.indexOf(self.data[i].country) == -1) {
				continue;
			}

			table += `
				<tr data-id="${i}">
					<td class="text-center">
						<div class="div-single-selection" data-id="${i}">
							<input type="checkbox" class="deleteSelection">
						</div>
					</td>
					<td class="text-truncate c-pointer editRow" title="${self.data[i].Descripcion}">${self.data[i].Descripcion}</td>
					<td class="text-truncate c-pointer editRow" title="${self.data[i].surveyls_title}">${self.data[i].surveyls_title}</td>
					<td class="text-truncate c-pointer editRow" title="${self.data[i].surveyls_description}">${self.data[i].surveyls_description}</td>
					<td class="text-truncate c-pointer editRow" title="${self.data[i].country}">${self.data[i].country}</td>
					<td class="text-truncate c-pointer editRow" title="${self.data[i].FechaUltimaEjecucion}">${self.data[i].FechaUltimaEjecucion}</td>
					<td class="text-center">
						<div id="dropdownActions${i}" class="div-dd-actions c-pointer" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
							${stcmbackend.svg.threeDotsVertical18}
						</div>

						<div class="dropdown-menu dropdown-menu-right shadow menu-actions" aria-labelledby="dropdownActions${i}" data-id="${i}">
							<p class="dropdown-item editRow">
								${stcmbackend.svg.pencilWithoutColor}
								<span>${pf.const.language.RSC225}</span>
							</p>
							<p class="dropdown-item deleteRow">
								${stcmbackend.svg.trashWithoutColor}
								<span>${pf.const.language.RSC95}</span>
							</p>
						</div>
					</td>
				</tr>
			`;
		}

		table += `
			</tbody>
		`;

		$('#registers').html(table);

		// Setup - add a text input to each footer cell
		$('#registers .filtersResult td').each(function() {
			let title = $(this).text();
			let value = `<input type="text" class="form-control form-control-sm">`;

			if(title == 'selector' || title == 'acciones') {
				value = `<input type="text" class="form-control form-control-sm" disabled>`;
			}

			$(this).html(value);
		});

		let dataTable = $('#registers').DataTable({
			retrieve: true,
			language: self.language,
			pageLength: 25,
			autoWidth: false,
			columnDefs: [
				{width: '25px', orderable: false, targets: 0},
				{width: '60px', targets: 4},
				{width: '110px', targets: 5},
				{width: '60px', orderable: false, targets: 6}
			],
			dom: 'Bfrtip',
			buttons: [{
				extend: 'excelHtml5',
				text: pf.const.language.RSC1741,
				className: 'd-none',
				title: pf.const.language.RSC1741,
				exportOptions: {
					columns: [1, 2, 3, 4, 5]
				},
				customize(xlsx) {
					dataTablesExcelCustomize(xlsx);
				}
			}],
			aaSorting: []
		});

		// Ocultar botones de tabla
		hideTableButtons('registers');

		// Apply the search
		applyTheSearch(dataTable, 'filtersResult');

		// Exportar tabla
		$('#export').off().on('click', function() {
			$('#resultTable .buttons-excel').trigger('click');
		});

		self.tableEvents();

		$('#resultTable').on('draw.dt', function() {
			self.tableEvents();
		});
	},

	tableEvents() {
		let self = this;

		if(self.editSegmentation) {
			// Eventos del input global
			globalSelectionInputActions();

			// Editar segmentación
			$('.editRow').off().on('click', function() {
				let id = $(this).parent().data('id');
				let idSeg = self.data[id].idSegmentacion;

				sessionStorage.setItem('idSegmentacion', btoa(idSeg));
				window.location.href = '#!segmentaciones_edit';
			});

			// Borrar segmentación
			$('.deleteRow').off().on('click', function() {
				let id = $(this).parent().data('id');

				let objInfo = {
					accept: {
						text: pf.const.language.RSC95
					},
					cancel: {
						text: pf.const.language.RSC57
					}
				};

				let alertTitle = pf.const.language.RSC1741;
				let alertText = pf.const.language.RSC1744;
				pf.utils.showInfoDialogAcceptCancel(alertTitle, alertText, objInfo, function() {
					self.deleteSegmentacion(id);
				}, function() {});
			});

			// Array de eliminado múltiple
			$('.deleteSelection').off().on('change', function() {
				let value = $(this).prop('checked');
				let id = $(this).parent().data('id');

				if(value) {
					self.arrayDelMult.push(id);
				} else {
					let index = self.arrayDelMult.indexOf(id);
					self.arrayDelMult.splice(index, 1);
				}

				// Eventos de los inputs individuales
				deleteSelectionInputActions(self.arrayDelMult);
			});

			// Función de borrado múltiple
			$('#multSelecDelete').off().on('click', function() {
				// Aviso de borrado múltiple
				let objInfo = {
					accept: {
						text: pf.const.language.RSC95
					},
					cancel: {
						text: pf.const.language.RSC57
					}
				};

				let alertTitle = pf.const.language.RSC1741;
				let alertText = pf.const.language.RSC1743;
				pf.utils.showInfoDialogAcceptCancel(alertTitle, alertText, objInfo, function() {
					self.deleteSegmentacion();
				}, function() {});
			});
		}
	},

	deleteSegmentacion(id = false) {
		let self = this;

		let segmentations = [];
		if(id !== false) {
			let obj = {
				idSegmentacion: self.data[id].idSegmentacion,
				sid: self.data[id].sid
			}
			segmentations.push(obj);
		} else {
			let delSize = self.arrayDelMult.length;
			for(let i = 0; i < delSize; i++) {
				let obj = {
					idSegmentacion: self.data[self.arrayDelMult[i]].idSegmentacion,
					sid: self.data[self.arrayDelMult[i]].sid
				}
				segmentations.push(obj);
			}
			self.arrayDelMult = [];
		}

		let parameters = {
			segmentations: JSON.stringify(segmentations)
		};
		ajaxComunCallWithCallback('deleteSegmentacion', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let successTitle = pf.const.language.RSC1741;
				let successContent = pf.const.language.RSC1745;
				pf.utils.showInfoDialog(successTitle, successContent);
				loadHTML('inc/usuarios/segmentaciones.html', 'wrapper', SegmentacionesController);
			}
		});
	}
};