<?php
include_once(dirname(__FILE__) . '/UtilesController.php');

class HashtagsController {
	private $utilesController;

	function __construct() {
		$this->utilesController = new UtilesController();
	}

	// Guardar hashtag nuevo
	public function addNewHashtag($client) {
		$params = [];
		$size = count($client['params']);
		for($i = 0; $i < $size; $i++) {
			if($client['params'][$i]['param'] !== '' && $client['params'][$i]['value'] !== '') {
				$obj = (object)[
					'param' => $client['params'][$i]['param'],
					'value' => $client['params'][$i]['value']
				];

				array_push($params, $obj);
			}
		}

		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'text' => $client['text'],
			'method' => $client['method'],
			'description' => $client['description'],
			'url' => $client['url'],
			'params' => json_encode($params)
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Eliminar hashtag
	public function deleteHashtag($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];

		if($client['hashtags'] != '[]') {
			foreach($client['hashtags'] as $hashtag) {
				$params = [
					'token' => $client['token'],
					'idHashtag' => $hashtag['idHashtag']
				];

				$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

				if($resultPOST->status != 'OK') {
					return $resultPOST;
				}
			}
		} else {
			$resultPOST = [
				'status' => 'OK'
			];
		}

		return $resultPOST;
	}

	// Carga de hashtag por id
	public function getHashtagByID($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'idHashtag' => $client['idHashtag']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Editar hashtag
	public function updateHashtag($client) {
		$params = [];
		$size = count($client['params']);
		for($i = 0; $i < $size; $i++) {
			if($client['params'][$i]['param'] !== '' && $client['params'][$i]['value'] !== '') {
				$obj = (object)[
					'param' => $client['params'][$i]['param'],
					'value' => $client['params'][$i]['value']
				];

				array_push($params, $obj);
			}
		}

		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'idHashtag' => $client['idHashtag'],
			'text' => $client['text'],
			'method' => $client['method'],
			'description' => $client['description'],
			'url' => $client['url'],
			'params' => json_encode($params)
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}
}