<?php
class LogController {
    public static $logLines = true;
    public static $logFolderPath = "/var/www/html/sociallabs/public/stcm_backend_web/API/log/";
    public static $logFileName = "callstack.log";

    public static function logTraceLine() {
        if (!self::$logLines) {
            return;
        }

        $logMsg = "";
        $file = self::$logFolderPath . self::$logFileName;

        // Verificar si la carpeta de registro existe
        if (!is_dir(self::$logFolderPath)) {
            mkdir(self::$logFolderPath, 0755, true);
        }

        // Intentar abrir el archivo con manejo de errores
        try {
            $archivo = fopen($file, "a");
            if ($archivo === false) {
                throw new Exception("No se pudo abrir el archivo de registro.");
            }

            $trace = debug_backtrace(DEBUG_BACKTRACE_PROVIDE_OBJECT, 2);
            $lineID = isset($trace[1]['line']) ? $trace[1]['line'] : "LineUnknown";
            $fileName = isset($trace[1]['file']) ? $trace[1]['file'] : "FileUnknown";
            $functionName = isset($trace[1]['function']) ? $trace[1]['function'] : "FunctionUnknown";
            $timeStamp = date("d m Y H:i:s");

            $logMsg = "File: {$fileName} || Function: {$functionName} || Line: {$lineID} || Time: {$timeStamp}\n";

            fwrite($archivo, $logMsg);
        } catch (Exception $e) {
            error_log("Error al abrir el archivo de registro: " . $e->getMessage());
        } finally {
            if (isset($archivo) && is_resource($archivo)) {
                fclose($archivo);
            }
        }

        return $logMsg;
    }
}