<?php
include_once(dirname(__FILE__) . '/UtilesController.php');

class MisionesController {
	private $utilesController;

	function __construct() {
		$this->utilesController = new UtilesController();
	}

	// Petición de Misiones
	public function getAllMisiones($client, $token) {
		if(isset($token)) {
			$url = CONSTANTS::SERVERAPI . 'getAllMisiones';
		} else {
			$url = CONSTANTS::SERVERAPI . $client['action'];
			$token = $client['token'];
		}

		if(isset($client['idCliente'])) {
			$idCliente = $client['idCliente'];
		} else {
			$idCliente = '';
		}

		if(isset($client['tipoAnidada'])) {
			$tipoAnidada = $client['tipoAnidada'];
		} else {
			$tipoAnidada = '';
		}

		$params = [
			'token' => $token,
			'idCliente' => $idCliente,
			'tipoAnidada' => $tipoAnidada
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Petición de Misión por stampMision
	public function getMision($client, $token, $stampMision) {
		if(isset($token)) {
			$url = CONSTANTS::SERVERAPI . 'getMision';
		} else {
			$url = CONSTANTS::SERVERAPI . $client['action'];
			$token = $client['token'];
			$stampMision = $client['stampMision'];
		}
		$params = [
			'token' => $token,
			'stampMision' => $stampMision
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Petición de Objetivos por Tipos de Misiones
	public function getAllTipoMisionObjetivos($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'tipomision' => $client['tipomision']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Petición de recordatorios de Misión
	public function getMisionRemember($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'stampMision' => $client['stampMision']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Comprobar si existe una misión de referidos entre las fechas dadas
	public function existsMisionBetweenDates($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'tipomision' => $client['tipomision'],
			'country' => $client['country'],
			'fechahorainicioexec' => $client['fechahorainicioexec'],
			'fechahorafinexec' => $client['fechahorafinexec']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Crear misión
	public function createMision($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];

		if(isset($client['producto_mision']) && $client['producto_mision'] == '1') {
			$params = [
				'token' => $client['token'],
				'idmision' => $client['idmision'],
				'descripcion' => $client['descripcion'],
				'textomisionvalidacion' => $client['textovalidacion'],
				'textoiniciomision' => $client['textoiniciomision'],
				'textofinmision' => $client['textofinmision'],
				'textomisionok' => $client['textomisionok'],
				'textomisionko' => $client['textomisionko'],
				'tipomision' => $client['tipomision'],
				'fechahorainicio' => $client['fechahorainicio'],
				'fechahorainicioexec' => $client['fechahorainicioexec'],
				'fechahorafin' => $client['fechahorafin'],
				'fechahorafinexec' => $client['fechahorafinexec'],
				'importe' => $client['importe'],
				'currency' => $client['currency'],
				'country' => $client['country'],
				'encuesta' => $client['encuesta'],
				'idPlantillaReportes' => '0',
				'order' => $client['order'],
				'finmisioncupo' => $client['finmisioncupo'],
				'textofinmisioncupo' => $client['textofinmisioncupo'],
				'needValidation' => $client['needValidation'],
				'textomisionkoAutoNoCumplimiento' => $client['textomisionkoAutoNoCumplimiento'],
				'usaComision' => '0',
				'importenocumplimiento' => '',
				'currencynocumplimiento' => '',
				'misionInicial' => '',
				'misionInfinita' => '',
				'idCliente' => '',
				'tipoAnidada' => '0',
				'estadoAnidada' => '',
				'requiereTracking' => '0',
				'continuingMission' => '0'
			];
		} else {
			$estadoAnidada = '';
			if($client['tipoAnidada'] == '1') {
				if($client['estadoAnidadaStamp'] == '') {
					$estadoAnidada = '0';
				} else {
					$estadoAnidada = '1';

					$client['fechahorainicio'] = $client['nestedMission']['fechahorainicio'];
					$client['fechahorainicioexec'] = $client['nestedMission']['fechahorainicioexec'];
					$client['fechahorafin'] = $client['nestedMission']['fechahorafin'];
					$client['fechahorafinexec'] = $client['nestedMission']['fechahorafinexec'];
				}
			}

			$params = [
				'token' => $client['token'],
				'idmision' => $client['idmision'],
				'descripcion' => $client['descripcion'],
				'textomisionvalidacion' => $client['textovalidacion'],
				'textoiniciomision' => $client['textoiniciomision'],
				'textofinmision' => $client['textofinmision'],
				'textomisionok' => $client['textomisionok'],
				'textomisionko' => $client['textomisionko'],
				'tipomision' => $client['tipomision'],
				'desctipomision' => $client['desctipomision'],
				'fechahorainicio' => $client['fechahorainicio'],
				'fechahorainicioexec' => $client['fechahorainicioexec'],
				'fechahorafin' => $client['fechahorafin'],
				'fechahorafinexec' => $client['fechahorafinexec'],
				'importe' => $client['importe'],
				'encuesta' => $client['encuesta'],
				'idPlantillaReportes' => $client['idPlantillaReportes'],
				'order' => $client['order'],
				'currency' => $client['currency'],
				'country' => $client['country'],
				'importeinterno' => $client['importeinterno'],
				'finmisioncupo' => $client['finmisioncupo'],
				'textofinmisioncupo' => $client['textofinmisioncupo'],
				'currencyinterno' => $client['currencyinterno'],
				'needValidation' => $client['needValidation'],
				'textomisionkoAutoNoCumplimiento' => $client['textomisionkoAutoNoCumplimiento'],
				'usaComision' => $client['usaComision'],
				'importenocumplimiento' => $client['importenocumplimiento'],
				'currencynocumplimiento' => $client['currencynocumplimiento'],
				'misionInicial' => $client['misionInicial'],
				'misionInfinita' => $client['misionInfinita'],
				'idCliente' => $client['idCliente'],
				'tipoAnidada' => $client['tipoAnidada'],
				'estadoAnidada' => $estadoAnidada,
				'requiereTracking' => $client['requiereTracking'],
				'continuingMission' => $client['continuingMission'],
				'isAuditoria' => $client['isAuditoria']
			];
		}

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		if($resultPOST->status != 'OK') {
			return $resultPOST;
		}

		$stampMision = $resultPOST->result;

		// Misión anidada
		if($client['nestedMission'] != 'null') {
			// Último parámetro con el stampMisión de la misión anidada
			$resultPOSTnestedMission = $this->utilesController->updateMision($client['token'], $client['nestedMission'], $stampMision);

			if($resultPOSTnestedMission->status != 'OK') {
				return $resultPOSTnestedMission;
			}
		}

		// Recordatorios
		if(count($client['reminders']) > 0 && $client['reminders'] != '[]') {
			foreach($client['reminders'] as $reminder) {
				$resultPOST = $this->setCMBPNotificationsMission($client, $reminder, $stampMision);

				if($resultPOST->status != 'OK') {
					return $resultPOST;
				}
			}
		}

		// Creado a partir de paso a paso
		if(isset($client['missionSBS']) && $client['missionSBS'] == '1') {
			$url = CONSTANTS::SERVERAPI . 'setCMBPProjectsMisiones';
			$params = [
				'token' => $client['token'],
				'id' => $client['id'],
				'mision' => $client['idmision'],
				'missionStamp' => $stampMision,
				'Descripcion' => $client['descripcion'],
				'fechahorainicio' => $client['fechahorainicioexec'],
				'fechahorafin' => $client['fechahorafinexec'],
				'importe' => $client['importe'],
				'inicionotificado' => '0',
				'finnotificado' => ''
			];

			$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

			if($resultPOST->status != 'OK') {
				return $resultPOST;
			}
		}

		// Creado a partir de producto
		if(isset($client['producto_mision']) && $client['producto_mision'] == '1') {
			$url = CONSTANTS::SERVERAPI . 'setCMBPProjectsMisiones';
			$params = [
				'token' => $client['token'],
				'id' => $client['id'],
				'mision' => $client['idmision'],
				'missionStamp' => $stampMision,
				'Descripcion' => $client['descripcion'],
				'fechahorainicio' => $client['fechahorainicioexec'],
				'fechahorafin' => $client['fechahorafinexec'],
				'importe' => $client['importe'],
				'inicionotificado' => '0',
				'finnotificado' => ''
			];

			$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

			if($resultPOST->status != 'OK') {
				return $resultPOST;
			}

			if($client['encuesta'] == '0') {
				$url = CONSTANTS::SERVERAPI . 'setMisionObjetivo';
				$params = [
					'token' => $client['token'],
					'idmision' => $client['idmision'],
					'objetivo' => $client['objetivo'],
					'descripcion' => $client['descobjetivo'],
					'numveces' => 1,
					'periodo' => 'total'
				];

				$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

				if($resultPOST->status != 'OK') {
					return $resultPOST;
				}
			}

			$resultPOST->result = $stampMision;
			return $resultPOST;
		}
		//Aplicamos la fecha inicio y expiración de la encuesta en el caso de que la misión tenga una
		if( $client['encuesta'] == '1' && $client['idEncuesta'] != '') {
			$resultPOST = $this->setImporteStartDateExpireDateSurvey($client);
		}

		if($resultPOST->status == 'OK') {
			$url = CONSTANTS::SERVERAPI . 'setMisionObjetivo';
			if($client['encuesta'] == '1') {
				$params = [
					'token' => $client['token'],
					'idmision' => $client['idmision'],
					'objetivo' => $client['objetivo'],
					'descobjetivo' => $client['descobjetivo'],
					'encuesta' => $client['idEncuesta'],
					'descencuesta' => $client['descencuesta']
				];
			} else if($client['order'] == 1) {
				$params = [
					'token' => $client['token'],
					'idmision' => $client['idmision'],
					'objetivo' => $client['objetivo'],
					'descobjetivo' => $client['descobjetivo'],
					'orderamount' => $client['orderamount'],
					'orderamountporcfinanciated' => $client['orderamountporcfinanciated'],
					'orderproductitem' => json_encode($client['orderproductitem']),
					'orderproductAmount' => json_encode($client['orderproductAmount']),
					'periodo' => $client['periodo'],
					'ordernumtimes' => $client['ordernumtimes']
				];
			} else {
				$params = [
					'token' => $client['token'],
					'idmision' => $client['idmision'],
					'objetivo' => $client['objetivo'],
					'descobjetivo' => $client['descobjetivo'],
					'numveces' => $client['numveces'],
					'periodo' => $client['periodo']
				];
			}

			$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

			// Registro de errores
			if($resultPOST->status != 'OK') {
				return $resultPOST;
			}

			// Exclusión de preguntas/respuestas
			if($client['misionQuestionsArray'] !== '[]' && $client['encuesta'] == '1') {
				$k = 0;
				// $misionQuestionsArray: ["order#columname#value#valuecode#valueInclusive#codeInclusive"] - FORMATO
				$size = count($client['misionQuestionsArray']);

				$misionQuestionsArray = '[';
				for($i = 0; $i < $size; $i++) {
					if($client['misionQuestionsArray'][$i]['type'] != 'K' && $client['misionQuestionsArray'][$i]['type'] != 'M') {
						$value = implode(',', $client['misionQuestionsArray'][$i]['value']);
						$valueInclusive = implode(',', $client['misionQuestionsArray'][$i]['valueInclusive']);
						$code = implode(',', $client['misionQuestionsArray'][$i]['code']);
						$codeInclusive = implode(',', $client['misionQuestionsArray'][$i]['codeInclusive']);
						$string = $k . '#' . $client['misionQuestionsArray'][$i]['columnName'] . '#' . strval($value) . '#' . strval($code) . '#' . strval($valueInclusive) . '#' . strval($codeInclusive);
						$misionQuestionsArray .= '"' . $string . '",';
						$k++;
					} else if($client['misionQuestionsArray'][$i]['type'] == 'M') {
						for($x = 0; $x < count($client['misionQuestionsArray'][$i]['value']); $x++) {
							$string = $k . '#' . $client['misionQuestionsArray'][$i]['columnName'] . $client['misionQuestionsArray'][$i]['code'][$x] . '#' . $client['misionQuestionsArray'][$i]['value'][$x] . '#Y##';
							$misionQuestionsArray .= '"' . $string . '",';
							$k++;
						}
						for($x = 0; $x < count($client['misionQuestionsArray'][$i]['valueInclusive']); $x++) {
							$string = $k . '#' . $client['misionQuestionsArray'][$i]['columnName'] . $client['misionQuestionsArray'][$i]['codeInclusive'][$x] . '###' . $client['misionQuestionsArray'][$i]['valueInclusive'][$x] . '#Y';
							$misionQuestionsArray .= '"' . $string . '",';
							$k++;
						}
					} else {
						$sizeK = count($client['misionQuestionsArray'][$i]['valuesSQ']);
						for($j = 0; $j < $sizeK; $j++) {
							$columnNameKArray = explode('|', $client['misionQuestionsArray'][$i]['valuesSQ'][$j]);
							$columnNameK = $columnNameKArray[0];
							$value = implode(',', $client['misionQuestionsArray'][$i]['value'][$columnNameK]);
							$code = implode(',', $client['misionQuestionsArray'][$i]['code'][$columnNameK]);
							$valueInclusive = implode(',', $client['misionQuestionsArray'][$i]['valueInclusive'][$columnNameK]);
							$codeInclusive = implode(',', $client['misionQuestionsArray'][$i]['codeInclusive'][$columnNameK]);
							$string = $k . '#' . $columnNameK . '#' . $value . '#' . $code . '#' . $valueInclusive . '#' . $codeInclusive;
							$misionQuestionsArray .= '"' . $string . '",';
							$k++;
						}
					}
				}
				$misionQuestionsArray = substr($misionQuestionsArray, 0, -1);
				$misionQuestionsArray .= ']';

				$url = CONSTANTS::SERVERAPI . 'addMisionQuestionNoAccomplish';
				$params = [
					'token' => $client['token'],
					'idmision' => $client['idmision'],
					'misionQuestionsArray' => $misionQuestionsArray
				];

				$resultPOST = $this->utilesController->sendCurlPOST($url, $params);
			}

			$resultPOST->result = $stampMision;
			return $resultPOST;
		} else {
			return $resultPOST;
		}
	}

	// Eliminar misión
	public function dropMision($client) {
		if($client['missions'] != '[]') {
			foreach($client['missions'] as $mission) {
				$url2 = CONSTANTS::SERVERAPI . 'deleteMisionQuestionNoAccomplish';
				$params2 = [
					'token' => $client['token'],
					'idmision' => $mission['id']
				];

				$resultPOST2 = $this->utilesController->sendCurlPOST($url2, $params2);

				if($resultPOST2->status != 'OK') {
					return $resultPOST2;
				}

				$url = CONSTANTS::SERVERAPI . $client['action'];
				$params = [
					'token' => $client['token'],
					'idmision' => $mission['id']
				];

				$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

				if($resultPOST->status != 'OK') {
					return $resultPOST;
				}
			}
		} else {
			$resultPOST = [
				'status' => 'OK'
			];
		}

		return $resultPOST;
	}

	// Petición de objetivos de misión
	public function getMisionesObjetivos($client, $data, $serviceExecution) {
		$url = CONSTANTS::SERVERAPI . 'getMisionesObjetivos';
		if(!isset($data)) {
			$token = $client['token'];
			$idmision = $client['idmision'];
		} else {
			$token = $data['token'];
			$idmision = $data['idmision'];
		}
		if(!isset($serviceExecution)) {
			$serviceExecution = '';
		}
		$params = [
			'token' => $token,
			'idmision' => $idmision,
			'serviceExecution' => $serviceExecution
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Añadir el objetivo a la misión y actualizar la fecha de expiracion de la encuesta con la fecha de la mision
	public function setMisionObjetivoAndUpdateSurveyExpiration($client) {
		// Borrado de objetivos
		$url = CONSTANTS::SERVERAPI . 'deleteMisionObjetivos';
		$params = [
			'token' => $client['token'],
			'idmision' => $client['idmision']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		// Registro de errores
		if($resultPOST->status != 'OK') {
			return $resultPOST;
		}

		$url = CONSTANTS::SERVERAPI . 'setMisionObjetivo';

		$token = $client['token'];
		$idmision = $client['idmision'];
		$encuesta = $client['idEncuesta'];
		$descencuesta = $client['descencuesta'];
		$objetivo = $client['objetivo'];
		$descobjetivo = $client['descobjetivo'];

		$params = [
			'token' => $token,
			'idmision' => $idmision,
			'encuesta' => $encuesta,
			'descencuesta' => $descencuesta,
			'objetivo' => $objetivo,
			'descripcion' => $descobjetivo
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		// Registro de errores
		if($resultPOST->status != 'OK') {
			return $resultPOST;
		}

		$stampMission = $client['stampMission'];
		$infoMision = $this->getMision($client, $token, $stampMission);
		$client['fechahorainicioexec'] = $infoMision->result[0]->fechahorainicioexec;
		$client['fechahorafinexec'] = $infoMision->result[0]->fechahorafinexec;
		$client['importe'] = $infoMision->result[0]->importe;
		$resultPOSTExpire = $this->setImporteStartDateExpireDateSurvey($client);

		return $resultPOST;
	}

	// Editar misión
	public function updateMision($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];

		if(isset($client['producto_mision']) && $client['producto_mision'] == '1') {
			$params = [
				'token' => $client['token'],
				'idmision' => $client['idmision'],
				'descripcion' => $client['descripcion'],
				'textomisionvalidacion' => $client['textovalidacion'],
				'textoiniciomision' => $client['textoiniciomision'],
				'textofinmision' => $client['textofinmision'],
				'textomisionok' => $client['textomisionok'],
				'textomisionko' => $client['textomisionko'],
				'tipomision' => $client['tipomision'],
				'fechahorainicio' => $client['fechahorainicio'],
				'fechahorainicioexec' => $client['fechahorainicioexec'],
				'fechahorafin' => $client['fechahorafin'],
				'fechahorafinexec' => $client['fechahorafinexec'],
				'importe' => $client['importe'],
				'currency' => $client['currency'],
				'country' => $client['country'],
				'encuesta' => $client['encuesta'],
				'idPlantillaReportes' => '0',
				'order' => $client['order'],
				'finmisioncupo' => $client['finmisioncupo'],
				'textofinmisioncupo' => $client['textofinmisioncupo'],
				'needValidation' => $client['needValidation'],
				'cierreManual' => '0',
				'textomisionkoAutoNoCumplimiento' => $client['textomisionkoAutoNoCumplimiento'],
				'usaComision' => '0',
				'importenocumplimiento' => '',
				'currencynocumplimiento' => '',
				'misionInicial' => '',
				'misionInfinita' => '',
				'idCliente' => '',
				'tipoAnidada' => '0',
				'estadoAnidada' => '',
				'requiereTracking' => '0',
				'continuingMission' => '0'
			];
		} else {
			if($client['manualClosing'] == '1') {
				$client['textofinmision'] = $client['manualClosingText'];
				$client['fechahorafin'] = date('d/m/Y#H#i#s#');
				$client['fechahorafinexec'] = date('d/m/Y H:i:s');
			}

			$estadoAnidada = '';
			if($client['tipoAnidada'] == '1') {
				if($client['estadoAnidadaStamp'] == '' && $client['nestedMissionOld'] == '') {
					$estadoAnidada = '0';
				} else {
					$estadoAnidada = '1';

					if($client['nestedMission'] != 'null') {
						$client['fechahorainicio'] = $client['nestedMission']['fechahorainicio'];
						$client['fechahorainicioexec'] = $client['nestedMission']['fechahorainicioexec'];
						$client['fechahorafin'] = $client['nestedMission']['fechahorafin'];
						$client['fechahorafinexec'] = $client['nestedMission']['fechahorafinexec'];
					}
				}
			}

			$params = [
				'token' => $client['token'],
				'idmision' => $client['idmision'],
				'descripcion' => $client['descripcion'],
				'textomisionvalidacion' => $client['textovalidacion'],
				'textoiniciomision' => $client['textoiniciomision'],
				'textofinmision' => $client['textofinmision'],
				'textomisionok' => $client['textomisionok'],
				'textomisionko' => $client['textomisionko'],
				'tipomision' => $client['tipomision'],
				'desctipomision' => $client['desctipomision'],
				'fechahorainicio' => $client['fechahorainicio'],
				'fechahorainicioexec' => $client['fechahorainicioexec'],
				'fechahorafin' => $client['fechahorafin'],
				'fechahorafinexec' => $client['fechahorafinexec'],
				'importe' => $client['importe'],
				'encuesta' => $client['encuesta'],
				'idPlantillaReportes' => $client['idPlantillaReportes'],
				'currency' => $client['currency'],
				'country' => $client['country'],
				'order' => $client['order'],
				'importeinterno' => $client['importeinterno'],
				'finmisioncupo' => $client['finmisioncupo'],
				'textofinmisioncupo' => $client['textofinmisioncupo'],
				'currencyinterno' => $client['currencyinterno'],
				'needValidation' => $client['needValidation'],
				'cierreManual' => $client['manualClosing'],
				'textomisionkoAutoNoCumplimiento' => $client['textomisionkoAutoNoCumplimiento'],
				'usaComision' => $client['usaComision'],
				'importenocumplimiento' => $client['importenocumplimiento'],
				'currencynocumplimiento' => $client['currencynocumplimiento'],
				'misionInicial' => $client['misionInicial'],
				'misionInfinita' => $client['misionInfinita'],
				'idCliente' => $client['idCliente'],
				'tipoAnidada' => $client['tipoAnidada'],
				'estadoAnidada' => $estadoAnidada,
				'requiereTracking' => $client['requiereTracking'],
				'continuingMission' => $client['continuingMission'],
				'isAuditoria' => $client['isAuditoria']
			];
		}

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		if($resultPOST->status != 'OK') {
			return $resultPOST;
		}

		// Misión anidada
		if($client['nestedMission'] != 'null') {
			// Último parámetro con el stampMisión de la misión anidada
			$resultPOSTnestedMission = $this->utilesController->updateMision($client['token'], $client['nestedMission'], $client['stampMision']);

			if($resultPOSTnestedMission->status != 'OK') {
				return $resultPOSTnestedMission;
			}

			// Si se cambia de misión anidada se modifica la misión anterior
			if($client['nestedMissionOld'] != '' && $client['nestedMissionOld'] != $client['nestedMission']['stampMision']) {
				$nestedMissionOld = $this->getMision($client, $client['token'], $client['nestedMissionOld']);

				$params = (array)$nestedMissionOld->result[0];

				// Último parámetro vacío para desactivar la misión anidada
				$resultPOSTnestedMission = $this->utilesController->updateMision($client['token'], $params, '');

				if($resultPOSTnestedMission->status != 'OK') {
					return $resultPOSTnestedMission;
				}
			}
		}

		// Si se quita la misión anidada se modifica la misión padre
		if($client['nestedMissionOld'] != '' && $client['estadoAnidada'] == '') {
			$nestedMissionOld = $this->getMision($client, $client['token'], $client['nestedMissionOld']);

			$params = (array)$nestedMissionOld->result[0];

			// Último parámetro vacío para desactivar la misión anidada
			$resultPOSTnestedMission = $this->utilesController->updateMision($client['token'], $params, '');

			if($resultPOSTnestedMission->status != 'OK') {
				return $resultPOSTnestedMission;
			}
		}

		// Control de modificación de fecha/hora fin de misiones en curso
		if($client['endDateTimeMod'] === true) {
			$admin = $client['userMail'];
			$dateOld = $client['endDateTimeOld'];
			$dateNew = $client['fechahorafinexec'];
			$missionName = $client['idmision'];
			$message = "El usuario administrador: $admin, ha modificado la mision '$missionName' cambiando la fecha de fin de misión de $dateOld a $dateNew";
			$this->utilesController->setCMBPLOG($client['token'], 'SERVICE', 'updateMision', $message, '', '1');
		}

		// Envío de notificación a los usuarios que no respondieron la encuesta con la reapertura de misión
		if($client['reopeningMessage'] != '') {
			// Lista de difusión de los que aún no han participado
			$url = CONSTANTS::SERVERAPI . 'getCMBPMisionesNOParticipantes';
			$params = [
				'token' => $client['token'],
				'mision' => $client['idmision'],
				'idProject' => $client['projectListID']
			];

			$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

			if($resultPOST->status != 'OK') {
				return $resultPOST;
			}

			$listId = $resultPOST->listId;

			// Mandar mensaje de reapertura
			$dataMsg = [
				'message' => $client['reopeningMessage'],
				'from' => $client['UsuarioQueNotifica'],
				'emailsToSend' => '',
				'idlist' => $listId
			];

			$resultPOST = $this->utilesController->postMessageMultiple($client, $dataMsg, $client['token']);

			if($resultPOST->status != 'OK') {
				return $resultPOST;
			}

			$url = CONSTANTS::SERVERAPI . 'updateMisionFinNotificado';
			$params = [
				'token' => $client['token'],
				'idProject' => $client['projectListID'],
				'mision' => $client['idmision'],
				'Value' => '0'
			];

			$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

			if($resultPOST->status != 'OK') {
				return $resultPOST;
			}
		}

		// Control de finalización manual de misión
		if($client['manualClosing'] == '1') {
			$admin = $client['userMail'];
			$missionName = $client['idmision'];
			$message = "El usuario administrador: $admin, ha finalizado manualmente la mision '$missionName'";
			$this->utilesController->setCMBPLOG($client['token'], 'SERVICE', 'updateMision', $message, '', '1');
		}

		// Recordatorios
		if(count($client['reminders']) > 0 && $client['reminders'] != '[]') {
			if($client['remindersChange'] == 'true') {
				// Priemero borrar todos los recordatorios anteriores
				if(count($client['remindersId']) > 0 && $client['remindersId'] != '[]') {
					foreach($client['remindersId'] as $remindersId) {
						$resultPOST = $this->deleteCMBPNotificationsMission($client, $remindersId);

						if($resultPOST->status != 'OK') {
							return $resultPOST;
						}
					}
				}

				// Luego volverlos a guardar
				foreach($client['reminders'] as $reminder) {
					// Comprobación de recordatorios ya enviados
					$lastRun = explode('#', $reminder)[2];

					if($lastRun[2] == '') {
						$resultPOST = $this->setCMBPNotificationsMission($client, $reminder, $client['stampMision']);

						if($resultPOST->status != 'OK') {
							return $resultPOST;
						}
					}
				}
			}
		} else if(count($client['remindersId']) > 0 && $client['remindersId'] != '[]') {
			// Recordatorios a borrar
			foreach($client['remindersId'] as $remindersId) {
				$resultPOST = $this->deleteCMBPNotificationsMission($client, $remindersId);

				if($resultPOST->status != 'OK') {
					return $resultPOST;
				}
			}
		}

		// Editado a partir de producto
		if(isset($client['producto_mision']) && $client['producto_mision'] == '1') {
			return $resultPOST;
		}

		if($client['encuesta'] == '1' && $client['idEncuesta'] != '') {
			// Datos de encuesta
			$resultPOST = $this->setImporteStartDateExpireDateSurvey($client);
		}

		if($resultPOST->status == 'OK') {
			// Borrado de objetivos
			$url = CONSTANTS::SERVERAPI . 'deleteMisionObjetivos';
			$params = [
				'token' => $client['token'],
				'idmision' => $client['idmision']
			];

			$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

			if($resultPOST->status == 'OK') {
				// Creación de objetivos
				$url = CONSTANTS::SERVERAPI . 'setMisionObjetivo';
				if($client['encuesta'] == 1) {
					$params = [
						'token' => $client['token'],
						'idmision' => $client['idmision'],
						'objetivo' => $client['objetivo'],
						'descobjetivo' => $client['descobjetivo'],
						'encuesta' => $client['idEncuesta'],
						'descripcion' => $client['descencuesta']
					];
				} else if($client['order'] == 1) {
					$params = [
						'token' => $client['token'],
						'idmision' => $client['idmision'],
						'objetivo' => $client['objetivo'],
						'descobjetivo' => $client['descobjetivo'],
						'orderamount' => $client['orderamount'],
						'orderamountporcfinanciated' => $client['orderamountporcfinanciated'],
						'orderproductitem' => json_encode($client['orderproductitem']),
						'orderproductAmount' => json_encode($client['orderproductAmount']),
						'periodo' => $client['periodo'],
						'ordernumtimes' => $client['ordernumtimes']
					];
				} else {
					$params = [
						'token' => $client['token'],
						'idmision' => $client['idmision'],
						'objetivo' => $client['objetivo'],
						'descobjetivo' => $client['descobjetivo'],
						'numveces' => $client['numveces'],
						'periodo' => $client['periodo']
					];
				}

				$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

				// Registro de errores
				if($resultPOST->status != 'OK') {
					return $resultPOST;
				}

				// Exclusión de preguntas/respuestas
				if(($client['misionQuestionsArray'] !== '[]' || $client['misionQuestionsArrayControl'] == '1') && $client['encuesta'] == '1') {
					// Eliminación de valores anteriores
					$url3 = CONSTANTS::SERVERAPI . 'deleteMisionQuestionNoAccomplish';
					$params3 = [
						'token' => $client['token'],
						'idmision' => $client['idmision']
					];

					$resultPOST = $this->utilesController->sendCurlPOST($url3, $params3);

					// Registro de errores
					if($resultPOST->status != 'OK') {
						return $resultPOST;
					}

					// Exclusión de preguntas/respuestas
					if($client['misionQuestionsArray'] !== '[]' && $client['encuesta'] == '1') {
						$k = 0;
						// $misionQuestionsArray: ["order#columname#value#valuecode#valueInclusive#codeInclusive"] - FORMATO
						$size = count($client['misionQuestionsArray']);

						$misionQuestionsArray = '[';
						for($i = 0; $i < $size; $i++) {
							if($client['misionQuestionsArray'][$i]['type'] != 'K' && $client['misionQuestionsArray'][$i]['type'] != 'M') {
								$value = implode(',', $client['misionQuestionsArray'][$i]['value']);
								$valueInclusive = implode(',', $client['misionQuestionsArray'][$i]['valueInclusive']);
								$code = implode(',', $client['misionQuestionsArray'][$i]['code']);
								$codeInclusive = implode(',', $client['misionQuestionsArray'][$i]['codeInclusive']);
								$string = $k . '#' . $client['misionQuestionsArray'][$i]['columnName'] . '#' . strval($value) . '#' . strval($code) . '#' . strval($valueInclusive) . '#' . strval($codeInclusive);
								$misionQuestionsArray .= '"' . $string . '",';
								$k++;
							} else if($client['misionQuestionsArray'][$i]['type'] == 'M') {
								for($x = 0; $x < count($client['misionQuestionsArray'][$i]['value']); $x++) {
									$string = $k . '#' . $client['misionQuestionsArray'][$i]['columnName'] . $client['misionQuestionsArray'][$i]['code'][$x] . '#' . $client['misionQuestionsArray'][$i]['value'][$x] . '#Y##';
									$misionQuestionsArray .= '"' . $string . '",';
									$k++;
								}
								for($x = 0; $x < count($client['misionQuestionsArray'][$i]['valueInclusive']); $x++) {
									$string = $k . '#' . $client['misionQuestionsArray'][$i]['columnName'] . $client['misionQuestionsArray'][$i]['codeInclusive'][$x] . '###' . $client['misionQuestionsArray'][$i]['valueInclusive'][$x] . '#Y';
									$misionQuestionsArray .= '"' . $string . '",';
									$k++;
								}
							} else {
								$sizeK = count($client['misionQuestionsArray'][$i]['valuesSQ']);
								for($j = 0; $j < $sizeK; $j++) {
									$columnNameKArray = explode('|', $client['misionQuestionsArray'][$i]['valuesSQ'][$j]);
									$columnNameK = $columnNameKArray[0];
									$value = implode(',', $client['misionQuestionsArray'][$i]['value'][$columnNameK]);
									$code = implode(',', $client['misionQuestionsArray'][$i]['code'][$columnNameK]);
									$valueInclusive = implode(',', $client['misionQuestionsArray'][$i]['valueInclusive'][$columnNameK]);
									$codeInclusive = implode(',', $client['misionQuestionsArray'][$i]['codeInclusive'][$columnNameK]);
									$string = $k . '#' . $columnNameK . '#' . $value . '#' . $code . '#' . $valueInclusive . '#' . $codeInclusive;
									$misionQuestionsArray .= '"' . $string . '",';
									$k++;
								}
							}
						}
						$misionQuestionsArray = substr($misionQuestionsArray, 0, -1);
						$misionQuestionsArray .= ']';

						$url2 = CONSTANTS::SERVERAPI . 'addMisionQuestionNoAccomplish';
						$params2 = [
							'token' => $client['token'],
							'idmision' => $client['idmision'],
							'misionQuestionsArray' => $misionQuestionsArray
						];

						$resultPOST = $this->utilesController->sendCurlPOST($url2, $params2);
					}
				}
				return $resultPOST;
			} else {
				return $resultPOST;
			}
		} else {
			return $resultPOST;
		}
	}

	// Crear/editar tipo de misión
	public function setTipoMision($client) {
		// Borra el tipo de misión para editarlo
		if($client['todo'] == 'edit') {
			$url = CONSTANTS::SERVERAPI . 'deleteTipoMision';
			$params = [
				'token' => $client['token'],
				'tipomision' => $client['tipomision']
			];

			$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

			if($resultPOST->status != 'OK') {
				return $resultPOST;
			}
		}

		// Crea el tipo de misión
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'tipomision' => $client['tipomision'],
			'descripcion' => $client['descripcion'],
			'survey' => $client['survey'],
			'order' => $client['order'],
			'needValidation' => $client['needValidation'],
			'isPassiveTracking' => $client['isPassiveTracking'],
			'isVideocall' => $client['isVideocall'],
			'isAuditoria' => $client['isAuditoria'],
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		if($resultPOST->status == 'OK') {
			// Borra el objetivo de misión para editarlo
			if($client['todo'] == 'edit') {
				$url = CONSTANTS::SERVERAPI . 'deleteAllTipoMisionObjetivos';
				$params = [
					'token' => $client['token'],
					'tipomision' => $client['tipomision']
				];

				$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

				if($resultPOST->status != 'OK') {
					return $resultPOST;
				}
			}

			// Crea el objetivo de misión
			$url = CONSTANTS::SERVERAPI . 'setAllTipoMisionObjetivos';
			$params = [
				'token' => $client['token'],
				'tipomision' => $client['tipomision'],
				'objetivo' => $client['objetivo']
			];

			$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

			return $resultPOST;
		} else {
			return $resultPOST;
		}
	}

	// Eliminar tipo de misión
	public function deleteTipoMision($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];

		if($client['missionsType'] != '[]') {
			foreach($client['missionsType'] as $missionType) {
				$params = [
					'token' => $client['token'],
					'tipomision' => $missionType['id']
				];

				$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

				if($resultPOST->status != 'OK') {
					return $resultPOST;
				}
			}
		} else {
			$resultPOST = [
				'status' => 'OK'
			];
		}

		return $resultPOST;
	}

	// Modificación de avisos de cumplimiento
	public function deleteAllAvisosDisableUserAuto($client) {
		// Borra la lista de avisos
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		if($resultPOST->status == 'OK') {
			// Guarda la nueva lista de avisos
			$url = CONSTANTS::SERVERAPI . 'saveAllAvisosDisableUserAuto';
			$params = [
				'token' => $client['token'],
				'avisos' => json_encode($client['avisos']),
				'disableuserslastwarning' => $client['disableuserslastwarning']
			];

			$resultPOST = $this->utilesController->sendCurlPOST($url, $params);
		}

		return $resultPOST;
	}

	// Actualización de inicio de misión
	public function clientUpdateMisionInicioNotificado($client) {
		$url = CONSTANTS::SERVERAPI . 'updateMisionInicioNotificado';
		$params = [
			'token' => $client['token'],
			'idProject' => $client['idProject'],
			'mision' => $client['mision'],
			'Value' => $client['Value'],
			'idTenant' => $client['idTenant'],
			'idCPG' => $client['idCPG']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Actualización de fin de misión
	public function clientUpdateMisionFinNotificado($client) {
		$url = CONSTANTS::SERVERAPI . 'updateMisionFinNotificado';
		$params = [
			'token' => $client['token'],
			'idProject' => $client['idProject'],
			'mision' => $client['mision'],
			'Value' => $client['Value'],
			'idTenant' => $client['idTenant'],
			'idCPG' => $client['idCPG']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Actualización de Encuesta
	public function setImporteStartDateExpireDateSurvey($client) {
		// Formato de fecha/hora de inicio
		$startArray = explode(' ', $client['fechahorainicioexec']);
		$dateStartArray = explode('/', $startArray[0]);
		$startdate = $dateStartArray[2] . '-' . $dateStartArray[1] . '-' . $dateStartArray[0] . ' ' . $startArray[1];
		// Formato de fecha/hora de fin
		$endArray = explode(' ', $client['fechahorafinexec']);
		$dateEndArray = explode('/', $endArray[0]);
		$expiresdate = $dateEndArray[2] . '-' . $dateEndArray[1] . '-' . $dateEndArray[0] . ' ' . $endArray[1];

		$url = CONSTANTS::SERVERAPI . 'setImporteStartDateExpireDateSurvey';
		$params = [
			'token' => $client['token'],
			'survey' => $client['idEncuesta'],
			'importe' => $client['importe'],
			'startdate' => $startdate,
			'expiresdate' => $expiresdate
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Guardar notificaciones de recordatorio de misión
	public function setCMBPNotificationsMission($client, $reminder, $stampMision) {
		// Guardar notificación para lista
		// ID
		$dateMission = new DateTime();
		$id = intval($dateMission->format('YnjHisv'));
		// Formato FechaHoraEjecucionUnica
		$reminderArray = explode('#', $reminder);
		$dateTimeArray = explode(' ', $reminderArray[0]);
		$dateArray = explode('-', $dateTimeArray[0]);
		$date = $dateArray[2] . '/' . $dateArray[1] . '/' . $dateArray[0];
		$time = str_replace(':', '#', $dateTimeArray[1]);
		$dateTimeExec = $date . '#' . $time . '#00';
		$aux01 = $date . ' ' . $dateTimeArray[1] . ':00 24';
		$reminderName = $client['recordatorios'] . ' - ' . $client['idmision'] . ' - ' . $date . ' ' . $dateTimeArray[1];

		$url = CONSTANTS::SERVERAPI . 'setCMBPNotifications';
		$params = [
			'token' => $client['token'],
			'id' => $id,
			'Descripcion' => $reminderName,
			'TipoNotificacion' => 2,
			'TiempoEntreEjecuciones' => '',
			'UnidadDeTiempo' => '',
			'FechaHoraEjecucionUnica' => $dateTimeExec,
			'Activa' => '1',
			'EstiloNotificacion' => '0',
			'UsuarioQueNotifica' => $client['UsuarioQueNotifica'],
			'DescUsuarioQueNotifica' => $client['DescUsuarioQueNotifica'],
			'UsuarioANotificar' => '',
			'DescUsuarioANotificar' => '',
			'GrupoANotificar' => '',
			'DescGrupoANotificar' => '',
			'ListaANotificar' => $client['ListaDistribucionID'],
			'DescListaANotificar' => '',
			'MotivoNotificacion' => '0',
			'ArchivoANotificar' => '',
			'TipoArchivoANotificar' => '',
			'MensajeANotificar' => $reminderArray[1],
			'EncuestaANotificar' => '',
			'DescEncuestaANotificar' => '',
			'UsuarioAlta' => $client['userMail'],
			'FechaAlta' => $dateMission->format('d/m/Y H:i:s'),
			'UsuarioUltimaModificacion' => $client['userMail'],
			'FechaUltimaModificacion' => $dateMission->format('d/m/Y H:i:s'),
			'FechaUltimaEjecucion' => '',
			'Observaciones1' => '',
			'Observaciones2' => '',
			'Aux01' => $aux01,
			'Aux02' => '',
			'Aux03' => '',
			'Aux04' => '',
			'Aux05' => '',
			'NumVecesCiclica' => '',
			'country' => $client['country'],
			'missionRemember' => '1',
			'missionStamp' => $stampMision,
			'mission' => $client['idmision'],
			'idProject' => $client['projectListID']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Eliminar notificación de recordatorio de misión
	public function deleteCMBPNotificationsMission($client, $remindersId) {
		$url = CONSTANTS::SERVERAPI . 'deleteCMBPNotifications';
		$params = [
			'token' => $client['token'],
			'id' => $remindersId
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Petición de usuarios notificados en una misión
	public function getNumParticipantesNotificados($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'stampMision' => $client['stampMision'],
			'project' => $client['project'],
			'typeMsg' => $client['typeMsg'],
			'descripcion' => $client['descripcion']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Petición de proyectos por misión
	public function getMisionesProjects($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'stampMision' => $client['stampMision']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Enviar notificación a usuarios no notificados
	public function sendMisionMessageUsersNotNotified($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'stampMision' => $client['stampMision'],
			'project' => $client['project'],
			'typeMsg' => $client['typeMsg']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Petición de exclusiones por respuesta/pregunta
	public function getMisionQuestionNoAccomplish($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'idmision' => $client['idmision']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Petición de mision en curso con cupo
	public function getCMBPMisionFinCupo($client) {
		$url = CONSTANTS::SERVERAPI . 'getCMBPMisionesFinCupo';
		$params = [
			'token' => $client['token']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		$response['cumplimiento'] = '0';
		$response['result'] = $resultPOST->result;
		$response['status'] = $resultPOST->status;

		foreach ($resultPOST->result as $value) {
			if($client['idMission'] == $value->idmision) {
				if($response['cumplimiento'] < $value->Cumplimiento) {
					$response['cumplimiento'] = $value->Cumplimiento;
				}
			}
		}

		return $response;
	}

	// Petición de mision en curso sin cupo - Devuelve el cupo mínimo en función del cumplimiento actual en todos los proyectos relacionados con la misión
	public function getCumplimientoMision($client) {
		$urlSnap = CONSTANTS::SERVERAPI . 'getSnapAcualMisionCumplimiento';
		$url = CONSTANTS::SERVERAPI . 'getAnalyticsMisiones';

		$cupoMinimo = 0;

		$projects = explode(',', $client['projects']);

		foreach($projects as $project) {
			$params = [
				'token' => $client['token'],
				'project' => $project,
				'mision' => $client['mision']
			];

			$resultPOSTSnap = $this->utilesController->sendCurlPOST($urlSnap, $params);

			$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

			if($resultPOST->result->totalOK[0]->resultadoOK > $cupoMinimo) {
				$cupoMinimo = $resultPOST->result->totalOK[0]->resultadoOK;
			}
		}

		$response['result'] = $cupoMinimo;
		$response['status'] = 'OK';

		return $response;
	}

	// Generar links de mision
	public function getMissionSurveyLinks($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'participants' => json_encode($client['participants']),
			'idMission' => $client['idMission']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Petición de encuestas con misión
	public function getAllSurveysWithMissions($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'idCliente' => $client['idCliente']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}
}