<?php
include_once (dirname(__FILE__) . '/UtilesController.php');
include_once (dirname(__FILE__) . '/ListasDifusionController.php');
include_once (dirname(__FILE__) . '/../Model/GenerateTableExcel.php');

class NotificacionesController {
	private $utilesController;
	private $listasDifusionController;

	function __construct() {
		$this->utilesController = new UtilesController();
		$this->listasDifusionController = new ListasDifusionController();
	}

	// Petición de todas las notificaciones
	public function getCMBPNotifications($client, $id, $token, $serviceExecution = null) {
		$url = CONSTANTS::SERVERAPI . 'getCMBPNotifications';
		if (!isset($id)) {
			$id = $client['id'];
		}
		if (!isset($token)) {
			$token = $client['token'];
		}
		if (!isset($serviceExecution)) {
			$serviceExecution = '';
		}
		$params = [
			'token' => $token,
			'id' => $id,
			'serviceExecution' => $serviceExecution
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	public function getPagosPendientesPorPais($country, $token) {
		$url = CONSTANTS::SERVERAPI . 'getPagosPendientesByCountry';
		$params = [
			'token' => $token,
			'country' => $country
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	public function getCMBPNotificationsSchedulePayments($client, $id, $token) {
		$url = CONSTANTS::SERVERAPI . 'getScheduledPaymentById';
		if (!isset($id)) {
			$id = $client['id'];
		}
		if (!isset($token)) {
			$token = $client['token'];
		}
		$params = [
			'token' => $token,
			'id' => $id
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Guardar notificación
	public function setCMBPNotifications($client) {
		// Archivo a subir
		if (isset($_FILES['ArchivoANotificar'])) {
			$fileNotif = $_FILES['ArchivoANotificar'];
			$fecha = date_create();
			$archivo = CONSTANTS::PATH_EXPORT_WORD . '/notificaciones/' . $client['id'];
			if (!file_exists($archivo)) {
				$createFile = $this->utilesController->createDirectory($archivo);

				if ($createFile['status'] == 'KO') {
					return $createFile;
				}
			}

			// Comprobación de nombre original
			$strangerCharts = ['?', '[', ']', '/', '\\', '=', '<', '>', ':', ';', ',', '\'', '"', '&', '$', '#', '*', '(', ')', '|', '~', '`', '!', '{', '}', '%', '+'];
			for ($i = 0; $i < count($strangerCharts); $i++) {
				if (strpos($fileNotif['name'], $strangerCharts[$i]) !== false) {
					$resultPOST = [
						'status' => 'KO',
						'result' => 'The file name is not correct'
					];
					return $resultPOST;
				}
			}

			// Lista de extensiones permitidas
			$safeList = ['avi', 'gif', 'jpg', 'jpeg', 'mpeg', 'pdf', 'wav', 'weba', 'webm', 'png', 'mp3', 'mov', 'mp4', 'bmp'];
			$nameArray = explode('.', $fileNotif['name']);
			$lastPosition = count($nameArray) - 1;
			$extension = $nameArray[$lastPosition];
			$extension = strtolower($extension);
			if (!in_array($extension, $safeList)) {
				$resultPOST = [
					'status' => 'KO',
					'result' => 'The extension name is not correct'
				];
				return $resultPOST;
			}

			$name = date_timestamp_get($fecha) . $fileNotif['name'];
			$name = trim(strtolower($name));
			$name = str_replace(' ', '_', $name);

			// Reemplazar letras con acentos
			$name = $this->utilesController->removeAccents($name);

			if (!move_uploaded_file($fileNotif['tmp_name'], $archivo . '/' . $name)) {
				$resultPOST = [
					'status' => 'KO',
					'result' => 'Error uploading image'
				];
				return $resultPOST;
			}
		} else if (isset($client['ArchivoANotificar'])) {
			$name = $client['ArchivoANotificar'];
		} else {
			$name = '';
		}

		$date = new DateTime();

		$url = CONSTANTS::SERVERAPI . 'setCMBPNotifications';
		$params = [
			'token' => $client['token'],
			'id' => $client['id'],
			'Descripcion' => $client['Descripcion'],
			'TipoNotificacion' => $client['TipoNotificacion'],
			'TiempoEntreEjecuciones' => $client['TiempoEntreEjecuciones'],
			'UnidadDeTiempo' => $client['UnidadDeTiempo'],
			'FechaHoraEjecucionUnica' => $client['FechaHoraEjecucionUnica'],
			'Activa' => $client['Activa'],
			'EstiloNotificacion' => $client['EstiloNotificacion'],
			'UsuarioQueNotifica' => $client['UsuarioQueNotifica'],
			'DescUsuarioQueNotifica' => $client['DescUsuarioQueNotifica'],
			'UsuarioANotificar' => $client['UsuarioANotificar'],
			'DescUsuarioANotificar' => $client['DescUsuarioANotificar'],
			'GrupoANotificar' => $client['GrupoANotificar'],
			'DescGrupoANotificar' => $client['DescGrupoANotificar'],
			'ListaANotificar' => $client['ListaANotificar'],
			'DescListaANotificar' => $client['DescListaANotificar'],
			'MotivoNotificacion' => $client['MotivoNotificacion'],
			'ArchivoANotificar' => $name,
			'TipoArchivoANotificar' => $client['TipoArchivoANotificar'],
			'MensajeANotificar' => $client['MensajeANotificar'],
			'EncuestaANotificar' => $client['EncuestaANotificar'],
			'DescEncuestaANotificar' => $client['DescEncuestaANotificar'],
			'UsuarioAlta' => $client['UsuarioAlta'],
			'FechaAlta' => $date->format('d/m/Y H:i:s'),
			'UsuarioUltimaModificacion' => $client['UsuarioUltimaModificacion'],
			'FechaUltimaModificacion' => $date->format('d/m/Y H:i:s'),
			'FechaUltimaEjecucion' => $client['FechaUltimaEjecucion'],
			'Observaciones1' => $client['Observaciones1'],
			'Observaciones2' => $client['Observaciones2'],
			'Aux01' => $client['Aux01'],
			'Aux02' => $client['Aux02'],
			'Aux03' => $client['Aux03'],
			'Aux04' => $client['Aux04'],
			'Aux05' => $client['Aux05'],
			'NumVecesCiclica' => $client['NumVecesCiclica'],
			'country' => $client['country']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Editar notificación
	public function updateCMBPNotifications($client) {
		// Archivo a subir
		if ($client['fileSend'] == 'true') {
			if (isset($_FILES['ArchivoANotificar'])) {
				$fileNotif = $_FILES['ArchivoANotificar'];
				$fecha = date_create();
				$archivo = CONSTANTS::PATH_EXPORT_WORD . '/notificaciones/' . $client['id'];

				if (!file_exists($archivo)) {
					$createFile = $this->utilesController->createDirectory($archivo);

					if ($createFile['status'] == 'KO') {
						return $createFile;
					}
				}

				// Comprobación de nombre original
				$strangerCharts = ['?', '[', ']', '/', '\\', '=', '<', '>', ':', ';', ',', '\'', '"', '&', '$', '#', '*', '(', ')', '|', '~', '`', '!', '{', '}', '%', '+'];
				for ($i = 0; $i < count($strangerCharts); $i++) {
					if (strpos($fileNotif['name'], $strangerCharts[$i]) !== false) {
						$resultPOST = [
							'status' => 'KO',
							'result' => 'The file name is not correct'
						];
						return $resultPOST;
					}
				}

				$name = date_timestamp_get($fecha) . $fileNotif['name'];
				$name = trim(strtolower($name));
				$name = str_replace(' ', '_', $name);

				// Reemplazar letras con acentos
				$name = $this->utilesController->removeAccents($name);
				if (!move_uploaded_file($fileNotif['tmp_name'], $archivo . '/' . $name)) {
					$resultPOST = [
						'status' => 'KO',
						'result' => 'Error uploading image'
					];
					return $resultPOST;
				}
			} else {
				$name = '';
			}
		} else {
			$name = $client['ArchivoANotificar'];
		}

		$date = new DateTime();

		$url = CONSTANTS::SERVERAPI . 'updateCMBPNotifications';
		$params = [
			'token' => $client['token'],
			'id' => $client['id'],
			'Descripcion' => $client['Descripcion'],
			'TipoNotificacion' => $client['TipoNotificacion'],
			'TiempoEntreEjecuciones' => $client['TiempoEntreEjecuciones'],
			'UnidadDeTiempo' => $client['UnidadDeTiempo'],
			'FechaHoraEjecucionUnica' => $client['FechaHoraEjecucionUnica'],
			'Activa' => $client['Activa'],
			'EstiloNotificacion' => $client['EstiloNotificacion'],
			'UsuarioQueNotifica' => $client['UsuarioQueNotifica'],
			'DescUsuarioQueNotifica' => $client['DescUsuarioQueNotifica'],
			'UsuarioANotificar' => $client['UsuarioANotificar'],
			'DescUsuarioANotificar' => $client['DescUsuarioANotificar'],
			'GrupoANotificar' => $client['GrupoANotificar'],
			'DescGrupoANotificar' => $client['DescGrupoANotificar'],
			'ListaANotificar' => $client['ListaANotificar'],
			'DescListaANotificar' => $client['DescListaANotificar'],
			'MotivoNotificacion' => $client['MotivoNotificacion'],
			'ArchivoANotificar' => $name,
			'TipoArchivoANotificar' => $client['TipoArchivoANotificar'],
			'MensajeANotificar' => $client['MensajeANotificar'],
			'EncuestaANotificar' => $client['EncuestaANotificar'],
			'DescEncuestaANotificar' => $client['DescEncuestaANotificar'],
			'UsuarioUltimaModificacion' => $client['UsuarioUltimaModificacion'],
			'FechaUltimaModificacion' => $date->format('d/m/Y H:i:s'),
			'FechaUltimaEjecucion' => '',
			'Observaciones1' => '',
			'Observaciones2' => '',
			'Aux01' => $client['Aux01'],
			'Aux02' => '',
			'Aux03' => '',
			'Aux04' => '',
			'Aux05' => '',
			'NumVecesCiclica' => $client['NumVecesCiclica'],
			'country' => $client['country']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Ejecutar notificación Schedule Payments
	public function executeNofiticationSchedulePayments($client, $id, $token) {
		if (!isset($id)) {
			$id = $client['id'];
		}
		if (!isset($token)) {
			$token = $client['token'];
		}

		$notification = $this->getCMBPNotificationsSchedulePayments($client, $id, $token);

		if ($notification->status == 'OK') {
			$data = $notification->result[0];
		} else {
			return $notification;
		}

		$dataRows = $this->getPagosPendientesPorPais($data->country, $token);

		if ($dataRows->numRows != '0') {
			$cabeceras = 'stamp';
			$cabeceras .= ',user';
			$cabeceras .= ',name';
			$cabeceras .= ',clabeInterbancaria';
			$cabeceras .= ',tipoIdentificacionDesc';
			$cabeceras .= ',userIdentificador';
			$cabeceras .= ',sid';
			$cabeceras .= ',concepto';
			$cabeceras .= ',valor';
			$cabeceras .= ',country';
			$cabeceras .= ',ciudad';
			$cabeceras .= ',direccion';
			$cabeceras .= ',telefono';
			$cabeceras .= ',bancoReceptor';
			$cabeceras .= ',bancoReceptorDesc';
			$cabeceras .= ',tipoCuentaBancariaDesc';
			$cabeceras .= ',fecha';
			$cabeceras .= ',cobrado';
			$cabeceras .= ',comentarios';

			$date = date_create();
			$stamp = date_timestamp_get($date);
			$timeStamp = $stamp * 1000;

			$generateTableExcel = new GenerateTableExcel();
			$filename = $generateTableExcel->printExcelFromResultOrdered($dataRows, $cabeceras, $timeStamp);

			$dataMsg = [
				'message' => $data->Cuerpo,
				'email' => $data->MailTo,
				'asunto' => $data->Asunto,
				'body' => $data->Cuerpo,
				'file' => $filename
			];

			$result = $this->SendEmailScheduledPayment($client, $dataMsg, $token, 'ScheduledPayment_' . $data->country . '.xlsx');

			if ($result->status != 'OK') {
				throw new Exception('KO');
			}

			$data->ArchivoANotificar = $filename;
			$data->TipoArchivoANotificar = '';
			$data->MensajeANotificar = $data->mensajePush;

			try {
				// Comprobar si hay que notificar a un usuario
				$date = new DateTime();
				if ($data->UsuarioANotificar != '') {
					if ($data->MensajeANotificar != '') {
						$dataMsg = [
							'message' => $data->MensajeANotificar,
							'to' => $data->UsuarioANotificar,
							'from' => $data->usuarioQueNotifica
						];

						$result = $this->PostMessageToUser($client, $dataMsg, $token);

						if ($result->status != 'OK') {
							throw new Exception('KO');
						}
					}
				}

				// Comprobar si hay que notificar a un grupo
				if ($data->GrupoANotificar != '') {
					if ($data->MensajeANotificar != '') {
						$dataMsg = [
							'message' => $data->MensajeANotificar,
							'to' => $data->GrupoANotificar,
							'from' => $data->usuarioQueNotifica
						];

						$result = $this->PostMessageToGroup($client, $dataMsg, $token);

						if ($result->status != 'OK') {
							throw new Exception('KO');
						}
					}
				}

				// Comprobar si hay que notificar a una lista
				if ($data->ListaANotificar != '') {
					if ($data->MensajeANotificar != '') {
						$dataMsg = [
							'message' => $data->MensajeANotificar,
							'emailsToSend' => '',
							'from' => $data->usuarioQueNotifica,
							'idlist' => $data->ListaANotificar
						];

						$result = $this->utilesController->postMessageMultiple($client, $dataMsg, $token);

						if ($result->status != 'OK') {
							throw new Exception('KO');
						}
					}
				}

				$response = $this->updateCMBPNotificationsSchedulePaymentsExecution($id, $date->format('d/m/Y H:i:s'), '', '', $token, $data->idTenant, $data->idCPG);
				return $response;
			} catch (Exception $e) {
				$response = $this->updateCMBPNotificationsSchedulePaymentsExecution($id, $date->format('d/m/Y H:i:s'), 'ERROR', $e, $token, $data->idTenant, $data->idCPG);
				return $response;
			}
		} else {
			$resultPOST = [
				'result' => 'OK'
			];
			return $resultPOST;
		}
	}

	// Ejecutar notificación
	public function executeNofitication($client, $id, $token, $serviceExecution) {
		if (!isset($id)) {
			$id = $client['id'];
		}
		if (!isset($token)) {
			$token = $client['token'];
		}

		$notification = $this->getCMBPNotifications($client, $id, $token, $serviceExecution);

		// Comprobar si es de recordatorio
		if ($notification->status == 'OK') {
			if ($notification->result[0]->missionRemember == '1') {
				$url = CONSTANTS::SERVERAPI . 'postMessageMultipleRemember';
				$params = [
					'token' => $token,
					'from' => $notification->result[0]->UsuarioQueNotifica,
					'emailsToSend' => '',
					'message' => $notification->result[0]->MensajeANotificar,
					'idlist' => $notification->result[0]->ListaANotificar,
					'project' => $notification->result[0]->idProject,
					'idmision' => $notification->result[0]->mission
				];

				$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

				return $resultPOST;
			} else {
				$data = $notification->result[0];
			}
		} else {
			return $notification;
		}

		switch ($data->MotivoNotificacion) {
			case '0':
				$data->ArchivoANotificar = '';
				$data->TipoArchivoANotificar = '';
				$data->EncuestaANotificar = '';
				$data->DescEncuestaANotificar = '';
				break;
			case '1':
				$data->EncuestaANotificar = '';
				$data->DescEncuestaANotificar = '';
				break;
			case '2':
				$data->ArchivoANotificar = '';
				$data->TipoArchivoANotificar = '';
				$data->MensajeANotificar = '';
				break;
		}

		try {
			// Comprobar si hay que notificar a un usuario
			$date = new DateTime();
			if ($data->UsuarioANotificar != '') {
				if ($data->ArchivoANotificar != '') {
					$dataFile = [
						'file' => $data->ArchivoANotificar,
						'message' => $data->MensajeANotificar,
						'to' => $data->UsuarioANotificar,
						'from' => $data->UsuarioQueNotifica,
						'TipoArchivoANotificar' => $data->TipoArchivoANotificar
					];

					$result = $this->SendFileToUser($client, $dataFile, $id);

					if ($result->status != 'OK') {
						$response['status'] = 'KO';
						$response['resp'] = 'image';
						return $response;
					}
				} else if ($data->MensajeANotificar != '') {
					$dataMsg = [
						'message' => $data->MensajeANotificar,
						'to' => $data->UsuarioANotificar,
						'from' => $data->UsuarioQueNotifica
					];

					$result = $this->PostMessageToUser($client, $dataMsg, $token);

					if ($result->status != 'OK') {
						throw new Exception('KO');
					}
				} else if ($data->EncuestaANotificar != '') {
					$dataSurvey = [
						'from' => $data->UsuarioQueNotifica,
						'emailsToSend' => [$data->UsuarioANotificar],
						'message' => $data->EncuestaANotificar,
						'idlist' => '',
						'misionStamp' => ''
					];

					$result = $this->postSurvey($client, $dataSurvey);

					if ($result->status != 'OK') {
						throw new Exception('KO');
					}
				}
			}

			// Comprobar si hay que notificar a un grupo
			if ($data->GrupoANotificar != '') {
				if ($data->ArchivoANotificar != '') {
					$dataFile = [
						'file' => $data->ArchivoANotificar,
						'message' => $data->MensajeANotificar,
						'to' => $data->GrupoANotificar,
						'from' => $data->UsuarioQueNotifica,
						'TipoArchivoANotificar' => $data->TipoArchivoANotificar
					];

					$result = $this->SendFileToGroup($client, $dataFile, $id);

					if ($result->status != 'OK') {
						$response['status'] = 'KO';
						$response['resp'] = 'image';
						return $response;
					}
				} else if ($data->MensajeANotificar != '') {
					$dataMsg = [
						'message' => $data->MensajeANotificar,
						'to' => $data->GrupoANotificar,
						'from' => $data->UsuarioQueNotifica
					];

					$result = $this->PostMessageToGroup($client, $dataMsg, $token);

					if ($result->status != 'OK') {
						throw new Exception('KO');
					}
				} else if ($data->EncuestaANotificar != '') {
					$dataSurvey = [
						'from' => $data->UsuarioQueNotifica,
						'to' => $data->GrupoANotificar,
						'message' => $data->EncuestaANotificar
					];

					$result = $this->postGroupSurvey($client, $dataSurvey);

					if ($result->status != 'OK') {
						throw new Exception('KO');
					}
				}
			}

			// Comprobar si hay que notificar a una lista
			if ($data->ListaANotificar != '') {
				$list = $this->listasDifusionController->getDistributionListUsers($client, $data->ListaANotificar);

				$usersList = [];
				if ($list->status == 'OK' && count($list->result) > 0) {
					foreach ($list->result as $user) {
						array_push($usersList, $user->jidUser);
					}
				}

				if ($data->ArchivoANotificar != '') {
					// Obtener usuarios de la lista
					$dataFile = [
						'file' => $data->ArchivoANotificar,
						'message' => $data->MensajeANotificar,
						'to' => json_encode($usersList),
						'from' => $data->UsuarioQueNotifica,
						'TipoArchivoANotificar' => $data->TipoArchivoANotificar,
						'idlist' => $data->ListaANotificar
					];

					$result = $this->SendFileToList($client, $dataFile, $id);

					if ($result->status != 'OK') {
						$response['status'] = 'KO';
						$response['resp'] = 'image';
						return $response;
					}
				} else if ($data->MensajeANotificar != '') {
					$dataMsg = [
						'message' => $data->MensajeANotificar,
						'emailsToSend' => json_encode($usersList),
						'from' => $data->UsuarioQueNotifica,
						'idlist' => $data->ListaANotificar
					];

					$result = $this->utilesController->postMessageMultiple($client, $dataMsg, $token);

					if ($result->status != 'OK') {
						throw new Exception('KO');
					}
				} else if ($data->EncuestaANotificar != '') {
					$dataSurvey = [
						'from' => $data->UsuarioQueNotifica,
						'emailsToSend' => json_encode($usersList),
						'message' => $data->EncuestaANotificar,
						'idlist' => $data->ListaANotificar,
						'misionStamp' => ''
					];

					$result = $this->postSurvey($client, $dataSurvey);

					if ($result->status != 'OK') {
						throw new Exception('KO');
					}
				}
			}

			$response = $this->updateCMBPNotificationsExecution($id, $date->format('d/m/Y H:i:s'), '', '', $token, $data->idTenant, $data->idCPG);
			return $response;
		} catch (Exception $e) {
			$response = $this->updateCMBPNotificationsExecution($id, $date->format('d/m/Y H:i:s'), 'ERROR', $e, $token, $data->idTenant, $data->idCPG);
			return $response;
		}
	}

	// Eliminar notificación
	public function deleteCMBPNotifications($client) {
		$url = CONSTANTS::SERVERAPI . 'deleteCMBPNotifications';

		if ($client['notifications'] != '[]') {
			foreach ($client['notifications'] as $notification) {
				$params = [
					'token' => $client['token'],
					'id' => $notification['id']
				];

				$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

				if ($resultPOST->status != 'OK') {
					return $resultPOST;
				}
			}
		} else {
			$resultPOST = [
				'status' => 'OK'
			];
		}

		return $resultPOST;
	}

	// Enviar notificación con adjunto a usuario
	public function SendFileToUser($client, $data, $id) {
		// Comprobar el tipo de archivo a enviar
		switch ($data['TipoArchivoANotificar']) {
			case 'Imagen':
				$action = 'sendImage';
				break;
			case 'Video':
				$action = 'sendVideo';
				break;
			case 'PDF':
				$action = 'sendPDF';
				break;
		}

		$archivo = CONSTANTS::PATH_EXPORT_WORD . '/notificaciones/' . $id . '/' . $data['file'];
		$type = mime_content_type($archivo);

		if ($type === null) {
			$resultPOST = [
				'status' => 'KO',
				'result' => 'File not found'
			];
			return $resultPOST;
		}

		$file_info = pathinfo($data['file']);
		if ($type === "application/octet-stream" && $file_info['extension'] == 'mp4') {
			$fileName = $file_info['basename'];
			$fileType = 'video/mp4';
		} else {
			$fileName = $file_info['filename'] . '.' . pathinfo($archivo, PATHINFO_EXTENSION);
			$fileType = $type;
		}
		$filecurl = new CURLFile($archivo, $fileType, $fileName);

		$url = CONSTANTS::SERVERAPI . $action;
		$params = [
			'token' => $client['token'],
			'file' => $filecurl,
			'message' => $data['message'],
			'to' => $data['to'],
			'from' => $data['from']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Enviar notificación con adjunto a grupo
	public function SendFileToGroup($client, $data, $id) {
		// Comprobar el tipo de archivo a enviar
		switch ($data['TipoArchivoANotificar']) {
			case 'Imagen':
				$action = 'sendImageGroup';
				break;
			case 'Video':
				$action = 'sendVideoGroup';
				break;
			case 'PDF':
				$action = 'sendPDFGroup';
				break;
		}

		$archivo = CONSTANTS::PATH_EXPORT_WORD . '/notificaciones/' . $id . '/' . $data['file'];

		$type = mime_content_type($archivo);

		if ($type === null) {
			$resultPOST = [
				'status' => 'KO',
				'result' => 'File not found'
			];
			return $resultPOST;
		}

		$file_info = pathinfo($data['file']);
		if ($type === "application/octet-stream" && $file_info['extension'] == 'mp4') {
			$fileName = $file_info['basename'];
			$fileType = 'video/mp4';
		} else {
			$fileName = $file_info['filename'] . '.' . pathinfo($archivo, PATHINFO_EXTENSION);
			$fileType = $type;
		}
		$filecurl = new CURLFile($archivo, $fileType, $fileName);

		$url = CONSTANTS::SERVERAPI . $action;
		$params = [
			'token' => $client['token'],
			'file' => $filecurl,
			'message' => $data['message'],
			'to' => $data['to'],
			'from' => $data['from']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Enviar notificación con adjunto a lista
	public function SendFileToList($client, $data, $id) {
		// Comprobar el tipo de archivo a enviar
		switch ($data['TipoArchivoANotificar']) {
			case 'Imagen':
				$action = 'sendImageMultiple';
				break;
			case 'Video':
				$action = 'sendVideoMultiple';
				break;
			case 'PDF':
				$action = 'sendPDFMultiple';
				break;
		}

		$archivo = CONSTANTS::PATH_EXPORT_WORD . '/notificaciones/' . $id . '/' . $data['file'];

		$type = mime_content_type($archivo);

		if ($type === null) {
			$resultPOST = [
				'status' => 'KO',
				'result' => 'File not found'
			];
			return $resultPOST;
		}

		$file_info = pathinfo($data['file']);
		if ($type === "application/octet-stream" && $file_info['extension'] == 'mp4') {
			$fileName = $file_info['basename'];
			$fileType = 'video/mp4';
		} else {
			$fileName = $file_info['filename'] . '.' . pathinfo($archivo, PATHINFO_EXTENSION);
			$fileType = $type;
		}
		$filecurl = new CURLFile($archivo, $fileType, $fileName);

		$url = CONSTANTS::SERVERAPI . $action;
		$params = [
			'token' => $client['token'],
			'file' => $filecurl,
			'message' => $data['message'],
			'emailsToSend' => json_encode($data['to']),
			'from' => $data['from'],
			'idlist' => $data['idlist']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	public function SendEmailScheduledPayment($client, $data, $token, $fileName) {
		if (!isset($token)) {
			$token = $client['token'];
		}
		$url = CONSTANTS::SERVERAPI . 'sendEmailScheduledPayment';

		$archivo = $data['file'];

		$filecurl = new CURLFile($archivo, 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', $fileName);

		$params = [
			'token' => $token,
			'message' => $data['message'],
			'email' => $data['email'],
			'asunto' => $data['asunto'],
			'body' => $data['body'],
			'file' => $filecurl
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Enviar notificación a usuario
	public function PostMessageToUser($client, $data, $token) {
		if (!isset($token)) {
			$token = $client['token'];
		}
		$url = CONSTANTS::SERVERAPI . 'postMessage';
		$params = [
			'token' => $token,
			'message' => $data['message'],
			'to' => $data['to'],
			'from' => $data['from']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Enviar notificación a grupo
	public function PostMessageToGroup($client, $data, $token = null) {
		if (!isset($token)) {
			$token = $client['token'];
		}
		$url = CONSTANTS::SERVERAPI . 'postGroupMessage';
		$params = [
			'token' => $token,
			'message' => $data['message'],
			'to' => $data['to'],
			'from' => $data['from']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Enviar encuesta a usuario o lista desde el apartado de editMision
	public function postSurveyMisiones($client) {
		$url = CONSTANTS::SERVERAPI . 'postSurvey';
		$params = [
			'token' => $client['token'],
			'from' => $client['from'],
			'emailsToSend' => json_encode($client['emailsToSend']),
			'message' => $client['message'],
			'idlist' => $client['idlist'],
			'misionStamp' => $client['misionStamp'],
			'idProject' => $client['idProject'],
			'textToNotify' => $client['textToNotify'],
			'isMision' => $client['isMision']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Enviar encuesta a usuario o lista
	public function postSurvey($client, $data, $token = null, $textToNotify = '', $isMision = '0') {
		if (!isset($token)) {
			$token = $client['token'];
		}
		$url = CONSTANTS::SERVERAPI . 'postSurvey';
		$params = [
			'token' => $token,
			'from' => $data['from'],
			'emailsToSend' => json_encode($data['emailsToSend']),
			'message' => $data['message'],
			'idlist' => $data['idlist'],
			'misionStamp' => $data['misionStamp'],
			'idProject' => $data['idProject'],
			'textToNotify' => $textToNotify,
			'isMision' => $isMision
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Enviar pregunta a los usuarios (por ejemplo en el PassiveTracking)
	public function PostQuestionMultiple($client, $data, $token = null) {
		$url = CONSTANTS::SERVERAPI . 'postQuestionMultiple';

		if (!isset($token)) {
			$token = $client['token'];
		}

		if ($data['idlist'] != '') {
			$params = [
				'token' => $token,
				'message' => $data['message'],
				'emailsToSend' => '',
				'idlist' => $data['idlist'],
				'from' => $data['from'],
				'passiveTracking' => 1
			];
		} else {
			$params = [
				'token' => $token,
				'message' => $data['message'],
				'emailsToSend' => $data['emailsToSend'],
				'idlist' => '',
				'from' => $data['from'],
				'passiveTracking' => 1
			];
		}

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Enviar encuesta a grupo
	public function postGroupSurvey($client, $data) {
		$url = CONSTANTS::SERVERAPI . 'postGroupSurvey';
		$params = [
			'token' => $client['token'],
			'from' => $data['from'],
			'to' => $data['to'],
			'emailsToSend' => $data['emailsToSend'],
			'message' => $data['message'],
			'idlist' => $data['idlist']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Actualizar Notificación despues de ejecución de notificaciones
	public function updateCMBPNotificationsExecution($id, $date, $obs1, $obs2, $token, $idTenant, $idCPG) {
		$url = CONSTANTS::SERVERAPI . 'updateCMBPNotificationsExecution';
		$params = [
			'token' => $token,
			'id' => $id,
			'FechaUltimaEjecucion' => $date,
			'Observaciones1' => $obs1,
			'Observaciones2' => $obs2,
			'idTenant' => $idTenant,
			'idCPG' => $idCPG
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	public function updateCMBPNotificationsSchedulePaymentsExecution($id, $date, $obs1, $obs2, $token, $idTenant, $idCPG) {
		$url = CONSTANTS::SERVERAPI . 'updateCMBPNotificationsSchedulePaymentsExecution';
		$params = [
			'token' => $token,
			'id' => $id,
			'UltimaEjecucion' => $date,
			'Observaciones1' => $obs1,
			'Observaciones2' => $obs2,
			'idTenant' => $idTenant,
			'idCPG' => $idCPG
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Petición de cola de notificaciones cíclicas
	public function getCMBPNotificationsServiceCiclicasTimer($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'TiempoEntreEjecuciones' => $client['TiempoEntreEjecuciones'],
			'UnidadDeTiempo' => $client['UnidadDeTiempo']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Notificar a pre-consejeros
	public function sendReActivationEmail($client) {
		// Limpieza de reactivación
		$url = CONSTANTS::SERVERAPI . 'cleanReActivationEmails';
		$params = [
			'token' => $client['token']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		if ($resultPOST->status != 'OK') {
			return $resultPOST;
		}

		$url = CONSTANTS::SERVERAPI . $client['action'];
		$emailArray = explode(',', $client['emailArray']);
		$sendMail = $client['sendMail'];

		$size = count($emailArray);
		$control = 499;
		$emailArrayToSend = [];
		for ($i = 0; $i < $size; $i++) {
			array_push($emailArrayToSend, $emailArray[$i]);
			if ($i == $control) {
				$params = [
					'token' => $client['token'],
					'email' => implode(',', $emailArrayToSend),
					'sendMail' => $sendMail
				];

				$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

				if ($resultPOST->status != 'OK') {
					return $resultPOST;
				} else {
					$control += 500;
					$emailArrayToSend = [];
				}
			}
		}

		if (count($emailArrayToSend) > 0) {
			$params = [
				'token' => $client['token'],
				'email' => implode(',', $emailArrayToSend),
				'sendMail' => $client['sendMail']
			];

			$resultPOST = $this->utilesController->sendCurlPOST($url, $params);
		}

		return $resultPOST;
	}
}