<?php
include_once(dirname(__FILE__) . '/UtilesController.php');

class RolesController {
	private $utilesController;

	function __construct() {
		$this->utilesController = new UtilesController();
	}

	// Crear nuevo rol
	public function newRole($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'role' => $client['role'],
			'permissions' => json_encode($client['permissions'])
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		if($resultPOST->status === 'OK') {
			$url = CONSTANTS::SERVERAPI . 'setUserCustomMenuRole';
			$params = [
				'token' => $client['token'],
				'role' => $client['role'],
				'values' => json_encode($client['menus'])
			];

			$resultPOST = $this->utilesController->sendCurlPOST($url, $params);
		}
		return $resultPOST;
	}

	// Comprobación de rol a eliminar
	public function roleStatus($client) {
		$response = [
			'status' => 'OK',
			'result' => []
		];
		$url = CONSTANTS::SERVERAPI . $client['action'];

		if($client['roles'] != '[]') {
			foreach($client['roles'] as $rol) {
				$params = [
					'token' => $client['token'],
					'role' => $rol['id']
				];

				$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

				if($resultPOST->status != 'OK') {
					return $resultPOST;
				} else {
					if($resultPOST->result->inUse == 0 && $resultPOST->result->defaultRole == 0) {
						$removeRole = $this->deleteRole($client, $rol['id']);

						if($removeRole->status == 'KO') {
							return $removeRole;
						}
					} else {
						$role = [
							'rol' => $rol['id'],
							'rolStatus' => $resultPOST->result
						];
						array_push($response['result'], $role);
					}
				}
			}
		}

		return $response;
	}

	// Eliminar Rol
	public function deleteRole($client, $rol = null) {
		$url = CONSTANTS::SERVERAPI . $client['action'];

		if(isset($rol)) {
			$url = CONSTANTS::SERVERAPI . 'deleteRole';
			$client['roles'] = [
				['id' => $rol]
			];
		}

		if($client['roles'] != '[]') {
			foreach($client['roles'] as $rol) {
				$params = [
					'token' => $client['token'],
					'role' => $rol['id']
				];

				$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

				if($resultPOST->status != 'OK') {
					return $resultPOST;
				}
			}
		} else {
			$resultPOST = [
				'status' => 'OK'
			];
		}

		return $resultPOST;
	}

	// Petición de rol
	public function getRole($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'role' => $client['role']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Petición de menús del rol
	public function getUserCustomMenuRole($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'role' => $client['role']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Editar rol
	public function editRole($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'role' => $client['role'],
			'permissions' => json_encode($client['permissions'])
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		if($resultPOST->status === 'OK') {
			if($client['menusChangedOrder'] === true) {
				$url = CONSTANTS::SERVERAPI . 'setUserCustomMenuRole';
				$params = [
					'token' => $client['token'],
					'role' => $client['role'],
					'values' => json_encode($client['menus'])
				];

				$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

				if($resultPOST->status != 'OK') {
					return $resultPOST;
				}
			}

			if($client['updateRoleUsers'] === true) {
				$url = CONSTANTS::SERVERAPI . 'setCustomMenuForAllUsersWithRole';
				$params = [
					'token' => $client['token'],
					'role' => $client['role']
				];

				$resultPOST = $this->utilesController->sendCurlPOST($url, $params);
			}
		}
		return $resultPOST;
	}
}