<?php
include_once(dirname(__FILE__) . '/UtilesController.php');

class RotacionesController {
	private $utilesController;

	function __construct() {
		$this->utilesController = new UtilesController();
	}

	// Eliminar rotación
	public function deleteRotacionSurveyQuestions($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];

		if($client['rotations'] != '[]') {
			foreach($client['rotations'] as $rotation) {
				$params = [
					'token' => $client['token'],
					'survey' => $rotation['survey'],
					'idrotation' => $rotation['idrotation']
				];

				$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

				if($resultPOST->status != 'OK') {
					return $resultPOST;
				}
			}
		} else {
			$resultPOST = [
				'status' => 'OK'
			];
		}

		return $resultPOST;
	}

	// Crea/edita rotación
	public function setRotacionSurveyQuestions($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'survey' => $client['survey'],
			'idrotation' => $client['idrotation'],
			'description' => $client['description'],
			'values' => json_encode($client['values'])
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	//obtener las questions de la rotacion
	public function getRotacionSurveyQuestions($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'survey' => $client['survey'],
			'idrotation' => $client['idrotation']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	//obtener las questions de la rotacion
	public function getAllRotacionesSurvey($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'survey' => $client['survey']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	//obtener las questions de la rotacion
	public function getProjectMisionRotaciones($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'idProject' => $client['idProject'],
			'mision' => $client['mision'],
			'survey' => $client['survey']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	//obtener las questions de la rotacion
	public function deleteProjectMisionRotaciones($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'survey' => $client['survey'],
			'idrotation' => $client['idrotation'],
			'mision' => $client['mision'],
			'idProject' => $client['idProject']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	//obtener las questions de la rotacion
	public function setProjectMisionRotaciones($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'values' => json_encode($client['values'])
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	//obtener las questions de la rotacion
	public function getProjectMisionRotacionesAsigned($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'survey' => $client['survey'],
			'idProject' => $client['idProject'],
			'mision' => $client['mision']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	//obtener las questions de la rotacion
	public function setUserRotacion($client) {
		$url = CONSTANTS::SERVERAPI . 'setUserRotacion';
		$params = [
			'token' => $client['token'],
			'values' => json_encode($client['values'])
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	//Obtener todas las rotaciones de un proyecto
	public function getAllRotacionesProject($client) {
		$arrayResults = [];
		//por cada mision del proyecto obtenemos las rotaciones
		foreach($client['misions'] as $mision) {
			$url = CONSTANTS::SERVERAPI . 'getProjectMisionRotaciones';
			$params = [
				'token' => $client['token'],
				'survey' => $mision['survey'],
				'idProject' => $mision['idProject'],
				'mision' => $mision['mision']
			];

			$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

			if($resultPOST->status != 'OK') {
				return $resultPOST;
			}

			if(count($resultPOST->result) > 0) {
				$result = $resultPOST->result;
				$misionObject = [
					'mision' => $mision['mision'],
					'survey' => $mision['survey'],
					'project' => $mision['idProject'],
					'rotations' => $result
				];
				array_push($arrayResults, $misionObject);
			}
		}
		$resultPOST->status = 'OK';
		$resultPOST->result = $arrayResults;

		return $resultPOST;
	}

	//Obtener todas las rotaciones de un proyecto
	public function getAllAsignedProjectRotaciones($client) {
		$arrayResults = [];
		//por cada mision del proyecto obtenemos las rotaciones
		foreach($client['misions'] as $mision) {
			$url = CONSTANTS::SERVERAPI . 'getProjectMisionRotacionesAsigned';

			$params = [
				'token' => $client['token'],
				'survey' => $mision['survey'],
				'idProject' => $mision['idProject'],
				'mision' => $mision['mision']
			];

			$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

			if($resultPOST->status != 'OK') {
				return $resultPOST;
			}

			if(count($resultPOST->result) > 0) {
				$result = $resultPOST->result;
				$misionObject = [
					'mision' => $mision['mision'],
					'survey' => $mision['survey'],
					'project' => $mision['idProject'],
					'rotations' => $result
				];
				array_push($arrayResults, $misionObject);
			}
		}
		$resultPOST->result = $arrayResults;
		$resultPOST->status = 'OK';

		return $resultPOST;
	}
}