<?php
ini_set('display_errors', 0);

/* error_reporting(E_ALL & ~E_NOTICE);
ini_set('display_errors', 1); */

require_once(dirname(__FILE__) . '/Controllers/Controller.php');
require_once(dirname(__FILE__) . '/Controllers/Service.php');

$token = 'HtDFjQYeyfFb9e27n9URgFw27b9en9URg11Fw664ey11664ey11WJ9P27aGLOKmFh';
$ctrl = new Controller();
$service = new Service();

$directory = dirname(__FILE__) . '/running.txt';
$errorFile = dirname(__FILE__) . '/runningError.txt';
$exists = file_exists($directory);

if(!$exists) {
	// Crear fichero
	$startDate = date('Y-m-d H:i:s');
	file_put_contents($directory, $startDate);

	try {
		// Ejecutar el servicio
		$response = $service->startService();

		// Control de errores
		$responseDecode = json_decode($response);
		$responseDecode->missions = json_decode($responseDecode->missions);
		$date = date('Y-m-d H:i:s');

		if($responseDecode->schedule_payments != 'OK') {
			// Escribir devolución en archivo de errores - Schedule Payments
			file_put_contents($errorFile, $date . ' Schedule Payments: ' . $responseDecode->schedule_payments . "\n\r", FILE_APPEND);
		}

		if($responseDecode->programs != 'OK') {
			// Escribir devolución en archivo de errores - Programadas
			file_put_contents($errorFile, $date . ' Programadas: ' . $responseDecode->programs . "\n\r", FILE_APPEND);
		}

		if($responseDecode->missions->endMission != 'OK') {
			// Escribir devolución en archivo de errores - Fin de misión
			file_put_contents($errorFile, $date . ' Fin de misión: ' . $responseDecode->missions->endMission . "\n\r", FILE_APPEND);
		}

		// Borrar fichero aunque haya excepción
		$exists = file_exists($directory);
		if($exists) {
			$deleteCheck = false;
			while(!$deleteCheck) {
				$deleteCheck = unlink($directory);
			}
		}
	} catch(Exception $e) {
		//Gestión de excepciones
		$exceptionString =	' EXCEPTION OCURRED: ' . $e->getMessage() . "\r\n" .
							'	-Exception Code: ' . $e->getCode() . "\r\n" .
							'	-Exception Line: ' . $e->getLine() . "\r\n" .
							'	-Exception Trace: ' . "\r\n" . $e->getTraceAsString() . "\r\n";
		//escribir la excepción en el errorfile
		file_put_contents($errorFile, $date . $exceptionString . '---------------------------------' ."\r\n", FILE_APPEND);
		//lanzar un log en el server para registrarlo
		$ctrl->setCMBPLOG($token, 'SERVICE_EXCEPTION', 'service exception', $exceptionString, '');
	}
}
?>