let AddonsNewController = {
	sections: [],
	deeplinks: [],

	reset() {
		let self = this;

		self.sections = [];
		self.deeplinks = [];
	},

	setEvents() {
		let self = this;
		self.reset();

		// Reducción de Header
		headerSectionHeight(0);

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC1246 + ' - ' + pf.const.language.RSC7);

		// Opciones de header
		let jsonsubopt = {
			back: 'back',
			save: 'save'
		};

		let nav = `
			${createSubOptionSave(jsonsubopt.save)}
			${createSubOptionBack(jsonsubopt.back)}
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		// Botón principal
		$('#save').addClass('main-button');

		// Botones secundarios
		$('#back').addClass('secondary-button');

		self.loadLang();
		self.applyEvents();

		stcmbackend.addons.sections.tableSections(self);
		stcmbackend.addons.deeplinks.tableDeepLinks(self);

		// fontawesome-iconpicker
		$('#icons').iconpicker({
			fullClassFormatter(val) {
				return val;
			}
		});
		$('.iconpicker').css('width', '230px');

		// Collapse
		addEventArrowTableHeader();

		// Pintar texto de label
		changeLabelsColor();
	},

	loadLang() {
		pf.rsc.translateByTag('text');

		// TITLES
		$('.addTitle').attr('title', pf.const.language.RSC93);
		$('.exportTitle').attr('title', pf.const.language.RSC47);
	},

	applyEvents() {
		let self = this;

		// Métodos comunes
		stcmbackend.addons.applyEvents(self, 'newAddonsCountry');

		// Guardar nuevo AddOn
		$('#save').on('click', function() {
			self.setAddOn();
		});

		//changesMade: false,
		//self.changesMade = false;
		// Detectar cambios en inputs
		/* $('input').change(function() {
			console.log('change');
			self.changesMade = true;
		});

		// En caso de que haya cambios sin guardar en página
		$('#menuSections a, #menuSectionsMini a').on('click', function(e) {
			if(self.changesMade || true) {
				e.preventDefault();
				console.log('Se han hecho cambios');
				console.log($(this).attr('class'));
				//$(this).trigger('click');
				if($(this).attr('class') == 'link-section') {
					console.log($(this).attr('href'));
					window.location.href = $(this).attr('href');
				}
			}
		}); */

	},

	setAddOn() {
		let self = this;

		// Campos obligatorios 'addon_name' y 'addon_path'
		let addon_name_check = true;
		let addon_name = $('#name').val().trim();
		if(addon_name == '') {
			$('#name').addClass('is-invalid');
			$('[for="name"]').addClass('is-invalid');
			addon_name_check = false;
		} else {
			$('#name').removeClass('is-invalid');
			$('[for="name"]').removeClass('is-invalid');
			addon_name_check = true;
		}
		let addon_description = $('#description').val().trim();
		let addon_path_check = true;
		let addon_path = $('#path').val().trim();
		if(addon_path == '') {
			$('#path').addClass('is-invalid');
			$('[for="path"]').addClass('is-invalid');
			addon_path_check = false;
		} else {
			$('#path').removeClass('is-invalid');
			$('[for="path"]').removeClass('is-invalid');
			addon_path_check = true;
		}
		let addon_var = $('#variable').val().trim();
		let addon_function = $('#function').val().trim();
		let addon_function_params = $('#parameters').val().trim();
		let addon_enabled = ($('#enable').prop('checked') ? '1' : '0');
		let gestiona_alert = ($('#ownAlertManagement').prop('checked') ? '1' : '0');
		let enrolamiento = ($('#register').prop('checked') ? '1' : '0');
		let fullScreen = ($('#fullScreen').prop('checked') ? '1' : '0');
		let addon_url = $('#url').val().trim();
		let addon_icon = $('#icon-button').find('i').attr('class');

		if(!addon_name_check || !addon_path_check) {
			pf.utils.alerts.showCompleteAllFields();
			return false;
		}

		let parameters = {
			addon_name: addon_name,
			addon_description: addon_description,
			addon_path: addon_path,
			addon_var: addon_var,
			addon_function: addon_function,
			addon_function_params: addon_function_params,
			addon_enabled: addon_enabled,
			gestiona_alert: gestiona_alert,
			country: $('#pais').val(),
			addon_url: addon_url,
			addon_icon: addon_icon,
			secciones: JSON.stringify(self.sections),
			deeplinks: JSON.stringify(self.deeplinks),
			publicPath: stcm.const.downloads,
			enrolamiento: enrolamiento,
			fullScreen: fullScreen
		};

		let index = 0;
		self.deeplinks.forEach(element => {
			parameters['file' + index] = element.file;
			index = index + 1;
		});

		ajaxComunCallWithCallback('setAddOn', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let successTitle = pf.const.language.RSC1246;
				let successContent = pf.const.language.RSC1251;
				pf.utils.showInfoDialog(successTitle, successContent);
				window.location.href = '#!addons';
			}
		});
	},

	clickEvents(data) {
		$('#pais').val(data.isocode);
		$('#countryDelete').show();
	}
};