let RolesBackendEditController = {
	data: '',
	role: '',
	addOnPermissionsFlag: false,
	addOnPermissions: [],
	addOnPermissionsOld: [],
	addOnFlag: false,
	addOns: '',
	seccionFlag: false,
	secciones: '',
	permissions: [],
	addOnsIndex: '',
	idAddOn: '',
	idAddOnIndex: '',
	loaders: {},

	reset() {
		let self = this;

		self.data = '';
		self.role = atob(sessionStorage.getItem('rol_backend'));
		self.addOnPermissionsFlag = false;
		self.addOnPermissions = [];
		self.addOnPermissionsOld = [];
		self.addOnFlag = false;
		self.addOns = '';
		self.seccionFlag = false;
		self.secciones = '';
		self.permissions = [];
		self.addOnsIndex = '';
		self.idAddOn = '';
		self.idAddOnIndex = '';
		self.loaders = {
			getAdminRoleMenu: false,
			getUsersRoleAddons: false
		};
	},

	setEvents() {
		let self = this;
		self.reset();

		// Reducción de Header
		headerSectionHeight(0);

		let JSONuser = sessionStorage['STCMBackEnd:user'];
		let user = JSON.parse(JSONuser);

		// Ocultar la sección Permisos AddOn para CPGs que no sean 0
		let idCPG = user.idCPG;
		if(idCPG != '0') {
			$('#addOnP').hide();
		}

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC1278 + ' - ' + pf.const.language.RSC225);

		// Opciones de header
		let jsonsubopt = {
			back: 'backRoles',
			save: 'saveRoles'
		};

		let nav = `
			${createSubOptionSave(jsonsubopt.save)}
			${createSubOptionBack(jsonsubopt.back)}
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		// Botón principal
		$('#saveRoles').addClass('main-button');

		// Botones secundarios
		$('#backRoles').addClass('secondary-button');

		self.loadLang();

		// Iniciar spinner
		addLoader();

		// Crear HTML de permisos
		stcmbackend.rolesBackend.createPermissionsSection(self);

		let parameters = {
			role: self.role
		};
		ajaxComunCallWithCallback('getAdminRoleMenu', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				self.data = ajaxReturn.result[0];

				for(let permiso in self.data) {
					if(permiso == 'role') {
						$('#rolName').val(self.data[permiso]);
					} else if(permiso == 'idTenant' || permiso == 'idCPG') {
						continue;
					} else {
						if(self.data[permiso] == '1') {
							$('#rp_' + permiso).prop('checked', true);
						} else {
							$('#rp_' + permiso).prop('checked', false);
						}
					}
				}

				// Switch general
				if($('.pSwitch').length == $('.pSwitch:checked').length) {
					$('#allSwitchs').prop('checked', true);
				} else {
					$('#allSwitchs').prop('checked', false);
				}

				self.applyEvents();

				stcmbackend.rolesBackend.tableAddOnPermissions(self);

				// Control de spinner
				self.loaders.getAdminRoleMenu = true;
				spinnerControl(self.loaders);
			}
		}, false);

		ajaxComunCallWithCallback('getUsersRoleAddons', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let size = ajaxReturn.result.length;
				for(let i = 0; i < size; i++) {
					let obj = {
						idAddon: ajaxReturn.result[i].idAddon,
						nameAddon: ajaxReturn.result[i].addon_name,
						idSection: ajaxReturn.result[i].idSection,
						visible: ajaxReturn.result[i].showSection
					};
					self.addOnPermissions.push(obj);
					self.addOnPermissionsOld.push(obj);
				}

				// Tabla de resultado
				stcmbackend.rolesBackend.tableAddOnPermissions(self);

				// Control de spinner
				self.loaders.getUsersRoleAddons = true;
				spinnerControl(self.loaders);
			}
		}, false);

		// Collapse
		addEventArrowTableHeader();

		// Pintar texto de label
		changeLabelsColor();
	},

	loadLang() {
		// Nombre
		pf.rsc.translateByTag('text');

		let arrayStrong = ['RSC123'];
		pf.rsc.translateByTagHTMLFormat('strong', arrayStrong);
		// TITLES
		$('.exportTitle').attr('title', pf.const.language.RSC47);
		$('.acceptTitle').attr('title', pf.const.language.RSC141);
	},

	applyEvents() {
		let self = this;

		// Guardar rol editado
		$('#saveRoles').on('click', function() {
			let objInfo = {
				accept: {
					text: pf.const.language.RSC78
				},
				cancel: {
					text: pf.const.language.RSC57
				}
			};

			let alertTitle = pf.const.language.RSC1278;
			let alertText = pf.const.language.RSC269;
			pf.utils.showInfoDialogAcceptCancel(alertTitle, alertText, objInfo, function() {
				self.editAdminRoleMenu();
			}, function() {});
		});

		stcmbackend.rolesBackend.applyEvents(self);
	},

	editAdminRoleMenu() {
		let self = this;

		let parameters = {
			role: self.role,
			addOnPermissions: JSON.stringify(self.addOnPermissions),
			addOnPermissionsOld: JSON.stringify(self.addOnPermissionsOld)
		};

		let size = self.permissions.length;
		for(let i = 0; i < size; i++) {
			parameters[self.permissions[i].switchID.replace('rp_', '')] = ($('#' + self.permissions[i].switchID).prop('checked') === true ? 1 : 0);

			let sizeB = self.permissions[i].subSections.length;
			for(let j = 0; j < sizeB; j++) {
				parameters[self.permissions[i].subSections[j].switchID.replace('rp_', '')] = ($('#' + self.permissions[i].subSections[j].switchID).prop('checked') === true ? 1 : 0);

				let sizeC = self.permissions[i].subSections[j].subSections.length;
				for(let k = 0; k < sizeC; k++) {
					parameters[self.permissions[i].subSections[j].subSections[k].switchID.replace('rp_', '')] = ($('#' + self.permissions[i].subSections[j].subSections[k].switchID).prop('checked') === true ? 1 : 0);
				}
			}
		}

		ajaxComunCallWithCallback('editAdminRoleMenu', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let successTitle = pf.const.language.RSC1278;
				let successContent = pf.const.language.RSC270;
				pf.utils.showInfoDialog(successTitle, successContent);
				window.location.href = '#!roles_backend';
			}
		});
	}
};