let ExclusionesWordcloudController = {
	data: '',
	arrayDelMult: [],

	reset() {
		let self = this;

		self.data = '';
		self.arrayDelMult = [];
	},

	setEvents() {
		let self = this;
		self.reset();

		// Reducción de Header
		headerSectionHeight(0);

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC1838);

		// Opciones de header
		let jsonsubopt = {
			new: 'new'
		};

		let nav = `
			${createSubOptionNew(jsonsubopt.new)}
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		$('#new svg').css({'width': '24px', 'height': '24px'});

		// Botón principal
		$('#new').addClass('main-button');

		self.loadLang();
		self.applyEvents();

		ajaxComunCallWithCallback('getAllWordsExcludedCloud', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				self.data = ajaxReturn.result;

				// Tabla de resultados
				self.renderData();
			}
		});

		// Collapse
		addEventArrowTableHeader();
	},

	loadLang() {
		pf.rsc.translateByTag('text');

		// TITLES
		$('.exportTitle').attr('title', pf.const.language.RSC47);
		$('.deleteMultTitle').attr('title', pf.const.language.RSC95);
	},

	applyEvents() {
		// Nuevo
		$('#new').on('click', function() {
			window.location.href = '#!exclusiones_wordcloud_new';
		});
	},

	renderData() {
		let self = this;

		$('#resultTable').show();

		// Comprobación de array
		if(!Array.isArray(self.data)) {
			self.data = [];
		}

		let table = `
			<thead>
				<tr>
					<th class="text-center" scope="col" title="">
						<div class="div-global-selection">
							<input type="checkbox" class="globalSelection">
						</div>
					</th>
					<th scope="col" title="${pf.const.language.RSC1839}">${pf.const.language.RSC1839}</th>
					<th scope="col" title="${pf.const.language.RSC552}">${pf.const.language.RSC552}</th>
					<th scope="col" title="${pf.const.language.RSC2516}">${pf.const.language.RSC2516}</th>
				</tr>
			</thead>

			<thead class="filtersResult">
				<tr>
					<td>selector</td>
					<td>excludedword</td>
					<td>language</td>
					<td>acciones</td>
				</tr>
			</thead>

			<tbody>
		`;

		let size = self.data.length;
		for(let i = 0; i < size; i++) {
			table += `
				<tr data-id="${self.data[i].id}">
					<td class="text-truncate text-center">
						<div class="div-single-selection" data-id="${self.data[i].id}">
							<input type="checkbox" class="deleteSelection">
						</div>
					</td>
					<td class="text-truncate c-pointer editRow" title="${self.data[i].word}">${self.data[i].word}</td>
					<td class="text-truncate c-pointer editRow" title="${self.data[i].lenguage}">${self.data[i].lenguage}</td>
					<td class="text-truncate text-center" title="${pf.const.language.RSC226}">
						<div id="dropdownActions${i}" class="div-dd-actions c-pointer" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
							${stcmbackend.svg.threeDotsVertical18}
						</div>

						<div class="dropdown-menu dropdown-menu-right shadow menu-actions" aria-labelledby="dropdownActions${i}" data-id="${self.data[i].id}">
							<p class="dropdown-item editRow">
								${stcmbackend.svg.pencilWithoutColor}
								<span>${pf.const.language.RSC225}</span>
							</p>
							<p class="dropdown-item deleteRow">
								${stcmbackend.svg.trashWithoutColor}
								<span>${pf.const.language.RSC95}</span>
							</p>
						</div>
					</td>
				</tr>
			`;
		}

		table += `
			</tbody>
		`;

		$('#registers').html(table);

		// Setup - add a text input to each footer cell
		$('#registers .filtersResult td').each(function() {
			let title = $(this).text();
			let value = `<input type="text" class="form-control form-control-sm" disabled>`;

			if(title === 'excludedword' || title === 'language') {
				value = `<input type="text" class="form-control form-control-sm">`;
			}

			$(this).html(value);
		});

		let dataTable = $('#registers').DataTable({
			retrieve: true,
			language: pf.const.language_table,
			pageLength: 25,
			autoWidth: false,
			columnDefs: [
				{width: '25px', orderable: false, targets: 0},
				{width: '50px', targets: 2},
				{width: '60px', orderable: false, targets: 3}
			],
			dom: 'Bfrtip',
			buttons: [{
				extend: 'excelHtml5',
				text: pf.const.language.RSC129,
				className: 'd-none',
				title: pf.const.language.RSC1838,
				exportOptions: {
					columns: [1]
				},
				customize(xlsx) {
					dataTablesExcelCustomize(xlsx);
				}
			}],
			order: [[1, 'asc']]
		});

		// Ocultar botones de tabla
		hideTableButtons('registers');

		// Apply the search
		applyTheSearch(dataTable, 'filtersResult');

		// Exportar tabla
		$('#exportExclusiones').off().on('click', function() {
			$('#resultTable .buttons-excel').trigger('click');
		});

		self.dataEvents(dataTable);

		$('#resultTable').on('draw.dt', function() {
			self.dataEvents(dataTable);
		});
	},

	dataEvents(dataTable) {
		let self = this;

		// Eventos del input global
		globalSelectionInputActions();

		// Editar exclusion
		$('.editRow').off().on('click', function() {
			let id = $(this).parent().data('id');

			sessionStorage.setItem('id', btoa(id));
			window.location.href = '#!exclusiones_wordcloud_edit';
		});

		// Borrar exclusión
		$('.deleteRow').off().on('click', function() {
			let id = $(this).parent().data('id');

			let objInfo = {
				accept: {
					text: pf.const.language.RSC95
				},
				cancel: {
					text: pf.const.language.RSC57
				}
			};

			let alertTitle = pf.const.language.RSC1838;
			let alertText = pf.const.language.RSC1846;
			pf.utils.showInfoDialogAcceptCancel(alertTitle, alertText, objInfo, function() {
				self.deleteWordExcludedCloudByID(id);
			}, function() {});
		});

		// Array de eliminado múltiple
		$('.deleteSelection').off().on('change', function() {
			let value = $(this).prop('checked');
			let id = $(this).parent().data('id');;

			if(value) {
				self.arrayDelMult.push(id);
			} else {
				let index = self.arrayDelMult.indexOf(id);
				self.arrayDelMult.splice(index, 1);
			}

			// Eventos de los inputs individuales
			deleteSelectionInputActions(self.arrayDelMult);
		});

		// Función de borrado múltiple
		$('#multSelecDelete').off().on('click', function() {
			// Aviso de borrado múltiple
			let objInfo = {
				accept: {
					text: pf.const.language.RSC95
				},
				cancel: {
					text: pf.const.language.RSC57
				}
			};

			let alertTitle = pf.const.language.RSC1838;
			let alertText = pf.const.language.RSC1863;
			pf.utils.showInfoDialogAcceptCancel(alertTitle, alertText, objInfo, function() {
				self.deleteWordExcludedCloudByID();
			}, function() {});
		});
	},

	deleteWordExcludedCloudByID(id = false) {
		let self = this;

		let delMult = [];
		if(id !== false) {
			let obj = {
				exclusionId: id
			}
			delMult.push(obj);
		} else {
			let delSize = self.arrayDelMult.length;
			for(let i = 0; i < delSize; i++) {
				let obj = {
					exclusionId: self.arrayDelMult[i]
				}
				delMult.push(obj);
			}
			self.arrayDelMult = [];
		}

		let parameters = {
			exclusiones: JSON.stringify(delMult)
		};
		ajaxComunCallWithCallback('deleteWordExcludedCloudByID', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let successTitle = pf.const.language.RSC1838;
				let successContent = pf.const.language.RSC1864;
				pf.utils.showInfoDialog(successTitle, successContent);
				loadHTML('inc/ajustes/exclusiones_wordcloud.html', 'wrapper', ExclusionesWordcloudController);
			}
		});
	}
};