let ExclusionesWordcloudEditController = {
	word: '',
	data: '',
	id: '' ,
	nuevoValor: '',

	reset() {
		let self = this;

		self.word = '';
		self.data = '';
		self.id = atob(sessionStorage.getItem('id'));
		self.nuevoValor = '';
	},

	setEvents() {
		let self = this;
		self.reset();

		ajaxComunCallWithCallback('getAllWordsExcludedCloud', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				self.data = ajaxReturn.result;

				// Tabla de resultados
				self.renderData();
			}
		});

		// Reducción de Header
		headerSectionHeight(0);

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC1838 + ' - ' + pf.const.language.RSC225);

		// Opciones de header
		let jsonsubopt = {
			back: 'back',
			save: 'save'
		};

		let nav = `
			${createSubOptionSave(jsonsubopt.save)}
			${createSubOptionBack(jsonsubopt.back)}
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		// Botón principal
		$('#save').addClass('main-button');

		// Botones secundarios
		$('#back').addClass('secondary-button');

		// Collapse
		addEventArrowTableHeader();

		stcmbackend.exclusionesWordcloud.loadLang(self);
		self.applyEvents();

		// Pintar texto de label
		changeLabelsColor();
	},

	applyEvents() {
		let self = this;

		let url = window.location.href;
		if(url.indexOf('localhost') != -1 || url.indexOf('sociallabs') != -1) {
			$('#system').prop('disabled', false);
		}

		stcmbackend.exclusionesWordcloud.sharedEvents(self);

		// Editar entrada Exclusión
		$('#save').on('click', function() {
			self.nuevoValor = $('#palabraExcluida').val().trim();

			let formIncomplete = false;
			if(self.nuevoValor == '') {
				formIncomplete = true;
				$('#palabraExcluida').addClass('is-invalid');
				$('[for="palabraExcluida"]').addClass('is-invalid');
			}

			// Comprobación
			if(formIncomplete) {
				let alertTitle = pf.const.language.RSC21;
				let alertText = pf.const.language.RSC101;
				pf.utils.showInfoDialog(alertTitle, alertText);
				return;
			}

			if(self.word != self.nuevoValor) {
				self.editExclusion();
			} else {
				// Al actualizar un campo sin modificar la palabra, se genera un error por el tema de los idiomas.
				// Volvemos a la página anterior sin realizar los cambios
				let successTitle = pf.const.language.RSC466;
				let successContent = pf.const.language.RSC1862;
				pf.utils.showInfoDialog(successTitle, successContent);
				window.location.href = '#!exclusiones_wordcloud';
			}
		});
	},

	editExclusion() {
		let self = this;

		let parameters = {
			id: self.id,
			word: self.nuevoValor
		};
		ajaxComunCallWithCallback('updateWordExcludedCloudByID', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let successTitle = pf.const.language.RSC466;
				let successContent = pf.const.language.RSC1862;
				pf.utils.showInfoDialog(successTitle, successContent);
				window.location.href = '#!exclusiones_wordcloud';
			}
		});
	},

	renderData() {
		let self = this;

		let size = self.data.length;
		for(let i = 0; i < size; i++) {
			if(self.data[i].id == self.id) {
				self.word = self.data[i].word;
				$('#palabraExcluida').val(self.word);
			}
		}
	}
};