let FormularioRegistroController = {
	email: 1,
	acceptterms: 1,
	firstname: 1,
	lastname:1,
	secondlastname: 1,
	country: 1,
	countrydefault: '',
	role: 1,
	roledefault: '',
	language: 1,
	languagedefault: '',
	terms: [],
	rscValidation: '',
	codevalidationtimeminutes: '',
	rscDataAll: {},
	rscData: '',
	tableRSCFlag: false,
	requestType: '',
	loaders: {},

	reset() {
		let self = this;

		self.email = 1;
		self.acceptterms = 1;
		self.firstname = 1;
		self.lastname =1;
		self.secondlastname = 1;
		self.country = 1;
		self.countrydefault = '';
		self.role = 1;
		self.roledefault = '';
		self.language = 1;
		self.languagedefault = '';
		self.terms = [];
		self.rscValidation = '';
		self.codevalidationtimeminutes = '';
		self.rscDataAll = {};
		self.rscData = '';
		self.tableRSCFlag = false;
		self.requestType = '';
		self.loaders = {
			getRegisterConfiguration: false,
			getAllRSC: false
		};
	},

	setEvents() {
		let self = this;
		self.reset();

		// Reducción de Header
		headerSectionHeight(0);

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC1520);

		// Opciones de header
		let jsonsubopt = {
			save: 'save'
		};

		let nav = `
			${createSubOptionSave(jsonsubopt.save)}
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		// Botón principal
		$('#save').addClass('main-button');

		self.loadLanguage();

		// Collapse
		addEventArrowTableHeader();

		// Añadir texto de identificación
		$('#newTermino').off().on('click', function() {
			let obj = {
				enabled: '1',
				rscterms: '',
				rsctext: '',
			};
			self.terms.push(obj);
			self.terminosTable();
		});

		// Iniciar spinner
		addLoader();

		ajaxComunCallWithCallback('getRegisterConfiguration', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				self.email = ajaxReturn.result.email;
				self.acceptterms = ajaxReturn.result.acceptterms;
				self.firstname = ajaxReturn.result.firstname;
				self.lastname = ajaxReturn.result.lastname;
				self.secondlastname = ajaxReturn.result.secondlastname;
				self.country = ajaxReturn.result.country;
				self.countrydefault = ajaxReturn.result.countrydefault;
				self.role = ajaxReturn.result.role;
				self.roledefault = ajaxReturn.result.roledefault;
				self.language = ajaxReturn.result.language;
				self.languagedefault = ajaxReturn.result.languagedefault;
				self.terms = ajaxReturn.result.terms;
				self.roledefault = ajaxReturn.result.roledefault;
				self.rscValidation = ajaxReturn.result.rscValidation;
				self.codevalidationtimeminutes = ajaxReturn.result.codevalidationtimeminutes;
				let hourValue = Math.floor(ajaxReturn.result.codevalidationtimeminutes/60);
				let minuteValue = Math.floor(ajaxReturn.result.codevalidationtimeminutes%60);
				$('#timeInputHours').val(hourValue);
				$('#timeInputMinutes').val(minuteValue);
				$('#displayTermsInput').prop('checked', (ajaxReturn.result.acceptterms == '1'));
				$('#registroUsername').prop('checked', ajaxReturn.result.email != '1');
				$('#validateBySMS').prop('checked', (ajaxReturn.result.validateBySMS == '1'));
				$('#validateBySMS').prop('disabled', (ajaxReturn.result.email != '1' && ajaxReturn.result.validateBySMS == '1'));
				$('#validateByEmail').prop('checked', (ajaxReturn.result.validateByEmail == '1'));
				$('#validateByEmail').prop('disabled', (ajaxReturn.result.email == '1' && ajaxReturn.result.validateByEmail == '1'));

				self.registerFieldsTable();

				// Control de spinner
				self.loaders.getRegisterConfiguration = true;
				spinnerControl(self.loaders);
			}
		}, false);

		ajaxComunCallWithCallback('getAllRSC', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				self.rscData = ajaxReturn.result;

				// Dicionario completo
				let language = sessionStorage['STCMBackEnd:lenguage'];
				self.rscDataAll = {};
				let size = self.rscData.length;
				for(let i = 0; i < size; i++) {
					if(self.rscData[i].app == 1 && self.rscData[i].system != 1) {
						self.rscDataAll[self.rscData[i].idRSC] = self.rscData[i][language];
					}
				}
				$('#textRSCValidacion').val(self.rscDataAll[self.rscValidation]);
				$('#textRSCValidacion').attr('title', self.rscDataAll[self.rscValidation]);
				$('#idRSCValidacion').prop('title', self.rscValidation);

				self.terminosTable();

				// Control de spinner
				self.loaders.getAllRSC = true;
				spinnerControl(self.loaders);
			}
		}, false);

		// Si se selecciona identificar por e-mail se marca validación por e-mail y no se puede cambiar
		$('#registroEmail').on('change', function() {
			$('#validateByEmail').prop('checked', true);
			$('#validateByEmail').prop('disabled', true);
			$('#validateBySMS').prop('disabled', false);
		});

		// Si se selecciona identificar por nombre de usuario se marca validación por sms y no se puede cambiar
		$('#registroUsername').on('change', function() {
			$('#validateBySMS').prop('checked', true);
			$('#validateByEmail').prop('disabled', false);
			$('#validateBySMS').prop('disabled', true);
		});

		// Guardado de nueva configuracion
		$('#save').click(function() {
			let objInfo = {
				accept: {
					text: pf.const.language.RSC78
				},
				cancel: {
					text: pf.const.language.RSC57
				}
			};

			let alertTitle = pf.const.language.RSC78;
			let alertText = pf.const.language.RSC105;
			pf.utils.showInfoDialogAcceptCancel(alertTitle, alertText, objInfo, function() {
				self.saveRegisterForm();
			}, function() {});
		});

		// Pintar texto de label
		changeLabelsColor();
	},

	loadLanguage() {
		pf.rsc.translateByTag('text');
	},

	registerFieldsTable() {
		let self = this;

		let table = `
			<table id="tableRegisterFields" class="table table-hover tRegs">
				<thead>
					<tr>
						<th scope="col" title="${pf.const.language.RSC1522}">
							${pf.const.language.RSC1522}
						</th>
						<th scope="col" title="${pf.const.language.RSC1524}">
							${pf.const.language.RSC1524}
							<span class="float-right">${pf.const.language.RSC278}:</span>
						</th>
						<th scope="col" class="text-center">
							<div class="custom-control custom-switch">
								<input id="allSwitchs" type="checkbox" class="custom-control-input">
								<label for="allSwitchs" class="custom-control-label c-pointer"></label>
							</div>
						</th>
					</tr>
				</thead>

				<tbody>
					<tr>
						<td class="text-truncate" title="${pf.const.language.RSC123}">${pf.const.language.RSC123}</td>
						<td></td>
						<td class="text-center">
							<span class="d-none">${(self.firstname == '1' ? '1' : '0')}</span>
							<div class="custom-control custom-switch">
								<input id="nombreInput" type="checkbox" class="custom-control-input uSwitch"${(self.firstname == '1' ? ' checked' : '')}>
								<label for="nombreInput" class="custom-control-label c-pointer"></label>
							</div>
						</td>
					</tr>
					<tr>
						<td class="text-truncate" title="${pf.const.language.RSC185}">${pf.const.language.RSC185}</td>
						<td></td>
						<td class="text-center">
							<span class="d-none">${(self.lastname == '1' ? '1' : '0')}</span>
							<div class="custom-control custom-switch">
								<input id="apellidoInput" type="checkbox" class="custom-control-input uSwitch"${(self.lastname == '1' ? ' checked' : '')}>
								<label for="apellidoInput" class="custom-control-label c-pointer"></label>
							</div>
						</td>
					</tr>
					<tr>
						<td class="text-truncate" title="${pf.const.language.RSC1523}">${pf.const.language.RSC1523}</td>
						<td></td>
						<td class="text-center">
							<span class="d-none">${(self.secondlastname == '1' ? '1' : '0')}</span>
							<div class="custom-control custom-switch">
								<input id="segundoApellidoInput" type="checkbox" class="custom-control-input uSwitch"${(self.secondlastname == '1' ? ' checked' : '')}>
								<label for="segundoApellidoInput" class="custom-control-label c-pointer"></label>
							</div>
						</td>
					</tr>
					<tr>
						<td class="text-truncate" title="${pf.const.language.RSC550}">${pf.const.language.RSC550}</td>
						<td class="text-truncate p-1">
							<div class="form-group mb-0">
								<div class="input-group new-input-style max wi-200">
									<input id="rscCountryDefault" type="text" class="form-control" value="${(self.country == '0' ? self.countrydefault : '')}" title="${(self.country == '0' ? self.countrydefault : '')}" disabled>
									<div class="input-group-append">
										<button id="btn_searchCountry" type="button" class="btn btn-outline-secondary btn-table" data-toggle="modal" data-target="#modalContainer" data-input="rscWelcomePage" data-cell="rscWelcomePageCell"${(self.country == '1' ? ' disabled' : '')}>
											${stcmbackend.svg.threeDots}
										</button>
									</div>
								</div>
							</div>
						</td>
						<td class="text-center">
							<span class="d-none">${(self.country == '1' ? '1' : '0')}</span>
							<div class="custom-control custom-switch">
								<input id="paisInput" type="checkbox" class="custom-control-input uSwitch"${(self.country == '1' ? ' checked' : '')}>
								<label for="paisInput" class="custom-control-label c-pointer"></label>
							</div>
						</td>
					</tr>
					<tr>
						<td class="text-truncate" title="${pf.const.language.RSC552}">${pf.const.language.RSC552}</td>
						<td class="text-truncate p-1">
							<div class="form-group mb-0">
								<div class="input-group new-input-style max wi-200">
									<input id="rscLanguageDefault" type="text" class="form-control" value="${(self.language == '0' ? self.languagedefault : '')}" title="${(self.language == '0' ? self.languagedefault : '')}" disabled>
									<div class="input-group-append">
										<button id="btn_searchLanguage" type="button" class="btn btn-outline-secondary btn-table" data-toggle="modal" data-target="#modalContainer" data-input="rscWelcomePage" data-cell="rscWelcomePageCell"${(self.language == '1' ? ' disabled' : '')}>
											${stcmbackend.svg.threeDots}
										</button>
									</div>
								</div>
							</div>
						</td>
						<td class="text-center">
							<span class="d-none">${(self.language == '1' ? '1' : '0')}</span>
							<div class="custom-control custom-switch">
								<input id="idiomaInput" type="checkbox" class="custom-control-input uSwitch"${(self.language == '1' ? ' checked' : '')}>
								<label for="idiomaInput" class="custom-control-label c-pointer"></label>
							</div>
						</td>
					</tr>
					<tr>
						<td class="text-truncate" title="${pf.const.language.RSC277}">${pf.const.language.RSC277}</td>
						<td class="text-truncate p-1">
							<div class="form-group mb-0">
								<div class="input-group new-input-style max wi-200">
									<input id="rscRoleDefault" type="text" class="form-control" value="${(self.role == '0' ? self.roledefault : '')}" title="${(self.role == '0' ? self.roledefault : '')}" disabled>
									<div class="input-group-append">
										<button id="btn_searchRole" type="button" class="btn btn-outline-secondary btn-table" data-toggle="modal" data-target="#modalContainer" data-input="rscWelcomePage" data-cell="rscWelcomePageCell"${(self.role == '1' ? ' disabled' : '')}>
											${stcmbackend.svg.threeDots}
										</button>
									</div>
								</div>
							</div>
						</td>
						<td class="text-center">
							<span class="d-none">${(self.role == '1' ? '1' : '0')}</span>
							<div class="custom-control custom-switch">
								<input id="rolInput" type="checkbox" class="custom-control-input uSwitch"${(self.role == '1' ? ' checked' : '')}>
								<label for="rolInput" class="custom-control-label c-pointer"></label>
							</div>
						</td>
					</tr>
				</tbody>
			</table>
		`;

		$('#registerFields').html(table);

		let tableRegisterFields = $('#tableRegisterFields').DataTable({
			retrieve: true,
			language: pf.const.language_table,
			paging: false,
			searching: false,
			ordering: false,
			autoWidth: false,
			columnDefs: [
				{width: '180px', targets: 0},
				{width: '35px', targets: 2}
			],
			dom: 'Bfrtip',
			buttons: [{
				extend: 'excelHtml5',
				text: pf.const.language.RSC1225,
				className: 'd-none',
				title: pf.const.language.RSC1225,
				customize(xlsx) {
					dataTablesExcelCustomize(xlsx);
				}
			}],
		});

		// Ocultar botones de tabla
		hideTableButtons('tableRegisterFields');

		self.registerFieldsTableEvents();
	},

	registerFieldsTableEvents() {
		let self = this;

		// Si todos los checkbox están seleccionados, se selecciona el checkbox principal, y viceversa
		// Comprobación inicial
		if($('.uSwitch').length == $('.uSwitch:checked').length) {
			$('#allSwitchs').prop('checked', true);
		} else {
			$('#allSwitchs').prop('checked', false);
		} 

		// La id del elemento principal modifica los elementos secundarios a través de su clase
		$('#allSwitchs').on('click', function() {
			$('.uSwitch').prop('checked', this.checked);
			if(this.checked) {
				$('#btn_searchCountry').prop('disabled', true);
				$('#rscCountryDefault').val('');
				$('#btn_searchLanguage').prop('disabled', true);
				$('#rscLanguageDefault').val('');
				$('#btn_searchRole').prop('disabled', true);
				$('#rscRoleDefault').val('');
			} else {
				$('#btn_searchCountry').prop('disabled', false);
				$('#rscCountryDefault').val(self.countrydefault);
				$('#btn_searchLanguage').prop('disabled', false);
				$('#rscLanguageDefault').val(self.languagedefault);
				$('#btn_searchRole').prop('disabled', false);
				$('#rscRoleDefault').val(self.roledefault);
			}
		});

		// Si todos los checkbox están seleccionados, se selecciona el checkbox principal, y viceversa
		$('.uSwitch').on('click', function() {
			if($('.uSwitch').length == $('.uSwitch:checked').length) {
				$('#allSwitchs').prop('checked', true);
			} else {
				$('#allSwitchs').prop('checked', false);
			}
		});

		//Activamos/desactivamos los inputs de pais idioma y rol default
		//comprobación inicial
		if($('#paisInput').checked) {
			$('#btn_searchCountry').prop('disabled', true);
			$('#rscCountryDefault').val('');
		}
		if($('#idiomaInput').checked) {
			$('#btn_searchLanguage').prop('disabled', true);
			$('#rscLanguageDefault').val('');
		}
		if($('#rolInput').checked) {
			$('#btn_searchRole').prop('disabled', true);
			$('#rscRoleDefault').val('');
		}

		//trigger listeners
		$('#paisInput').on('click', function() {
			if(this.checked) {
				$('#btn_searchCountry').prop('disabled', true);
				$('#rscCountryDefault').val('');
			} else {
				$('#btn_searchCountry').prop('disabled', false);
				$('#rscCountryDefault').val(self.countrydefault);
			}
		});
		$('#idiomaInput').on('click', function() {
			if(this.checked) {
				$('#btn_searchLanguage').prop('disabled', true);
				$('#rscLanguageDefault').val('');
			} else {
				$('#btn_searchLanguage').prop('disabled', false);
				$('#rscLanguageDefault').val(self.languagedefault);
			}
		});
		$('#rolInput').on('click', function() {
			if(this.checked) {
				$('#btn_searchRole').prop('disabled', true);
				$('#rscRoleDefault').val('');
			} else {
				$('#btn_searchRole').prop('disabled', false);
				$('#rscRoleDefault').val(self.roledefault);
			}
		});

		// Exportar tabla
		$('#exportRegisterFieldsTables').off().on('click', function() {
			$('#registerFields .buttons-excel').trigger('click');
		});

		// País por defecto
		let countryModal = new TableCountries(0, 'registerCountry');
		$('#btn_searchCountry').off().on('click', function() {
			self.requestType = 'country';
			countryModal.setEvents();
		});

		// Rol por defecto
		$('#btn_searchRole').off().on('click', function() {
			self.requestType = 'rol';
			tablePerfiles.setEvents('formularioRegistro');
		});

		// Lenguage por defecto
		$('#btn_searchLanguage').off().on('click', function() {
			self.requestType = 'language';
			tableLanguages.setEvents('formularioRegistro');
		});
	},

	terminosTable() {
		let self = this;

		let table = `
			<table id="tableTerminos" class="table table-hover tRegs">
				<thead>
					<tr>
						<th scope="col" title="${pf.const.language.RSC1527}">${pf.const.language.RSC1527}</th> 
						<th scope="col" title="${pf.const.language.RSC178}">${pf.const.language.RSC178}</th>
						<th scope="col" title="${pf.const.language.RSC1528}">${pf.const.language.RSC1528}</th> 
						<th scope="col" title="${pf.const.language.RSC178}">${pf.const.language.RSC178}</th>
						<th scope="col" title=""></th>
					</tr>
				</thead>

				<tbody>
		`;

		let size = self.terms.length;
		if(size < 1) {
			let obj = {
				enabled: '1',
				rscterms: '',
				rsctext: '',
			};
			self.terms.push(obj);
			size = 1;
		}

		for(let i = 0; i < size; i++) {
			let rscTextValue = self.terms[i].rsctext == '' ? '' : self.rscDataAll[self.terms[i].rsctext];
			let rscTermsValue = self.terms[i].rscterms == '' ? '' : self.rscDataAll[self.terms[i].rscterms];

			table += `
				<tr data-id="id${i}">
					<td class="text-truncate p-1">
						<span class="d-none">${self.terms[i].rsctext}</span>
						<div class="form-group mb-0">
							<div class="input-group new-input-style">
								<input id="terminoText_${i}" type="text" class="form-control terminoTextClass" value="${self.terms[i].rsctext}" title="${self.terms[i].rsctext}" disabled>
								<div class="input-group-append">
									<button id="btn_identification_${i}" type="button" class="btn btn-outline-secondary btn-table-id" data-toggle="modal" data-target="#modalRSCTable" data-input="terminoText_${i}" data-cell="cellText_id_${i}">
										${stcmbackend.svg.threeDots}
									</button>
								</div>
							</div>
						</div>
					</td>
					<td id="cellText_id_${i}" class="text-truncate" title="${rscTextValue || ''}">
						${rscTextValue || ''}
					</td>
					<td class="text-truncate p-1">
						<span class="d-none">${self.terms[i].rscterms}</span>
						<div class="form-group mb-0">
							<div class="input-group new-input-style">
								<input id="terminoTerms_${i}" type="text" class="form-control terminoTermsClass" value="${self.terms[i].rscterms}" title="${self.terms[i].rscterms}" disabled>
								<div class="input-group-append">
									<button id="btn_identification_${i}" type="button" class="btn btn-outline-secondary btn-table-id" data-toggle="modal" data-target="#modalRSCTable" data-input="terminoTerms_${i}" data-cell="cellTerms_id_${i}">
										${stcmbackend.svg.threeDots}
									</button>
								</div>
							</div>
						</div>
					</td>
					<td id="cellTerms_id_${i}" class="text-truncate" title="${rscTermsValue || ''}">
						${rscTermsValue || ''}
					</td>
					<td class="text-truncate text-center" title="${pf.const.language.RSC226}">
						<span class="c-pointer deleteIdentification">
							${stcmbackend.svg.bigTrash}
						</span>
					</td>
				</tr>
			`;
		}

		table += `
				</tbody>
			</table>
		`;

		$('#terminosTable').html(table);

		let tableTerminos = $('#tableTerminos').DataTable({
			retrieve: true,
			language: pf.const.language_table,
			paging: false,
			autoWidth: false,
			columnDefs: [
				{width: '90px', targets: 0},
				{width: '90px', targets: 2},
				{width: '30px', targets: 4}
			],
			ordering: false,
			dom: 'Bfrtip',
			buttons: [{
				extend: 'excelHtml5',
				text: pf.const.language.RSC222,
				className: 'd-none',
				title: pf.const.language.RSC222,
				customize(xlsx) {
					dataTablesExcelCustomize(xlsx);
				}
			}],
			aaSorting: []
		});

		// Ocultar botones de tabla
		hideTableButtons('tableTerminos');

		// Exportar tabla
		$('#exportTerminosTable').off().on('click', function() {
			self.terminosTable();
			$('#terminosTable .buttons-excel').trigger('click');
		});

		self.terminosTableEvents();
	},

	terminosTableEvents() {
		let self = this;

		// Modal de RSC
		$('.btn-table-id').off().on('click', function() {
			let position = $(this).attr('id').replace('btn_identification_', '');
			let inputId = $(this).data('input');
			let cellId = $(this).data('cell');
			self.renderRscData(inputId, cellId, position, 'terms');
		});

		// Eliminar registro
		$('.deleteIdentification').off().on('click', function() {
			let index = $(this).parent().parent().attr('data-id').replace('id', '');
			self.terms.splice(index, 1);
			self.terminosTable();
		});
	},

	renderRscData(inputId, cellId, position, eArray) {
		let self = this;

		let language = sessionStorage['STCMBackEnd:lenguage'];

		if(self.tableRSCFlag) {
			$('#tableRSC').dataTable().fnDestroy();
		} else {
			self.tableRSCFlag = true;
		}

		// Comprobación de array
		if(!Array.isArray(self.rscData)) {
			self.rscData = [];
		}

		let table = `
			<thead>
				<tr>
					<th scope="col" title="${pf.const.language.RSC366}">${pf.const.language.RSC366}</th>
					<th scope="col" title="${language}">${language}</th>
				</tr>
			</thead>

			<thead class="filtersResult">
				<tr>
					<td>id</td>
					<td>language</td>
				</tr>
			</thead>

			<tbody>
		`;

		let size = self.rscData.length;
		for(let i = 0; i < size; i++) {
			let languageRSC = self.rscData[i][language];

			// Solo RSC que son de app y no system
			if(self.rscData[i].app != 1 || self.rscData[i].system == 1) {
				continue;
			}

			table += `
				<tr id="id-${self.rscData[i].idRSC}" class="c-pointer rscElement" data-id="${self.rscData[i].idRSC}" data-text="${languageRSC}">
					<td title="${self.rscData[i].idRSC}">${self.rscData[i].idRSC}</td>
					<td title="${languageRSC}">${languageRSC}</td>
				</tr>
			`;
		}

		table += `
			</tbody>
		`;

		$('#tableRSC').html(table);

		// Setup - add a text input to each footer cell
		$('#tableRSC .filtersResult td').each(function() {
			let value = `<input type="text" class="form-control form-control-sm">`;

			$(this).html(value);
		});

		let tableRSC = $('#tableRSC').DataTable({
			retrieve: true,
			language: pf.const.language_table,
			scrollY: 300,
			scroller: false,
			paging: true,
			pageLength: 25,
			autoWidth: false,
			aaSorting: [],
			columnDefs: [
				{width: '30px', targets: 0}
			]
		});

		setTimeout(function() {
			tableRSC.columns.adjust();
		}, 200);

		// Ocultar botones de tabla
		hideTableButtons('tableRSC');

		// Apply the search
		applyTheSearch(tableRSC, 'filtersResult');

		self.rscDataEvents(inputId, cellId, position, eArray);

		$('#tableRSC').on('draw.dt', function() {
			self.rscDataEvents(inputId, cellId, position, eArray);
		});
	},

	rscDataEvents(inputId, cellId, position, eArray = null) {
		// Seleccionar RSC
		$('.rscElement').off().on('click', function() {
			let rscId = $(this).data('id');
			let rscText = $(this).data('text');

			$('#' + inputId).val(rscId);
			$('#' + inputId).attr('title', rscId);
			$('#' + cellId).html(rscText);
			$('#' + cellId).attr('title', rscText);
			$('#' + cellId).val(rscText);
			$('#closeRSC').trigger('click');
		});
	},

	clickEvents(data, dType = null) {
		let self = this;

		if(dType) {
			self.requestType = dType;
		}

		switch(self.requestType) {
			case 'country':
				self.countrydefault = data.isocode;
				$('#rscCountryDefault').val(data.isocode);
				break;
			case 'rol':
				self.roledefault = data.id;
				$('#rscRoleDefault').val(data.id);
				break;
			case 'language':
				self.languagedefault = data.isocode;
				$('#rscLanguageDefault').val(data.isocode)
				break;
			default:
				break;
		}
	},

	generateTermsArray() {
		let termsArray = [];
		$('#terminosTable tbody').find('tr').each((i, row)=>{
			let termsObject = {};
			termsObject.enabled = '1';
			termsObject.id = i.toString();
			termsObject.idTenant = sessionStorage['STCMBackEnd:idTenant'];
			termsObject.rsctext = $(row).find('.terminoTextClass').val();
			termsObject.rscterms = $(row).find('.terminoTermsClass').val();
			termsArray.push(termsObject);
		});
		return(termsArray);
	},

	saveRegisterForm() {
		let self = this;

		let email = ($('#registroEmail:checked').length > 0 ? '1' : '0');
		let firstname = ($('#nombreInput:checked').length > 0 ? '1' : '0');
		let lastname = ($('#apellidoInput:checked').length > 0 ? '1' : '0');
		let secondlastname = ($('#segundoApellidoInput:checked').length > 0 ? '1' : '0');
		let country = ($('#paisInput:checked').length > 0 ? '1' : '0');
		let language = ($('#idiomaInput:checked').length > 0 ? '1' : '0');
		let role = ($('#rolInput:checked').length > 0 ? '1' : '0');
		let acceptterms = ($('#displayTermsInput:checked').length > 0 ? '1' : '0');

		let validateBySMS = ($('#validateBySMS').prop('checked') ? '1' : '0');
		let validateByEmail = ($('#validateByEmail').prop('checked') ? '1' : '0');
		if(validateBySMS === '0' && validateByEmail === '0') {
			let warningTitle = pf.const.language.RSC1520;
			let warningContent = pf.const.language.RSC2168;
			pf.utils.showInfoDialog(warningTitle, warningContent);
			$('#validateBySMS').addClass('is-invalid');
			$('#validateByEmail').addClass('is-invalid');
			return false;
		} else {
			$('#validateBySMS').removeClass('is-invalid');
			$('#validateByEmail').removeClass('is-invalid');
		}

		let countrydefault = self.countrydefault;
		let languagedefault = self.languagedefault;
		let roledefault = self.roledefault;

		let codevalidationtimeminutes = parseInt($('#timeInputHours').val()) * 60 + parseInt($('#timeInputMinutes').val());

		let rscValidation = $('#idRSCValidacion').attr('title');

		let terms = JSON.stringify(self.generateTermsArray());

		let parameters = {
			email: email,
			firstname: firstname,
			lastname: lastname,
			secondlastname: secondlastname,
			country: country,
			language: language,
			role: role,
			acceptterms: acceptterms,
			countrydefault: countrydefault,
			languagedefault: languagedefault,
			roledefault: roledefault,
			codevalidationtimeminutes: codevalidationtimeminutes,
			rscValidation: rscValidation,
			terms: terms,
			validateBySMS: validateBySMS,
			validateByEmail: validateByEmail
		};
		ajaxComunCallWithCallback('setRegisterConfiguration', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let confirmTitle = pf.const.language.RSC78;
				let confirmContent = pf.const.language.RSC106;

				pf.utils.showInfoDialog(confirmTitle, confirmContent);
				loadHTML('inc/ajustes/formularioRegistro.html', 'wrapper', FormularioRegistroController);
			}
		});
	}
};