let InversionController = {
	typeColors: null,
	fontSize: null,
	fontName: null,
	colorsRGB: [],
	colorsHex: [],
	investment: '',
	infoFlag: false,
	country: '',
	tableFlag: false,
	startDate: '',
	endDate: '',
	project: '',
	idProject: '',

	reset() {
		let self = this;

		self.typeColors = null;
		self.fontSize = null;
		self.fontName = null;
		self.colorsRGB = [];
		self.colorsHex = [];
		self.investment = '';
		self.infoFlag = false;
		self.country = '';
		self.tableFlag = false;
		self.startDate = '';
		self.endDate = '';
		self.project = '';
		self.idProject = '';
	},

	setEvents() {
		let self = this;
		self.reset();

		// Reducción de Header
		headerSectionHeight(0);

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC37);

		// Opciones de header
		let jsonsubopt = {
			startEndDate: {
				class: 'form-group m-0 pl-1',
				style: 'max-width: 145px; line-height: initial;'
			},
			startEndTime: {
				class: 'form-group m-0 pl-1',
				style: 'min-width: 105px; line-height: initial;'
			},
			country: {
				id: 'country',
				deleteBtn: true,
				style: 'style="line-height: initial; padding-top: 1.75rem!important"'
			},
			project: {
				id: 'project',
				style: 'style="line-height: initial; padding-top: 1.75rem!important"'
			},
			refresh: 'previewTables'
		};

		let nav = `
			<div class="row mx-0">
				${createSubOptionStartEndDateTime(jsonsubopt.startEndDate.class, jsonsubopt.startEndTime.class, jsonsubopt.startEndDate.style, jsonsubopt.startEndTime.style)}
				${createSubOptionCountry(jsonsubopt.country.id, jsonsubopt.country.deleteBtn, jsonsubopt.country.style)}
				${createSubOptionProject(jsonsubopt.project.id, jsonsubopt.project.style)}
				<div id="buttonsContainer" class="pa-to-28">
					${createSubOptionRefresh(jsonsubopt.refresh)}
				</div>
			</div>
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		// Botón principal
		$('#previewTables').addClass('main-button');

		$('#startTime').parent().hide();
		$('#endTime').parent().hide();
		$('#resultTableI').hide();
		$('#countryDelete').hide();

		// Inputs de fecha y hora
		let now = new Date();
		let nYear = now.getFullYear();
		let nMonth = now.getMonth() + 1;
		if(nMonth < 10) {
			nMonth = '0' + nMonth;
		}
		let nDay = now.getDate();
		if(nDay < 10) {
			nDay = '0' + nDay;
		}
		let today = nYear + '-' + nMonth + '-' + nDay;
		self.startDate = today;
		self.endDate = today;

		$('#startDate').val(self.startDate);
		$('#endDate').val(self.endDate);

		self.loadLang();

		// Valores de configuración
		let config = JSON.parse(atob(sessionStorage.getItem('STCMBackEnd:config')));
		self.typeColors = config.UsarColorDegradado;
		self.fontSize = config.SizeFontAnalytics;
		self.fontName = config.FontAnalytics;

		if(!config.RGBFin || config.RGBFin === '') {
			self.colorsRGB[0] = '000,000,255';
			self.colorsHex[0] = rgb2hex('rgb(000,000,255)');
		} else {
			if(self.typeColors == 1) {
				self.colorsRGB[0] = config.RGBFin;
				self.colorsHex[0] = rgb2hex('rgb(' + config.RGBFin + ')');
			} else {
				self.colorsRGB = [];
				for(let i = 0; i < config.colores.length; i++) {
					self.colorsRGB.push(config.colores[i].color);
				}
			}
		}

		if(!config.RGBInicio || config.RGBInicio === '') {
			self.colorsRGB[1] = '255,000,000';
			self.colorsHex[1] = rgb2hex('rgb(255,000,000)');
		} else {
			if(self.typeColors == 1) {
				self.colorsRGB[1] = config.RGBInicio;
				self.colorsHex[1] = rgb2hex('rgb(' + config.RGBInicio + ')');
			} else {
				self.colorsHex = [];
				for(let i = 0; i < config.colores.length; i++) {
					self.colorsHex.push(rgb2hex('rgb(' + config.colores[i].color + ')'));
				}
			}
		}

		self.applyEvents();

		// Control de países permitidos por el administrador si solo hay uno
		let countries = JSON.parse(atob(sessionStorage['STCMBackEnd:userCountries']));
		let countriesDesc = atob(sessionStorage['STCMBackEnd:userCountriesDesc']);
		let remuneration_country = sessionStorage['home:remuneration_country'];
		let advisers_country_desc = sessionStorage['home:remuneration_country_desc'];
		if(countries.length === 1) {
			self.country = countries[0];
			$('#country').val(countriesDesc);
			$('#country').attr('title', countriesDesc);
			$('#countryDelete').show();
			$('#previewTables').trigger('click');
		} else if(remuneration_country != undefined) {
			self.country = remuneration_country;
			$('#country').val(advisers_country_desc);
			$('#country').attr('title', advisers_country_desc);
			$('#countryDelete').show();
			$('#previewTables').trigger('click');
			sessionStorage.removeItem('home:remuneration_country');
			sessionStorage.removeItem('home:remuneration_country_desc');
		}

		// Pintar texto de label
		changeLabelsColor();
	},

	loadLang() {
		pf.rsc.translateByTag('text');

		// TITLES
		$('.exportTitle').attr('title', pf.const.language.RSC47);
	},

	applyEvents() {
		let self = this;

		// País
		let countryModal = new TableCountries(0, 'inversion');
		$('#searchCountry').on('click', function() {
			countryModal.setEvents();
		});

		// Limpiar país
		$('#countryDelete').on('click', function() {
			self.country = '';
			$('#country').val('');
			$('#country').attr('title', '');
			$('#countryDelete').hide();
		});

		// Fecha de inicio
		$('#startDate').on('change', function() {
			self.startDate = $('#startDate').val();
			if(self.startDate > self.endDate) {
				$('#startDate').val(self.endDate);
				self.startDate = $('#startDate').val();
			}
		});

		// Fecha de fin
		$('#endDate').on('change', function() {
			self.endDate = $('#endDate').val();
			if(self.endDate < self.startDate) {
				$('#endDate').val(self.startDate);
				self.endDate = $('#endDate').val();
			}
		});

		// Proyectos
		$('#searchProject').on('click', function() {
			// Objeto project
			if(self.project === '') {
				ajaxComunCallWithCallback('getCMBPProjects', {}, function(ajaxReturn) {
					if(ajaxReturn) {
						self.project = ajaxReturn.result;

						self.renderProject();
					}
				});
			} else {
				$('#projectTable').modal('show', true);
			}
		});

		// Visualizar tabla de Inversiones
		$('#previewTables').on('click', function() {
			$('#resultTableI').show();

			let parameters = {
				country: self.country,
				project: self.idProject,
				rangoDesde: self.startDate.replace(/-/g, '/'),
				rangoHasta: self.endDate.replace(/-/g, '/')
			};
			ajaxComunCallWithCallback('getAnalyticsInversion', parameters, function(ajaxReturn) {
				if(ajaxReturn) {
					self.investment = ajaxReturn.result;

					self.renderInvestment();
				}
			});
		});
	},

	renderProject() {
		let self = this;

		let table = `
			<thead>
				<tr>
					<th scope="col" title="${pf.const.language.RSC165}">${pf.const.language.RSC165}</th>
					<th scope="col" title="${pf.const.language.RSC123}">${pf.const.language.RSC123}</th>
					<th scope="col" title="${pf.const.language.RSC143}">${pf.const.language.RSC143}</th>
					<th scope="col" title="${pf.const.language.RSC144}">${pf.const.language.RSC144}</th>
				</tr>
			</thead>

			<thead class="filtersProject">
				<tr>
					<td>FechaAlta</td>
					<td>NombreProyecto</td>
					<td>LiderProyecto</td>
					<td>ClienteInterno</td>
				</tr>
			</thead>

			<tbody>
		`;

		// Obtener países permitidos
		let allowedCountries = JSON.parse(atob(sessionStorage['STCMBackEnd:userCountries']));
		let size = self.project.length;
		for(let i = 0; i < size; i++) {
			// Control de países permitidos
			if(allowedCountries.indexOf(self.project[i].country) == -1) {
				continue;
			}

			// Formato de fecha, el servicio devuelve AAAA-MM-DD HH:MM:SS
			let dateTime = '';
			let dateTimeArray = self.project[i].FechaDeAlta.split(' ');
			let date = dateTimeArray[0].replace(/-/g, '/');
			if(self.dateFormat === 'DDMMAAAA') {
				dateTime = modifyDateFormat(date);
			} else {
				dateTime = date;
			}

			table += `
				<tr id="id${self.project[i].id}" class="c-pointer">
					<td title="${dateTime}">${dateTime}</td>
					<td class="projectName" title="${self.project[i].NombreProyecto}">${self.project[i].NombreProyecto}</td>
					<td title="${self.project[i].LiderProyecto}">${self.project[i].LiderProyecto}</td>
					<td title="${self.project[i].ClienteInterno}">${self.project[i].ClienteInterno}</td>
				</tr>
			`;
		}

		table += `
			</tbody>
		`;

		$('#tableProject').html(table);

		// Setup - add a text input to each footer cell
		$('#tableProject .filtersProject td').each(function() {
			let value = `<input type="text" class="form-control form-control-sm">`;

			$(this).html(value);
		});

		let tableProject = $('#tableProject').DataTable({
			language: pf.const.language_table,
			scrollY: 300,
			scroller: false,
			paging: true,
			pageLength: 25,
			autoWidth: false,
			order: [[0, 'desc']]
		});

		setTimeout(function() {
			tableProject.columns.adjust();
		}, 200);

		// Ocultar botones de tabla
		hideTableButtons('tableProject');

		// Apply the search
		applyTheSearch(tableProject, 'filtersProject');

		$('#tableProject tbody').off().on('click', 'tr', function() {
			self.idProject = $(this).prop('id').replace('id', '');
			let name = $(this).find('.projectName').text();
			$('#project').val(name);
			$('#tableProject tbody tr').css('outline-width', 'initial');
			$('#tableProject tbody tr').css('outline-style', 'none');
			$('#tableProject tbody tr').css('outline-color', '#000');
			$('#tableProject tbody tr').css('font-weight', 'normal');
			$(this).css('outline-width', 'thin');
			$(this).css('outline-style', 'solid');
			$(this).css('outline-color', '#f00');
			$(this).css('font-weight', 'bold');
			$('#closeProject').trigger('click');
		});
	},

	renderInvestment() {
		let self = this;

		$('#registers').html('');
		if(self.tableFlag) {
			$('#registers').dataTable().fnDestroy();
		} else {
			self.tableFlag = true;
		}

		let table = `
			<thead>
				<tr>
					<th scope="col">#</th>
					<th scope="col" title="${pf.const.language.RSC165}">${pf.const.language.RSC165}</th>
					<th scope="col" title="${pf.const.language.RSC550}">${pf.const.language.RSC550}</th>
					<th scope="col" title="${pf.const.language.RSC175}">${pf.const.language.RSC175}</th>
					<th scope="col" title="${pf.const.language.RSC176}">${pf.const.language.RSC176}</th>
					<th scope="col" title="${pf.const.language.RSC26}">${pf.const.language.RSC26}</th>
					<th scope="col" title="${pf.const.language.RSC178}">${pf.const.language.RSC178}</th>
					<th scope="col" title="Target">Target</th>
					<th scope="col" title="${pf.const.language.RSC145}">${pf.const.language.RSC145}</th>
					<th scope="col" title="${pf.const.language.RSC953}">${pf.const.language.RSC953}</th>
					<th scope="col" title="${pf.const.language.RSC179}">${pf.const.language.RSC179}</th>
					<th scope="col" title="${pf.const.language.RSC180}">${pf.const.language.RSC180}</th>
					<th scope="col" title="% ${pf.const.language.RSC181}">% ${pf.const.language.RSC181}</th>
					<th scope="col" title="${pf.const.language.RSC182}">${pf.const.language.RSC182}</th>
					<th scope="col" title="${pf.const.language.RSC183}">${pf.const.language.RSC183}</th>
					<th scope="col" title="${pf.const.language.RSC1314}">${pf.const.language.RSC1314}</th>
				</tr>
			</thead>

			<thead class="filtersResult">
				<tr>
					<td>#</td>
					<td>date</td>
					<td>pais</td>
					<td>organization</td>
					<td>project</td>
					<td>mission</td>
					<td>description</td>
					<td>target</td>
					<td>importe</td>
					<td>moneda</td>
					<td>missionsSent</td>
					<td>missionsAccomplished</td>
					<td>totalCompliance</td>
					<td>plannedInvestment</td>
					<td>realInvestment</td>
					<td>informacion</td>
				</tr>
			</thead>

			<tbody>
		`;

		let counter = 0;
		let missionsSentTotal = 0;
		let missionsAccomplishedTotal = 0;
		let plannedInvestmentTotal = 0;
		let realInvestmentTotal = 0;

		// Obtener países permitidos
		let allowedCountries = JSON.parse(atob(sessionStorage['STCMBackEnd:userCountries']));
		let size = self.investment.length;
		for(let i = 0; i < size; i++) {
			let missions = self.investment[i].misiones;
			let dateArray = self.investment[i].projectFecha.split(' ');
			let date = dateArray[0];
			let missionsSize = missions.length;
			if(missionsSize > 0) {
				for(let j = 0; j < missionsSize; j++) {
					// Control de países permitidos
					if(allowedCountries.indexOf(missions[j].country) == -1) {
						continue;
					}
					counter++;

					let totalCompliance = '';
					if(self.investment[i].numParticipantesProjectOK > 0 && self.investment[i].numParticipantesProject > 0) {
						totalCompliance = (self.investment[i].numParticipantesProjectOK * 100 / self.investment[i].numParticipantesProject).toFixed(1) + '%';
					} else {
						totalCompliance = '-';
					}

					let index = '';
					if(missions[j].inversionReal > 0 && missions[j].inversionPrevista > 0) {
						index = (missions[j].inversionReal * 100 / missions[j].inversionPrevista).toFixed(1) + '%';
					} else {
						index = '-';
					}

					table += `
						<tr>
							<td class="text-truncate" title="${counter}">${counter}</td>
							<td class="text-truncate" title="${date}">${date}</td>
							<td class="text-truncate" title="${missions[j].country}">${missions[j].country}</td>
							<td class="text-truncate" title="${self.investment[i].projectCustomer}">${self.investment[i].projectCustomer}</td>
							<td class="text-truncate" title="${self.investment[i].projectoDesc}">${self.investment[i].projectoDesc}</td>
							<td class="text-truncate" title="${missions[j].tipoMision}">${missions[j].tipoMision}</td>
							<td class="text-truncate" title="${missions[j].misionDesc}">${missions[j].misionDesc}</td>
							<td class="text-truncate" title="-">-</td>
							<td class="text-truncate" title="${missions[j].importemision}">${missions[j].importemision}</td>
							<td class="text-truncate" title="${missions[j].currency}">${missions[j].currency}</td>
							<td class="text-truncate" title="${self.investment[i].numParticipantesProject}">${self.investment[i].numParticipantesProject}</td>
							<td class="text-truncate" title="${self.investment[i].numParticipantesProjectOK}">${self.investment[i].numParticipantesProjectOK}</td>
							<td class="text-truncate" title="${totalCompliance}">${totalCompliance}</td>
							<td class="text-truncate" title="${missions[j].inversionPrevista}">${missions[j].inversionPrevista}</td>
							<td class="text-truncate" title="${missions[j].inversionReal}">${missions[j].inversionReal}</td>
							<td class="text-center">
								<button type="button" class="btn table-button main-color-text searchInfo" data-toggle="modal" data-target="#infoModal" data-i="${i}" data-j="${j}">
									${stcmbackend.svg.bigEyeWithoutColor}
								</button>
							</td>
						</tr>
					`;
					missionsSentTotal += parseInt(self.investment[i].numParticipantesProject);
					missionsAccomplishedTotal += parseInt(self.investment[i].numParticipantesProjectOK);
					plannedInvestmentTotal += parseInt(missions[j].inversionPrevista);
					realInvestmentTotal += parseInt(missions[j].inversionReal);
				}
			}
		}

		let totalAccomplished = (missionsAccomplishedTotal * 100 / missionsSentTotal).toFixed(1) + '%';
		if(totalAccomplished === 'NaN%') {
			totalAccomplished = '-';
		}
		let totalInvestment = (realInvestmentTotal * 100 / plannedInvestmentTotal).toFixed(1) + '%';
		if(totalInvestment === 'NaN%') {
			totalInvestment = '-';
		}

		table += `
			</tbody>

			<tfoot>
				<tr class="font-weight-bold">
					<td colspan="3" title="${pf.const.language.RSC184}">${pf.const.language.RSC184}</td>
					<td></td>
					<td></td>
					<td></td>
					<td></td>
					<td></td>
					<td></td>
					<td></td>
					<td id="missSent" title="${missionsSentTotal}">${missionsSentTotal}</td>
					<td id="missAcco" title="${missionsAccomplishedTotal}">${missionsAccomplishedTotal}</td>
					<td id="missPercent" title="${totalAccomplished}">${totalAccomplished}</td>
					<td id="planInve" title="${plannedInvestmentTotal}">${plannedInvestmentTotal}</td>
					<td id="realInve" title="${realInvestmentTotal}">${realInvestmentTotal}</td>
					<td></td>
				</tr>
			</tfoot>
		`;

		$('#registers').html(table);

		// Setup - add a text input to each footer cell
		$('#registers .filtersResult td').each(function() {
			$(this).html('<input type="text" class="form-control form-control-sm">');
		});

		let dataTable = $('#registers').DataTable({
			retrieve: true,
			language: pf.const.language_table,
			pageLength: 25,
			autoWidth: false,
			columnDefs: [
				{width: '15px', targets: 0},
				{width: '55px', targets: 1},
				{width: '50px', targets: 2},
				{width: '60px', targets: 9},
				{width: '75px', targets: 15}
			],
			dom: 'Bfrtip',
			buttons: [{
				extend: 'excelHtml5',
				footer: true,
				text: pf.const.language.RSC129,
				className: 'd-none',
				title: pf.const.language.RSC37,
				customize(xlsx) {
					dataTablesExcelCustomize(xlsx);
				}
			}],
			rowGroup: {
				endRender(rows, group) {
					// Paginado
					return group + ': ' + pf.const.language.RSC146 + ' (' + rows.count() + ')';
				},
				dataSrc: 0
			},
			order: [[0, 'asc']],
			drawCallback() {
				let missSent = 0;
				let missAcco = 0;
				let missPercent = '';
				let planInve = 0;
				let realInve = 0;
				let InvePercent = '';
				$('#registers').DataTable().rows({filter: 'applied'}).data().each(function(el, index) {
					missSent += parseInt(el[10]);
					missAcco += parseInt(el[11]);
					planInve += parseInt(el[13]);
					realInve += parseInt(el[14]);
				});

				$('#missSent').text(missSent);
				$('#missAcco').text(missAcco);
				$('#planInve').text(planInve);
				$('#realInve').text(realInve);

				missPercent = (missAcco * 100 / missSent).toFixed(1) + '%';
				if(missPercent === 'NaN%') {
					missPercent = '-';
				}
				InvePercent = (realInve * 100 / planInve).toFixed(1) + '%';
				if(InvePercent === 'NaN%') {
					InvePercent = '-';
				}

				$('#missPercent').text(missPercent);
				$('#InvePercent').text(InvePercent);
			}
		});

		// Ocultar botones de tabla
		hideTableButtons('registers');

		// Apply the search
		applyTheSearch(dataTable, 'filtersResult');

		dataTable.rowGroup().disable().draw();
		$('#nestBy').hide();

		// Creación de select principal de agrupamiento
		// Arrays de datos
		let name = [];

		$.each($('#registers thead th'), function() {
			name.push($(this).text());
		});

		let options1 = `<option value="-1">${pf.const.language.RSC130}</option>`;
		for(let i = 0; i < name.length; i++) {
			options1 += `<option value="${i}">${name[i]}</option>`;
		}
		$('#groupBy').html(options1);

		// Función de agrupamiento anidado
		function nestBy() {
			$('#nestBy').html('');
			let options2 = `<option value="-1">${pf.const.language.RSC131}</option>`;
			for(let i = 0; i < name.length; i++) {
				if(i == $('#groupBy').val()) {
					continue;
				} else {
					options2 += `<option value="${i}">${name[i]}</option>`;
				}
			}
			$('#nestBy').html(options2);

			// Evento de anidado
			$('#nestBy').off().on('change', function() {
				let valueGroup = $('#groupBy').val();

				if($('#nestBy').val() === '-1') {
					dataTable.rowGroup().dataSrc(valueGroup);
					dataTable.order([[valueGroup, 'asc']]).draw();
				} else {
					let valueNest = $('#nestBy').val();
					dataTable.rowGroup().dataSrc([valueGroup, valueNest]);
					dataTable.order([[valueGroup, 'asc'], [valueNest, 'asc']]).draw();
				}
			});
		}

		// Evento de agrupamiento
		$('#groupBy').on('change', function() {
			if($('#groupBy').val() === '-1') {
				dataTable.rowGroup().disable().draw();
				$('#nestBy').hide();
			} else {
				let value = $('#groupBy').val();

				dataTable.rowGroup().enable().draw();
				$('#nestBy').show();

				dataTable.rowGroup().dataSrc(value);
				dataTable.order([[value, 'asc']]).draw();

				// Recreación de agrupamiento secundario
				nestBy();
			}
		});

		// Exportar tabla
		$('#exportInvestment').off().on('click', function() {
			$('#resultTableI .buttons-excel').trigger('click');
		});

		self.tableEvents();

		// Eventos con cambio de página de tabla
		$('#resultTableI').on('draw.dt', function() {
			self.tableEvents();
		});
	},

	tableEvents() {
		let self = this;

		$('.searchInfo').off().on('click', function() {
			let i = $(this).data('i');
			let j = $(this).data('j');

			let info = self.investment[i].misiones[j].participantesMision;
			self.infoTable(info);
		});
	},

	infoTable(info) {
		let self = this;

		if(self.infoFlag) {
			$('#tableInfo').dataTable().fnDestroy();
		} else {
			self.infoFlag = true;
		}

		let table = `
			<thead>
				<tr>
					<th scope="col" title="${pf.const.language.RSC176}">${pf.const.language.RSC176}</th>
					<th scope="col" title="${pf.const.language.RSC177}">${pf.const.language.RSC177}</th>
					<th scope="col" title="${pf.const.language.RSC68}">${pf.const.language.RSC68}</th>
					<th scope="col" title="${pf.const.language.RSC564}">${pf.const.language.RSC564}</th>
				</tr>
			</thead>

			<thead class="filtersInfo">
				<tr>
					<td>proyecto</td>
					<td>misión</td>
					<td>usuario</td>
					<td>estado</td>
				</tr>
			</thead>

			<tbody>
		`;

		let size = info.length;
		for(let i = 0; i < size; i++) {
			let cumplimiento = pf.const.language.RSC158;
			if(info[i].estadoMision == 1) {
				cumplimiento = pf.const.language.RSC157;
			}

			table += `
				<tr>
					<td class="text-truncate" title="${info[i].idProject}">${info[i].idProject}</td>
					<td class="text-truncate" title="${info[i].idmision}">${info[i].idmision}</td>
					<td class="text-truncate" title="${info[i].idUser}">${info[i].idUser}</td>
					<td class="text-truncate" title="${cumplimiento}">${cumplimiento}</td>
				</tr>
			`;
		}

		table += `
			</tbody>
		`;

		$('#tableInfo').html(table);

		// Setup - add a text input to each footer cell
		$('#tableInfo .filtersInfo td').each(function() {
			let value = `<input type="text" class="form-control form-control-sm">`;

			$(this).html(value);
		});

		let tableInfo = $('#tableInfo').DataTable({
			retrieve: true,
			language: pf.const.language_table,
			scrollY: 300,
			scroller: false,
			paging: true,
			pageLength: 25,
			autoWidth: false,
			columnDefs: [
				{width: '90px', targets: 3}
			],
			dom: 'Bfrtip',
			buttons: [{
				extend: 'excelHtml5',
				footer: true,
				text: pf.const.language.RSC1314,
				className: 'd-none',
				title: pf.const.language.RSC1314,
				exportOptions: {
					format: {
						body(data, row, column, node) {
							let dev = '';
							if(column === 0) {
								dev = '\0' + data;
							} else {
								dev = data;
							}
							return dev;
						}
					}
				},
				customize(xlsx) {
					dataTablesExcelCustomize(xlsx);
				}
			}],
			aaSorting: []
		});

		setTimeout(function() {
			tableInfo.columns.adjust();
		}, 200);

		// Ocultar botones de tabla
		hideTableButtons('tableInfo');

		// Apply the search
		applyTheSearch(tableInfo, 'filtersInfo');

		// Exportar tabla
		$('#exportInfo').off().on('click', function() {
			$('#infoTable .buttons-excel').trigger('click');
		});
	},

	clickEvents(data) {
		let self = this;

		self.country = data.isocode;
		$('#country').val(data.descripcion);
		$('#country').attr('title', data.descripcion);
		$('#countryDelete').show();
	}
};