let MuestreoDetalladoMAZSegTablaController = {
	dataSurveys: '',
	previewTables: '',
	totalPreviewTables: '',
	printed: 0,
	country: '',
	idPoll: '',
	segmento: '',
	groupSize: 5,
	countQuestions: 0,
	numPrintTables: stcm.const.NumTablasPrintar,
	currentPage: 0,
	totalPages: 1,
	totalTables: 0,
	consumer: 0,

	reset() {
		let self = this;

		self.dataSurveys = JSON.parse(atob(sessionStorage['STCMBackEnd:muesDetMAZSeg']));
		self.printed = 0;
		self.previewTables = 0;
		self.totalPreviewTables = 0;
		self.country = '';
		self.idPoll = '';
		self.groupSize = 5;
		self.countQuestions = 0;
		self.numPrintTables = stcm.const.NumTablasPrintar;
		self.currentPage = 0;
		self.totalPages = 1;
		self.totalTables = 0;
		self.consumer = 0;
	},

	setEvents() {
		let self = this;
		self.reset();

		// Reducción de Header
		headerSectionHeight(0);

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC1874 + ' - ' + pf.const.language.RSC965);

		$('#datadetailtablestab').html(pf.const.language.RSC965);
		$('#datadetailindextab').html(pf.const.language.RSC964);
		$('#datadetailresulttab').html(pf.const.language.RSC345);

		// Opciones de header
		let jsonsubopt = {
			back: 'back',
			export: {
				id: 'export',
				disabled: true
			}
		};

		let nav = `
			${createSubOptionExport(jsonsubopt.export.id, jsonsubopt.export.disabled)}
			${createSubOptionBack(jsonsubopt.back)}
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		// Botones secundarios
		$('#back').addClass('secondary-button');
		$('#export').addClass('secondary-button');

		self.consumer = sessionStorage.getItem('STCMBackEnd:Consumer');

		self.loadLang();
		self.applyEvents();

		self.setTabEvents();

		// -- Creación objeto para hacer request --
		// La creación de este objeto está pensada para que las encuestas
		// aunque sean iguales, no tengan el mismo survey_sid

		let surveysList = [];
		let objectToRequest = {};

		for(let index = 0; index < self.dataSurveys.length; index++) {
			if(self.dataSurveys[index]['survey_sid'] == '') {
				continue;
			}
			let survey = self.dataSurveys[index]['survey_sid'];
			surveysList.push(survey);
			let obj = {
				country: '',
				segmentations: []
			}
			obj['country'] = self.dataSurveys[index]['iso'];
			obj['segmentations'] = self.dataSurveys[index]['segmentacionIdCountry'];
			objectToRequest[survey] = obj;
		}

		self.idPoll = JSON.stringify(surveysList.join());
		var find = '"';
		var re = new RegExp(find, 'g');

		// -- Creación objeto para hacer request --
		self.idPoll = self.idPoll.replace(re, '');
		self.segmento = JSON.stringify(objectToRequest);

		$('#previewTable').hide();
		$('#previewTable #datadetailtables .card-body').html('');
		$('#previewTable #datadetailindex .card-body #tablePreviewIndex tbody').html('');
		$('#previewTable #datadetailindex .card-body #tablePreviewIndexHidden tbody').html('');

		//solo pedimos las preguntas de la primera survey, previamente ha papsado por el ws para validar si son iguales
		let parameters = {
			survey: self.idPoll,
			segmento: self.segmento
		};
		ajaxComunCallWithCallback('getAnalyticsMuestraToExportByPerfQuestionMAZSegmento', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				self.printed = 0;
				self.previewTables = ajaxReturn.result;
				self.totalPreviewTables = ajaxReturn.numQuestions;
				self.requestQueue(0);

				$('#export').prop('disabled', false);
			}
		});

		// Collapse
		addEventArrowTableHeader();
	},

	loadLang() {
		pf.rsc.translateByTag('text');
	},

	applyEvents() {
		let self = this;

		// Volver a Muestreo (Detallado Total MAZ)
		$('#back').on('click', function() {
			window.location.href = '#!muestreodetallado_maz_seg';
		});

		$('#export').off().on('click', function() {
			self.exportAsExcel();
		});
	},

	requestQueue(start) {
		let self = this;

		let size = self.totalPreviewTables;
		let end = start + self.groupSize;
		self.countQuestions = 0;
		if(size < end) {
			end = size;
		}
		for(var i = start; i < end; ++i) {
			var qid = self.getQIDFromMultipleSurveys(i);
			var div = $('<tr id="' + qid + '">');
			var divHidden = $('<tr id="' + qid + '">');
			var divHiddenSpace = '<tr><th class="text-left"></th></tr>';
			$('#previewTable #datadetailindex .card-body #tablePreviewIndex tbody').append(div);
			$('#previewTable #datadetailindex .card-body #tablePreviewIndexHidden tbody').append(divHidden);
			$('#previewTable #datadetailindex .card-body #tablePreviewIndexHidden tbody').append(divHiddenSpace);
			var div = $('<div id="' + qid + '">');
			var divPerc = $('<div id="perc' + qid + '">');
			$('#previewTable #datadetailtables .card-body').append(div);
			$('#previewTable #datadetailtables .card-body').append(divPerc);
			self.requestSingleQuestion(qid, i, size, end);
		}
	},

	getQIDFromMultipleSurveys(index) {
		let self = this;

		let result = '';
		let first = true;
		let comma = '';

		for(const [key, value] of Object.entries(self.previewTables)) {
			result = result + comma + value[index]['qid'];
			if(first) {
				first = false;
				comma = '-';
			}
		}

		return result;
	},

	printPagination() {
		let self = this;

		if(self.numPrintTables <= 0) {
			return;
		}

		//get total of pages
		self.totalPages = Math.ceil(self.totalTables / self.numPrintTables);
		if(self.totalPages == 1) {
			return;
		}

		//generate menu to navigate between pages
		$('#previewTable #datadetailtables .card-body .pagDetallado').html('');
		var menu = `
			<div class="list-group list-group-horizontal d-flex justify-content-end">
				<a id="pageChangeButton" value="anterior" class="c-pointer w-auto d-inline list-group-item list-group-item-action pageChangeButton ${((self.currentPage === 0) ? 'disabled' : '')}">${pf.const.language.RSC1061}</a>
		`;
		let block = '';
		let min = 0;
		switch(parseInt(self.currentPage)) {
			case 0:
			case 1:
				min = Math.min(parseInt(self.totalPages)-1, 2);
				for(let i = 0; i <= min; ++i) {
					block += `<a id="pageChangeButton" value="${i}" class="c-pointer w-auto d-inline list-group-item list-group-item-action ${((i === 0) ? 'active' : '')} pageChangeButton">${(i + 1)}</a>`;
				}

				if(parseInt(self.totalPages) > 4) {
					block += `<div class="w-auto d-inline list-group-item list-group-item-action disabled" > ... </div>`;
				}

				if(parseInt(self.totalPages) > 3) {
					block += `<a id="pageChangeButton" value="${(parseInt(self.totalPages) - 1)}" class="c-pointer w-auto d-inline list-group-item list-group-item-action pageChangeButton">${parseInt(self.totalPages)}</a>`;
				}

				menu += block;
				break;
			case parseInt((self.totalPages) - 2):
			case parseInt((self.totalPages) - 1):
				block += `<a id="pageChangeButton" value="0" class="c-pointer w-auto d-inline list-group-item list-group-item-action pageChangeButton">1</a>`;
				if(parseInt(self.totalPages) > 4) {
					block += `<div class="w-auto d-inline list-group-item list-group-item-action disabled" > ... </div>`;
				}

				min = Math.max(1,parseInt(self.totalPages) - 3);
				for(let i = min; i <= parseInt(self.totalPages)-1; ++i) {
					block += `<a id="pageChangeButton" value="${i}" class="c-pointer w-auto d-inline list-group-item list-group-item-action ${((i === 0) ? 'active' : '')} pageChangeButton">${(i + 1)}</a>`;
				}
				menu += block;
				break;
			default:
				block += `<a id="pageChangeButton" value="0" class="c-pointer w-auto d-inline list-group-item list-group-item-action pageChangeButton">1</a>`;
				if(parseInt(self.currentPage)-1 != 1) {
					block += `<div class="w-auto d-inline list-group-item list-group-item-action disabled" > ... </div>`;
				}

				min = Math.min(parseInt(self.totalPages) - 1, parseInt(self.currentPage) + 2);
				for(let i = parseInt(self.currentPage)-1; i < min; ++i) {
					block += `<a id="pageChangeButton" value="${i}" class="c-pointer w-auto d-inline list-group-item list-group-item-action ${((i === 0) ? 'active' : '')} pageChangeButton">${(i + 1)}</a>`;
				}
				if(min == parseInt(self.totalPages) - 1) {
					block += `<a id="pageChangeButton" value="${(parseInt(self.totalPages) - 1)}" class="c-pointer w-auto d-inline list-group-item list-group-item-action pageChangeButton">${parseInt(self.totalPages)}</a>`;
					menu+=block;
					break;
				}
				block += `<div class="w-auto d-inline list-group-item list-group-item-action disabled" > ... </div>`;
				block += `<a id="pageChangeButton" value="${(parseInt(self.totalPages) - 1)}" class="c-pointer w-auto d-inline list-group-item list-group-item-action pageChangeButton">${parseInt(self.totalPages)}</a>`;
				menu += block;
				break;
		}
		menu += `
				<a id="pageChangeButton" value="siguiente" class="c-pointer w-auto d-inline list-group-item list-group-item-action pageChangeButton ${((self.currentPage === self.totalPages - 1) ? 'disabled' : '')}">${pf.const.language.RSC1530}</a>
			</div>
		`;
		//add menu to html
		$('#previewTable #datadetailtables .card-body .pagDetallado').append(menu);
		//add click event to every menu item
		$('.pageChangeButton').off().click(function(e) {
			e.preventDefault();
			addLoader();
			self.renderPage($(this).attr('value'));
			removeLoader();
		});
	},

	//render page at @param page
	renderPage(page) {
		let self = this;
		switch(page) {
			case 'anterior':
				if(self.currentPage > 0) {
					--self.currentPage;
				}
				break;
			case 'siguiente':
				if(self.currentPage < self.totalPages-1) {
					++self.currentPage;
				}
				break;
			default:
				self.currentPage = page;
				break;
		}
		//display the correct pages
		$('#previewTable #datadetailtables .card-body div').hide();
		$('#previewTable #datadetailtables .card-body div').slice(self.currentPage * self.numPrintTables, self.currentPage * self.numPrintTables + self.numPrintTables).show();
		//add class active
		self.printPagination();

		$('.pageChangeButton.active').removeClass('active');
		$('.pageChangeButton[value="' + self.currentPage + '"]').addClass('active');
		//handle back and forward 
		if(self.currentPage == 0) {
			$(`.pageChangeButton[value="anterior"]`).addClass('disabled');
		} else {
			$(`.pageChangeButton[value="anterior"]`).removeClass('disabled');
		}

		if(self.currentPage == (self.totalPages - 1)) {
			$(`.pageChangeButton[value="siguiente"]`).addClass('disabled');
		} else {
			$(`.pageChangeButton[value="siguiente"]`).removeClass('disabled');
		}

		//scroll to the top
		$('.app-content').scroll();
		$('.app-content').animate({
			scrollTop: 0
		}, 1300);
	},

	requestSingleQuestion(qid, index, total, end) {
		let self = this;

		let token = sessionStorage['STCMBackEnd:token'];
		let reqName = 'getAnalyticsMuestraToExportByPerfMAZSegmento' + qid;

		let form = new FormData();
		form.append('action', 'getAnalyticsMuestraToExportByPerfMAZSegmento');
		form.append('token', token);
		form.append('survey', self.idPoll); //separated sid by ,
		form.append('segmento', self.segmento); //object with key surveyid and values country and segmentations ({'612': {'country': 'esp', 'segmentations': ['1634630314000']})
		form.append('pregunta', qid); //separated qid by ,

		let reqData = {
			url: stcm.const.serverAPI,
			method: 'POST',
			timeout: stcm.const.AJAX_TIMEOUT,
			processData: false,
			mimeType: 'application/x-www-form-urlencoded',
			contentType: false,
			data: form
		};

		pf.ajax.request(reqName, reqData);
		$(document).off(reqName);
		$(document).on(reqName, function(event, response) {
			if(response.status === 'OK') {
				let printed = false;
				let resp = JSON.parse(response.resData.response);
				if(resp.status === 'OK') {
					if(resp.result.length == 0) {
						self.printed += 1; //porque las de tipo : vienen como array vacío
					}
					Object.keys(resp.result).forEach(function(key) {
						let question = resp.result[key];
						if(key == 'totales' && index == 0) {
							$('#previewTable #datadetailresult .card-body').html('');
							self.renderTableTotal(question);
						} else if(key != 'totales' && key != 'factoresPonderacion') {
							if(typeof(question.answers) !== 'undefined') {
								self.renderPreviewTable(question, resp.result['totales'], resp.result['factoresPonderacion']);
							} else {
								self.renderPreviewTableSQ(question, resp.result['totales'], resp.result['factoresPonderacion']);
							}
							self.printed += 1;
						}
						if(total == self.printed && !printed) {
							printed = true;
							$('#previewTable #datadetailtables .card-body div').hide();
							self.totalTables = $('#previewTable #datadetailtables .card-body div').length;
							section = `<section class="pagDetallado"></section>`;
							$('#previewTable #datadetailtables .card-body').append(section);
							self.renderPage(0);
							removeLoader();
							$('#export').prop('disabled', false);
						}
					});

					self.countQuestions++;
					if(end <= total && self.countQuestions == self.groupSize) {
						self.requestQueue(end);
					}
				} else {
					let errorTitle = pf.const.language.RSC61;
					let errorContent = resp.result;
					pf.utils.showInfoDialog(errorTitle, errorContent);
					if(resp.result == 'Not authorized') {
						pf.ajax.setWindowLocationIndex();
					}
				}
			} else {
				let errorTitle = pf.const.language.RSC61;
				let errorContent = response.result;
				pf.utils.showInfoDialog(errorTitle, errorContent);
				if(response.result == 'Not authorized') {
					pf.ajax.setWindowLocationIndex();
				}
			}
		});
	},

	renderTableTotal(totales) {
		let self = this;

		let headersGenero = totales.genero || [];
		let headersEdad = totales.edad || [];
		let headersSec = totales.sec || [];
		let headersRegion = totales.region || [];
		let headersConsumo = totales.consumo || [];

		let total = 0;

		let tableinit = `
			<table id="tableTotalResult" class="table table-hover">
				<thead>
					<tr>
						<th></th>
		`;
		tableinit += `<th title="${pf.const.language.RSC345}">${pf.const.language.RSC345}</th><th></th>`;
		tableinit += `
				</tr>
			</thead>

			<tbody>
				<tr><td class="text-truncate" title="${pf.const.language.RSC345}"><strong>${pf.const.language.RSC345}</strong></td>
		`;

		let table = '';

		let length = headersGenero.length;
		for(let i = 0; i < length; ++i) {
			table += `
				<tr>
					<td class="text-truncate" title="${headersGenero[i].genero}"><strong>${headersGenero[i].genero}</strong></td>
					<td class="text-truncate" title="${headersGenero[i].value}">${headersGenero[i].value}</td>
					<td class="text-truncate" title="${headersGenero[i].porc}%">${headersGenero[i].porc}%</td>
				</tr>
			`;
			total += headersGenero[i].value;
		}

		length = headersEdad.length;
		for(let i = 0; i < length; ++i) {
			table += `
				<tr>
					<td class="text-truncate" title="${headersEdad[i].edad}"><strong>${headersEdad[i].edad}</strong></td>
					<td class="text-truncate" title="${headersEdad[i].value}">${headersEdad[i].value}</td>
					<td class="text-truncate" title="${headersEdad[i].porc}%">${headersEdad[i].porc}%</td>
				</tr>
			`;
		}

		length = headersSec.length;
		for(let i = 0; i < length; ++i) {
			table += `
				<tr>
					<td class="text-truncate" title="${headersSec[i].sec}"><strong>${headersSec[i].sec}</strong></td>
					<td class="text-truncate" title="${headersSec[i].value}">${headersSec[i].value}</td>
					<td class="text-truncate" title="${headersSec[i].porc}%">${headersSec[i].porc}%</td>
				</tr>
			`;
		}

		length = headersRegion.length;
		for(let i = 0; i < length; ++i) {
			table += `
				<tr>
					<td class="text-truncate" title="${headersRegion[i].region}"><strong>${headersRegion[i].descripcion}</strong></td>
					<td class="text-truncate" title="${headersRegion[i].value}">${headersRegion[i].value}</td>
					<td class="text-truncate" title="${headersRegion[i].porc}%">${headersRegion[i].porc}%</td>
				</tr>
			`;
		}

		if(self.consumer == '1') {
			length = headersConsumo.length;
			for(let i = 0; i < length; ++i) {
				var textConsumo = '';
				if(headersConsumo[i].questionConsumo == '1') {
					textConsumo = pf.const.language.RSC1899;
				} else if(headersConsumo[i].questionConsumo == '0') {
					textConsumo = pf.const.language.RSC1900;
				}
				table += `
					<tr>
						<td class="text-truncate" title="${textConsumo}"><strong>${textConsumo}</strong></td>
						<td class="text-truncate" title="${headersConsumo[i].value}">${headersConsumo[i].value}</td>
						<td class="text-truncate" title="${headersConsumo[i].porc}%">${headersConsumo[i].porc}%</td>
					</tr>
				`;
			}
		}

		table += `
				</tbody>
			</table>
		`;

		table = tableinit + `<td class="text-truncate" title="${total}"><strong>${total}</strong></td><td class="text-truncate"><strong></strong></td></tr>` + table;

		$('#previewTable #datadetailresult .card-body').append(table);
	},

	renderTTBLTB(tableElem) {
		// Añadido T2B y L2B para preguntas tipo L
		// T2B
		let numberOfRows = $(tableElem).find('tbody tr').length - 1; //restamos 1 por la fila del total
		let top1Porc = $(tableElem).find('#sidpercent0');
		let top2Porc = $(tableElem).find('#sidpercent1');
		let trPorc = `<tr class="text-truncate" strtype="text">`;
		for(let i = 0; i < top1Porc.children().length; i++) {
			let element1 = top1Porc.children()[i];
			let element2 = top2Porc.children()[i];
			if(i == 0) {
				trPorc += `<td class="text-truncate" strtype="text">T2B</td>`;
			} else {
				text1 = $(element1).attr('title') != null ? $(element1).attr('title').slice(0, -1) : 0;
				text2 = $(element2).attr('title') != null ? $(element2).attr('title').slice(0, -1) : 0;
				let suma = parseFloat(text1) + parseFloat(text2);
				if(i == 1) {
					trPorc += `<td class="text-truncate" strtype="text"><strong>${suma.toFixed(2)}%</strong></td>`;
				} else {
					trPorc += `<td class="text-truncate" strtype="text">${suma.toFixed(2)}%</td>`;
				}
			}
		}
		trPorc += '</tr>';

		// L2B
		let low1Porc = $(tableElem).find('#sidpercent' + (numberOfRows - 1));
		let low2Porc = $(tableElem).find('#sidpercent' + (numberOfRows - 2));
		let trLowPorc = `<tr class="text-truncate" strtype="text">`;
		for(let i = 0; i < low1Porc.children().length; i++) {
			let element1 = low1Porc.children()[i];
			let element2 = low2Porc.children()[i];
			if(i == 0) {
				trLowPorc += `<td class="text-truncate" strtype="text">L2B</td>`;
			} else {
				text1 = $(element1).attr('title') != null ? $(element1).attr('title').slice(0, -1) : 0;
				text2 = $(element2).attr('title') != null ? $(element2).attr('title').slice(0, -1) : 0;
				let suma = parseFloat(text1) + parseFloat(text2);
				if(i == 1) {
					trLowPorc += `<td class="text-truncate" strtype="text"><strong>${suma.toFixed(2)}%</strong></td>`;
				} else {
					trLowPorc += `<td class="text-truncate" strtype="text">${suma.toFixed(2)}%</td>`;
				}
			}
		}
		trLowPorc += '</tr>';

		return {'TTB': trPorc, 'LTB': trLowPorc};
	},

	renderPreviewTable(question, arrayTotales, arrayFactoresPonderacion) {
		let self = this;

		$('#previewTable').show();
		let qType = question.type;

		let totalUsers = question.numAnswersTotal;
		let totalGeneroPorc = question.answers[0].totalGeneroPorc;

		let headersGenero = question.answers[0].genero || [];
		let headersEdad = question.answers[0].edad || [];
		let headersSec = question.answers[0].sec || [];
		let headersRegion = question.answers[0].region || [];
		let headersConsumo = question.answers[0].consumo || [];

		let total = headersGenero.length + headersEdad.length + headersSec.length + headersRegion.length + 2;
		if(self.consumer == '1') {
			total += headersConsumo.length;
		}
		let headersRes = self.renderTableHeaders(question, total, headersGenero, headersEdad, headersSec, headersRegion, headersConsumo);

		let tableindex = `<th class="text-left w-100" title="${question.question}">${question.question}</th>`;
		let tableindexHidden = `<th class="text-left w-100" title="${question.question}">${question.question}</th>`;

		let table = headersRes.table;
		let tablePercent = headersRes.table;
		let tablePercentTTBLTB = headersRes.table;

		let j = 0;
		let totalArrayRes = headersRes.totalArrayRes;
		let totalPonderated = 0;
		if($('#ponderacion').is(':checked') && qType == 'T') {
			Object.keys(question.answers).forEach(function(key) {
				let genero = question.answers[key].genero || [];
				totalPonderated += self.getCalculateDataPonderated(genero, totalArrayRes, arrayFactoresPonderacion);
			});
		}

		Object.keys(question.answers).forEach(function(key) {
			let answer = question.answers[key];
			let answerStr = answer.answer;
			if(typeof(answer.answer) === 'undefined') {
				answerStr = answer.question;
			}

			if(answerStr == '') {
				answerStr = answer.code;
			}

			if(answerStr != '') {
				table += `<tr id="sid${j}">`;
				table += `<td class="text-truncate" strtype="text" title="${answerStr}" style='mso-number-format: "\@";'>${answerStr}</td>`;

				tablePercent += `<tr id="sidpercent${j}">`;
				tablePercent += `<td class="text-truncate" strtype="text" title="${answerStr}" style='mso-number-format: "\@";'>${answerStr}</td>`;

				tablePercentTTBLTB += `<tr id="sidpercent${j}">`;
				tablePercentTTBLTB += `<td class="text-truncate" strtype="text" title="${answerStr}" style='mso-number-format: "\@";'>${answerStr}</td>`;

				let genero = question.answers[key].genero || [];
				let edad = question.answers[key].edad || [];
				let sec = question.answers[key].sec || [];
				let region = question.answers[key].region || [];
				let consumo = question.answers[key].consumo || [];
				let numUsers = question.answers[key].numUsers || 0;

				var calculateRes = self.renderCalculateData(genero, edad, sec, region, consumo, totalArrayRes, question.numAnswersTotal, qType, arrayTotales, numUsers, arrayFactoresPonderacion, totalPonderated);
				table += calculateRes.table + `</tr>`;
				tablePercent += calculateRes.tablePercent + `</tr>`;
				tablePercentTTBLTB += calculateRes.tablePercentTTBLTB + `</tr>`;
				totalArrayRes = calculateRes.totalArrayRes;
				j++;
			}
		});

		let result = self.renderTotalData(totalArrayRes, headersGenero, headersEdad, headersSec, headersRegion, headersConsumo, arrayFactoresPonderacion);
		table += result.table;
		tablePercent += result.table;
		tablePercentTTBLTB += result.table;

		table += `
				</tbody>
			</table>
			</br></br>
		`;

		tablePercent += `
				</tbody>
			</table>
			</br></br>
		`;

		var elemTablePerc = self.renderCalculatePercent(tablePercent,totalUsers);

		$('#previewTable #datadetailtables .card-body').find('#' + question.qid).append(table);
		$('#previewTable #datadetailtables .card-body').find('#perc' + question.qid).append(elemTablePerc);
		if(qType == 'L') {
			let TTBLTB = self.renderTTBLTB(tablePercentTTBLTB);
			tablePercentTTBLTB += TTBLTB.TTB;
			tablePercentTTBLTB += TTBLTB.LTB;
			tablePercentTTBLTB += `
					</tbody>
				</table>
				</br></br>
			`;
			var elemTablePercTTBLTB = self.renderCalculatePercent(tablePercentTTBLTB,totalUsers);
			$('#previewTable #datadetailtables .card-body').find('#perc' + question.qid).append(elemTablePercTTBLTB);
		}
		$('#previewTable #datadetailindex .card-body #tablePreviewIndex tbody').find('#' + question.qid).append(tableindex);
		$('#previewTable #datadetailindex .card-body #tablePreviewIndexHidden tbody').find('#' + question.qid).append(tableindexHidden);
		$('.dataTables_filter').hide();
	},

	renderPreviewTableSQ(question, arrayTotales, arrayFactoresPonderacion) {
		let self = this;

		$('#previewTable').show();
		let qType = question.type;

		let totalUsers = question.sq[0].answers[0].numUsers;
		let totalGeneroPorc = question.sq[0].answers[0].totalGeneroPorc;

		let headersGenero = question.sq[0].answers[0].genero || [];
		let headersEdad = question.sq[0].answers[0].edad || [];
		let headersSec = question.sq[0].answers[0].sec || [];
		let headersRegion = question.sq[0].answers[0].region || [];
		let headersConsumo = question.sq[0].answers[0].consumo || [];

		let total = headersGenero.length+headersEdad.length+headersSec.length+headersRegion.length + 2;
		if(self.consumer == '1') {
			total += headersConsumo.length;
		}
		let headersRes = self.renderTableHeaders(question, total, headersGenero, headersEdad, headersSec, headersRegion, headersConsumo);

		let table = '';
		let tablePercent = '';

		let j = 0;
		Object.keys(question.sq).forEach(function(keysq) {
			table += headersRes.table;
			tablePercent += headersRes.table;

			let answer = question.sq[keysq];
			table += `<tr><th class="text-left" colspan="${total}" title="${answer.question}">${answer.question}</th></tr>`;
			tablePercent += `<tr><th class="text-left" colspan="${total}" title="${answer.question}">${answer.question}</th></tr>`;

			let tableindex = `<tr><th class="text-left w-100" title="${question.question + ' ' + answer.question}">${question.question + ' ' + answer.question}</th></tr>`;
			$(tableindex).insertBefore($('#previewTable #datadetailindex .card-body #tablePreviewIndex tbody').find('#' + question.qid));
			$(tableindex).insertBefore($('#previewTable #datadetailindex .card-body #tablePreviewIndexHidden tbody').find('#' + question.qid));

			let totalArrayRes = headersRes.totalArrayRes;
			let totalPonderated = 0;
			if($('#ponderacion').is(':checked') && qType == 'T') {
				Object.keys(answer.answers).forEach(function(key) {
					let genero = answer.answers[key].genero || [];
					totalPonderated += self.getCalculateDataPonderated(genero, totalArrayRes, arrayFactoresPonderacion);
				});
			}
			Object.keys(answer.answers).forEach(function(key) {
				let answerStr = answer.answers[key].answer;
				if(typeof(answer.answers[key].answer) === 'undefined') {
					answerStr = answer.answers[key].question;
				}

				if(answerStr != '') {
					table += `<tr id="sid${j}">`;
					table += `<td class="text-truncate" strtype="text" title="${answerStr}" style='mso-number-format: "\@";'>${answerStr}</td>`;

					tablePercent += `<tr id="sidpercent${j}">`;
					tablePercent += `<td class="text-truncate" strtype="text" title="${answerStr}" style='mso-number-format: "\@";'>${answerStr}</td>`;

					let genero = answer.answers[key].genero || [];
					let edad = answer.answers[key].edad || [];
					let sec = answer.answers[key].sec || [];
					let region = answer.answers[key].region || [];
					let consumo = answer.answers[key].consumo || [];
					let numUsers = answer.answers[key].numUsers || 0;

					var calculateRes = self.renderCalculateData(genero, edad, sec, region, consumo, totalArrayRes, totalUsers, qType, arrayTotales, numUsers, arrayFactoresPonderacion, totalPonderated);
					table += calculateRes.table + `</tr>`;
					tablePercent += calculateRes.tablePercent + `</tr>`;
					totalArrayRes = calculateRes.totalArrayRes;
					j++;
				}
			});

			let result = self.renderTotalData(totalArrayRes, headersGenero, headersEdad, headersSec, headersRegion, headersConsumo, arrayFactoresPonderacion);
			table += result.table;
			tablePercent += result.table;
			totalArrayRes = result.totalArrayRes;

			if(question.type == ':') {
				table += '</tbody></table></br></br>';
				tablePercent += '</tbody></table></br></br>';
			}
		});

		$('#previewTable #datadetailindex .card-body #tablePreviewIndexHidden tbody').find('#' + question.qid).remove();

		if(question.type != ':') {
			table += `
					</tbody>
				</table>
				</br></br>
			`;

			tablePercent += `
					</tbody>
				</table>
				</br></br>
			`;
		}

		var elemTablePerc = self.renderCalculatePercent(tablePercent,totalUsers);
		$('#previewTable #datadetailtables .card-body').find('#' + question.qid).append(table);
		$('#previewTable #datadetailtables .card-body').find('#perc' + question.qid).append(elemTablePerc);

		$('.dataTables_filter').hide();
	},

	renderTableHeaders(question, total, headersGenero, headersEdad, headersSec, headersRegion, headersConsumo) {
		let self = this;

		let totalArrayRes = [];

		let table = `
			<table id="tablePreview${question.row}" class="table table-hover">
				<thead>
					<tr><th class="text-left" colspan="${total}" title="${question.question}">${question.question}</th></tr>
					<tr>`;
						table += `<th></th>`;
						table += `<th></th>`;

						let length = headersGenero.length;
						table += `<th class="text-center" colspan="${length}" title="${pf.const.language.RSC151}">${pf.const.language.RSC151}</th>`;

						length = headersEdad.length;
						table += `<th class="text-center" colspan="${length}" title="${pf.const.language.RSC565}">${pf.const.language.RSC565}</th>`;

						length = headersSec.length;
						table += `<th class="text-center" colspan="${length}" title="${pf.const.language.RSC598}">${pf.const.language.RSC598}</th>`;

						length = headersRegion.length;
						table += `<th class="text-center" colspan="${length}" title="${pf.const.language.RSC1741}">${pf.const.language.RSC1741}</th>`;

						if(self.consumer == '1') {
							length = headersConsumo.length;
							table += `<th class="text-center" colspan="${length}" title="${pf.const.language.RSC618}">${pf.const.language.RSC618}</th>`;
						}
					table +=
					`</tr>
					<tr>`;
						table += `<th></th>`;
						table += `<th title="${pf.const.language.RSC345}">${pf.const.language.RSC345}</th>`;

						length = headersGenero.length;
						for(let i = 0; i < length; ++i) {
							table += `<th title="${headersGenero[i].genero}">${headersGenero[i].genero}</th>`;
							totalArrayRes[headersGenero[i].genero] = 0;
						}

						length = headersEdad.length;
						for(let i = 0; i < length; ++i) {
							table += `<th title="${headersEdad[i].edad}">${headersEdad[i].edad}</th>`;
							totalArrayRes[headersEdad[i].edad] = 0;
						}

						length = headersSec.length;
						for(let i = 0; i < length; ++i) {
							table += `<th title="${headersSec[i].sec}">${headersSec[i].sec}</th>`;
							totalArrayRes[headersSec[i].sec] = 0;
						}

						length = headersRegion.length;
						for(let i = 0; i < length; ++i) {
							table += `<th title="${headersRegion[i].regionABI}">${headersRegion[i].descripcion}</th>`;
							totalArrayRes[headersRegion[i].regionABI] = 0;
						}

						if(self.consumer == '1') {
							length = headersConsumo.length;
							for(let i = 0; i < length; ++i) {
								if(headersConsumo[i].questionConsumo == '1') {
									table += `<th title="${pf.const.language.RSC1899}">${pf.const.language.RSC1899}</th>`;
								} else if(headersConsumo[i].questionConsumo == '0') {
									table += `<th title="${pf.const.language.RSC1900}">${pf.const.language.RSC1900}</th>`;
								}
								totalArrayRes[headersConsumo[i].questionConsumo] = 0;
							}
						}
					table +=
					`</tr>
				</thead>` +
				// TODO: FIltros
				//	<thead class="filtersPoll">
				//		<tr>
				//			<td>remuneracion</td>
				//		</tr>
				// </thead>
				`<tbody>
		`;

		return {'table': table, 'totalArrayRes': totalArrayRes};
	},

	formatPonderacionesIfChecked(arrayFactoresPonderacion, key, key2, value) {
		//mirar si se ha marcado el check de ponderación
		if($('#ponderacion').is(':checked')) {
			var factorponderacion = arrayFactoresPonderacion[key][key2];
			value = value * factorponderacion;
			value = parseFloat(value.toFixed(2));
		}
		return value;
	},

	formatPonderacionesIfCheckedTotales(value) {
		//mirar si se ha marcado el check de ponderación
		if($('#ponderacion').is(':checked')) {
			value = value.toFixed(2);
		}
		return value;
	},

	formatPonderacionesIfCheckedTotalesPercent(qType, total, numUsers, numAnswersTotal) {
		let totalPorc = 0;
		//mirar si se ha marcado el check de ponderación
		if($('#ponderacion').is(':checked')) {
			totalPorc = (parseFloat(total) * 100) / parseFloat(numAnswersTotal);
			if(qType == 'M' || qType == 'S') {
				totalPorc = (parseFloat(total) * 100) / parseFloat(numUsers);
			}
		} else {
			totalPorc = (parseInt(total) * 100) / parseInt(numAnswersTotal);
			if(qType == 'M' || qType == 'S') {
				totalPorc = (parseInt(total) * 100) / parseInt(numUsers);
			}
		}
		return totalPorc;
	},

	formatPonderacionesIfCheckedPercent(qType, porcentaje, value, total, arrayFactoresPonderacion, key, key2) {
		let self = this;

		let result = 0;

		//mirar si se ha marcado el check de ponderación
		if($('#ponderacion').is(':checked')) {
			let valuePond = self.formatPonderacionesIfChecked(arrayFactoresPonderacion, key, key2, value);
			result = ((valuePond*100)/total).toFixed(2);
		} else {
			result = porcentaje.toFixed(2);
		}
		return result;
	},

	singlePercentTTBLTB(a, b) {
		if(b == 0) {
			return 0;
		}

		return ((a/b) * 100).toFixed(2);
	},

	renderCalculateData(genero, edad, sec, region, consumo, totalArrayRes, numAnswersTotal, qType, arrayTotales, numUsers, arrayFactoresPonderacion, totalPonderated) {
		let self = this;

		let table = '';
		let total = 0;
		let totalPorc = 0;
		let tablePercent = '';
		let tablePercentTTBLTB = '';
		let partialPercent = 0;
		let partialPercentTTBLTB = 0;
		let totalGrouped = 0;

		let length = genero.length;
		for(let i = 0; i < length; ++i) {
			let value = self.formatPonderacionesIfChecked(arrayFactoresPonderacion, 'genero', genero[i].genero, genero[i].value);
			table += `<td class="text-truncate" title="${value}">${value}</td>`;

			if(!$('#ponderacion').is(':checked')) {
				partialPercent = self.formatPonderacionesIfCheckedPercent(qType, genero[i].porc, genero[i].value, arrayTotales.genero[i].value, arrayFactoresPonderacion, 'genero', genero[i].genero);
				partialPercentTTBLTB = self.singlePercentTTBLTB(genero[i].value, arrayTotales.genero[i].value);
				tablePercent += `<td class="text-truncate" strtype="text" data-val="${partialPercent}" title="${partialPercent}%"></td>`;
				tablePercentTTBLTB += `<td class="text-truncate" strtype="text" data-val="${partialPercentTTBLTB}" title="${partialPercentTTBLTB}%"></td>`;
			}

			totalArrayRes[genero[i].genero] = parseInt(totalArrayRes[genero[i].genero]) + parseInt(genero[i].value);
			total += value;
			totalGrouped += value;
		}

		if($('#ponderacion').is(':checked')) {
			for(let i = 0; i < length; ++i) {
				partialPercent = self.formatPonderacionesIfCheckedPercent(qType, genero[i].porc, genero[i].value, totalGrouped, arrayFactoresPonderacion, 'genero', genero[i].genero);
				partialPercentTTBLTB = self.singlePercentTTBLTB(genero[i].value, arrayTotales.genero[i].value);
				tablePercent += `<td class="text-truncate" strtype="text" data-val="${partialPercent}" title="${partialPercent}%"></td>`;
				tablePercentTTBLTB += `<td class="text-truncate" strtype="text" data-val="${partialPercentTTBLTB}" title="${partialPercentTTBLTB}%"></td>`;
			}
		}

		length = edad.length;
		totalGrouped = 0;
		for(let i = 0; i < length; ++i) {
			let value = self.formatPonderacionesIfChecked(arrayFactoresPonderacion, 'edad', edad[i].edad, edad[i].value);
			table += `<td class="text-truncate" title="${value}">${value}</td>`;

			if(!$('#ponderacion').is(':checked')) {
				partialPercent = self.formatPonderacionesIfCheckedPercent(qType, edad[i].porc, edad[i].value, arrayTotales.edad[i].value, arrayFactoresPonderacion, 'edad', edad[i].edad);
				partialPercentTTBLTB = self.singlePercentTTBLTB(edad[i].value, arrayTotales.edad[i].value);
				tablePercent += `<td class="text-truncate" strtype="text" data-val="${partialPercent}" title="${partialPercent}%"></td>`;
				tablePercentTTBLTB += `<td class="text-truncate" strtype="text" data-val="${partialPercentTTBLTB}" title="${partialPercentTTBLTB}%"></td>`;
			}

			totalArrayRes[edad[i].edad] = parseInt(totalArrayRes[edad[i].edad]) + parseInt(edad[i].value);
			totalGrouped += value;
		}

		if($('#ponderacion').is(':checked')) {
			for(let i = 0; i < length; ++i) {
				partialPercent = self.formatPonderacionesIfCheckedPercent(qType, edad[i].porc, edad[i].value, totalGrouped, arrayFactoresPonderacion, 'edad', edad[i].edad);
				partialPercentTTBLTB = self.singlePercentTTBLTB(edad[i].value, arrayTotales.edad[i].value);
				tablePercent += `<td class="text-truncate" strtype="text" data-val="${partialPercent}" title="${partialPercent}%"></td>`;
				tablePercentTTBLTB += `<td class="text-truncate" strtype="text" data-val="${partialPercentTTBLTB}" title="${partialPercentTTBLTB}%"></td>`;
			}
		}

		length = sec.length;
		totalGrouped = 0;
		for(let i = 0; i < length; ++i) {
			let value = self.formatPonderacionesIfChecked(arrayFactoresPonderacion, 'sec', sec[i].sec, sec[i].value);
			table += `<td class="text-truncate" title="${value}">${value}</td>`;

			if(!$('#ponderacion').is(':checked')) {
				partialPercent = self.formatPonderacionesIfCheckedPercent(qType, sec[i].porc, sec[i].value, arrayTotales.sec[i].value, arrayFactoresPonderacion, 'sec', sec[i].sec);
				partialPercentTTBLTB = self.singlePercentTTBLTB(sec[i].value, arrayTotales.sec[i].value);
				tablePercent += `<td class="text-truncate" strtype="text" data-val="${partialPercent}" title="${partialPercent}%"></td>`;
				tablePercentTTBLTB += `<td class="text-truncate" strtype="text" data-val="${partialPercentTTBLTB}" title="${partialPercentTTBLTB}%"></td>`;
			}

			totalArrayRes[sec[i].sec] = parseInt(totalArrayRes[sec[i].sec]) + parseInt(sec[i].value);
			totalGrouped += value;
		}

		if($('#ponderacion').is(':checked')) {
			for(let i = 0; i < length; ++i) {
				partialPercent = self.formatPonderacionesIfCheckedPercent(qType, sec[i].porc, sec[i].value, totalGrouped, arrayFactoresPonderacion, 'sec', sec[i].sec);
				partialPercentTTBLTB = self.singlePercentTTBLTB(sec[i].value, arrayTotales.sec[i].value);
				tablePercent += `<td class="text-truncate" strtype="text" data-val="${partialPercent}" title="${partialPercent}%"></td>`;
				tablePercentTTBLTB += `<td class="text-truncate" strtype="text" data-val="${partialPercentTTBLTB}" title="${partialPercentTTBLTB}%"></td>`;
			}
		}

		length = region.length;
		totalGrouped = 0;
		for(let i = 0; i < length; ++i) {
			let value = self.formatPonderacionesIfChecked(arrayFactoresPonderacion, 'region', region[i].regionABI, region[i].value);
			table += `<td class="text-truncate" title="${value}">${value}</td>`;

			if(!$('#ponderacion').is(':checked')) {
				partialPercent = self.formatPonderacionesIfCheckedPercent(qType, region[i].porc, region[i].value, arrayTotales.region[i].value, arrayFactoresPonderacion, 'region', region[i].regionABI);
				partialPercentTTBLTB = self.singlePercentTTBLTB(region[i].value, arrayTotales.region[i].value);
				tablePercent += `<td class="text-truncate" strtype="text" data-val="${partialPercent}" title="${partialPercent}%"></td>`;
				tablePercentTTBLTB += `<td class="text-truncate" strtype="text" data-val="${partialPercentTTBLTB}" title="${partialPercentTTBLTB}%"></td>`;
			}

			totalArrayRes[region[i].regionABI] = parseInt(totalArrayRes[region[i].regionABI]) + parseInt(region[i].value);
			totalGrouped += value;
		}

		if($('#ponderacion').is(':checked')) {
			for(let i = 0; i < length; ++i) {
				partialPercent = self.formatPonderacionesIfCheckedPercent(qType, region[i].porc, region[i].value, totalGrouped, arrayFactoresPonderacion, 'region', region[i].regionABI);
				partialPercentTTBLTB = self.singlePercentTTBLTB(region[i].value, arrayTotales.region[i].value);
				tablePercent += `<td class="text-truncate" strtype="text" data-val="${partialPercent}" title="${partialPercent}%"></td>`;
				tablePercentTTBLTB += `<td class="text-truncate" strtype="text" data-val="${partialPercentTTBLTB}" title="${partialPercentTTBLTB}%"></td>`;
			}
		}

		if(self.consumer == '1') {
			length = consumo.length;
			totalGrouped = 0;
			for(let i = 0; i < length; ++i) {
				let value = self.formatPonderacionesIfChecked(arrayFactoresPonderacion, 'consumo', consumo[i].questionConsumo, consumo[i].value);
				table += `<td class="text-truncate" title="${value}">${value}</td>`;

				if(!$('#ponderacion').is(':checked')) {
					partialPercent = self.formatPonderacionesIfCheckedPercent(qType, consumo[i].porc, consumo[i].value, arrayTotales.consumo[i].value, arrayFactoresPonderacion, 'consumo', consumo[i].questionConsumo);
					partialPercentTTBLTB = self.singlePercentTTBLTB(consumo[i].value, arrayTotales.consumo[i].value);
					tablePercent += `<td class="text-truncate" strtype="text" data-val="${partialPercent}" title="${partialPercent}%"></td>`;
					tablePercentTTBLTB += `<td class="text-truncate" strtype="text" data-val="${partialPercentTTBLTB}" title="${partialPercentTTBLTB}%"></td>`;
				}

				totalArrayRes[consumo[i].questionConsumo] = parseInt(totalArrayRes[consumo[i].questionConsumo]) + parseInt(consumo[i].value);
				totalGrouped += value;
			}

			if($('#ponderacion').is(':checked')) {
				for(let i = 0; i < length; ++i) {
					partialPercent = self.formatPonderacionesIfCheckedPercent(qType, consumo[i].porc, consumo[i].value, totalGrouped, arrayFactoresPonderacion, 'consumo', consumo[i].questionConsumo);
					partialPercentTTBLTB = self.singlePercentTTBLTB(consumo[i].value, arrayTotales.consumo[i].value);
					tablePercent += `<td class="text-truncate" strtype="text" data-val="${partialPercent}" title="${partialPercent}%"></td>`;
					tablePercentTTBLTB += `<td class="text-truncate" strtype="text" data-val="${partialPercent}" title="${partialPercent}%"></td>`;
				}
			}
		}

		total = self.formatPonderacionesIfCheckedTotales(total);
		//cambio requerido por Alex a fecha 24/08/2021 para calcular los porcentajes por columnas
		if($('#ponderacion').is(':checked') && qType == 'T') {
			totalPorc = self.formatPonderacionesIfCheckedTotalesPercent(qType, total, numUsers, totalPonderated);
		} else {
			totalPorc = self.formatPonderacionesIfCheckedTotalesPercent(qType, total, numUsers, numAnswersTotal);
		}

		if(totalPorc == undefined) {
			totalPorc = 0;
		}

		table = `<td class="text-truncate" title="${total}"><strong>${total}</strong></td>` + table;
		tablePercent = `<td class="text-truncate" strtype="text" title="${totalPorc.toFixed(2)}%"><strong>${totalPorc.toFixed(2)}%</strong></td>` + tablePercent;
		tablePercentTTBLTB = `<td class="text-truncate" strtype="text" title="${totalPorc.toFixed(2)}%"><strong>${totalPorc.toFixed(2)}%</strong></td>` + tablePercentTTBLTB;

		return {'table': table, 'totalArrayRes': totalArrayRes, 'tablePercent': tablePercent, 'tablePercentTTBLTB': tablePercentTTBLTB};
	},

	getCalculateDataPonderated(genero, totalArrayRes, arrayFactoresPonderacion) {
		let self = this;

		let length = genero.length;
		for(let i = 0; i < length; ++i) {
			totalArrayRes[genero[i].genero] = parseInt(totalArrayRes[genero[i].genero]) + parseInt(genero[i].value);
		}

		let result = self.calculateTotalDataPonderated(totalArrayRes, genero, arrayFactoresPonderacion);

		for(let i = 0; i < length; ++i) {
			totalArrayRes[genero[i].genero] = 0;
		}

		return result;
	},

	renderCalculatePercent(tablePercent,totalUsers) {
		var elemTablePerc = $(tablePercent);
		var totalRow = elemTablePerc.find('tr[id^="totalRow"] td');
		elemTablePerc.find('tr[id^="sidpercent"]').each(function() {
			var index = 0;
			$(this).find('td').each(function() {
				if(typeof($(this).attr('data-val')) !== 'undefined') {
					var calcPerc = $(this).attr('data-val');
					if($(this).attr('data-val') == 0) {
						calcPerc = 0;
					}
					$(this).text(calcPerc + '%');
				}
				++index;
			});
		});

		return elemTablePerc;
	},

	renderTotalData(totalArrayRes, headersGenero, headersEdad, headersSec, headersRegion, headersConsumo, arrayFactoresPonderacion) {
		let self = this;

		let tableTotal = `<tr id="totalRow"><td class="text-truncate" title="${pf.const.language.RSC345}"><strong>${pf.const.language.RSC345}</strong></td>`;
		let table = '';
		let total = 0;

		length = headersGenero.length;
		for(let i = 0; i < length; ++i) {
			let value = self.formatPonderacionesIfChecked(arrayFactoresPonderacion, 'genero', headersGenero[i].genero, totalArrayRes[headersGenero[i].genero]);
			table += `<td class="text-truncate" title="${value}"><strong>${value}</strong></td>`;
			total += value;
			totalArrayRes[headersGenero[i].genero] = 0;
		}

		length = headersEdad.length;
		for(let i = 0; i < length; ++i) {
			let value = self.formatPonderacionesIfChecked(arrayFactoresPonderacion, 'edad', headersEdad[i].edad, totalArrayRes[headersEdad[i].edad]);
			table += `<td class="text-truncate" title="${value}"><strong>${value}</strong></td>`;
			totalArrayRes[headersEdad[i].genero] = 0;
		}
		for(let i = 0; i < length; ++i) {
			totalArrayRes[headersEdad[i].edad] = 0;
		}

		length = headersSec.length;
		for(let i = 0; i < length; ++i) {
			let value = self.formatPonderacionesIfChecked(arrayFactoresPonderacion, 'sec', headersSec[i].sec, totalArrayRes[headersSec[i].sec]);
			table += `<td class="text-truncate" title="${value}"><strong>${value}</strong></td>`;
			totalArrayRes[headersSec[i].genero] = 0;
		}
		for(let i = 0; i < length; ++i) {
			totalArrayRes[headersSec[i].sec] = 0;
		}

		length = headersRegion.length;
		for(let i = 0; i < length; ++i) {
			let value = self.formatPonderacionesIfChecked(arrayFactoresPonderacion, 'region', headersRegion[i].regionABI, totalArrayRes[headersRegion[i].regionABI]);
			table += `<td class="text-truncate" title="${value}"><strong>${value}</strong></td>`;
			totalArrayRes[headersRegion[i].genero] = 0;
		}
		for(let i = 0; i < length; ++i) {
			totalArrayRes[headersRegion[i].regionABI] = 0;
		}

		if(self.consumer == '1') {
			length = headersConsumo.length;
			for(let i = 0; i < length; ++i) {
				let value = self.formatPonderacionesIfChecked(arrayFactoresPonderacion, 'consumo', headersConsumo[i].questionConsumo, totalArrayRes[headersConsumo[i].questionConsumo]);
				table += `<td class="text-truncate" title="${value}"><strong>${value}</strong></td>`;
				totalArrayRes[headersConsumo[i].genero] = 0;
			}
			for(let i = 0; i < length; ++i) {
				totalArrayRes[headersConsumo[i].questionConsumo] = 0;
			}
		}

		table = tableTotal + `<td class="text-truncate" title="${total}"><strong>${total}</strong></td>${table}</tr>`;

		return {'table': table, 'totalArrayRes': totalArrayRes};
	},

	calculateTotalDataPonderated(totalArrayRes, headersGenero, arrayFactoresPonderacion) {
		let self = this;

		let total = 0;

		length = headersGenero.length;
		for(let i = 0; i < length; ++i) {
			let value = self.formatPonderacionesIfChecked(arrayFactoresPonderacion, 'genero', headersGenero[i].genero, totalArrayRes[headersGenero[i].genero]);
			total += value;
		}

		return total;
	},

	setTabEvents() {
		$('#datadetailtablestab').click(function() {
			$('#datadetailindextab, #datadetailresulttab').removeClass('activeTB');
			$(this).addClass('activeTB');
			$('#datadetailtables').show();
			$('#datadetailindex').hide();
			$('#datadetailresult').hide();
		});

		$('#datadetailindextab').click(function() {
			$('#datadetailtablestab, #datadetailresulttab').removeClass('activeTB');
			$(this).addClass('activeTB');
			$('#datadetailtables').hide();
			$('#datadetailindex').show();
			$('#datadetailresult').hide();
		});

		$('#datadetailresulttab').click(function() {
			$('#datadetailindextab, #datadetailtablestab').removeClass('activeTB');
			$(this).addClass('activeTB');
			$('#datadetailtables').hide();
			$('#datadetailindex').hide();
			$('#datadetailresult').show();
		});
	},

	generateExcelTables() {
		if('ActiveXObject' in window) {
			alert('This is Internet Explorer!');
		} else {
			var cache = {};
			var tmpl = function tmpl(str, data) {
				var fn = !/\W/.test(str) ? cache[str] = cache[str] || tmpl(document.getElementById(str).innerHTML) :
				new Function("obj",
								"var p=[],print=function(){p.push.apply(p,arguments);};" +
								"with(obj){p.push('" +
								str.replace(/[\r\t\n]/g, " ")
								.split("{{").join("\t")
								.replace(/((^|}})[^\t]*)'/g, "$1\r")
								.replace(/\t=(.*?)}}/g, "',$1,'")
								.split("\t").join("');")
								.split("}}").join("p.push('")
								.split("\r").join("\\'") + "');}return p.join('');");
				return data ? fn(data) : fn;
			};
			var tableToExcel = (function() {
				var uri = 'data:application/vnd.ms-excel;base64,',
					template = '<html xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:x="urn:schemas-microsoft-com:office:excel" xmlns="http://www.w3.org/TR/REC-html40"><head><!--[if gte mso 9]><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet><x:Name>{{=worksheet}}</x:Name><x:WorksheetOptions><x:DisplayGridlines/></x:WorksheetOptions></x:ExcelWorksheet></x:ExcelWorksheets></x:ExcelWorkbook></xml><![endif]--></head><body>{{for(var i=0; i<tables.length; i++){ }}<table>{{=tables[i]}}</table><table></table><table></table><table></table><table></table>{{ } }}</body></html>',
					base64 = function(s) {
						return window.btoa(unescape(encodeURIComponent(s)));
					},
					format = function(s, c) {
						return s.replace(/{(\w+)}/g, function(m, p) {
							return c[p];
						});
					};
				return function(tableList, name) {
					if(!tableList.length > 0 && !tableList[0].nodeType) table = document.getElementById(table);
					var tables = [];
					for(var i = 0; i < tableList.length; i++) {
						tables.push(tableList[i].innerHTML);
					}
					var ctx = {
						worksheet: name || 'Worksheet',
						tables: tables
					};

					var link = document.createElement('a');
					link.download = $('#poll').val() + '.xls';
					link.href = uri + base64(tmpl(template, ctx));
					link.click();
				};
			})();
			tableToExcel($('table[id^="tablePreview"]'), 'one');
		}
	},

	s2ab(s) {
		var buf = new ArrayBuffer(s.length);
		var view = new Uint8Array(buf);
		for(var i=0; i!=s.length; ++i) view[i] = s.charCodeAt(i) & 0xFF;
		return buf;
	},

	create_gap_rows(ws, nrows) {
		var ref = XLSX.utils.decode_range(ws['!ref']);	// get original range
		ref.e.r += nrows;								// add to ending row
		ws['!ref'] = XLSX.utils.encode_range(ref);		// reassign row
		removeLoader();
	},

	exportAsExcel() {
		let self = this;

		var tables = $('#datadetailtables table[id^="tablePreview"]');
		var wb = XLSX.utils.book_new();

		//Hoja preguntas
		var tableindex = $('#tablePreviewIndexHidden');
		if(tableindex.length > 0) {
			var wsindex = XLSX.utils.table_to_sheet(tableindex[0]);
			XLSX.utils.book_append_sheet(wb, wsindex, pf.const.language.RSC964);
		}

		var ws = XLSX.utils.table_to_sheet(tables[0]);
		for(var i = 1; i < tables.length; ++i) {
			self.create_gap_rows(ws, 4);
			XLSX.utils.sheet_add_dom(ws, tables[i], {origin: -1});
		}

		//change cell format to %
		Object.entries(ws).forEach(function(obj) {
			// Valor
			value = obj[1].v;
			if(typeof(value) !== 'undefined' && value != '') {
				valuestr = value.toString();
				if(valuestr.indexOf('%') !== -1) {
					// Fórmula
					obj[1].z = '#,##0.00"%"';
					// Tipo
					obj[1].t = 'n';
					if(valuestr != 'NaN%') {
						obj[1].v = parseFloat(valuestr.replace('%', ''));
					} else {
						obj[1].v = 0;
					}
				}
			}
		});

		XLSX.utils.book_append_sheet(wb, ws, pf.const.language.RSC965);

		//Hoja totales
		var tabletotal = $('#tableTotalResult');
		if(tabletotal.length > 0) {
			var wstotal = XLSX.utils.table_to_sheet(tabletotal[0]);
			XLSX.utils.book_append_sheet(wb, wstotal, pf.const.language.RSC345);
		}

		var wbout = XLSX.write(wb, {bookType:'xlsx', bookSST:true, type: 'binary'});

		module$FileSaver.saveAs(new Blob([self.s2ab(wbout)],{type:'application/octet-stream'}), self.idPoll + '-TOTALMAZ' + '.xlsx');
	}
};