class NotificationGeneratorController {
	constructor(values) {
		this.ajax = values.ajax;
		this.abort = false;
		this.reqLabel = values.reqLabel;
		this.sendMail = values.sendMail;
	}

	start () {
		let self = this;

		self.executeNotification();
	}

	executeNotification () {
		let self = this;

		self.ajax = false;
		//$('#show-generating-reports').show();
		$('#show-generating-reports').css('visibility', 'visible');
		let idReport = Math.floor(Date.now() / 1000);
		self.idReport = idReport;
		let text = pf.const.language.RSC1881;
		let report = {
			name: pf.const.language.RSC1877,
			id: idReport,
			title: pf.const.language.RSC1876,
			subtitle: pf.const.language.RSC1881,
			cancelButton: true
		}
		if(self.sendMail == 0) {
			report = {
				name: pf.const.language.RSC2020,
				id: idReport,
				title: pf.const.language.RSC2020,
				subtitle: pf.const.language.RSC2021,
				cancelButton: true
			}
			text = pf.const.language.RSC2021;
		}
		CardGeneratorController.addNotificationWithText(report, text);

		$(`#cancelDowload${self.idReport}`).off().on('click', (e)=>{
			e.preventDefault();
			self.cancelAjax();
		});

		setTimeout(function() {
			NotificacionesPreConsejerosController.sendReActivationEmail(self.idReport, self.sendMail);
		}, 500);
	}

	cancelAjax (deleteNotification = true) {
		let self = this;

		self.ajax = true;
		self.abort = true;
		pf.ajax.abortRequest(this.reqLabel);
		if(deleteNotification) {
			CardGeneratorController.deleteNotification(this.idReport);
		}
	}
}