let PlantillasReportesNewController = {
	user: null,
	language: '',
	fontAnalytics: '',
	sizeFontAnalytics: '',
	plantillaURL: '',
	plantilla: null,
	plantilla_portadaURL: '',
	plantilla_portada: null,
	logoURL: '',
	logo: null,
	colorsFixed: [],
	setReportTemplatesObj: {},
	raizGraphs: '',
	questionSelected: '',
	typesGraphs: {},
	localFonts: [],
	localFontsUrl: stcm.const.downloads + 'customfonts/',

	reset() {
		let self = this;

		self.user = null;
		self.language = pf.const.language_table;
		self.fontAnalytics = '';
		self.sizeFontAnalytics = '';
		self.plantillaURL = '';
		self.plantilla = null;
		self.plantilla_portadaURL = '';
		self.plantilla_portada = null;
		self.logoURL = '';
		self.logo = null;
		self.colorsFixed = [];
		self.setReportTemplatesObj = {};
		self.raizGraphs = stcm.const.downloads + 'types_graphs/';
		self.questionSelected = '';
		self.localFonts = [];
		self.typesGraphs = {
			tenPoints: {
				nameRSC: pf.const.language.RSC2452,
				nameGraph: 'stacked_bar',
				nameGraphRSC: pf.const.language.RSC2460,
				img: 'bar_apilada.png'
			},
			fivePoints: {
				nameRSC: pf.const.language.RSC2453,
				nameGraph: 'stacked_bar',
				nameGraphRSC: pf.const.language.RSC2460,
				img: 'bar_apilada.png'
			},
			listDropdownFilter: {
				nameRSC: pf.const.language.RSC2454,
				nameGraph: 'columns',
				nameGraphRSC: pf.const.language.RSC2465,
				img: 'column.png'
			},
			listDropdown: {
				nameRSC: pf.const.language.RSC2455,
				nameGraph: 'columns',
				nameGraphRSC: pf.const.language.RSC2465,
				img: 'column.png'
			},
			list: {
				nameRSC: pf.const.language.RSC2456,
				nameGraph: 'columns',
				nameGraphRSC: pf.const.language.RSC2465,
				img: 'column.png'
			},
			listWithComment: {
				nameRSC: pf.const.language.RSC2457,
				nameGraph: 'columns',
				nameGraphRSC: pf.const.language.RSC2465,
				img: 'column.png'
			},
			yesNo: {
				nameRSC: pf.const.language.RSC2458,
				nameGraph: 'pie',
				nameGraphRSC: pf.const.language.RSC2461,
				img: 'pie.png'
			},
			multipleChoice: {
				nameRSC: pf.const.language.RSC2459,
				nameGraph: 'columns',
				nameGraphRSC: pf.const.language.RSC2465,
				img: 'column.png'
			}
		};
	},

	setEvents() {
		let self = this;
		self.reset();

		let JSONuser = sessionStorage['STCMBackEnd:user'];
		let user = JSON.parse(JSONuser);
		let userMail = user.email;
		let user_split = userMail.split('@');
		self.user = user_split[0].replace('.', '_');

		// Reducción de Header
		headerSectionHeight(0);

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC2347 + ' - ' + pf.const.language.RSC7);

		// Opciones de header
		let jsonsubopt = {
			back: 'back',
			save: 'save'
		};

		let nav = `
			${createSubOptionSave(jsonsubopt.save)}
			${createSubOptionBack(jsonsubopt.back)}
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		// Botón principal
		$('#save').addClass('main-button');

		// Botones secundarios
		$('#back').addClass('secondary-button');

		// Valores de configuración
		let config = JSON.parse(atob(sessionStorage.getItem('STCMBackEnd:config')));
		self.fontAnalytics = config.FontAnalytics;
		self.sizeFontAnalytics = config.SizeFontAnalytics;

		// Imagenes por defecto
		let raiz = stcm.const.downloads + 'report_templates/';
		$('#plantillaIMG').attr('src', raiz + 'plantilla.PNG?stamp=' + new Date().getTime());
		self.plantillaURL = raiz + 'plantilla.PNG';
		$('#plantillaPortadaIMG').attr('src', raiz + 'plantilla_portada.PNG?stamp=' + new Date().getTime());
		self.plantilla_portadaURL = raiz + 'plantilla_portada.PNG';
		$('#logoIMG').attr('src', raiz + 'logo_rep.PNG?stamp=' + new Date().getTime());
		self.logoURL = raiz + 'logo_rep.PNG';

		// Imágenes de gráficas
		$('#gColumns').attr('src', self.raizGraphs + 'column.png?stamp=' + new Date().getTime());
		$('#gPie').attr('src', self.raizGraphs + 'pie.png?stamp=' + new Date().getTime());
		$('#gBars').attr('src', self.raizGraphs + 'bar.png?stamp=' + new Date().getTime());
		$('#gStackedBar').attr('src', self.raizGraphs + 'bar_apilada.png?stamp=' + new Date().getTime());
		$('#gLine').attr('src', self.raizGraphs + 'line.png?stamp=' + new Date().getTime());
		$('#gDoughnut').attr('src', self.raizGraphs + 'donut.png?stamp=' + new Date().getTime());

		self.loadLang();
		self.applyEvents();
		self.renderTypesGraphs();

		// Collapse
		addEventArrowTableHeader();

		// Pintar texto de label
		changeLabelsColor();
	},

	loadLang() {
		pf.rsc.translateByTag('text');

		// TITLES
		$('.exportTitle').attr('title', pf.const.language.RSC47);
	},

	applyEvents() {
		let self = this;

		// Vover
		$('#back').on('click', function() {
			window.location.href = '#!plantillas_reportes';
		});

		ajaxComunCallWithCallback('getTemplateReportCustomFont', {}, function (ajaxReturn) {
			if (ajaxReturn) {
				// Fuentes
				self.localFonts = self.getLocalFontsFromArrayObjects(ajaxReturn.result);

				$(function () {
					$('#font-picker').fontselect({
						localFonts: self.localFonts,
						localFontsUrl: self.localFontsUrl
					});
				});
			}
		});

		$('#font-picker').val(self.fontAnalytics);
		$('#fontSize').val(self.sizeFontAnalytics);

		// Selector opciones colores
		$('input:radio[name=inlineRadioOptions]').click(function() {
			let type = $('input:radio[name=inlineRadioOptions]:checked').val();
			if(type == '1') {
				$('#rango').removeClass('d-none');
				$('#fijos').addClass('d-none');
			} else {
				$('#rango').addClass('d-none');
				$('#fijos').removeClass('d-none');
			}
			self.renderColors();
		});

		//Añadir colores fijos
		$('#add-color').click(function() {
			self.addColor();
		});

		// Apariencia y comportamiento de los inputs tipo 'color'
		inputTypeColorEvents();

		// Plantilla
		$('#plantillaIMGdiv').on('click', function() {
			$('#plantilla').trigger('click');
		});
		$('#plantilla').change(function(evt) {
			let info = pf.utils.getFileSrc(evt);
			self.plantilla = info.file;
			$('#plantillaIMG').attr('src', info.src);
		});

		// Plantilla portada
		$('#plantillaPortadaIMGdiv').on('click', function() {
			$('#plantilla_portada').trigger('click');
		});
		$('#plantilla_portada').change(function(evt) {
			let info = pf.utils.getFileSrc(evt);
			self.plantilla_portada = info.file;
			$('#plantillaPortadaIMG').attr('src', info.src);
		});

		// Logo
		$('#logoIMGdiv').on('click', function() {
			$('#logo').trigger('click');
		});
		$('#logo').change(function(evt) {
			let info = pf.utils.getFileSrc(evt);
			self.logo = info.file;
			$('#logoIMG').attr('src', info.src);
		});

		// Guardar
		$('#save').on('click', function() {
			self.getFormPlantillasReportes();
		});

		$('#addCustomFont').click(function () {
			let objInfo = {
				accept: {
					text: pf.const.language.RSC141
				},
				cancel: {
					text: pf.const.language.RSC57
				}
			};

			let title = pf.const.language.RSC86;
			let contentText = pf.const.language.RSC2757;
			let content = `
				<span>`+ contentText + `</span>
				<input type="file" style="display:none;" id="fontCustomfile" name="filename" accept="application/font-woff">
				<div id="uploadCustomFont" style="cursor: pointer; text-align: center; margin-top: 15px;" onclick="$('#fontCustomfile').click();">
					<i class="fa-solid fa-upload"></i>
					<span>Upload file</span>
				</div>
			`;

			pf.utils.showInfoDialogAcceptCancel(title, content, objInfo, function accept() {
				let file = $('#fontCustomfile').prop('files')[0];

				if (file == undefined) {
					pf.utils.showInfoDialog(pf.const.language.RSC2347, pf.const.language.RSC2759);
				}
				else {
					let customFontName = file.name.split('.')[0];
					self.localFonts.push(customFontName);

					let parameters = {
						file: file
					};
					ajaxComunCallWithCallback('setReportCustomFont', parameters, function (ajaxReturn) {
						if (ajaxReturn) {
							if (ajaxReturn.status == 'OK') {
								$('.font-select').remove();
								$('#font-picker').fontselect({
									localFonts: self.localFonts,
									localFontsUrl: self.localFontsUrl
								});
								$('#font-picker').trigger('setFont', customFontName);
							}
							else {
								pf.utils.showInfoDialog(pf.const.language.RSC2347, pf.const.language.RSC1040);
							}
						}
					});
				}
			},
			function cancel() {
				//
			});

			setTimeout(function () {
				$("input[type=file]").on('change', function () {
					let file = $('#fontCustomfile').prop('files')[0];

					let customFontName = file.name.split('.')[0];
					$('#uploadCustomFont').parent().append(`
						<div id="uploadedFileNameTmp" style="margin-top: 25px; text-align: center;">
							<i class="fa-solid fa-cloud-check"></i>
							<span style="padding: 0 10px;">` + customFontName + `</span>
							<i style="cursor: pointer" class="fa-solid fa-trash"></i>
						</div>
					`);

					$('#uploadedFileNameTmp .fa-trash').click(function () {
						$('#uploadedFileNameTmp').remove();
						$("#fontCustomfile").val(null);
					});
				});
			}, 1000);
		});

		$('#font-picker').on('change', function () {
			// Replace + signs with spaces for css
			var font = this.value.replace(/\+/g, ' ');

			// Split font into family and weight
			font = font.split(':');
			var fontFamily = font[0];

			if (self.localFonts.includes(fontFamily)) {
				$('#customFontWarning').show();
			}
			else {
				$('#customFontWarning').hide();
			}

		});

		$('#preview').click(function() {
			let type = $('input:radio[name=inlineRadioOptions]:checked').val();
			let colors = '';
			let showGraph = true;
			if(type == '1') {
				let i = $('#RGBInicio').val();
				let f = $('#RGBFin').val();
				colors = generateColors(f, i, 10);
			} else {
				let totalColors = self.colorsFixed.length;
				if(totalColors == 0) {
					showGraph = false;
				} else {
					colors = [];
					let arraylColors = colors.length;
					while(arraylColors < 10) {
						for(let i = 0; i < totalColors; i++) {
							colors.push(self.colorsFixed[i])
							arraylColors = colors.length;
							if(arraylColors == 10) {
								break;
							}
						}
					}
				}
			}

			let fontSize = $('#fontSize').val();
			let fontFamily = $('#font-picker').val();
			Chart.defaults.global.defaultFontSize = fontSize;
			Chart.defaults.global.defaultFontFamily = fontFamily;

			if(self.myChart) {
				self.myChart.destroy();
			}

			if(showGraph) {
				let ctx = $('#graph');
				self.myChart = new Chart(ctx, {
					type: 'bar',
					data: {
						labels: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10'],
						datasets: [{
							data: [10, 20, 30, 40, 50, 60, 70, 80, 90, 100],
							backgroundColor: colors
						}]
					},
					options: {
						// Radio de ángulos
						cornerRadius: 6,
						layout: {
							padding: {
								top: 30
							}
						},
						responsive: true,
						maintainAspectRatio: true,
						scales: {
							yAxes: [{
								display: false,
								ticks: {
									beginAtZero: true
								}
							}],
							xAxes: [{
								barPercentage: 0.5,
								ticks: {
									display: true,
									autoSkip: false
								}
							}]
						},
						legend: {
							display: false
						},
						tooltips: {
							enabled: false
						},
						plugins: {
							datalabels: {
								color: 'black',
								font: {
									weight: 'bold'
								},
								anchor: 'end',
								align: 'end',
								formatter(value, context) {
									return value;
								}
							}
						}
					}
				});
			}
		});

		// Modal de tipo de gráficas
		$('.graphImage').on('click', function() {
			let graphSelected = $(this).data('graph');

			switch(graphSelected) {
				case 'columns':
					self.typesGraphs[self.questionSelected].nameGraph = 'columns';
					self.typesGraphs[self.questionSelected].nameGraphRSC = pf.const.language.RSC2465;
					self.typesGraphs[self.questionSelected].img = 'column.png';
				break;
				case 'pie':
					self.typesGraphs[self.questionSelected].nameGraph = 'pie';
					self.typesGraphs[self.questionSelected].nameGraphRSC = pf.const.language.RSC2461;
					self.typesGraphs[self.questionSelected].img = 'pie.png';
				break;
				case 'bars':
					self.typesGraphs[self.questionSelected].nameGraph = 'bars';
					self.typesGraphs[self.questionSelected].nameGraphRSC = pf.const.language.RSC2464;
					self.typesGraphs[self.questionSelected].img = 'bar.png';
				break;
				case 'stacked_bar':
					self.typesGraphs[self.questionSelected].nameGraph = 'stacked_bar';
					self.typesGraphs[self.questionSelected].nameGraphRSC = pf.const.language.RSC2460;
					self.typesGraphs[self.questionSelected].img = 'bar_apilada.png';
				break;
				case 'line':
					self.typesGraphs[self.questionSelected].nameGraph = 'line';
					self.typesGraphs[self.questionSelected].nameGraphRSC = pf.const.language.RSC2463;
					self.typesGraphs[self.questionSelected].img = 'line.png';
				break;
				case 'doughnut':
					self.typesGraphs[self.questionSelected].nameGraph = 'doughnut';
					self.typesGraphs[self.questionSelected].nameGraphRSC = pf.const.language.RSC2462;
					self.typesGraphs[self.questionSelected].img = 'donut.png';
				break;
			}

			$('#modalPictures').modal('hide');

			self.renderTypesGraphs();
		});
	},

	getLocalFontsFromArrayObjects(objCustomFonts) {
		let array = [];
		objCustomFonts.forEach(element => {
			array.push(element.font);
		});

		return array;
	},

	renderTypesGraphs() {
		let self = this;

		let excelTitle = pf.const.language.RSC2447;

		let table = `
			<table id="registers" class="table table-hover">
				<thead>
					<tr>
						<th scope="col" title="${pf.const.language.RSC2448}">${pf.const.language.RSC2448}</th>
						<th scope="col" title="${pf.const.language.RSC2449}">${pf.const.language.RSC2449}</th>
						<th scope="col" title="${pf.const.language.RSC2450}">${pf.const.language.RSC2450}</th>
						<th scope="col" title="${pf.const.language.RSC2451}">${pf.const.language.RSC2451}</th>
					</tr>
				</thead>

				<thead class="filtersResult">
					<tr>
						<td>question</td>
						<td>chartType</td>
						<td>graphicImage</td>
						<td>modify</td>
					</tr>
				</thead>

				<tbody>
		`;

		for(let question in self.typesGraphs) {
			table += `
				<tr>
					<td class="text-truncate" title="${self.typesGraphs[question].nameRSC}">${self.typesGraphs[question].nameRSC}</td>
					<td class="text-truncate" title="${self.typesGraphs[question].nameGraphRSC}">${self.typesGraphs[question].nameGraphRSC}</td>
					<td class="text-center text-truncate">
						<img src="${self.raizGraphs + self.typesGraphs[question].img + '?stamp=' + new Date().getTime()}" class="border ob-fit-cont" height="70" width="100">
					</td>
					<td class="text-truncate text-center" title="${pf.const.language.RSC2451}">
						<button type="button" class="btn table-button main-color-text btn-modify" data-graph="${question}">
							${stcmbackend.svg.bigPencil}
						</button>
					</td>
				</tr>
			`;
		}

		table += `
				</tbody>
			</table>
		`;

		$('#typesGraphsCollapse').html(table);

		// Setup - add a text input to each footer cell
		$('#registers .filtersResult td').each(function() {
			let title = $(this).text();
			let value = `<input type="text" class="form-control form-control-sm">`;

			if(title == 'graphicImage' || title == 'modify') {
				value = `<input type="text" class="form-control form-control-sm" disabled>`;
			}

			$(this).html(value);
		});

		let dataTable = $('#registers').DataTable({
			retrieve: true,
			language: self.language,
			pageLength: 25,
			autoWidth: false,
			columnDefs: [
				{width: '120px', orderable: false, targets: 2},
				{width: '75px', orderable: false, targets: 3}
			],
			dom: 'Bfrtip',
			buttons: [{
				extend: 'excelHtml5',
				text: excelTitle,
				className: 'd-none',
				title: excelTitle,
				exportOptions: {
					columns: [0, 1]
				},
				customize(xlsx) {
					dataTablesExcelCustomize(xlsx);
				}
			}],
			aaSorting: []
		});

		// Ocultar botones de tabla
		hideTableButtons('registers');

		// Apply the search
		applyTheSearch(dataTable, 'filtersResult');

		// Exportar tabla
		$('#export').off().on('click', function() {
			$('#typesGraphsCollapse .buttons-excel').trigger('click');
		});

		self.typesGraphsEvents();

		$('#typesGraphsCollapse').off().on('draw.dt', function() {
			self.typesGraphsEvents();
		});
	},

	typesGraphsEvents() {
		let self = this;

		$('.btn-modify').off().on('click', function() {
			$('#modalPictures').modal('show');
			$('.graphImage').parent().show();
			$('#gStackedBar').parent().parent().hide();

			self.questionSelected = $(this).data('graph');

			if(self.questionSelected === 'tenPoints' || self.questionSelected === 'fivePoints') {
				$('#gStackedBar').parent().parent().show();
			} else if(self.questionSelected === 'multipleChoice') {
				$('#gPie').parent().parent().hide();
				$('#gDoughnut').parent().parent().hide();
			}

			$('.i_charts').prop('checked', false);
			$('#i_' + self.typesGraphs[self.questionSelected].nameGraph).prop('checked', true);
		});
	},

	// Renderizado de colores fijos
	renderColors() {
		let self = this;

		let length = self.colorsFixed.length;
		let content = '';
		for(let i = 0; i < length; i++) {
			content += `
				<div class="form-inline mt-2">
					<input id="color${i}" type="color" class="color-pick colorSelectInput colorSelectInputFixed" data-position="${i}" value="${self.colorsFixed[i]}">
					<div id="color${i}Div" class="wi-cal-100per-n150 colorSelectDiv colorSelectDivFixed" data-id="color${i}" style="background-color: ${self.colorsFixed[i]};" tabindex="0"></div>
					<button id="up-color_${i}" type="button" class="btn btn-nav ml-2 li-he-5" data-action="up" data-position="${i}">
						${stcmbackend.svg.caretUpFillWithoutColor}
					</button>
					<button id="down-color_${i}" type="button" class="btn btn-nav ml-2 li-he-5" data-action="down" data-position="${i}">
						${stcmbackend.svg.caretDownFillWithoutColor}
					</button>
					<button id="remove-color_${i}" type="button" class="btn btn-nav ml-2 li-he-5" data-action="remove" data-position="${i}">
						${stcmbackend.svg.trash}
					</button>
				</div>
			`;
		};
		$('#formColors').html(content);

		// Cambios de color en fijos
		$('.colorSelectDivFixed').off().on('click', function() {
			let id = $(this).data('id');
			$('#' + id).trigger('click');
		});
		$('.colorSelectInputFixed').off().on('change', function() {
			let color = $(this).val();
			let divId = $(this).attr('id') + 'Div';
			$('#' + divId).css('background-color', color);
		});

		$('#up-color_0').css('dissabled', 'true');
		$('#up-color_0').css('visibility', 'hidden');
		$('#down-color_' + (length - 1)).css('dissabled', 'true');
		$('#down-color_' + (length - 1)).css('visibility', 'hidden');

		$('[data-action]').click(function() {
			let position = $(this).data('position');
			if($(this).data('action') == 'up') {
				self.orderUp(position);
			} else if($(this).data('action') == 'down') {
				self.orderDown(position);
			} else if($(this).data('action') == 'remove') {
				self.removeColor(position);
			}
		});

		$('.color-pick').change(function() {
			let i = $(this).data('position');
			let color = $(this).val();
			self.colorsFixed[i] = color;
		});
	},

	// Añadir color fijo
	addColor() {
		let self = this;

		//Obtener color
		let color = $('#newColor').val();
		self.colorsFixed.push(color);

		self.renderColors();
	},

	// Subir color fijo
	orderUp(position) {
		let self = this;

		self.colorsFixed.splice(position - 1, 0, self.colorsFixed[position]);
		self.colorsFixed.splice(position + 1, 1);
		self.renderColors();
	},

	// Bajar color fijo
	orderDown(position) {
		let self = this;

		self.colorsFixed.splice(position + 2, 0, self.colorsFixed[position]);
		self.colorsFixed.splice(position, 1);
		self.renderColors();
	},

	// eliminar color fijo
	removeColor(position) {
		let self = this;

		self.colorsFixed.splice(position, 1);
		self.renderColors();
	},

	getFormPlantillasReportes() {
		let self = this;

		let check = true;

		// Nombre
		let nombre = $('#name').val().trim();
		if(nombre == '') {
			check = false;
			$('#name').addClass('is-invalid');
			$('[for="name"]').addClass('is-invalid');
		} else {
			$('#name').removeClass('is-invalid');
			$('[for="name"]').removeClass('is-invalid');
		}

		// Descripción
		let descripcion = $('#description').val().trim();

		// Tipo de fuente
		let tipoFuente = $('#font-picker').val().replace(/\+/g, ' ');

		// Tamaño de fuente
		let tamanoFuente = $('#fontSize').val();
		if(tamanoFuente == '') {
			check = false;
			$('#fontSize').addClass('is-invalid');
			$('[for="fontSize"]').addClass('is-invalid');
		} else {
			$('#fontSize').removeClass('is-invalid');
			$('[for="fontSize"]').removeClass('is-invalid');
		}

		// Formato de colores
		let rangoColores = $('input:radio[name=inlineRadioOptions]:checked').val();

		let colorInicio = '';
		let colorFinal = '';
		let coloresComponenRango = '';
		if(rangoColores == 1) {
			colorInicio = $('#RGBInicio').val();
			colorFinal = $('#RGBFin').val();
		} else {
			coloresComponenRango = self.colorsFixed.join();
		}

		let colorTituloPortada = $('#RGBTituloPortada').val();
		let colorTitulo = $('#RGBTitulo').val();

		let orderIntroduction = $('#orderIntroduction');
		let orderBigSmall = $('#orderBigSmall');
		let orderSmallBig = $('#orderSmallBig');

		let answersOrder = 'default';
		if (orderIntroduction.prop('checked')) answersOrder = orderIntroduction.val();
		else if (orderBigSmall.prop('checked')) answersOrder = orderBigSmall.val();
		else if (orderSmallBig.prop('checked')) answersOrder = orderSmallBig.val();

		// Comprobación
		if(!check) {
			let alertTitle = pf.const.language.RSC2347;
			let alertText = pf.const.language.RSC101;
			pf.utils.showInfoDialog(alertTitle, alertText);
		} else {
			self.setReportTemplatesObj = {
				nombre: nombre,
				descripcion: descripcion,
				tipoFuente: tipoFuente,
				tamanoFuente: tamanoFuente,
				rangoColores: rangoColores,
				colorInicio: colorInicio,
				colorFinal: colorFinal,
				coloresComponenRango: coloresComponenRango,
				plantilla: self.plantilla,
				plantillaPortada: self.plantilla_portada,
				logo: self.logo,
				colorTituloPortada: colorTituloPortada,
				colorTitulo: colorTitulo,
				answersOrder: answersOrder
			};
			self.setPlantillaReportes();
		}
	},

	setPlantillaReportes() {
		let self = this;

		let parameters = {
			nombre: self.setReportTemplatesObj.nombre,
			descripcion: self.setReportTemplatesObj.descripcion,
			tipoFuente: self.setReportTemplatesObj.tipoFuente,
			tamanoFuente: self.setReportTemplatesObj.tamanoFuente,
			rangoColores: self.setReportTemplatesObj.rangoColores,
			colorInicio: self.setReportTemplatesObj.colorInicio,
			colorFinal: self.setReportTemplatesObj.colorFinal,
			coloresComponenRango: self.setReportTemplatesObj.coloresComponenRango,
			plantillaURL: self.plantillaURL,
			plantilla: self.setReportTemplatesObj.plantilla,
			plantillaPortadaURL: self.plantilla_portadaURL,
			plantillaPortada: self.setReportTemplatesObj.plantillaPortada,
			logoURL: self.logoURL,
			logo: self.setReportTemplatesObj.logo,
			colorTituloPortada: self.setReportTemplatesObj.colorTituloPortada,
			colorTitulo: self.setReportTemplatesObj.colorTitulo,
			answersOrder: self.setReportTemplatesObj.answersOrder,
			// Valores de tipo de gráfica
			type3: self.typesGraphs['tenPoints'].nameGraph,
			type4: self.typesGraphs['listDropdownFilter'].nameGraph,
			type5: self.typesGraphs['fivePoints'].nameGraph,
			typeINTERROGANTE: self.typesGraphs['listDropdown'].nameGraph,
			typeL: self.typesGraphs['list'].nameGraph,
			typeO: self.typesGraphs['listWithComment'].nameGraph,
			typeY: self.typesGraphs['yesNo'].nameGraph,
			typeM: self.typesGraphs['multipleChoice'].nameGraph
		};
		ajaxComunCallWithCallback('setPlantillaReportes', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let successTitle = pf.const.language.RSC2347;
				let successContent = pf.const.language.RSC2351;
				pf.utils.showInfoDialog(successTitle, successContent);
				window.location.href = '#!plantillas_reportes';
			}
		});
	}
};