let WordCloudController = {
	url: null,

	resetData() {
		let self = this;

		self.url = null;
	},

	setEvents() {
		let self = this;
		self.resetData();

		// Reducción de Header
		headerSectionHeight(0);

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC542);

		// Valores de configuración
		let config = JSON.parse(atob(sessionStorage.getItem('STCMBackEnd:config')));

		// Validar url
		if(config.URLWordCloud == '' || config.URLWordCloud == undefined || config.URLWordCloud == null) {
			let warningTitle = pf.const.language.RSC61;
			let warningContent = pf.const.language.RSC993;
			pf.utils.showInfoDialog(warningTitle, warningContent);
			return;
		}

		// Colores
		let primaryColor = config.tenant[0].colorPrimario.replace('#', '');
		let secondaryColor = config.tenant[0].colorSecundario.replace('#', '');

		// Palabras (1) o frases (2)
		let wordsOrPhrases = 1;

		self.url = config.URLWordCloud + '/?a=&b=&c=&d=&e=&f=&g=' + primaryColor + '&h=' + secondaryColor + '&i=' + wordsOrPhrases + '&j=&k=&l=&m=&n=&o=';

		self.printIframe();
	},

	printIframe() {
		let self = this;

		let iframe = `
			<iframe src="${self.url}" class="embed-responsive-item ml-1" allowfullscreen></iframe>
		`;
		$('#iframeWordCloud').html(iframe);
	}
};