let BotsEditController = {
	bot: null,
	country: null,

	reset() {
		let self = this;

		self.profile = null;
		self.country = null;
	},

	setEvents() {
		let self = this;
		self.reset();

		self.bot = JSON.parse(atob(sessionStorage.getItem('bots')));

		// Reducción de Header
		headerSectionHeight(0);

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC43 + ' - ' + pf.const.language.RSC225);

		// Opciones de header
		let jsonsubopt = {
			back: 'back',
			save: 'save'
		};

		let nav = `
			${createSubOptionSave(jsonsubopt.save)}
			${createSubOptionBack(jsonsubopt.back)}
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		// Botón principal
		$('#save').addClass('main-button');

		// Botones secundarios
		$('#back').addClass('secondary-button');

		$('#botName').val(self.bot.botName);
		$('#directLine').val(self.bot.directLine);
		$('#pais').val(self.bot.pais);

		self.loadLang();
		self.applyEvents();

		// Collapse
		addEventArrowTableHeader();

		// Pintar texto de label
		changeLabelsColor();
	},

	loadLang() {
		pf.rsc.translateByTag('text');
	},

	applyEvents() {
		let self = this;

		$('#back').on('click', function() {
			window.location.href = '#!bots';
		});

		// País
		let countryModal = new TableCountries(0, 'BotsEditController');
		$('#searchCountry').off().on('click', function() {
			countryModal.setEvents();
		});

		$('#save').on('click', function() {
			let objInfo = {
				accept: {
					text: pf.const.language.RSC78
				},
				cancel: {
					text: pf.const.language.RSC57
				}
			};

			let alertTitle = pf.const.language.RSC78;
			let alertText = pf.const.language.RSC105;
			pf.utils.showInfoDialogAcceptCancel(alertTitle, alertText, objInfo, function() {
				self.editBot();
			}, function() {});
		});
	},

	clickEvents(data) {
		$('#pais').val(data.isocode);
	},

	editBot() {
		let self = this;

		// Control de campos
		let incomplete = false;

		let directLine = $('#directLine').val().trim();
		if(directLine == '') {
			incomplete = true;
			$('#directLine').addClass('is-invalid');
			$('[for="directLine"]').addClass('is-invalid');
		} else {
			$('#directLine').removeClass('is-invalid');
			$('[for="directLine"]').removeClass('is-invalid');
		}

		let botName = $('#botName').val().trim();
		if(botName == '') {
			incomplete = true;
			$('#botName').addClass('is-invalid');
			$('[for="botName"]').addClass('is-invalid');
		} else {
			$('#botName').removeClass('is-invalid');
			$('[for="botName"]').removeClass('is-invalid');
		}

		let pais = $('#pais').val();
		if(pais == '') {
			incomplete = true;
			$('#pais').addClass('is-invalid');
			$('[for="pais"]').addClass('is-invalid');
		} else {
			$('#pais').removeClass('is-invalid');
			$('[for="pais"]').removeClass('is-invalid');
		}

		if(incomplete) {
			pf.utils.alerts.showCompleteAllFields();
			return false;
		}

		let parameters = {
			directLine: directLine,
			botName: self.bot.botName,
			botNameNew: botName,
			pais: pais
		};
		ajaxComunCallWithCallback('updateBot', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let successTitle = (pf.const.language.RSC78);
				let successContent = (pf.const.language.RSC106);
				pf.utils.showInfoDialog(successTitle, successContent);
				window.location.href = '#!bots';
			}
		});
	}
};