let DominiosEmbebidosNewController = {
	domain: null,

	reset() {
		let self = this;

		self.domain = null;
	},

	setEvents() {
		let self = this;
		self.reset();

		// Reducción de Header
		headerSectionHeight(0);

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC42 + ' - ' + pf.const.language.RSC7);

		// Opciones de header
		let jsonsubopt = {
			back: 'back',
			save: 'save'
		};

		let nav = `
			${createSubOptionSave(jsonsubopt.save)}
			${createSubOptionBack(jsonsubopt.back)}
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		// Botón principal
		$('#save').addClass('main-button');

		// Botones secundarios
		$('#back').addClass('secondary-button');

		self.loadLang();
		self.applyEvents();

		// Collapse
		addEventArrowTableHeader();

		// Pintar texto de label
		changeLabelsColor();
	},

	loadLang() {
		pf.rsc.translateByTag('text');
	},

	applyEvents() {
		let self = this;

		$('#back').on('click', function() {
			window.location.href = '#!dominios_embebidos';
		});

		$('#save').on('click', function() {
			if($('#domain').val().trim() != '') {
				let objInfo = {
					accept: {
						text: pf.const.language.RSC78
					},
					cancel: {
						text: pf.const.language.RSC57
					}
				};

				let alertTitle = pf.const.language.RSC78;
				let alertText = pf.const.language.RSC105;
				pf.utils.showInfoDialogAcceptCancel(alertTitle, alertText, objInfo, function() {
					self.newDomain();
				}, function() {});
			} else {
				$('#domain').addClass('is-invalid');
				$('[for="domain"]').addClass('is-invalid');
	
				let errorTitle = pf.const.language.RSC93;
				let errorContent = pf.const.language.RSC94;
				pf.utils.showInfoDialog(errorTitle, errorContent);
			}
		});
	},

	newDomain() {
		let parameters = {
			domain: $('#domain').val()
		};
		ajaxComunCallWithCallback('newDomain', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let errorTitle = pf.const.language.RSC93;
				let errorContent = pf.const.language.RSC107;
				pf.utils.showInfoDialog(errorTitle, errorContent);
				window.location.href = '#!dominios_embebidos';
			}
		});
	}
};