let PerfilacionNewController = {
	user: null,
	profiling: '',
	profilingType: '',
	profilingActualPercent: '',
	maxValuePercent: 0,
	profilingActualLicenses: '',
	profilingTotalLicenses: '',

	reset() {
		let self = this;

		self.user = null;
		self.profiling = '';
		self.profilingType = '';
		self.profilingActualPercent = '';
		self.maxValuePercent = 0;
		self.profilingActualLicenses = '';
		self.profilingTotalLicenses = '';
	},

	setEvents() {
		let self = this;
		self.reset();

		let JSONuser = sessionStorage['STCMBackEnd:user'];
		let user = JSON.parse(JSONuser);
		let userMail = user.email;
		let user_split = userMail.split('@');
		self.user = user_split[0].replace('.', '_');

		// Reducción de Header
		headerSectionHeight(0);

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC515 + ' - ' + pf.const.language.RSC7);

		// Opciones de header
		let jsonsubopt = {
			back: 'back',
			save: 'save'
		};

		let nav = `
				${createSubOptionSave(jsonsubopt.save)}
				${createSubOptionBack(jsonsubopt.back)}
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		// Botón principal
		$('#save').addClass('main-button');

		// Botones secundarios
		$('#back').addClass('secondary-button');

		self.profiling = sessionStorage.getItem('profiling');
		self.profilingType = atob(sessionStorage.getItem('profilingType'));
		switch(self.profilingType) {
			case 'gender':
				$('#header1').text(pf.const.language.RSC516);
				if(self.profiling == 3) {
					$('#typeN').hide();
					$('#secABI').hide();
					$('#regAA').hide();
					$('#esta').hide();
					$('#ciud').hide();
					$('#edad').hide();
					$('#mini').hide();
					$('#maxi').hide();
					$('#ocup').hide();
					$('#noOcup').hide();
				} else {
					$('#type3').hide();
					// Recoger datos totales
					self.profilingActualPercent = atob(sessionStorage.getItem('totalPercentGender'));
					self.profilingActualLicenses = atob(sessionStorage.getItem('totalLicensesGender'));
					// Añadir textos
					$('#elementType').text(pf.const.language.RSC151);
					$('.licensesInput').hide();
				}
				break;
			case 'state':
				$('#header1').text(pf.const.language.RSC517);
				if(self.profiling == 3) {
					$('#typeN').hide();
					$('#secABI').hide();
					$('#edad').hide();
					$('#mini').hide();
					$('#maxi').hide();
					$('#gene').hide();
					$('#lice').hide();
					$('#ocup').hide();
					$('#noOcup').hide();
				} else {
					$('#type3').hide();
					// Recoger datos totales
					self.profilingActualPercent = atob(sessionStorage.getItem('totalPercentState'));
					self.profilingActualLicenses = atob(sessionStorage.getItem('totalLicensesState'));
					// Añadir textos
					$('#elementType').text(pf.const.language.RSC153);
					$('.licensesInput').hide();
				}
				break;
			case 'age':
				$('#header1').text(pf.const.language.RSC518);
				if(self.profiling == 3) {
					$('#typeN').hide();
					$('#secABI').hide();
					$('#regAA').hide();
					$('#esta').hide();
					$('#ciud').hide();
					$('#gene').hide();
					$('#ocup').hide();
					$('#noOcup').hide();
				} else {
					$('#type3').hide();
					// Recoger datos totales
					self.profilingActualPercent = atob(sessionStorage.getItem('totalPercentAge'));
					self.profilingActualLicenses = atob(sessionStorage.getItem('totalLicensesAge'));
					// Añadir textos
					$('#elementType').text(pf.const.language.RSC152);
					$('.licensesInput').hide();
				}
				break;
			case 'PerfSec':
				$('#header1').text('Perfilación por PerfSec');
				$('#typeN').hide();
				$('#regA').hide();
				$('#regAA').hide();
				$('#esta').hide();
				$('#ciud').hide();
				$('#edad').hide();
				$('#gene').hide();
				$('#ocup').hide();
				$('#noOcup').hide();
				break;
			case 'PerfRegion':
				$('#header1').text('Perfilación por PerfRegion');
				$('#typeN').hide();
				$('#secABI').hide();
				$('#regAA').hide();
				$('#esta').hide();
				$('#ciud').hide();
				$('#edad').hide();
				$('#mini').hide();
				$('#maxi').hide();
				$('#gene').hide();
				$('#ocup').hide();
				$('#noOcup').hide();
				break;
			case 'Integration':
				$('#header1').text(pf.const.language.RSC617);
				$('#typeN').hide();
				$('#regi').hide();
				$('#regA').hide();
				$('#secABI').hide();
				$('#regAA').hide();
				$('#esta').hide();
				$('#ciud').hide();
				$('#edad').hide();
				$('#mini').hide();
				$('#maxi').hide();
				$('#gene').hide();
				$('#lice').hide();
				break;
		}

		if(self.profiling != 3) {
			// Porcentaje máximo
			self.maxValuePercent = parseFloat(100 - self.profilingActualPercent).toFixed(1);
			$('#valueMax').text(pf.const.language.RSC532 + ' ' + self.maxValuePercent);

			// Licencias totales
			self.profilingTotalLicenses = Math.round(100 * self.profilingActualLicenses / self.profilingActualPercent);
		}

		self.loadLang();
		self.applyEvents();

		// Control de países permitidos por el administrador si solo hay uno
		let countries = JSON.parse(atob(sessionStorage['STCMBackEnd:userCountries']));
		if(countries.length === 1) {
			$('#country').val(countries[0]);
		}

		// Collapse
		addEventArrowTableHeader();

		// Pintar texto de label
		changeLabelsColor();
	},

	loadLang() {
		pf.rsc.translateByTag('text');
	},

	applyEvents() {
		let self = this;
		stcmbackend.perfilacion.sharedEvents(self, 'newPerfilacionCountry');

		// Guardar nueva entrada en registros de perfilación
		$('#save').on('click', function() {
			self.loadProfiling();
		});
	},

	loadProfiling() {
		let self = this;

		let reqName = '';
		let parameters = {};
		switch(self.profilingType) {
			case 'gender':
				reqName = 'setPerfGenero';
				break;
			case 'state':
				reqName = 'setPerfEstados';
				break;
			case 'age':
				reqName = 'setPerfEdad';
				break;
			case 'PerfSec':
				reqName = 'setPerfSec';
				break;
			case 'PerfRegion':
				reqName = 'setPerfRegion';
				break;
			case 'Integration':
				reqName = 'setLicenciasDiscriminantes';
				break;
		}

		if(self.profiling == 3) {
			// Comprobaciones
			let pais = $('#country').val();
			let region = $('#region').val().trim();
			let genero = $('#gender').val().trim();
			let regionABI = $('#regionABI').val().trim();
			let licencias = $('#licensesABI').val().trim();
			let estado = $('#state').val().trim();
			let ciudad = $('#city').val().trim();
			let regionABIAux = $('#regionABIAux').val().trim();
			let edad = $('#age').val().trim();
			let min = $('#min').val().trim();
			let max = $('#max').val().trim();
			let sec = $('#sec').val().trim();
			let cumple = $('#ocupadas').val().trim();
			let nocumple = $('#noOcupadas').val().trim();

			let comprobation = false;

			if(pais === '') {
				$('#country').addClass('is-invalid');
				$('#country-group').addClass('group-invalid');
				$('[for="country"]').addClass('is-invalid');
				comprobation = true;
			} else {
				$('#country').removeClass('is-invalid');
				$('#country-group').removeClass('group-invalid');
				$('[for="country"]').removeClass('is-invalid');
			}
			if(region === '' && self.profilingType != 'Integration') {
				$('#region').addClass('is-invalid');
				$('[for="region"]').addClass('is-invalid');
				comprobation = true;
			} else {
				$('#region').removeClass('is-invalid');
				$('[for="region"]').removeClass('is-invalid');
			}

			switch(self.profilingType) {
				case 'gender':
					if(genero === '') {
						$('#gender').addClass('is-invalid');
						$('[for="gender"]').addClass('is-invalid');
						comprobation = true;
					} else {
						$('#gender').removeClass('is-invalid');
						$('[for="gender"]').removeClass('is-invalid');
					}

					parameters = {
						pais: pais,
						region: region,
						porcentaje: '',
						genero: genero,
						regionABI: regionABI,
						licencias: licencias
					};
					break;
				case 'state':
					if(estado === '') {
						$('#state').addClass('is-invalid');
						$('[for="state"]').addClass('is-invalid');
						comprobation = true;
					} else {
						$('#state').removeClass('is-invalid');
						$('[for="state"]').removeClass('is-invalid');
					}

					parameters = {
						pais: pais,
						region: region,
						porcentaje: '',
						estado: estado,
						ciudad: ciudad,
						regionABI: regionABI,
						regionABIAux: regionABIAux
					};
					break;
				case 'age':
					if(edad === '') {
						$('#age').addClass('is-invalid');
						$('[for="age"]').addClass('is-invalid');
						comprobation = true;
					} else {
						$('#age').removeClass('is-invalid');
						$('[for="age"]').removeClass('is-invalid');
					}
					if(min === '') {
						$('#min').addClass('is-invalid');
						$('[for="min"]').addClass('is-invalid');
						comprobation = true;
					} else {
						$('#min').removeClass('is-invalid');
						$('[for="min"]').removeClass('is-invalid');
					}
					if(max === '') {
						$('#max').addClass('is-invalid');
						$('[for="max"]').addClass('is-invalid');
						comprobation = true;
					} else {
						$('#max').removeClass('is-invalid');
						$('[for="max"]').removeClass('is-invalid');
					}
					if(min === '') {
						$('#min').addClass('is-invalid');
						comprobation = true;
					} else {
						$('#min').removeClass('is-invalid');
					}
					if(max === '') {
						$('#max').addClass('is-invalid');
						comprobation = true;
					} else {
						$('#max').removeClass('is-invalid');
					}

					parameters = {
						pais: pais,
						region: region,
						porcentaje: '',
						edad: edad,
						min: min,
						max: max,
						regionABI: regionABI,
						licencias: licencias
					};
					break;
				case 'PerfSec':
					if(sec === '') {
						$('#sec').addClass('is-invalid');
						$('[for="sec"]').addClass('is-invalid');
						comprobation = true;
					} else {
						$('#sec').removeClass('is-invalid');
						$('[for="sec"]').removeClass('is-invalid');
					}

					parameters = {
						pais: pais,
						region: region,
						porcentaje: '',
						sec: sec,
						min: min,
						max: max,
						licencias: licencias
					};
					break;
				case 'PerfRegion':
					if(regionABI === '') {
						$('#regionABI').addClass('is-invalid');
						$('[for="regionABI"]').addClass('is-invalid');
						comprobation = true;
					} else {
						$('#regionABI').removeClass('is-invalid');
						$('[for="regionABI"]').removeClass('is-invalid');
					}

					parameters = {
						pais: pais,
						region: region,
						porcentaje: '',
						regionABI: regionABI,
						licencias: licencias
					};
					break;
				case 'Integration':
					if(cumple === '') {
						$('#ocupadas').addClass('is-invalid');
						$('[for="ocupadas"]').addClass('is-invalid');
						comprobation = true;
					} else {
						$('#ocupadas').removeClass('is-invalid');
						$('[for="ocupadas"]').removeClass('is-invalid');
					}
					if(nocumple === '') {
						$('#noOcupadas').addClass('is-invalid');
						$('[for="noOcupadas"]').addClass('is-invalid');
						comprobation = true;
					} else {
						$('#noOcupadas').removeClass('is-invalid');
						$('[for="noOcupadas"]').removeClass('is-invalid');
					}

					parameters = {
						pais: pais,
						region: region,
						porcentaje: '',
						cumple: cumple,
						nocumple: nocumple
					};
					break;
			}

			if(comprobation) {
				pf.utils.alerts.showCompleteAllFields();
				return false;
			}
		} else {
			let element = $('#element').val().trim();
			// Revisión de que el elemento no esté vacio
			if(element === '') {
				$('#element').addClass('is-invalid');
				$('[for="element"]').addClass('is-invalid');
				pf.utils.alerts.showCompleteAllFields();
				return false;
			}

			switch(self.profilingType) {
				case 'gender':
					parameters = {
						pais: '',
						region: '',
						regionABI: '',
						regionABIAux: '',
						ciudad: '',
						min: '',
						max: '',
						sec: '',
						cumple: '',
						nocumple: '',
						licencias: $('#licenses').val(),
						porcentaje: $('#percentage').val(),
						genero: element
					}
					break;
				case 'state':
					parameters = {
						pais: '',
						region: '',
						regionABI: '',
						regionABIAux: '',
						ciudad: '',
						min: '',
						max: '',
						sec: '',
						cumple: '',
						nocumple: '',
						licencias: $('#licenses').val(),
						porcentaje: $('#percentage').val(),
						estado: element
					}
					break;
				case 'age':
					parameters = {
						pais: '',
						region: '',
						regionABI: '',
						regionABIAux: '',
						ciudad: '',
						min: '',
						max: '',
						sec: '',
						cumple: '',
						nocumple: '',
						licencias: $('#licenses').val(),
						porcentaje: $('#percentage').val(),
						edad: element
					}
					break;
			}
		}

		ajaxComunCallWithCallback(reqName, parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let successTitle = pf.const.language.RSC515;
				let successContent = pf.const.language.RSC521;
				pf.utils.showInfoDialog(successTitle, successContent);
				window.location.href = '#!perfilacion';
			}
		});
	},

	clickEvents(data) {
		$('#country').val(data.isocode);
	}
};