let PerfilesNewController = {
	profile: null,
	allProfiles: '',

	reset() {
		let self = this;

		self.profile = null;
		self.allProfiles = '';
	},

	setEvents() {
		let self = this;
		self.reset();

		// Reducción de Header
		headerSectionHeight(0);

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC553);

		// Opciones de header
		let jsonsubopt = {
			back: 'back',
			save: 'save'
		};

		let nav = `
			${createSubOptionSave(jsonsubopt.save)}
			${createSubOptionBack(jsonsubopt.back)}
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		// Botón principal
		$('#save').addClass('main-button');

		// Botones secundarios
		$('#back').addClass('secondary-button');

		// Todos los perfiles
		ajaxComunCallWithCallback('getProfiles', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				self.allProfiles = ajaxReturn.result;
			}
		});

		self.loadLang();
		self.applyEvents();

		// Collapse
		addEventArrowTableHeader();

		// Pintar texto de label
		changeLabelsColor();
	},

	loadLang() {
		pf.rsc.translateByTag('text');
	},

	applyEvents() {
		let self = this;

		stcmbackend.perfiles.sharedEvents(self);

		$('#save').on('click', function() {
			let objInfo = {
				accept: {
					text: pf.const.language.RSC78
				},
				cancel: {
					text: pf.const.language.RSC57
				}
			};

			let alertTitle = pf.const.language.RSC78;
			let alertText = pf.const.language.RSC105;
			pf.utils.showInfoDialogAcceptCancel(alertTitle, alertText, objInfo, function() {
				self.setProfile();
			}, function() {});
		});
	},

	setProfile() {
		let self = this;

		let id = $('#id').val().trim();
		if(id === '') {
			$('#id').addClass('is-invalid');
			$('[for="id"]').addClass('is-invalid');

			pf.utils.alerts.showCompleteAllFields();
			return false;
		}

		let value = 0;
		if($('#enabled').prop('checked')) {
			value = 1;
		}
		let profileDef = 0;
		if($('#default').prop('checked')) {
			profileDef = 1;
			let size = self.allProfiles.length;
			for(let i = 0; i < size; i++) {
				if(self.allProfiles[i].default == 1) {
					self.editProfile(self.allProfiles[i].id, self.allProfiles[i].descripcion, self.allProfiles[i].enabled, '0');
					break;
				}
			}
		}

		let parameters = {
			id: id,
			description: $('#descripcion').val(),
			value: value,
			default: profileDef
		};
		ajaxComunCallWithCallback('setProfile', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				if(ajaxReturn.result == 'This profile already exists.') {
					let successTitle = (pf.const.language.RSC553);
					let successContent = (pf.const.language.RSC596);
					pf.utils.showInfoDialog(successTitle, successContent);
				} else {
					let successTitle = (pf.const.language.RSC78);
					let successContent = (pf.const.language.RSC106);
					pf.utils.showInfoDialog(successTitle, successContent);
					window.location.href = '#!perfiles';
				}
			}
		});
	},

	// En caso de nuevo perfil predefinido se actualiza el anterior perfil predefinido
	editProfile(id, descripcion, enabled, def) {
		let parameters = {
			id: id,
			description: descripcion,
			value: enabled,
			default: def
		};
		ajaxComunCallWithCallback('updateProfile', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				//
			}
		});
	}
};