let RSCNewController = {
	user: null,
	languagesList: [],
	ckEditors: {},

	reset() {
		let self = this;

		self.user = null;
		self.languagesList = atob(sessionStorage.getItem('languagesList')).split(',');
		self.ckEditors = {};
	},

	setEvents() {
		let self = this;
		self.reset();

		// Reducción de Header
		headerSectionHeight(0);

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC466 + ' - ' + pf.const.language.RSC7);

		// Opciones de header
		let jsonsubopt = {
			back: 'back',
			save: 'save'
		};

		let nav = `
			${createSubOptionSave(jsonsubopt.save)}
			${createSubOptionBack(jsonsubopt.back)}
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		// Botón principal
		$('#save').addClass('main-button');

		// Botones secundarios
		$('#back').addClass('secondary-button');

		self.loadLang();
		self.applyEvents();

		// Collapse
		addEventArrowTableHeader();

		// Pintar texto de label
		changeLabelsColor();
	},

	loadLang() {
		pf.rsc.translateByTag('text');
	},

	applyEvents() {
		let self = this;

		stcmbackend.rsc.sharedEvents(self);

		let url = window.location.href;

		let RSCInputs = '';
		let size = self.languagesList.length;
		for(let i = 0; i < size; i++) {
			if(self.languagesList[i] == 'system') {
				if(url.indexOf('localhost') != -1 || url.indexOf('sociallabs') != -1) {
					$('#system').prop('disabled', false);
					$('#system').prop('checked', true);
				} else {
					continue;
				}
			} else if(self.languagesList[i] == 'country') {
				continue;
			} else {
				let htmlEditor = `<input id="${self.languagesList[i]}" type="text" class="form-control">`;

				if(self.languagesList[i] != 'idTenant' && self.languagesList[i] != 'idCPG') {
					htmlEditor = `<input id="${self.languagesList[i]}" type="text" class="ckEditor" name="editor${i}">`;
				}

				RSCInputs += `
					<div class="form-group">
						<label for="${self.languagesList[i]}">${self.languagesList[i]}</label>
						${htmlEditor}
					</div>
				`;
			}
		}

		$('#RSCInputs').prepend(RSCInputs);

		$('.ckEditor').each(function() {
			let id = $(this).attr('id');
			ClassicEditor.create(document.querySelector('#' + id),{
				toolbar: ['bold', 'italic', 'underline']
			})
			.then(editor => {
				self.ckEditors[id] = editor;
			})
			.catch(error => {
				console.log('CKEditor Error');
			});
		});

		// Guardar nueva entrada RSC
		$('#save').on('click', function() {
			self.loadRSC();
		});
	},

	loadRSC() {
		let self = this;

		let valueSys = $('#system').prop('checked') ? '1' : '0';
		let valueCou = $('#country').prop('checked') ? '1' : '0';
		let valueApl = $('#RSCAplicacion').prop('checked') ? '1' : '0';

		let parameters = {
			system: valueSys,
			country: valueCou,
			app: valueApl
		};

		let size = self.languagesList.length;
		for(let i = 0; i < size; i ++) {
			if(self.languagesList[i] == 'system' || self.languagesList[i] == 'country') {
				continue;
			}
			RSCKey = self.languagesList[i];

			// El value de los inputs de RSC por idioma se tienen que extraer de 
			// los objetos almacenados en la array self.ckEditors

			if(RSCKey in self.ckEditors) {
				RSCKeyParameters = RSCKey.toLowerCase();
				parameters[RSCKeyParameters] = self.ckEditors[RSCKey].getData().replace('<p>', '').replace('</p>', '');
			} else {
				RSCKeyParameters = RSCKey.toLowerCase();
				parameters[RSCKeyParameters] = $('#' + self.languagesList[i]).val().trim();
			}
		}

		ajaxComunCallWithCallback('setRSC', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let successTitle = pf.const.language.RSC466;
				let successContent = pf.const.language.RSC464;
				pf.utils.showInfoDialog(successTitle, successContent);
				window.location.href = '#!rsc';
			}
		});
	}
};