let CPGEditController = {
	user: null,
	language: '',
	idCPG: '',
	data: '',
	maxSize: 0,
	logoPrimario: null,
	logoSecundario: null,
	favicon: null,
	logoWallet: null,
	logoWellcome: null,
	setCPGObj: {},

	reset() {
		let self = this;

		self.user = null;
		self.language = pf.const.language_table;
		self.idCPG = atob(sessionStorage.getItem('idCPG'));
		self.data = '';
		self.maxSize = 0;
		self.logoPrimario = null;
		self.logoSecundario = null;
		self.favicon = null;
		self.logoWallet = null,
		self.logoWellcome = null,
		self.setCPGObj = {
			country: '',
			lenguage: '',
			activo: '',
			razonSocial: '',
			nombreComercial: '',
			identFiscal: '',
			direccion: '',
			poblacion: '',
			provincia: '',
			cp: '',
			telefono: '',
			web: '',
			email: '',
			numLicencias: '',
			logoPrimario: '',
			logoSecundario: '',
			favicon: '',
			logoWalletApp: '',
			logoWelcomeApp: '',
			colorPrimario: '',
			colorSecundario: '',
			colorMenu1: '',
			colorFuenteMenu1: '',
			colorMenu2: '',
			colorFuenteMenu2: '',
			colorMenu3: '',
			colorFuenteMenu3: ''
		};
	},

	setEvents() {
		let self = this;
		self.reset();

		let JSONuser = sessionStorage['STCMBackEnd:user'];
		let user = JSON.parse(JSONuser);
		let userMail = user.email;
		let user_split = userMail.split('@');
		self.user = user_split[0].replace('.', '_');

		let userTenant = sessionStorage['STCMBackEnd:idTenant'];

		// Reducción de Header
		headerSectionHeight(0);

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC1716 + ' - ' + pf.const.language.RSC225 + ' - ID: ' + self.idCPG);

		// Opciones de header
		let jsonsubopt = {
			back: 'back',
			save: 'save'
		};

		let nav = `
			${createSubOptionSave(jsonsubopt.save)}
			${createSubOptionBack(jsonsubopt.back)}
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		// Botón principal
		$('#save').addClass('main-button');

		// Botones secundarios
		$('#back').addClass('secondary-button');

		self.loadLang();
		self.applyEvents();

		// Valores de configuración
		let config = JSON.parse(atob(sessionStorage.getItem('STCMBackEnd:config')));
		self.maxSize = config.upload_max_filesize_bytes;

		addLoader();
		let parameters = {
			idCPG: self.idCPG
		};
		ajaxComunCallWithCallback('getCPGById', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				self.data = ajaxReturn.result[0];
				self.setCPGObj = {
					country: self.data.country,
					lenguage: self.data.lenguage,
					activo: self.data.activo,
					razonSocial: self.data.razonSocial,
					nombreComercial: self.data.nombreComercial,
					identFiscal: self.data.identFiscal,
					direccion: self.data.direccion,
					poblacion: self.data.poblacion,
					provincia: self.data.provincia,
					cp: self.data.cp,
					telefono: self.data.telefono,
					web: self.data.web,
					email: self.data.email,
					numLicencias: self.data.numLicencias,
					logoPrimario: self.data.logoPrimario,
					logoSecundario: self.data.logoSecundario,
					favicon: self.data.favicon,
					logoWalletApp: self.data.logoWalletApp,
					logoWelcomeApp: self.data.logoWelcomeApp,
					colorPrimario: self.data.colorPrimario,
					colorSecundario: self.data.colorSecundario,
					colorMenu1: self.data.colorMenu1,
					colorFuenteMenu1: self.data.colorFuenteMenu1,
					colorMenu2: self.data.colorMenu2,
					colorFuenteMenu2: self.data.colorFuenteMenu2,
					colorMenu3: self.data.colorMenu3,
					colorFuenteMenu3: self.data.colorFuenteMenu3
				};

				ajaxComunCallWithCallback('getIdiomas', {}, function(ajaxReturn) {
					if(ajaxReturn) {
						let idiomas = ajaxReturn.result;

						// Búsqueda de idiomas activos y creación de select
						let options = '';
						let size = idiomas.length;
						for(let i = 0; i < size; i++) {
							if(idiomas[i].enabled == 1) {
								options += `<option value="${idiomas[i].isocode}">${idiomas[i].descripcion}</option>`;
							}
						}

						$('#idioma').html(options);
						$('#idioma').val(self.setCPGObj.lenguage);

						removeLoader();
					}
				}, false);

				// Tabla de resultados
				self.renderForm();
			}
		}, false);

		// Imagenes seleccionadas
		let raiz = stcm.const.downloads + 'tenants/' + userTenant + '/cpg/' + self.idCPG;
		$('#logoPrimIMG').attr('src', raiz+ '/logo.png?stamp=' + new Date().getTime());
		$('#logoSecIMG').attr('src', raiz + '/logo_home.png?stamp=' + new Date().getTime());
		$('#faviconIMG').attr('src', raiz + '/favicon.ico?stamp=' + new Date().getTime());
		$('#logoWalletIMG').attr('src', raiz + '/wallet_card.png?stamp=' + new Date().getTime());
		$('#logoWellcomeIMG').attr('src', raiz + '/logo_welcome.png?stamp=' + new Date().getTime());

		// Collapse
		addEventArrowTableHeader();

		// Pintar texto de label
		changeLabelsColor();
	},

	loadLang() {
		pf.rsc.translateByTag('text');
	},

	applyEvents() {
		let self = this;

		stcmbackend.cpg.sharedEvents(self, 'editCPGCountry');

		// Apariencia y comportamiento de los inputs tipo 'color'
		inputTypeColorEvents();

		// Guardar nuevo CPG
		$('#save').off().on('click', function() {
			self.getFormCPG();
		});
	},

	renderForm() {
		let self = this;

		// País
		$('#pais').val(self.data.country);

		// Activo
		if(self.data.activo == '1') {
			$('#enable').prop('checked', true);
		}

		// Razón social
		$('#razonSocial').val(self.data.razonSocial);

		// Nombre comercial
		$('#nombreComercial').val(self.data.nombreComercial);

		// Identidad fiscal
		$('#identidadFiscal').val(self.data.identFiscal);

		// Dirección
		$('#direccion').val(self.data.direccion);

		// Población
		$('#poblacion').val(self.data.poblacion);

		// Provincia
		$('#provincia').val(self.data.provincia);

		// Código postal
		$('#codigoPostal').val(self.data.cp);

		// Teléfono
		$('#telefono').val(self.data.telefono);

		// Web
		$('#web').val(self.data.web);

		// E-mail
		$('#mail').val(self.data.email);

		// Número de licencias
		$('#numLicencias').val(self.data.numLicencias);

		// Color primario
		$('#colorPri').val(self.data.colorPrimario);
		$('#colorPriDiv').css('background-color', self.data.colorPrimario);

		// Color secundario
		$('#colorSec').val(self.data.colorSecundario);
		$('#colorSecDiv').css('background-color', self.data.colorSecundario);

		// Color del menú
		$('#menuColor').val(self.data.colorMenu1);
		$('#menuColorDiv').css('background-color', self.data.colorMenu1);

		// Color de fuente del menú
		$('#menuFontColor').val(self.data.colorFuenteMenu1);
		$('#menuFontColorDiv').css('background-color', self.data.colorFuenteMenu1);

		// Color submenú nivel 2
		$('#submenu2Color').val(self.data.colorMenu2);
		$('#submenu2ColorDiv').css('background-color', self.data.colorMenu2);

		// Color de fuente del submenú de nivel 2
		$('#submenu2FontColor').val(self.data.colorFuenteMenu2);
		$('#submenu2FontColorDiv').css('background-color', self.data.colorFuenteMenu2);

		// Color submenú nivel 3
		$('#submenu3Color').val(self.data.colorMenu3);
		$('#submenu3ColorDiv').css('background-color', self.data.colorMenu3);

		// Color de fuente del submenú de nivel 3
		$('#submenu3FontColor').val(self.data.colorFuenteMenu3);
		$('#submenu3FontColorDiv').css('background-color', self.data.colorFuenteMenu3);
	},

	getFormCPG() {
		let self = this;

		let check = true;
		let changes = false;

		// País
		let country = $('#pais').val();
		if(country == '') {
			check = false;
			$('#pais').addClass('is-invalid');
			$('[for="pais"]').addClass('is-invalid');
		} else {
			$('#pais').removeClass('is-invalid');
			$('[for="pais"]').removeClass('is-invalid');
			if(self.setCPGObj.country != country) {
				changes = true;
			}
		}

		// Idioma
		let lenguage = $('#idioma').val();
		if(self.setCPGObj.lenguage != lenguage) {
			changes = true;
		}

		// Activo
		let activo = ($('#enable').prop('checked') ? '1' : '0');
		if(self.setCPGObj.activo != activo) {
			changes = true;
		}

		// Razón social
		let razonSocial = $('#razonSocial').val().trim();
		if(razonSocial == '') {
			check = false;
			$('#razonSocial').addClass('is-invalid');
			$('[for="razonSocial"]').addClass('is-invalid');
		} else {
			$('#razonSocial').removeClass('is-invalid');
			$('[for="razonSocial"]').removeClass('is-invalid');
			if(self.setCPGObj.razonSocial != razonSocial) {
				changes = true;
			}
		}

		// Nombre comercial
		let nombreComercial = $('#nombreComercial').val().trim();
		if(nombreComercial == '') {
			check = false;
			$('#nombreComercial').addClass('is-invalid');
			$('[for="nombreComercial"]').addClass('is-invalid');
		} else {
			$('#nombreComercial').removeClass('is-invalid');
			$('[for="nombreComercial"]').removeClass('is-invalid');
			if(self.setCPGObj.nombreComercial != nombreComercial) {
				changes = true;
			}
		}

		// Identidad fiscal
		let identFiscal = $('#identidadFiscal').val().trim();
		if(identFiscal == '') {
			check = false;
			$('#identidadFiscal').addClass('is-invalid');
			$('[for="identidadFiscal"]').addClass('is-invalid');
		} else {
			$('#identidadFiscal').removeClass('is-invalid');
			$('[for="identidadFiscal"]').removeClass('is-invalid');
			if(self.setCPGObj.identFiscal != identFiscal) {
				changes = true;
			}
		}

		// Dirección
		let direccion = $('#direccion').val().trim();
		if(self.setCPGObj.direccion != direccion) {
			changes = true;
		}

		// Población
		let poblacion = $('#poblacion').val().trim();
		if(self.setCPGObj.poblacion != poblacion) {
			changes = true;
		}

		// Provincia
		let provincia = $('#provincia').val().trim();
		if(self.setCPGObj.provincia != provincia) {
			changes = true;
		}

		// Código postal
		let cp = $('#codigoPostal').val().trim();
		if(self.setCPGObj.cp != cp) {
			changes = true;
		}

		// Teléfono
		let telefono = $('#telefono').val().trim();
		if(telefono == '') {
			check = false;
			$('#telefono').addClass('is-invalid');
			$('[for="telefono"]').addClass('is-invalid');
		} else {
			$('#telefono').removeClass('is-invalid');
			$('[for="telefono"]').removeClass('is-invalid');
			if(self.setCPGObj.telefono != telefono) {
				changes = true;
			}
		}

		// Web
		let web = $('#web').val().trim();
		if(self.setCPGObj.web != web) {
			changes = true;
		}

		// E-mail
		let email = $('#mail').val().trim();
		if(email == '' || !pf.utils.validateEmail(email)) {
			$('#mail').addClass('is-invalid');
			$('[for="mail"]').addClass('is-invalid');
		} else {
			$('#mail').removeClass('is-invalid');
			$('[for="mail"]').removeClass('is-invalid');
			if(self.setCPGObj.email != email) {
				changes = true;
			}
		}

		// Número de licencias
		let numLicencias = $('#numLicencias').val();

		// Logo principal
		let logoPrimario = self.logoPrimario;

		// Logo secundario
		let logoSecundario = self.logoSecundario;

		// Favicon
		let favicon = self.favicon;

		// Logo wallet
		let logoWallet = self.logoWallet;

		// Logo wellcome
		let logoWellcome = self.logoWellcome;

		// Color primario
		let colorPrimario = $('#colorPri').val();
		if(self.setCPGObj.colorPrimario != colorPrimario) {
			changes = true;
		}

		// Color secundario
		let colorSecundario = $('#colorSec').val();
		if(self.setCPGObj.colorSecundario != colorSecundario) {
			changes = true;
		}

		// Color del menú
		let colorMenu1 = $('#menuColor').val();
		if(self.setCPGObj.colorMenu1 != colorMenu1) {
			changes = true;
		}

		// Color de fuente del menú
		let colorFuenteMenu1 = $('#menuFontColor').val();
		if(self.setCPGObj.colorFuenteMenu1 != colorFuenteMenu1) {
			changes = true;
		}

		// Color submenú nivel 2
		let colorMenu2 = $('#submenu2Color').val();
		if(self.setCPGObj.colorMenu2 != colorMenu2) {
			changes = true;
		}

		// Color de fuente del submenú de nivel 2
		let colorFuenteMenu2 = $('#submenu2FontColor').val();
		if(self.setCPGObj.colorFuenteMenu2 != colorFuenteMenu2) {
			changes = true;
		}

		// Color submenú nivel 3
		let colorMenu3 = $('#submenu3Color').val();
		if(self.setCPGObj.colorMenu3 != colorMenu3) {
			changes = true;
		}

		// Color de fuente del submenú de nivel 3
		let colorFuenteMenu3 = $('#submenu3FontColor').val();
		if(self.setCPGObj.colorFuenteMenu3 != colorFuenteMenu3) {
			changes = true;
		}

		// Comprobación
		if(!check) {
			let alertTitle = pf.const.language.RSC1716;
			let alertText = pf.const.language.RSC101;
			pf.utils.showInfoDialog(alertTitle, alertText);
		} else {
			self.setCPGObj = {
				country: country,
				lenguage: lenguage,
				activo: activo,
				razonSocial: razonSocial,
				nombreComercial: nombreComercial,
				identFiscal: identFiscal,
				direccion: direccion,
				poblacion: poblacion,
				provincia: provincia,
				cp: cp,
				telefono: telefono,
				web: web,
				email: email,
				numLicencias: numLicencias,
				logoPrimario: logoPrimario,
				logoSecundario: logoSecundario,
				favicon: favicon,
				logoWalletApp: logoWallet,
				logoWelcomeApp: logoWellcome,
				colorPrimario: colorPrimario,
				colorSecundario: colorSecundario,
				colorMenu1: colorMenu1,
				colorFuenteMenu1: colorFuenteMenu1,
				colorMenu2: colorMenu2,
				colorFuenteMenu2: colorFuenteMenu2,
				colorMenu3: colorMenu3,
				colorFuenteMenu3: colorFuenteMenu3
			};
			self.updateCPG(changes);
		}
	},

	updateCPG(changes) {
		let self = this;

		let parameters = {
			idCPG: self.idCPG,
			country: self.setCPGObj.country,
			lenguage: self.setCPGObj.lenguage,
			razonSocial: self.setCPGObj.razonSocial,
			nombreComercial: self.setCPGObj.nombreComercial,
			identFiscal: self.setCPGObj.identFiscal,
			direccion: self.setCPGObj.direccion,
			poblacion: self.setCPGObj.poblacion,
			provincia: self.setCPGObj.provincia,
			cp: self.setCPGObj.cp,
			telefono: self.setCPGObj.telefono,
			web: self.setCPGObj.web,
			email: self.setCPGObj.email,
			numLicencias: self.setCPGObj.numLicencias,
			activo: self.setCPGObj.activo,
			colorPrimario: self.setCPGObj.colorPrimario,
			colorSecundario: self.setCPGObj.colorSecundario,
			colorMenu1: self.setCPGObj.colorMenu1,
			colorFuenteMenu1: self.setCPGObj.colorFuenteMenu1,
			colorMenu2: self.setCPGObj.colorMenu2,
			colorFuenteMenu2: self.setCPGObj.colorFuenteMenu2,
			colorMenu3: self.setCPGObj.colorMenu3,
			colorFuenteMenu3: self.setCPGObj.colorFuenteMenu3,
			logoPrimario: self.setCPGObj.logoPrimario,
			logoSecundario: self.setCPGObj.logoSecundario,
			favicon: self.setCPGObj.favicon,
			logoWalletApp: self.setCPGObj.logoWalletApp,
			logoWelcomeApp: self.setCPGObj.logoWelcomeApp,
			idTenant: sessionStorage['STCMBackEnd:idTenant'],
			urlLogos: stcm.const.downloads + 'tenants/' + sessionStorage['STCMBackEnd:idTenant'] + '/cpg/',
			changes: changes
		};
		ajaxComunCallWithCallback('updateCPG', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let successTitle = pf.const.language.RSC1716;
				let successContent = pf.const.language.RSC1722;
				pf.utils.showInfoDialog(successTitle, successContent);
				window.location.href = '#!cpg';
			}
		});
	},

	clickEvents(data) {
		$('#pais').val(data.isocode);
	}
};