let CustomersController = {
	data: '',
	arrayDelMult: [],

	reset() {
		let self = this;

		self.data = '';
		self.arrayDelMult = [];
	},

	setEvents() {
		let self = this;
		self.reset();

		// Reducción de Header
		headerSectionHeight(0);

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC2363);

		// Opciones de header
		let jsonsubopt = {
			new: 'new'
		};

		let nav = `
			${createSubOptionNew(jsonsubopt.new)}
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		$('#new svg').css({'width': '24px', 'height': '24px'});

		// Botón principal
		$('#new').addClass('main-button');

		ajaxComunCallWithCallback('getAllClientes', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				self.data = ajaxReturn.result;

				self.renderData();
			}
		});

		self.loadLang();
		self.applyEvents();

		// Collapse
		addEventArrowTableHeader();
	},

	loadLang() {
		pf.rsc.translateByTag('text');

		// TITLES
		$('.exportTitle').attr('title', pf.const.language.RSC47);
		$('.deleteMultTitle').attr('title', pf.const.language.RSC95);
	},

	applyEvents() {
		// Nuevo
		$('#new').on('click', function() {
			window.location.href = '#!customers_new';
		});
	},

	renderData() {
		let self = this;

		$('#resultTable').show();

		let table = `
			<thead>
				<tr>
					<th class="text-center" scope="col" title="">
						<div class="div-global-selection">
							<input type="checkbox" class="globalSelection">
						</div>
					</th>
					<th scope="col" title="${pf.const.language.RSC1540}">${pf.const.language.RSC1540}</th>
					<th scope="col" title="${pf.const.language.RSC1541}">${pf.const.language.RSC1541}</th>
					<th scope="col" title="${pf.const.language.RSC1542}">${pf.const.language.RSC1542}</th>
					<th scope="col" title="${pf.const.language.RSC550}">${pf.const.language.RSC550}</th>
					<th scope="col" title="${pf.const.language.RSC552}">${pf.const.language.RSC552}</th>
					<th scope="col" title="${pf.const.language.RSC1544}">${pf.const.language.RSC1544}</th>
					<th scope="col" title="${pf.const.language.RSC1543}">${pf.const.language.RSC1543}</th>
					<th scope="col" title="${pf.const.language.RSC1229}">${pf.const.language.RSC1229}</th>
					<th scope="col" title="${pf.const.language.RSC1545}">${pf.const.language.RSC1545}</th>
					<th scope="col" title="${pf.const.language.RSC1228}">${pf.const.language.RSC1228}</th>
					<th scope="col" title="${pf.const.language.RSC1546}">${pf.const.language.RSC1546}</th>
					<th scope="col" title="${pf.const.language.RSC136}">${pf.const.language.RSC136}</th>
					<th scope="col" title="${pf.const.language.RSC126}">${pf.const.language.RSC126}</th>
					<th scope="col" title="${pf.const.language.RSC2516}">${pf.const.language.RSC2516}</th>
				</tr>
			</thead>

			<thead class="filtersResult">
				<tr>
					<td>selector</td>
					<td>razonSocial</td>
					<td>nombreComercial</td>
					<td>identFiscal</td>
					<td>country</td>
					<td>lenguage</td>
					<td>provincia</td>
					<td>poblacion</td>
					<td>direccion</td>
					<td>cp</td>
					<td>telefono</td>
					<td>web</td>
					<td>email</td>
					<td>activo</td>
					<td>acciones</td>
				</tr>
			</thead>

			<tbody>
		`;

		// Obtener países permitidos
		let allowedCountries = JSON.parse(atob(sessionStorage['STCMBackEnd:userCountries']));
		let size = self.data.length;
		for(let i = 0; i < size; i++) {
			// Control de países permitidos
			if(self.data[i].country != '' && allowedCountries.indexOf(self.data[i].country) == -1) {
				continue;
			}

			table += `
				<tr data-id="${self.data[i].idCustomer}">
					<td class="text-center">
						<div class="div-single-selection" data-id="${self.data[i].idCustomer}">
							<input type="checkbox" class="deleteSelection">
						</div>
					</td>
					<td class="text-truncate c-pointer editRow" title="${self.data[i].razonSocial}">${self.data[i].razonSocial}</td>
					<td class="text-truncate c-pointer editRow" title="${self.data[i].nombreComercial}">${self.data[i].nombreComercial}</td>
					<td class="text-truncate c-pointer editRow" title="${self.data[i].identFiscal}">${self.data[i].identFiscal}</td>
					<td class="text-truncate c-pointer editRow" title="${self.data[i].country}">${self.data[i].country}</td>
					<td class="text-truncate c-pointer editRow" title="${self.data[i].lenguage}">${self.data[i].lenguage}</td>
					<td class="text-truncate c-pointer editRow" title="${self.data[i].provincia}">${self.data[i].provincia}</td>
					<td class="text-truncate c-pointer editRow" title="${self.data[i].poblacion}">${self.data[i].poblacion}</td>
					<td class="text-truncate c-pointer editRow" title="${self.data[i].direccion}">${self.data[i].direccion}</td>
					<td class="text-truncate c-pointer editRow" title="${self.data[i].cp}">${self.data[i].cp}</td>
					<td class="text-truncate c-pointer editRow" title="${self.data[i].telefono}">${self.data[i].telefono}</td>
					<td class="text-truncate c-pointer editRow" title="${self.data[i].web}">${self.data[i].web}</td>
					<td class="text-truncate c-pointer editRow" title="${self.data[i].email}">${self.data[i].email}</td>
					<td class="text-center c-pointer editRow">
						<span class="d-none">${(self.data[i].activo == '1' ? pf.const.language.RSC120 : pf.const.language.RSC121)}</span>
						<input type="checkbox" class="activa" disabled ${(self.data[i].activo == '1' ? 'checked' : '')}>
					</td>
					<td class="text-center">
						<div id="dropdownActions${i}" class="div-dd-actions c-pointer" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
							${stcmbackend.svg.threeDotsVertical18}
						</div>

						<div class="dropdown-menu dropdown-menu-right shadow menu-actions" aria-labelledby="dropdownActions${i}" data-id="${self.data[i].idCustomer}">
							<p class="dropdown-item editRow">
								${stcmbackend.svg.pencilWithoutColor}
								<span>${pf.const.language.RSC225}</span>
							</p>
							<p class="dropdown-item deleteRow">
								${stcmbackend.svg.trashWithoutColor}
								<span>${pf.const.language.RSC95}</span>
							</p>
						</div>
					</td>
				</tr>
			`;
		}

		table += `
			</tbody>
		`;

		$('#registers').html(table);

		// Setup - add a text input to each footer cell
		$('#registers .filtersResult td').each(function() {
			let title = $(this).text();
			let value = `<input type="text" class="form-control form-control-sm"">`;

			if(title == 'activo') {
				value = optionsSelectAllYesNo();
			} else if(title == 'selector' || title == 'acciones') {
				value = `<input type="text" class="form-control form-control-sm" disabled>`;
			}

			$(this).html(value);
		});

		let dataTable = $('#registers').DataTable({
			retrieve: true,
			language: pf.const.language_table,
			pageLength: 25,
			autoWidth: false,
			columnDefs: [
				{width: '25px', orderable: false, targets: 0},
				{width: '100px', targets: 1},
				{width: '120px', targets: 2},
				{width: '60px', orderable: false, targets: 14}
			],
			dom: 'Bfrtip',
			buttons: [{
				extend: 'excelHtml5',
				text: pf.const.language.RSC2363,
				className: 'd-none',
				title: pf.const.language.RSC2363,
				exportOptions: {
					columns: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13]
				},
				customize(xlsx) {
					dataTablesExcelCustomize(xlsx);
				}
			}],
			aaSorting: []
		});

		// Ocultar botones de tabla
		hideTableButtons('registers');

		// Apply the search
		applyTheSearch(dataTable, 'filtersResult');

		// Exportar tabla
		$('#export').off().on('click', function() {
			$('#resultTable .buttons-excel').trigger('click');
		});

		self.tableEvents(dataTable);

		$('#resultTable').on('draw.dt', function() {
			self.tableEvents(dataTable);
		});
	},

	tableEvents(dataTable) {
		let self = this;

		// Eventos del input global
		globalSelectionInputActions();

		// Editar cliente
		$('.editRow').off().on('click', function() {
			let id = $(this).parent().data('id');

			sessionStorage.setItem('idCustomer', btoa(id));
			window.location.href = '#!customers_edit';
		});

		// Borrar cliente
		$('.deleteRow').off().on('click', function() {
			let id = $(this).parent().data('id');

			let objInfo = {
				accept: {
					text: pf.const.language.RSC95
				},
				cancel: {
					text: pf.const.language.RSC57
				}
			};

			let alertTitle = pf.const.language.RSC2363;
			let alertText = pf.const.language.RSC2365;
			pf.utils.showInfoDialogAcceptCancel(alertTitle, alertText, objInfo, function() {
				self.deleteCustomers(id);
			}, function() {});
		});

		// Array de eliminado múltiple
		$('.deleteSelection').off().on('change', function() {
			let value = $(this).prop('checked');
			let id = $(this).parent().data('id');

			if(value) {
				self.arrayDelMult.push(id);
			} else {
				let index = self.arrayDelMult.indexOf(id);
				self.arrayDelMult.splice(index, 1);
			}

			// Eventos de los inputs individuales
			deleteSelectionInputActions(self.arrayDelMult);
		});

		// Función de borrado múltiple
		$('#multSelecDelete').off().on('click', function() {
			// Aviso de borrado múltiple
			let objInfo = {
				accept: {
					text: pf.const.language.RSC95
				},
				cancel: {
					text: pf.const.language.RSC57
				}
			};

			let alertTitle = pf.const.language.RSC2363;
			let alertText = pf.const.language.RSC2364;
			pf.utils.showInfoDialogAcceptCancel(alertTitle, alertText, objInfo, function() {
				self.deleteCustomers();
			}, function() {});
		});
	},

	deleteCustomers(id = false) {
		let self = this;

		let customers = [];
		if(id !== false) {
			let obj = {
				idCustomer: id
			}
			customers.push(obj);
		} else {
			let delSize = self.arrayDelMult.length;
			for(let i = 0; i < delSize; i++) {
				let obj = {
					idCustomer: self.arrayDelMult[i]
				}
				customers.push(obj);
			}
			self.arrayDelMult = [];
		}

		let parameters = {
			customers: JSON.stringify(customers)
		};
		ajaxComunCallWithCallback('deleteCliente', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let successTitle = pf.const.language.RSC2363;
				let successContent = pf.const.language.RSC2366;
				pf.utils.showInfoDialog(successTitle, successContent);
				loadHTML('inc/customers/customers.html', 'wrapper', CustomersController);
			}
		});
	}
};