stcmbackend.difusion = {
	sharedEvents(self) {
		$('#countryDelete').on('click', function() {
			$('#pais').val('');
			self.countryFilter = '';
			self.adminModal.admin = null;
			self.adminModal.data = null;
			self.adminModal.country = self.countryFilter;
			self.crewObject.data = null;
			self.crewObject.country = self.countryFilter;
			$('#countryDelete').hide();
		});

		// Volver a Listas de difusión
		$('#backLists').on('click', function() {
			window.location.href = '#!difusion';
		});

		// Importar excel
		$('#import').click(function() {
			$('#inputFile').trigger('click');
		});

		// Restricciones de carácteres por tecla
		$('.ovSpecChars').off().on('keypress', function(e) {
			// Parámetros: tecla, warningTitle, warningContent y pattern si no es el general
			let result = characterRestrictionsPerKey(e.keyCode, pf.const.language.RSC375, pf.const.language.RSC1762);

			return result;
		});

		// Restricciones de carácteres por pegado
		$('.ovSpecChars').on('paste', function() {
			// Parámetros: elemento, warningTitle, warningContent y pattern si no es el general
			characterRestrictionsPerPaste($(this), pf.const.language.RSC375, pf.const.language.RSC1762);
		});
	},

	uploadFile(evt, self, listName) {
		let selectedFile = evt.target.files[0];
		let reader = new FileReader();
		addLoader();

		reader.onload = function(event) {
			let data = event.target.result;
			let workbook = XLSX.read(data, {
				type: 'binary'
			});

			workbook.SheetNames.forEach(function(sheetName) {
				let arrayRSC = XLSX.utils.sheet_to_row_object_array(workbook.Sheets[sheetName]);
				let newMembers = []
				let sizeNew = arrayRSC.length;
				for(let i = 0; i < sizeNew; i++) {
					let name = 'name' + (i + 1);
					let mail = 'mail' + (i + 1);
					if(arrayRSC[i].Nombre) {
						name = arrayRSC[i].Nombre.trim();
					}
					if(arrayRSC[i]['E-mail']) {
						mail = arrayRSC[i]['E-mail'].trim();
					}

					let objNew = {
						nameUser: name,
						email: mail,
						id: ''
					};
					newMembers.push(objNew);
				}
				stcmbackend.difusion.setMembers(newMembers, self, listName);
			});
		};

		/* reader.onerror = function(event) {
			console.error('File could not be read! Code ' + event.target.error.code);
		}; */

		reader.readAsBinaryString(selectedFile);
	},

	setMembers(newMembers, self, listName) {
		ajaxComunCallWithCallback('getDomain', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				for(let i = 0; i < newMembers.length; ++i) {
					//build id for each member
					newMembers[i].id = newMembers[i].email.replace('@', '.') + '@' + ajaxReturn.result[0];
				}

				stcmbackend.difusion.getAllUsers(newMembers, self, listName);
			}
			removeLoader();
		});
	},

	getAllUsers(newMembers, self, listName) {
		let parameters = {
			country: self.countryFilter,
			consejero: 1,
			enabled: 1,
			staff: 1
		};
		ajaxComunCallWithCallback('getAllUsers', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				// Array de usuarios
				let usersIDArray = [];
				let size = ajaxReturn.result.length;
				for(let i = 0; i < size; i++) {
					usersIDArray.push(ajaxReturn.result[i].id);
				}

				// Comprobación de usuarios a añadir al grupo
				self.members = [];
				let gSize = newMembers.length;
				for(let i = 0; i < gSize; i++) {
					// newMembers.id está modificado para que contenga el email con formato de dominio
					if(usersIDArray.indexOf(newMembers[i].id) !== -1) {
						self.members.push(newMembers[i]);
					}
				}

				self.crewObject.members = self.members;
				tableMembers.setEvents(self.members, 'tableMembersUsers', listName);
			}
			removeLoader();
		});
	}
};