let HomeController = {
	adminData: null,
	allowedCountries: [],
	allowedCountriesDesc: [],
	activeCountry: '',
	activeCountryDesc: '',
	typeColors: '',
	colorsHex: [],
	chartsFlag: false,
	graphCharts: {},
	data: null,
	administratorPermission: {},

	reset() {
		let self = this;

		self.adminData = null;
		self.allowedCountries = [];
		self.allowedCountriesDesc = [];
		self.activeCountry = '';
		self.activeCountryDesc = '';
		self.typeColors = '';
		self.colorsHex = [];
		self.chartsFlag = false;
		self.graphCharts = {
			ageChart: null,
			genderChart: null,
			statesChart: null,
			nseChart: null,
			catalogingChart: null
		};
		self.data = null;
		self.administratorPermission = {};
	},

	setEvents: async function() {
		let self = this;
		self.reset();

		// Reducción de Header
		headerSectionHeight(0);

		// Control para que cuando se vuelva a home estando el chat abierto cierre este
		let commManagLinkState = $('#commManagLink').data('state');
		if(commManagLinkState == 'on') {
			$('#commManagLink').click();
		}
		$('[href="#!home"]').off().on('click', function() {
			let commManagLinkState = $('#commManagLink').data('state');
			if(commManagLinkState == 'on') {
				$('#commManagLink').click();
			}
		});

		$('#wrapper').addClass('totalTall');

		// Imagenes para los botones de accíon
		let newMissionButton = stcm.const.downloads + 'svg_new/mision.svg';
		$('#newMissionButton img').attr('src', newMissionButton);
		let notifyButton = stcm.const.downloads + 'svg_new/notificacion.svg';
		$('#notifyButton img').attr('src', notifyButton);
		let disperseButton = stcm.const.downloads + 'svg_new/dispersar.svg';
		$('#disperseButton img').attr('src', disperseButton);
		let validatePaymentsButton = stcm.const.downloads + 'svg_new/validar.svg';
		$('#validatePaymentsButton img').attr('src', validatePaymentsButton);

		// Datos de administrador
		self.adminData = JSON.parse(sessionStorage['STCMBackEnd:user']);
		let adminName = self.adminData.name;
		$('#adminName').text(adminName);

		// Permisos de administrador
		self.administratorPermission = JSON.parse(atob(sessionStorage['STCMBackEnd:administrator_permission']));
		// Controlar permisos de roll
		if(self.administratorPermission.alta_misiones != '1') {
			$('#newMissionButton').removeClass('d-flex');
			$('#newMissionButton').addClass('d-none');
		}
		if(self.administratorPermission.notificaciones != '1') {
			$('#notifyButton').removeClass('d-flex');
			$('#notifyButton').addClass('d-none');
		}
		if(self.administratorPermission.pagos != '1') {
			$('#disperseButton').removeClass('d-flex');
			$('#disperseButton').addClass('d-none');
		}
		if(self.administratorPermission.pagos_archivo != '1') {
			$('#validatePaymentsButton').removeClass('d-flex');
			$('#validatePaymentsButton').addClass('d-none');
		}
		if(self.administratorPermission.catalogacion != '1') {
			$('#seeMoreCataloging').addClass('d-none');
		}
		if(self.administratorPermission.misiones != '1') {
			$('#seeMoreMissions').addClass('d-none');
		}
		if(self.administratorPermission.asesores != '1') {
			$('#seeMoreActiveAdvisers').addClass('d-none');
		}
		if(self.administratorPermission.inversion != '1') {
			$('#seeMoreRemuneration').addClass('d-none');
		}

		// Países permitidos
		self.allowedCountries = JSON.parse(atob(sessionStorage['STCMBackEnd:userCountries']).split(","));
		self.allowedCountriesDesc = atob(sessionStorage['STCMBackEnd:userCountriesDesc']).split(",");

		if(self.allowedCountries.length > 1) {
			// Crear pestañas
			self.countryTabs();
		}

		self.containerSize();

		// País activo inicial
		self.activeCountry = self.allowedCountries[0];
		self.activeCountryDesc = self.allowedCountriesDesc[0];

		addLoader();
		// Colores
		self.getPlantillaReportesByDefault();

		self.loadLang();
		self.applyEvents();
	},

	loadLang() {
		pf.rsc.translateByTag('text');

		// Titles
		$('#newMissionButton').attr('title', pf.const.language.RSC2617);
		$('#notifyButton').attr('title', pf.const.language.RSC1242);
		$('#disperseButton').attr('title', pf.const.language.RSC2619);
		$('#validatePaymentsButton').attr('title', pf.const.language.RSC31);
		$('#ageTitle').attr('title', pf.const.language.RSC565);
		$('#genderTitle').attr('title', pf.const.language.RSC151);
		$('#statesTitle').attr('title', pf.const.language.RSC153);
		$('#nseTitle').attr('title', pf.const.language.RSC598);
		$('#catalogingTitle').attr('title', pf.const.language.RSC39);
		$('#missionsTitle').attr('title', pf.const.language.RSC14);
		$('#activeAdvisersTitle').attr('title', pf.const.language.RSC586);
		$('#remunerationsTitle').attr('title', pf.const.language.RSC118);
	},

	applyEvents() {
		let self = this;

		// Detectar cambio de tamaño de pantalla
		$(window).resize(function() {
			self.containerSize();
		});

		if(self.allowedCountries.length > 0) {
			// Cambio de país por pestaña
			$('#countryTabs .tab-button').on('click', function() {
				$('#countryTabs .tab-button').removeClass('activeTB');
				$(this).addClass('activeTB');

				self.activeCountry = $(this).attr('id');
				self.activeCountryDesc = $(this).data('desc');

				// Servicio de datos por país
				self.getMainDashboardByContry();
			});
		}

		// Nueva misión - inicio de step by step
		$('#newMissionButton').on('click', function() {
			$('#modalStepByStep').modal('toggle');
		});

		// Notificar - nueva notificación
		$('#notifyButton').on('click', function() {
			window.location.href = '#!notificaciones/nueva';
		});

		// Dispersar - pagos pendientes
		$('#disperseButton').on('click', function() {
			sessionStorage['home:disperse_country'] = self.activeCountry;
			sessionStorage['home:disperse_country_desc'] = self.activeCountryDesc;
			window.location.href = '#!pagos';
		});

		// Validar pagos
		$('#validatePaymentsButton').on('click', function() {
			window.location.href = '#!pagos_archivo';
		});

		// Catalogación Asesores
		$('#seeMoreCataloging').on('click', function() {
			sessionStorage['home:cataloging_country'] = self.activeCountry;
			sessionStorage['home:cataloging_country_desc'] = self.activeCountryDesc;
			window.location.href = '#!catalogacion';
		});

		// Misiones
		$('#seeMoreMissions').on('click', function() {
			window.location.href = '#!misiones';
		});

		// Asesores
		$('#seeMoreActiveAdvisers').on('click', function() {
			sessionStorage['home:advisers_country'] = self.activeCountry;
			sessionStorage['home:advisers_country_desc'] = self.activeCountryDesc;
			window.location.href = '#!asesores';
		});

		// Remuneración - inversión
		$('#seeMoreRemuneration').on('click', function() {
			sessionStorage['home:remuneration_country'] = self.activeCountry;
			sessionStorage['home:remuneration_country_desc'] = self.activeCountryDesc;
			window.location.href = '#!inversion';
		});
	},

	countryTabs() {
		let self = this;

		let countryTabs = '';

		let size = self.allowedCountries.length;
		for(let i = 0; i < size; i++) {
			let active = 'activeTB';
			if(i > 0) {
				active = '';
			}

			countryTabs += `
				<button id="${self.allowedCountries[i]}" type="button" class="btn glass-effect tab-button text-truncate m-0 mr-2 ${active}" data-desc="${self.allowedCountriesDesc[i]}" title="${self.allowedCountriesDesc[i]}">${self.allowedCountriesDesc[i]}</button>
			`;
		}

		$('#countryTabs').html(countryTabs);

		$('#countryTabs').addClass('ma-bo-10');
	},

	containerSize() {
		// Tamaño del contenedor
		let base = $('#init-home-container').height();
		let title = $('#page-title').height();
		let tabs = $('#countryTabs').height();
		let actions = $('#actionButtons').height();

		// Resta de margings
		let margings = 36;
		if(tabs == 0) {
			margings = 26;
		}

		let container = base - title - tabs - actions - margings;
		$('#countryDataContainers').css('height', container + 'px');
		$('.elementContainer').css('max-height', '100%');
	},

	getPlantillaReportesByDefault() {
		let self = this;

		ajaxComunCallWithCallback('getPlantillaReportesByDefault', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				let values = ajaxReturn.result[0];

				if(values != undefined) {
					self.typeColors = values.rangoColores;

					if(self.typeColors == '1') {
						self.colorsHex[0] = values.colorInicio;
						self.colorsHex[1] = values.colorFinal;
					} else {
						self.colorsHex = values.coloresComponenRango;
					}
				} else {
					self.typeColors = '1';
					self.colorsHex[0] = "#ffffff";
					self.colorsHex[1] = "#000000";
				}

				// Servicio de datos por país
				self.getMainDashboardByContry();
			}
		}, false);
	},

	getMainDashboardByContry() {
		let self = this;

		let parameters = {
			country: self.activeCountry
		};
		ajaxComunCallWithCallback('getMainDashboardByContry', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				self.data = ajaxReturn.result;

				// Control para eliminar las gráficas anteriores
				if(self.chartsFlag) {
					for(let chart in self.graphCharts) {
						if(self.graphCharts[chart]) {
							self.graphCharts[chart].destroy();
						}
					}
				} else {
					self.chartsFlag = true;
				}

				// Crear gráfica de edad
				self.createGraphs(self.data.Edad, 'ageChart', 'doughnut');

				// Crear gráfica de genero
				self.createGraphs(self.data.Genero, 'genderChart', 'doughnut');

				// Crear mapa de calor de estados (datos, pantallaCompleta)
				self.createMapGraph(self.data.Estado, false);

				// Crear gráfica de NSE
				self.createGraphs(self.data.NSE, 'nseChart', 'doughnut');

				// Crear gráfica de catalogación de asesores
				self.createGraphs(self.data.Catalogacion, 'catalogingChart', 'doughnut');

				// Tabla de misiones
				self.createTable();

				// Asesores activos
				let aWidth = $('#prevActiveAdvisers').width();
				let aLength = self.data.ComunidadActiva.toString().length;
				$('#prevActiveAdvisersValue').text(self.data.ComunidadActiva);
				// Control de tamaño del elemento para el tamaño de la fuente
				if(aLength > 4) {
					let fontSize = aWidth / aLength;
					if(fontSize < 30) {
						$('#prevActiveAdvisers .countryElementValue').css('font-size', fontSize + 'px');
					}
				}

				// Remuneración
				let rWidth = $('#prevRemuneration').width();
				let rLength = self.data.RemuneracionMesEnCursoObj.toString().length;
				$('#prevRemunerationValue').text(self.data.RemuneracionMesEnCursoObj);
				// Control de tamaño del elemento para el tamaño de la fuente
				if(rLength > 4) {
					let fontSize = rWidth / rLength;
					if(fontSize < 30) {
						$('#prevRemuneration .countryElementValue').css('font-size', fontSize + 'px');
					}
				}

				// Gráfica a pantalla completa
				$('.fullScreenGraphics').off().on('click', function() {
					let graph = $(this).data('graph');

					let element = '';
					switch(graph) {
						case 'ageChart':
							element = self.data.Edad;
							break;
						case 'genderChart':
							element = self.data.Genero;
							break;
						case 'nseChart':
							element = self.data.NSE;
							break;
						case 'catalogingChart':
							element = self.data.Catalogacion;
							break;
					}

					self.fullScreenGraphics(element);
				});

				// Mapa a pantalla completa
				$('#enlargeStates, #heatMapCanvas').off().on('click', function() {
					self.createMapGraph(self.data.Estado, true);
				});

				// Descargar gráfica o mapa a pantalla completa
				$('#downloadGraph').off().on('click', function() {
					/*Get image of canvas element*/
					let url_base64jp = document.getElementById('graphViewer').toDataURL('image/jpg');
					/*get download button (tag: <a></a>) */
					let a = document.getElementById('downloadGraph');
					/*insert chart image url to download button (tag: <a></a>) */
					a.href = url_base64jp;
				});

				// Cerrar gráfica o mapa a pantalla completa y recrear canvas
				$('#closeGraphic').off().on('click', function() {
					$('#graphicsViewer div').html('<canvas id="graphViewer" class="bg-white" width="800" height="600"></canvas>');

					$('#graphicsViewer').hide();
				});

				removeLoader();
			}
		}, false);
	},

	// GRÁFICAS
	createGraphs(values, id, type) {
		let self = this;

		let ctx = document.getElementById(id).getContext('2d');
		let quantity = values.length;

		// Valores
		let labels = [];
		let data = [];
		for(let i = 0; i < quantity; i++) {
			labels.push(values[i].label);
			data.push(values[i].porc);
		}

		// COLORES
		let colors = [];
		if(self.typeColors == 1) {
			colors = generateColors(self.colorsHex[0], self.colorsHex[1], quantity);
		} else {
			colors = arrayColors(self.colorsHex, quantity);
		}

		self.graphCharts[id] = new Chart(ctx, {
			type: type,
			data: {
				labels: labels,
				datasets: [{
					label: pf.const.language.RSC565,
					data: data,
					backgroundColor: colors
				}]
			},
			options: {
				responsive: true,
				maintainAspectRatio: false,
				legend: {
					display: false
				},
				tooltips: {
					callbacks: {
						label: function(tooltipItem, data) {
							let allData = data.datasets[tooltipItem.datasetIndex].data;
							let tooltipLabel = data.labels[tooltipItem.index];
							let tooltipData = allData[tooltipItem.index];
							return tooltipLabel + ": " + tooltipData + "%";
						}
					}
				},
				plugins: {
					datalabels: {
						color: function(context) {
							let index = context.dataIndex;
							let backgroundColor = context.dataset.backgroundColor[index];

							// Convirtiendo String Hexadecimal a RGB
							let result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(backgroundColor);
							let rgb = result ? {
									r: parseInt(result[1], 16),
									g: parseInt(result[2], 16),
									b: parseInt(result[3], 16)
								} : null; 

							//Formula que determinara el color blanco o negro de las letras
							let colorText = contrast(rgb);

							function contrast(rgb) {
								C = [rgb.r/255, rgb.g/255, rgb.b/255];
								for(let i = 0; i < C.length; ++i) {
									if( C[i] <= 0.03928 ) {
										C[i] = C[i] / 12.92
									} else {
										C[i] = Math.pow((C[i] + 0.055) / 1.055, 2.4);
									}
								}

								L = 0.2126 * C[0] + 0.7152 * C[1] + 0.0722 * C[2];
								if(L > 0.179) {
									return "#222222";
								} else {
									return "#dddddd";
								}
							}

							return colorText;
						},
						font: {
							weight: 'bold',
							size: 10
						},
						clamp: true,
						formatter(value, context) {
							return Math.round(parseFloat(value)) + '%';
						}
					}
				}
			}
		});
	},

	createMapGraph(data, fullScreen) {
		let self = this;

		if(fullScreen) {
			$('#graphicsViewer').show();

			let mapaPaisesRegiones = new Map();
			mapaPaisesRegiones.set(self.activeCountry, new Map());

			let ctx = document.getElementById('graphViewer').getContext('2d');

			// Datos
			let arrayLabels = [];
			let arrayLabelsData = [];
			let size = data.length;
			for(let i = 0; i <size; i++) {
				arrayLabels.push(data[i].label);
				arrayLabelsData.push(parseInt(data[i].num));
			}

			// Array de colores para representar el mapa (10 opciones)
			let quantity = 10;
			let colors = [];
			if(self.typeColors == 1) {
				colors = generateColors(self.colorsHex[0], self.colorsHex[1], quantity);
			} else {
				colors = arrayColors(self.colorsHex, quantity);
			}

			let heatMap = new HeatMap(self.activeCountry, 0, '', arrayLabels, arrayLabelsData, ctx, true, colors, true, '#383838');
			heatMap.createHeatMap();
		} else {
			$('#heatMap').html('');

			let mapaPaisesRegiones = new Map();
			mapaPaisesRegiones.set(self.activeCountry, new Map());

			let map = `<canvas id="heatMapCanvas" class="bg-white c-pointer" width="800" height="600" style="max-height: 100%;"></canvas>`;
			$('#heatMap').html(map);

			let ctx = document.getElementById('heatMapCanvas').getContext('2d');

			// Datos
			let arrayLabels = [];
			let arrayLabelsData = [];
			let size = data.length;
			for(let i = 0; i <size; i++) {
				arrayLabels.push(data[i].label);
				arrayLabelsData.push(parseInt(data[i].num));
			}

			// Array de colores para representar el mapa (10 opciones)
			let quantity = 10;
			let colors = [];
			if(self.typeColors == 1) {
				colors = generateColors(self.colorsHex[0], self.colorsHex[1], quantity);
			} else {
				colors = arrayColors(self.colorsHex, quantity);
			}

			let heatMap = new HeatMap(self.activeCountry, 0, '', arrayLabels, arrayLabelsData, ctx, true, colors, false, '#383838');
			heatMap.createHeatMap();
		}
	},

	// TABLA
	createTable() {
		let self = this;

		let table = `
			<table id="registers" class="table table-hover">
				<thead>
					<tr>
						<th scope="col" title="${pf.const.language.RSC123}">${pf.const.language.RSC123}</th>
						<th scope="col" title="${pf.const.language.RSC550}">${pf.const.language.RSC550}</th>
						<th scope="col" title="${pf.const.language.RSC117}">${pf.const.language.RSC117}</th>
						<th scope="col" title="${pf.const.language.RSC2283}">${pf.const.language.RSC2283}</th>
					</tr>
				</thead>

				<tbody>
		`;

		let size = self.data.UltimasMisionesCreadas.length;
		for(let i = 0; i < size; i++) {
			let startDateTime = self.data.UltimasMisionesCreadas[i].fechahorainicio.split('#');
			let startDateArray = startDateTime[0].split('/');
			let startDate = startDateArray[2] + '-' + startDateArray[1] + '-' + startDateArray[0];
			let startTime = startDateTime[1] + ':' + startDateTime[2];
			if(startTime.length == 5) {
				startTime += ':00';
			} else if(startTime == ':') {
				startTime = '-';
			}

			let endDateTime = self.data.UltimasMisionesCreadas[i].fechahorafin.split('#');
			let endDateArray = endDateTime[0].split('/');
			let endDate = endDateArray[2] + '-' + endDateArray[1] + '-' + endDateArray[0];
			let endTime = endDateTime[1] + ':' + endDateTime[2];
			if(endTime.length == 5) {
				endTime += ':00';
			} else if(endTime == ':') {
				endTime = '-';
			}

			// Reloj - Zona horaria
			let timeZone = sessionStorage['STCMBackEnd:timeZone'];
			let date = new Date();
			let renderTimeNow = moment.tz(date, timeZone).format('YYYY-MM-DD HH:mm:ss');

			let nowDate = new Date(renderTimeNow);
			let dateStart = '';
			let dateEnd = '';
			if(self.data.UltimasMisionesCreadas[i].fechahorainicio != '' && self.data.UltimasMisionesCreadas[i].fechahorafin != '') {
				dateStart = new Date(startDateArray[2], startDateArray[1]-1, startDateArray[0], startDateTime[1], startDateTime[2].substring(2, 0));
				dateEnd = new Date(endDateArray[2], endDateArray[1]-1, endDateArray[0], endDateTime[1], endDateTime[2].substring(2, 0));
			}

			// Para ordenación en columna
			let startDateOrder = startDate + startTime;
			let endDateOrder = endDate + endTime;

			// Estado en curso
			let estado = pf.const.language.RSC977;
			let estateVal = 1;
			let estadoClass = 'text-warning';
			if(self.data.UltimasMisionesCreadas[i].misionInfinita == '1' || (self.data.UltimasMisionesCreadas[i].fechahorainicio == '' && self.data.UltimasMisionesCreadas[i].fechahorafin == '' && self.data.UltimasMisionesCreadas[i].tipoAnidada == '1')) {
				startDate = '-';
				startTime = '';
				endDate = '-';
				endTime = '';

				// Para ordenación en columna
				startDateOrder = startDate + startTime;
				endDateOrder = endDate + endTime;
			} else {
				if(nowDate < dateStart) {
					// Estado no empezada
					estado = pf.const.language.RSC976;
					estateVal = 0;
					estadoClass = 'text-secondary';
				}

				if(nowDate > dateEnd) {
					// Estado finalizada
					estado = pf.const.language.RSC978;
					estateVal = 2;
					estadoClass = 'text-success';
				}

				// Formato de fecha, el servicio devuelve DD/MM/AAAA HH:MM:SS
				let dateTimeStartArray = self.data.UltimasMisionesCreadas[i].fechahorainicio.split('#');
				let dateTimeEndArray = self.data.UltimasMisionesCreadas[i].fechahorafin.split('#');
				if(self.dateFormat === 'AAAAMMDD') {
					startDate = modifyDateFormat(dateTimeStartArray[0]);
					endDate = modifyDateFormat(dateTimeEndArray[0]);
				} else {
					startDate = dateTimeStartArray[0];
					endDate = dateTimeEndArray[0];
				}
			}

			table += `
				<tr data-id="${self.data.UltimasMisionesCreadas[i].idmision}" data-state="${estateVal}" data-statetext="${estado}" data-stamp="${self.data.UltimasMisionesCreadas[i].stampMision}">
					<td class="text-truncate c-pointer editRow" title="${(self.data.UltimasMisionesCreadas[i].idmision || '-')}">${(self.data.UltimasMisionesCreadas[i].idmision || '-')}</td>
					<td class="text-truncate c-pointer editRow" title="${self.activeCountry}">${self.activeCountry}</td>
					<td class="text-truncate c-pointer editRow" title="${endDate + ' ' + endTime}">
						<span class="d-none">${endDateOrder}</span>
						${endDate + ' ' + endTime}
					</td>
					<td class="text-truncate c-pointer editRow font-weight-bold ${estadoClass}" title="${estado}"> ${estado} </td>
				</tr>
			`;
		}

		table += `
				</tbody>
			</table>
		`;

		$('#missionTable').html(table);

		let dataTable = $('#registers').DataTable({
			retrieve: true,
			language: pf.const.language_table,
			paging: false,
			searching: false,
			ordering: false,
			autoWidth: false,
			info: false,
			columnDefs: [
				{width: '60px', targets: 1}
			]
		});

		// Para pantallas altas
		if(parseInt($('#missionTable').css('height')) > 195) {
			$('#registers_wrapper').addClass('h-100');
			$('#registers').parent().parent().addClass('h-100');
			$('#registers').parent().addClass('h-100');
			$('#registers').addClass('h-100');
			$('#registers_wrapper').css('overflow', 'hidden');
		}

		// Edición solo activa si se tienen permisos
		if(sessionStorage['STCMBackEnd:editMission'] != 0) {
			// Editar misión
			$('.editRow').off().on('click', function() {
				let id = $(this).parent().data('id');
				let stamp = $(this).parent().data('stamp');
				let state = $(this).parent().data('state');
				let stateText = $(this).parent().data('statetext');

				sessionStorage.setItem('idMission', btoa(id));
				sessionStorage.setItem('idMissionStamp', btoa(stamp));
				sessionStorage.setItem('idMissionState', btoa(state));
				sessionStorage.setItem('idMissionStateText', btoa(stateText));
				window.location.href = '#!misiones_edit';
			});
		}
	},

	fullScreenGraphics(element) {
		let self = this;

		$('#graphicsViewer').show();
		let ctx = document.getElementById('graphViewer').getContext('2d');

		let quantity = element.length;

		// Valores
		let labels = [];
		let data = [];
		for(let i = 0; i < quantity; i++) {
			labels.push(element[i].label);
			data.push(element[i].porc);
		}

		// COLORES
		let colors = [];
		if(self.typeColors == 1) {
			colors = generateColors(self.colorsHex[0], self.colorsHex[1], quantity);
		} else {
			colors = arrayColors(self.colorsHex, quantity);
		}

		let graph = new Chart(ctx, {
			type: 'doughnut',
			data: {
				labels: labels,
				datasets: [{
					label: pf.const.language.RSC565,
					data: data,
					backgroundColor: colors
				}]
			},
			options: {
				responsive: true,
				maintainAspectRatio: false,
				layout: {
					padding: {
						top: 30
					}
				},
				legend: {
					display: true,
					position: 'bottom',
					onClick: false
				},
				tooltips: {
					callbacks: {
						label: function(tooltipItem, data) {
							let allData = data.datasets[tooltipItem.datasetIndex].data;
							let tooltipLabel = data.labels[tooltipItem.index];
							let tooltipData = allData[tooltipItem.index];
							return tooltipLabel + ": " + tooltipData + "%";
						}
					}
				},
				plugins: {
					datalabels: {
						color: function(context) {
							let index = context.dataIndex;
							let backgroundColor = context.dataset.backgroundColor[index];

							// Convirtiendo String Hexadecimal a RGB
							let result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(backgroundColor);
							let rgb = result ? {
									r: parseInt(result[1], 16),
									g: parseInt(result[2], 16),
									b: parseInt(result[3], 16)
								} : null; 

							//Formula que determinara el color blanco o negro de las letras
							let colorText = contrast(rgb);

							function contrast(rgb) {
								C = [rgb.r/255, rgb.g/255, rgb.b/255];
								for(let i = 0; i < C.length; ++i) {
									if( C[i] <= 0.03928 ) {
										C[i] = C[i] / 12.92
									} else {
										C[i] = Math.pow((C[i] + 0.055) / 1.055, 2.4);
									}
								}

								L = 0.2126 * C[0] + 0.7152 * C[1] + 0.0722 * C[2];
								if(L > 0.179) {
									return "#222222";
								} else {
									return "#dddddd";
								}
							}

							return colorText;
						},
						font: {
							weight: 'bold',
							size: 16
						},
						clamp: true,
						formatter(value, context) {
							return value + '%';
						}
					}
				}
			}
		});
	}
};