stcmbackend.gestionclientes = {
	generateHeadersTableGestionClientes() {
		let arrayTexts = [
			'',
			pf.const.language.RSC366,
			pf.const.language.RSC144,
			pf.const.language.RSC355,
			pf.const.language.RSC519
		];

		let headersInfo = {
			atr: {
				title: arrayTexts,
				id: ['inputTotalDel'],
				class: ['text-right']
			},
			text: arrayTexts
		}

		let filtersInfo = {
			text: [
				'edit',
				'id',
				'nombre',
				'endpoint',
				'licences'
			]
		}

		return stcmbackend.tables.headers.generateThead(headersInfo, filtersInfo);
	},

	generateHeadersTablePaisesCliente() {
		let arrayTexts = [
			'ISO',
			pf.const.language.RSC550,
			pf.const.language.RSC519
		];

		let headersInfo = {
			atr: {
				title: arrayTexts,
				id: ['inputTotalDel'],
				class: ['text-right']
			},
			text: arrayTexts
		}

		let filtersInfo = {
			text: [
				'iso',
				'pais',
				'licencias'
			]
		}

		return stcmbackend.tables.headers.generateThead(headersInfo, filtersInfo);
	},

	renderClient(object) {
		var pencil = stcmbackend.svg.pencil; 
		if(object.licences == 'n/d'){
			pencil = '';
		}

		return `
			<tr data-id="${object.id}">
				<td class="text-truncate text-center firstTD" title="${pf.const.language.RSC225}" data-id="${object.id}">
					<span class="c-pointer edit">
						${pencil}
					</span>
				</td>
				<td class="text-truncate" title="${object.id}">${object.id}</td>
				<td class="text-truncate" title="${object.nombre}">${object.nombre}</td>
				<td class="text-truncate" title="${object.endpoint}">${object.endpoint}</td>
				<td class="text-truncate" title="${object.licences}">${object.licences}</td>
			</tr>
		`;
	},

	renderClientePais(object) {
		return `
			<tr data-id="${object.pais}">
				<td class="text-truncate" title="${object.pais}">${object.pais}</td>
				<td class="text-truncate" title="${object.descripcion}">${object.descripcion}</td>
				<td class="text-truncate" title="${(object.licencias || '0')}">
						<span id="licSpan${object.pais}" class="d-none">${(object.licencias || '0')}</span>
						<input id="lic${object.pais}" type="number" class="form-control licInput" value="${(object.licencias || '0')}" title="${(object.licencias || '0')}" data-pais="${object.pais}">
					</td>
			</tr>
		`;
	},

	sharedEvents(self) {
		$('#back').on('click', function() {
			window.location.href = '#!clientes';
		});
	}
};