let HtmlNuevoController = {
	token: null,
	option: null,
	url: null,
	roles: null,
	allRoles: null,
	parentList: [],
	parentID: '',
	parentName: '',

	resetData() {
		let self = HtmlNuevoController;

		self.token = sessionStorage['STCMBackEnd:token'];
		self.option = null;
		self.url = null;
		self.roles = null;
		self.allRoles = null;
		self.parentList = [];
		self.parentID = '';
		self.parentName = '';
	},

	setEvents() {
		let self = HtmlNuevoController;
		self.resetData();

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC44 + ' - ' + pf.const.language.RSC7);

		let modal = 'newHTMLCountry';
		stcmbackend.html.setEvents(self, modal);

		// Modal de parent
		$('#btnParent').off().on('click', function() {
			stcmbackend.html.getAllCustomMenuOption(self, false);
		});

		// Guardar
		$('#btn-send').click(function() {
			// Obtener roles seleccionados
			self.getInputs();
			// Comprobar que los campos esta rellenos
			if(self.option.length == 0 || self.url.length == 0 || self.roles.length == 0) {
				if(self.option.length == 0) {
					$('#option').addClass('is-invalid');
					$('[for="option"]').addClass('is-invalid');
				} else {
					$('#option').removeClass('is-invalid');
					$('[for="option"]').removeClass('is-invalid');
				}

				if(self.url.length == 0) {
					$('#url').addClass('is-invalid');
					$('[for="url"]').addClass('is-invalid');
				} else {
					$('#url').removeClass('is-invalid');
					$('[for="url"]').removeClass('is-invalid');
				}

				let alertTitle = pf.const.language.RSC22;
				let alertText = pf.const.language.RSC101;
				let alertBtn = pf.const.language.RSC141;
				pf.utils.showInfoDialog(alertTitle, alertText, alertBtn);
			} else {
				let objInfo = {
					accept: {
						text: pf.const.language.RSC78
					},
					cancel: {
						text: pf.const.language.RSC57
					}
				};

				let alertTitle = pf.const.language.RSC78;
				let alertText = pf.const.language.RSC105;
				pf.utils.showInfoDialogAcceptCancel(alertTitle, alertText, objInfo, function() {
					self.save();
				}, function() {});
			}
		});

		self.loadLanguage();

		// Ocultar cubo de basura
		$('#parentDelete').hide();

		// Limpiar parent
		$('#parentDelete').on('click', function() {
			self.parentID = '';
			self.parentName = '';
			$('#parent').val(self.parentName);
			$('#parentDelete').hide();
		});

		// Collapse
		addEventArrowTableHeader();

		// Pintar texto de label
		changeLabelsColor();
	},

	loadLanguage() {
		pf.rsc.translateByTag('text');
	},

	renderRoles() {
		let self = HtmlNuevoController;

		self.allRoles = new TableHtmlRoles();
		self.allRoles.setEvents();
	},

	getInputs() {
		let self = HtmlNuevoController;

		self.option = $('#option').val();
		self.url = $('#url').val();
		self.roles = self.allRoles.getRoles();
	},

	save() {
		let self = HtmlNuevoController;

		let parameters = {
			option: self.option,
			url: self.url,
			parent: self.parentID,
			roles: JSON.stringify(self.roles),
			country: $('#pais').val()
		};
		ajaxComunCallWithCallback('setCustomMenuOption', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				window.location.href = '#!html';
			}
		});
	},

	clickEvents(data) {
		$('#pais').val(data.isocode);
		$('#countryDelete').show();
	}
};