stcmbackend.html = {
	setEvents(self, modal) {
		// Reducción de Header
		headerSectionHeight(0);

		// Opciones de header
		let jsonsubopt = {
			back: 'backLists',
			save: 'btn-send'
		};

		let nav = `
			${createSubOptionSave(jsonsubopt.save)}
			${createSubOptionBack(jsonsubopt.back)}
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		// Botón principal
		$('#btn-send').addClass('main-button');

		// Botones secundarios
		$('#backLists').addClass('secondary-button');

		// Vover a Html
		$('#backLists').on('click', function() {
			window.location.href = '#!html';
		});

		// Ocultar cubo de basura
		$('#countryDelete').hide();

		// País
		let countryModal = new TableCountries(0, modal);
		$('#searchCountry').off().on('click', function() {
			countryModal.setEvents();
		});

		// Limpiar País
		$('#countryDelete').on('click', function() {
			$('#pais').val('');
			$('#countryDelete').hide();
		});

		self.loadLanguage();

		// Obtener roles
		self.renderRoles();

		// Ocultar cubo de basura
		$('#parentDelete').hide();

		// Limpiar parent
		$('#parentDelete').on('click', function() {
			self.parentID = '';
			self.parentName = '';
			$('#parent').val(self.parentName);
			$('#parentDelete').hide();
		});
	},

	generateHeadersTableHtmlParent() {
		let arrayTexts = [pf.const.language.RSC366, pf.const.language.RSC353, pf.const.language.RSC354, pf.const.language.RSC355, pf.const.language.RSC17];
		let headersInfo = {
			atr: {title: arrayTexts},
			text: arrayTexts
		}

		let filtersInfo = {
			text: ['id', 'optionText', 'parent', 'url', 'roles']
		}

		return stcmbackend.tables.headers.generateTheadWithTable('tableHtml', 'table table-hover tRegs', headersInfo, filtersInfo, 'filters');
	},

	renderHtmlParent(object) {
		return `
			<tr id="p${object.id}" class="parent c-pointer">
				<td class="text-truncate" title="${object.id}">${(object.id != '' ? object.id : '-')}</td>
				<td class="text-truncate name" title="${object.optionText}">${(object.optionText != '' ? object.optionText : '-')}</td>
				<td class="text-truncate" title="${object.parent}">${(object.parent != '' ? object.parent : '-')}</td>
				<td class="text-truncate" title="${object.url}">${(object.url != '' ? object.url : '-')}</td>
				<td class="text-truncate" title="${object.roles}">${(object.roles != '' ? object.roles : '-')}</td>
			</tr>
		`;
	},

	renderParentTable(self) {
		let table = stcmbackend.html.generateHeadersTableHtmlParent();

		let size = self.parentList.length;
		for(let i = 0; i < size; i++) {
			table += stcmbackend.html.renderHtmlParent(self.parentList[i]);
		}

		table += `
				</tbody>
			</table>
		`;

		$('#tableParents').html(table);

		// Setup - add a text input to each footer cell
		$('#tableParents .filters td').each(function() {
			let value = `<input type="text" class="form-control form-control-sm">`;

			$(this).html(value);
		});

		let dataTable = $('#tableParents').DataTable({
			retrieve: true,
			language: pf.const.language_table,
			scrollY: 300,
			scroller: false,
			paging: true,
			pageLength: 25,
			autoWidth: false,
			aaSorting: [],
			lengthChange: false
		});

		// Ocultar botones de tabla
		hideTableButtons('tableParents');

		// Apply the search
		applyTheSearch(dataTable, 'filters');

		stcmbackend.html.tableParentsEvents(self);

		$('#tableParents').on('draw.dt', function() {
			stcmbackend.html.tableParentsEvents(self);
		});
	},

	tableParentsEvents(self) {
		$('.parent').off().on('click', function() {
			self.parentID = $(this).attr('id').replace('p', '');
			self.parentName = $(this).find('.name').text();
			$('#parent').val(self.parentName);
			$('#parentsClose').trigger('click');
			$('#parentDelete').show();
		});
	},

	getAllCustomMenuOptionAjax(callback) {
		ajaxComunCallWithCallback('getAllCustomMenuOption', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				callback(ajaxReturn);
			}
		});
	},

	getAllCustomMenuOption(self, init) {
		stcmbackend.html.getAllCustomMenuOptionAjax(function(ajaxReturn) {
			let size = ajaxReturn.result.length;
			if(init) {
				for(let i = 0; i < size; i++) {
					if(ajaxReturn.result[i].id == self.parentID) {
						self.parentName = ajaxReturn.result[i].optionText;
						$('#parent').val(self.parentName);
						$('#parentDelete').show();
						break;
					}
				}
			} else {
				self.parentList = [];
				for(let i = 0; i < size; i++) {
					if(ajaxReturn.result[i].parent == '') {
						self.parentList.push(ajaxReturn.result[i]);
					}
				}
				stcmbackend.html.renderParentTable(self);
			}
		});
	}
};