let ItemsEditController = {
	user: null,
	idItem: '',
	defaultImage: '',
	maxSize: 0,
	itemImages: [],
	itemImagesFile: [],
	acceptItemImages: [],
	acceptItemImagesFile: [],
	itemObj: {},
	existsGS1: false,
	noImgMain: true,
	idStores: [],
	stores: [],
	storesType: {},

	reset() {
		let self = this;

		self.user = null;
		self.idItem = atob(sessionStorage.getItem('idItem'));
		self.defaultImage = stcm.const.downloads + 'image.png';
		self.maxSize = 0;
		self.itemImages = [];
		self.itemImagesFile = [];
		self.acceptItemImages = [];
		self.acceptItemImagesFile = [];
		self.itemObj = {
			fichaGS1Completa: '',
			pendienteRevision: '',
			barcode: '',
			nombre: '',
			descripcion: '',
			categoria: '',
			subcategoria: '',
			segmento: '',
			subsegmento: '',
			ocasiones: '',
			fabricante: '',
			marca: '',
			submarca: '',
			sabor: '',
			empaque: '',
			contenido: '',
			unidadMedida: '',
			rangoContenido: ''
		};
		self.existsGS1 = false;
		self.noImgMain = true;
		self.idStores = [];
		self.stores = [];
		self.storesType = {};
	},

	setEvents() {
		let self = this;
		self.reset();

		let JSONuser = sessionStorage['STCMBackEnd:user'];
		let user = JSON.parse(JSONuser);
		let userMail = user.email;
		let user_split = userMail.split('@');
		self.user = user_split[0].replace('.', '_');

		// Reducción de Header
		headerSectionHeight(0);

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC2370 + ' - ' + pf.const.language.RSC225);

		// Opciones de header
		let jsonsubopt = {
			back: 'back',
			save: 'save'
		};

		let nav = `
			${createSubOptionSave(jsonsubopt.save)}
			${createSubOptionBack(jsonsubopt.back)}
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		// Botón principal
		$('#save').addClass('main-button');

		// Botones secundarios
		$('#back').addClass('secondary-button');

		// Ocultar carrusel
		$('#respCarousel').hide();

		// Valores de configuración
		let config = JSON.parse(atob(sessionStorage.getItem('STCMBackEnd:config')));
		self.maxSize = config.upload_max_filesize_bytes;

		addLoader();
		let parameters = {
			idItem: self.idItem
		};
		ajaxComunCallWithCallback('getItemsById', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let data = ajaxReturn.result[0];

				self.itemObj = {
					fichaGS1Completa: data.fichaGS1Completa,
					pendienteRevision: data.pendienteRevision,
					barcode: data.barcode,
					nombre: data.nombre,
					descripcion: data.descripcion,
					categoria: data.categoria,
					subcategoria: data.subcategoria,
					segmento: data.segmento,
					subsegmento: data.subsegmento,
					ocasiones: data.ocasiones,
					fabricante: data.fabricante,
					marca: data.marca,
					submarca: data.submarca,
					sabor: data.sabor,
					empaque: data.empaque,
					contenido: data.contenido,
					unidadMedida: data.unidadMedida,
					rangoContenido: data.rangoContenido
				};

				let size = data.comercios.length;
				for(let i = 0; i < size; i++) {
					self.idStores.push(data.comercios[i].id);
				}

				ajaxComunCallWithCallback('getAllComercios', {}, function(ajaxReturn) {
					if(ajaxReturn) {
						self.stores = ajaxReturn.result;
		
						for(let i = 0; i < self.stores.length; i++) {
							if(self.idStores.includes(self.stores[i].id)) {
								self.stores[i]['selected'] = true;
							} else {
								self.stores[i]['selected'] = false;
							}
						}
		
						ajaxComunCallWithCallback('getAllComerciosType', {}, function(ajaxReturn) {
							if(ajaxReturn) {
								self.storesType = {};
		
								for(let i = 0; i < ajaxReturn.result.length; i++) {
									self.storesType[ajaxReturn.result[i].id] = ajaxReturn.result[i].descripcion;
								}
		
								self.renderStores();
								removeLoader();
							}
						}, false);
					}
				}, false);

				if(data.imgFolder.length > 0) {
					for(let i = 0; i < data.imgFolder.length; i++) {
						let imgPath = stcm.const.downloads + 'items/' + self.idItem + '/' + data.imgFolder[i];
						self.itemImagesFile[i] = null;

						let main = '0';
						if(data.imgFolder[i].includes('_gs1_')) {
							main = '_gs1_';
							self.existsGS1 = true;
							self.noImgMain = false;
						} else if(data.imgFolder[i].includes('_main_')) {
							main = '_main_';
							self.noImgMain = false;
						}

						let obj = {
							imgPath: imgPath,
							status: 'old',
							main: main
						};

						self.itemImages[i] = obj;
						self.acceptItemImages[i] = obj;
					}

					self.itemImages[data.imgFolder.length] = {
						imgPath: self.defaultImage,
						status: 'default',
						main: '0'
					};

					// Mostrar carrusel
					$('#respCarousel').show();
					self.carousel();

					// Ocultar botón de nueva imagen
					$('#addImage').hide();
				} else {
					// Imagen por defecto
					self.itemImages[0] = {
						imgPath: self.defaultImage,
						status: 'default',
						main: '0'
					};

					// Ocultar botón de editar imágenes
					$('#editImages').hide();
				}

				// Tabla de resultados
				self.renderForm();
			}
		}, false);

		self.loadLang();
		self.applyEvents();

		// Collapse
		addEventArrowTableHeader();

		// Pintar texto de label
		changeLabelsColor();
	},

	loadLang() {
		pf.rsc.translateByTag('text');

		// TITLES
		$('.acceptTitle').attr('title', pf.const.language.RSC141);
	},

	applyEvents() {
		let self = this;

		// Añadir imágenes
		$('#addImage').off().on('click', function() {
			self.imagesRender();
			$('#modalPictures').modal('show');
		});

		// Editar imágenes
		$('#editImages').off().on('click', function() {
			self.imagesRender();
			$('#modalPictures').modal('show');
		});

		// Aceptar modal de imágenes
		$('#acceptImages').off().on('click', function() {
			$('#modalPictures').modal('hide');

			for(let i = 0; i < self.itemImages.length; i++) {
				let obj = {
					imgPath: self.itemImages[i].imgPath,
					status: self.itemImages[i].status,
					main: self.itemImages[i].main
				};
				self.acceptItemImages[i] = obj;
			}
			self.acceptItemImagesFile = self.itemImagesFile;

			// Mostrar u ocultar carrusel según proceda
			if(self.acceptItemImages.length > 0 && self.acceptItemImages[0].imgPath != self.defaultImage) {
				$('#respCarousel').show();
				self.carousel();
			} else {
				$('#respCarousel').hide();
			}
		});

		// Volver a items
		$('#back').off().on('click', function() {
			window.location.href = '#!show_all_items';
		});

		// Editar item
		$('#save').off().on('click', function() {
			self.getFormItem();
		});
	},

	carousel() {
		let self = this;

		let carouselImgs = '';
		let first = true;
		let size = self.acceptItemImages.length;

		// Control de imágen de _gs1_ o _main_
		let gs1 = -1;
		let main = -1;
		for(let i = 0; i < size; i++) {
			if(self.acceptItemImages[i].imgPath.includes('_gs1_')) {
				gs1 = i;
				main = -1;
				first = false;
				break;
			}

			if(self.acceptItemImages[i].imgPath.includes('_main_')) {
				main = i;
				first = false;
			}
		}

		for(let i = 0; i < size; i++) {
			if(self.acceptItemImages[i].imgPath == self.defaultImage || self.acceptItemImages[i].status == 'delete') {
				continue;
			}

			if(first) {
				carouselImgs += `
					<div class="carousel-item active">
						<img src="${self.acceptItemImages[i].imgPath}" class="img-fluid d-inline-block">
					</div>
				`;

				first = false;
			} else if(gs1 == i || main == i) {
				carouselImgs += `
					<div class="carousel-item active">
						<img src="${self.acceptItemImages[i].imgPath}" class="img-fluid d-inline-block">
					</div>
				`;
			} else {
				carouselImgs += `
					<div class="carousel-item">
						<img src="${self.acceptItemImages[i].imgPath}" class="img-fluid d-inline-block">
					</div>
				`;
			}
		}

		$('#carouselInner').html(carouselImgs);
		$('.carousel').carousel();
	},

	imagesRender() {
		let self = this;

		let picturesIMG = '';
		let size = self.itemImages.length;
		for(let i = 0; i < size; i++) {
			// Si es una imagen borrada no se muestra en el carrusel
			if(self.itemImages[i].status == 'delete') {
				continue;
			}

			// Clase para borrar imagen que no se aplica a la imagen por defecto
			let trash = 'deletePicture';

			// Clase para seleccionar imagen principal en caso de que no haya imagen de GS1 o cargar nueva imagen en caso de que sea la de por defecto
			let loadPicture = ' c-pointer selectMain';

			// Estilo para mostrar o no imagen principal
			let selectMain = 'display: none;';

			if(self.existsGS1) {
				loadPicture = '';
			}
			if(self.itemImages[i].imgPath === self.defaultImage) {
				trash = 'd-none';
				loadPicture = ' c-pointer loadPicture';
			}
			if(self.itemImages[i].main === '_gs1_') {
				trash = 'd-none';
				selectMain = '';
			}
			if(self.itemImages[i].main === '_main_') {
				trash = 'd-none';
				loadPicture = '';
				selectMain = '';
			}

			picturesIMG += `
				<div class="col-3 d-flex flex-column">
					<input id="otherPicture_${i}" type="file" class="d-none mb-3 loadPictureInput" accept="image/*" data-index="${i}">
					<div id="otherPicture_${i}IMGdiv" class="d-flex justify-content-center h-100">
						<div class="position-relative">
							<img id="otherPicture_${i}IMG" src="${self.itemImages[i].imgPath}" class="ob-fit-cont border${loadPicture}" alt="img" height="130" width="130" data-index="${i}">
							<div class="btn-eye pos-abs-t6-l6-rad-50" style="${selectMain}">
								${stcmbackend.svg.checkBigCircleWithoutColor}
							</div>
						</div>
					</div>
					<button id="btn_otherPicture_${i}" type="button" class="btn btn-nav ${trash}" data-index="${i}">
						${stcmbackend.svg.trash}
					</button>
				</div>
			`;
		}

		$('#picturesContainer').html(picturesIMG);

		self.imagesEvents();
	},

	imagesEvents() {
		let self = this;

		// Seleccionar imagen principal
		$('.selectMain').off().on('click', function() {
			let index = $(this).data('index');

			for(let i = 0; i < self.itemImages.length; i++) {
				if(i == index) {
					self.itemImages[i].main = '_main_';
				} else if(self.itemImages[i].main !== '_gs1_') {
					self.itemImages[i].main = '0';
				}
			}

			self.imagesRender();
		});

		// Carga de otras imágenes
		$('.loadPicture').off().on('click', function() {
			let index = $(this).data('index');
			$('#otherPicture_' + index).trigger('click');
		});
		$('.loadPictureInput').off().on('change', function(evt) {
			let index = $(this).data('index');
			let file = evt.target.files[0];
			if(file.size > self.maxSize) {
				let alertTitle = pf.const.language.RSC1909;
				let alertText = pf.const.language.RSC1337;
				pf.utils.showInfoDialog(alertTitle, alertText);
			} else {
				self.itemImagesFile[index] = file;
				let src = URL.createObjectURL(evt.target.files[0]);
				self.itemImages[index].imgPath = src;
				self.itemImages[index].status = 'new';
				if(self.noImgMain) {
					self.noImgMain = false;
					self.itemImages[index].main = '_main_';
				} else {
					self.itemImages[index].main = '0';
				}

				let obj = {
					imgPath: self.defaultImage,
					status: 'default',
					main: '0'
				};
				self.itemImages.push(obj);

				self.imagesRender();
			}
		});

		// Borrar imágenes
		$('.deletePicture').off().on('click', function() {
			let index = $(this).data('index');
			$('#otherPicture_' + index).val(null);

			self.itemImages[index].status = 'delete';
			self.itemImagesFile[index] = null;

			self.imagesRender();
		});
	},

	renderForm() {
		let self = this;

		// Ficha GS1 completa
		if(self.itemObj.fichaGS1Completa == '1') {
			$('#fichaGS1Completa').prop('checked', true);
		}

		// Pendiente de revisión
		if(self.itemObj.pendienteRevision == '1') {
			$('#pendienteRevision').prop('checked', true);
		}

		// Código de barra
		$('#barcode').val(self.itemObj.barcode);

		// Nombre
		$('#nombre').val(self.itemObj.nombre);

		// Descripción
		$('#descripcion').val(self.itemObj.descripcion);

		// Categoría
		$('#categoria').val(self.itemObj.categoria);

		// Subcategoría
		$('#subcategoria').val(self.itemObj.subcategoria);

		// Segmento
		$('#segmento').val(self.itemObj.segmento);

		// Subsegmento
		$('#subsegmento').val(self.itemObj.subsegmento);

		// Ocasiones
		$('#ocasiones').val(self.itemObj.ocasiones);

		// Fabricante
		$('#fabricante').val(self.itemObj.fabricante);

		// Marca
		$('#marca').val(self.itemObj.marca);

		// Submarca
		$('#submarca').val(self.itemObj.submarca);

		// Sabor
		$('#sabor').val(self.itemObj.sabor);

		// Empaque
		$('#empaque').val(self.itemObj.empaque);

		// Contenido
		$('#contenido').val(self.itemObj.contenido);

		// Unidad de medida
		$('#unidadMedida').val(self.itemObj.unidadMedida);

		// Rango de contenido
		$('#rangoContenido').val(self.itemObj.rangoContenido);
	},

	renderStores() {
		let self = this;

		let table = `
			<thead>
				<tr>
					<th scope="col" title="${pf.const.language.RSC123}">${pf.const.language.RSC123}</th>
					<th scope="col" title="${pf.const.language.RSC1229}">${pf.const.language.RSC1229}</th>
					<th scope="col" title="${pf.const.language.RSC2474}">${pf.const.language.RSC2474}</th>
					<th scope="col">
						<div class="custom-control custom-switch">
							<input id="allSwitchs" type="checkbox" class="custom-control-input">
							<label for="allSwitchs" class="custom-control-label c-pointer"></label>
						</div>
					</th>
				</tr>
			</thead>

			<thead class="filtersResult">
				<tr>
					<td>nombre</td>
					<td>direccion</td>
					<td>idComercioType</td>
					<td>select</td>
				</tr>
			</thead>

			<tbody>
		`;

		let size = self.stores.length;
		for(let i = 0; i < size; i++) {
			table += `
				<tr data-id="${self.stores[i].id}">
					<td class="text-truncate c-pointer editRow" title="${self.stores[i].nombre}">${self.stores[i].nombre}</td>
					<td class="text-truncate c-pointer editRow" title="${self.stores[i].direccion || '-'}">${self.stores[i].direccion || '-'}</td>
					<td class="text-truncate c-pointer editRow" title="${self.storesType[self.stores[i].idComercioType]}">${self.storesType[self.stores[i].idComercioType]}</td>
					<td>
						<div class="custom-control custom-switch">
							<span class="d-none">${(self.stores[i].selected ? pf.const.language.RSC120 : pf.const.language.RSC121)}</span>
							<input id="${self.stores[i].id}" type="checkbox" class="custom-control-input uSwitch" data-index="${i}" ${self.stores[i].selected ? 'checked' : ''}>
							<label for="${self.stores[i].id}" class="custom-control-label c-pointer"></label>
						</div>
					</td>
				</tr>
			`;
		}

		table += `
			</tbody>
		`;

		$('#registers').html(table);

		// Setup - add a text input to each footer cell
		$('#registers .filtersResult td').each(function() {
			let title = $(this).text();
			let value = `<input type="text" class="form-control form-control-sm">`;

			if(title === 'select') {
				value = optionsSelectAllYesNo();
			}

			$(this).html(value);
		});

		let dataTable = $('#registers').DataTable({
			retrieve: true,
			language: pf.const.language_table,
			paging: false,
			autoWidth: false,
			columnDefs: [
				{width: '60px', orderable: false, targets: 3}
			],
			exportOptions: {
				columns: [0, 1, 2]
			},
			dom: 'Bfrtip',
			buttons: [{
				extend: 'excelHtml5',
				text: pf.const.language.RSC2473,
				className: 'd-none',
				title: pf.const.language.RSC2473,
				customize(xlsx) {
					dataTablesExcelCustomize(xlsx);
				}
			}],
			aaSorting: []
		});

		// Apply the search
		applyTheSearch(dataTable, 'filtersResult');

		// Ocultar botones de tabla
		hideTableButtons('registers');

		// Exportar tabla
		$('#exportStores').off().on('click', function() {
			$('#storesTableContainer .buttons-excel').trigger('click');
		});

		self.storesTableEvents(dataTable);

		$('#registers').on('draw.dt', function() {
			self.storesTableEvents(dataTable);
		});
	},

	storesTableEvents() {
		let self = this;

		if($('.uSwitch').length == $('.uSwitch:checked').length) {
			$('#allSwitchs').prop('checked', true);
		} else {
			$('#allSwitchs').prop('checked', false);
		}

		// La id del elemento principal modifica los elementos secundarios a través de su clase
		$('#allSwitchs').on('click', function() {
			$('.uSwitch').prop('checked', this.checked);

			let size = self.stores.length;
			for(let i = 0; i < size; i++) {
				self.stores[i].selected = this.checked;
			}
		});

		// Si todos los checkbox están seleccionados, se selecciona el checkbox principal, y viceversa
		$('.uSwitch').on('click', function() {
			if($('.uSwitch').length == $('.uSwitch:checked').length) {
				$('#allSwitchs').prop('checked', true);
			} else {
				$('#allSwitchs').prop('checked', false);
			}

			let index = $(this).data('index');
			self.stores[index].selected = this.checked;
		});
	},

	getFormItem() {
		let self = this;

		let check = true;

		// Código de barras
		let barcode = $('#barcode').val().trim();
		if(barcode == '') {
			check = false;
			$('#barcode').addClass('is-invalid');
			$('[for="barcode"]').addClass('is-invalid');
		} else {
			$('#barcode').removeClass('is-invalid');
			$('[for="barcode"]').removeClass('is-invalid');
		}

		/* // Nombre
		let nombre = $('#nombre').val().trim();
		if(nombre == '') {
			check = false;
			$('#nombre').addClass('is-invalid');
			$('[for="nombre"]').addClass('is-invalid');
		} else {
			$('#nombre').removeClass('is-invalid');
			$('[for="nombre"]').removeClass('is-invalid');
		}

		// Categoría
		let categoria = $('#categoria').val().trim();
		if(categoria == '') {
			check = false;
			$('#categoria').addClass('is-invalid');
			$('[for="categoria"]').addClass('is-invalid');
		} else {
			$('#categoria').removeClass('is-invalid');
			$('[for="categoria"]').removeClass('is-invalid');
		}

		// Marca
		let marca = $('#marca').val().trim();
		if(marca == '') {
			check = false;
			$('#marca').addClass('is-invalid');
			$('[for="marca"]').addClass('is-invalid');
		} else {
			$('#marca').removeClass('is-invalid');
			$('[for="marca"]').removeClass('is-invalid');
		}

		// Contenido
		let contenido = $('#contenido').val().trim();
		if(contenido == '') {
			check = false;
			$('#contenido').addClass('is-invalid');
			$('[for="contenido"]').addClass('is-invalid');
		} else {
			$('#contenido').removeClass('is-invalid');
			$('[for="contenido"]').removeClass('is-invalid');
		} */

		// Comprobación
		if(!check) {
			let alertTitle = pf.const.language.RSC2370;
			let alertText = pf.const.language.RSC101;
			pf.utils.showInfoDialog(alertTitle, alertText);
		} else {
			self.itemObj = {
				fichaGS1Completa: ($('#fichaGS1Completa').prop('checked') ? '1' : '0'),
				pendienteRevision: ($('#pendienteRevision').prop('checked') ? '1' : '0'),
				barcode: $('#barcode').val().trim(),
				nombre: $('#nombre').val().trim(),
				descripcion: $('#descripcion').val().trim(),
				categoria: $('#categoria').val().trim(),
				subcategoria: $('#subcategoria').val().trim(),
				segmento: $('#segmento').val().trim(),
				subsegmento: $('#subsegmento').val().trim(),
				ocasiones: $('#ocasiones').val().trim(),
				fabricante: $('#fabricante').val().trim(),
				marca: $('#marca').val().trim(),
				submarca: $('#submarca').val().trim(),
				sabor: $('#sabor').val().trim(),
				empaque: $('#empaque').val().trim(),
				contenido: $('#contenido').val().trim(),
				unidadMedida: $('#unidadMedida').val(),
				rangoContenido: $('#rangoContenido').val().trim()
			};
			self.updateItems();
		}
	},

	updateItems() {
		let self = this;

		// Tiendas con el articulo
		let stores = [];
		let size = self.stores.length;
		for(let i = 0; i < size; i++) {
			if(self.stores[i].selected) {
				stores.push(self.stores[i].id);
			}
		}

		let parameters = {
			idItem: self.idItem,
			fichaGS1Completa: self.itemObj.fichaGS1Completa,
			pendienteRevision: self.itemObj.pendienteRevision,
			barcode: self.itemObj.barcode,
			nombre: self.itemObj.nombre,
			descripcion: self.itemObj.descripcion,
			categoria: self.itemObj.categoria,
			subcategoria: self.itemObj.subcategoria,
			segmento: self.itemObj.segmento,
			subsegmento: self.itemObj.subsegmento,
			ocasiones: self.itemObj.ocasiones,
			fabricante: self.itemObj.fabricante,
			marca: self.itemObj.marca,
			submarca: self.itemObj.submarca,
			sabor: self.itemObj.sabor,
			empaque: self.itemObj.empaque,
			contenido: self.itemObj.contenido,
			unidadMedida: self.itemObj.unidadMedida,
			rangoContenido: self.itemObj.rangoContenido,
			acceptItemImages: JSON.stringify(self.acceptItemImages),
			stores: JSON.stringify(stores)
		};

		// Imágenes
		let imgSize = self.acceptItemImagesFile.length;
		for(let i = 0; i < imgSize; i++) {
			parameters['img' + i] = self.acceptItemImagesFile[i];
		}

		ajaxComunCallWithCallback('updateItems', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let successTitle = pf.const.language.RSC2370;
				let successContent = pf.const.language.RSC2383;
				pf.utils.showInfoDialog(successTitle, successContent);
				window.location.href = '#!show_all_items';
			}
		});
	}
};