let TenantEditController = {
	user: null,
	language: '',
	idTenant: '',
	data: '',
	maxSize: 0,
	logoPrimario: null,
	logoSecundario: null,
	favicon: null,
	logoWallet: null,
	logoWellcome: null,
	setTenantObj: {},

	reset() {
		let self = this;

		self.user = null;
		self.language = pf.const.language_table;
		self.idTenant = atob(sessionStorage.getItem('idTenant'));
		self.data = '';
		self.maxSize = 0;
		self.logoPrimario = null;
		self.logoSecundario = null;
		self.favicon = null;
		self.logoWallet = null;
		self.logoWellcome = null;
		self.setTenantObj = {
			country: '',
			lenguage: '',
			activo: '',
			razonSocial: '',
			nombreComercial: '',
			identFiscal: '',
			direccion: '',
			poblacion: '',
			provincia: '',
			cp: '',
			telefono: '',
			web: '',
			email: '',
			numLicencias: '',
			logoPrimario: '',
			logoSecundario: '',
			favicon: '',
			logoWalletApp: '',
			logoWelcomeApp: '',
			colorPrimario: '',
			colorSecundario: ''
		};
	},

	setEvents() {
		let self = this;
		self.reset();

		let JSONuser = sessionStorage['STCMBackEnd:user'];
		let user = JSON.parse(JSONuser);
		let userMail = user.email;
		let user_split = userMail.split('@');
		self.user = user_split[0].replace('.', '_');

		// Reducción de Header
		headerSectionHeight(0);

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC1539 + ' - ' + pf.const.language.RSC225 + ' - ID: ' + self.idTenant);

		// Opciones de header
		let jsonsubopt = {
			back: 'back',
			save: 'save'
		};

		let nav = `
			${createSubOptionSave(jsonsubopt.save)}
			${createSubOptionBack(jsonsubopt.back)}
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		// Botón principal
		$('#save').addClass('main-button');

		// Botones secundarios
		$('#back').addClass('secondary-button');

		// Valores de configuración
		let config = JSON.parse(atob(sessionStorage.getItem('STCMBackEnd:config')));
		self.maxSize = config.upload_max_filesize_bytes;

		self.loadLang();
		self.applyEvents();

		addLoader();
		self.getTenantById();

		// Imagenes seleccionadas
		let raiz = stcm.const.downloads + 'tenants/' + self.idTenant;
		$('#logoPrimIMG').attr('src', raiz+ '/logo.png?stamp=' + new Date().getTime());
		$('#logoSecIMG').attr('src', raiz + '/logo_home.png?stamp=' + new Date().getTime());
		$('#faviconIMG').attr('src', raiz + '/favicon.ico?stamp=' + new Date().getTime());
		$('#logoWalletIMG').attr('src', raiz + '/wallet_card.png?stamp=' + new Date().getTime());
		$('#logoWellcomeIMG').attr('src', raiz + '/logo_welcome.png?stamp=' + new Date().getTime());

		// Collapse
		addEventArrowTableHeader();

		// Pintar texto de label
		changeLabelsColor();
	},

	loadLang() {
		pf.rsc.translateByTag('text');
	},

	applyEvents() {
		let self = this;

		stcmbackend.tenant.sharedEvents(self, 'editTenantCountry');

		// Apariencia y comportamiento de los inputs tipo 'color'
		inputTypeColorEvents();

		// Guardar nuevo tenant
		$('#save').off().on('click', function() {
			self.getFormTenant();
		});
	},

	getTenantById() {
		let self = this;

		let parameters = {
			idTenant: self.idTenant
		};
		ajaxComunCallWithCallback('getTenantById', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				self.data = ajaxReturn.result[0];
				self.setTenantObj = {
					country: self.data.country,
					lenguage: self.data.lenguage,
					activo: self.data.activo,
					razonSocial: self.data.razonSocial,
					nombreComercial: self.data.nombreComercial,
					identFiscal: self.data.identFiscal,
					direccion: self.data.direccion,
					poblacion: self.data.poblacion,
					provincia: self.data.provincia,
					cp: self.data.cp,
					telefono: self.data.telefono,
					web: self.data.web,
					email: self.data.email,
					numLicencias: self.data.numLicencias,
					logoPrimario: self.data.logoPrimario,
					logoSecundario: self.data.logoSecundario,
					favicon: self.data.favicon,
					logoWalletApp: self.data.logoWalletApp,
					logoWelcomeApp: self.data.logoWelcomeApp,
					colorPrimario: self.data.colorPrimario,
					colorSecundario: self.data.colorSecundario
				};
				ajaxComunCallWithCallback('getIdiomas', {}, function(ajaxReturn) {
					if(ajaxReturn) {
						let idiomas = ajaxReturn.result;

						// Búsqueda de idiomas activos y creación de select
						let options = '';
						let size = idiomas.length;
						for(let i = 0; i < size; i++) {
							if(idiomas[i].enabled == 1) {
								options += `<option value="${idiomas[i].isocode}">${idiomas[i].descripcion}</option>`;
							}
						}

						$('#idioma').html(options);
						$('#idioma').val(self.setTenantObj.lenguage);

						removeLoader();
					}
				}, false);

				// Tabla de resultados
				self.renderForm();
			}
		}, false);
	},

	renderForm() {
		let self = this;

		// País
		$('#pais').val(self.data.country);

		// Activo
		if(self.data.activo == '1') {
			$('#enable').prop('checked', true);
		}

		// Razón social
		$('#razonSocial').val(self.data.razonSocial);

		// Nombre comercial
		$('#nombreComercial').val(self.data.nombreComercial);

		// Identidad fiscal
		$('#identidadFiscal').val(self.data.identFiscal);

		// Dirección
		$('#direccion').val(self.data.direccion);

		// Población
		$('#poblacion').val(self.data.poblacion);

		// Provincia
		$('#provincia').val(self.data.provincia);

		// Código postal
		$('#codigoPostal').val(self.data.cp);

		// Teléfono
		$('#telefono').val(self.data.telefono);

		// Web
		$('#web').val(self.data.web);

		// E-mail
		$('#mail').val(self.data.email);

		// Número de licencias
		$('#numLicencias').val(self.data.numLicencias);

		// Color primario
		$('#colorPri').val(self.data.colorPrimario);
		$('#colorPriDiv').css('background-color', self.data.colorPrimario);

		// Color secundario
		$('#colorSec').val(self.data.colorSecundario);
		$('#colorSecDiv').css('background-color', self.data.colorSecundario);
	},

	getFormTenant() {
		let self = this;

		let check = true;
		let changes = false;

		// País
		let country = $('#pais').val();
		if(country == '') {
			check = false;
			$('#pais').addClass('is-invalid');
			$('[for="pais"]').addClass('is-invalid');
		} else {
			$('#pais').removeClass('is-invalid');
			$('[for="pais"]').removeClass('is-invalid');
			if(self.setTenantObj.country != country) {
				changes = true;
			}
		}

		// Idioma
		let lenguage = $('#idioma').val();
		if(self.setTenantObj.lenguage != lenguage) {
			changes = true;
		}

		// Activo
		let activo = ($('#enable').prop('checked') ? '1' : '0');
		if(self.setTenantObj.activo != activo) {
			changes = true;
		}

		// Razón social
		let razonSocial = $('#razonSocial').val().trim();
		if(razonSocial == '') {
			check = false;
			$('#razonSocial').addClass('is-invalid');
			$('[for="razonSocial"]').addClass('is-invalid');
		} else {
			$('#razonSocial').removeClass('is-invalid');
			$('[for="razonSocial"]').removeClass('is-invalid');
			if(self.setTenantObj.razonSocial != razonSocial) {
				changes = true;
			}
		}

		// Nombre comercial
		let nombreComercial = $('#nombreComercial').val().trim();
		if(nombreComercial == '') {
			check = false;
			$('#nombreComercial').addClass('is-invalid');
			$('[for="nombreComercial"]').addClass('is-invalid');
		} else {
			$('#nombreComercial').removeClass('is-invalid');
			$('[for="nombreComercial"]').removeClass('is-invalid');
			if(self.setTenantObj.nombreComercial != nombreComercial) {
				changes = true;
			}
		}

		// Identidad fiscal
		let identFiscal = $('#identidadFiscal').val().trim();
		if(identFiscal == '') {
			check = false;
			$('#identidadFiscal').addClass('is-invalid');
			$('[for="identidadFiscal"]').addClass('is-invalid');
		} else {
			$('#identidadFiscal').removeClass('is-invalid');
			$('[for="identidadFiscal"]').removeClass('is-invalid');
			if(self.setTenantObj.identFiscal != identFiscal) {
				changes = true;
			}
		}

		// Dirección
		let direccion = $('#direccion').val().trim();
		if(self.setTenantObj.direccion != direccion) {
			changes = true;
		}

		// Población
		let poblacion = $('#poblacion').val().trim();
		if(self.setTenantObj.poblacion != poblacion) {
			changes = true;
		}

		// Provincia
		let provincia = $('#provincia').val().trim();
		if(self.setTenantObj.provincia != provincia) {
			changes = true;
		}

		// Código postal
		let cp = $('#codigoPostal').val().trim();
		if(self.setTenantObj.cp != cp) {
			changes = true;
		}

		// Teléfono
		let telefono = $('#telefono').val().trim();
		if(telefono == '') {
			check = false;
			$('#telefono').addClass('is-invalid');
			$('[for="telefono"]').addClass('is-invalid');
		} else {
			$('#telefono').removeClass('is-invalid');
			$('[for="telefono"]').removeClass('is-invalid');
			if(self.setTenantObj.telefono != telefono) {
				changes = true;
			}
		}

		// Web
		let web = $('#web').val().trim();
		if(self.setTenantObj.web != web) {
			changes = true;
		}

		// E-mail
		let email = $('#mail').val().trim();
		if(email == '' || !pf.utils.validateEmail(email)) {
			$('#mail').addClass('is-invalid');
			$('[for="mail"]').addClass('is-invalid');
		} else {
			$('#mail').removeClass('is-invalid');
			$('[for="mail"]').removeClass('is-invalid');
			if(self.setTenantObj.email != email) {
				changes = true;
			}
		}

		// Número de licencias
		let numLicencias = $('#numLicencias').val();

		// Logo principal
		let logoPrimario = self.logoPrimario;

		// Logo secundario
		let logoSecundario = self.logoSecundario;

		// Favicon
		let favicon = self.favicon;

		// Logo wallet
		let logoWallet = self.logoWallet;

		// Logo wellcome
		let logoWellcome = self.logoWellcome;

		// Color primario
		let colorPrimario = $('#colorPri').val();
		if(self.setTenantObj.colorPrimario != colorPrimario) {
			changes = true;
		}

		// Color secundario
		let colorSecundario = $('#colorSec').val();
		if(self.setTenantObj.colorSecundario != colorSecundario) {
			changes = true;
		}

		// Comprobación
		if(!check) {
			let alertTitle = pf.const.language.RSC1539;
			let alertText = pf.const.language.RSC101;
			pf.utils.showInfoDialog(alertTitle, alertText);
		} else {
			self.setTenantObj = {
				country: country,
				lenguage: lenguage,
				activo: activo,
				razonSocial: razonSocial,
				nombreComercial: nombreComercial,
				identFiscal: identFiscal,
				direccion: direccion,
				poblacion: poblacion,
				provincia: provincia,
				cp: cp,
				telefono: telefono,
				web: web,
				email: email,
				numLicencias: numLicencias,
				logoPrimario: logoPrimario,
				logoSecundario: logoSecundario,
				favicon: favicon,
				logoWalletApp: logoWallet,
				logoWelcomeApp: logoWellcome,
				colorPrimario: colorPrimario,
				colorSecundario: colorSecundario
			};
			self.updateTenant(changes);
		}
	},

	updateTenant(changes) {
		let self = this;

		let parameters = {
			idTenant: self.idTenant,
			country: self.setTenantObj.country,
			lenguage: self.setTenantObj.lenguage,
			razonSocial: self.setTenantObj.razonSocial,
			nombreComercial: self.setTenantObj.nombreComercial,
			identFiscal: self.setTenantObj.identFiscal,
			direccion: self.setTenantObj.direccion,
			poblacion: self.setTenantObj.poblacion,
			provincia: self.setTenantObj.provincia,
			cp: self.setTenantObj.cp,
			telefono: self.setTenantObj.telefono,
			web: self.setTenantObj.web,
			email: self.setTenantObj.email,
			numLicencias: self.setTenantObj.numLicencias,
			activo: self.setTenantObj.activo,
			colorPrimario: self.setTenantObj.colorPrimario,
			colorSecundario: self.setTenantObj.colorSecundario,
			logoPrimario: self.setTenantObj.logoPrimario,
			logoSecundario: self.setTenantObj.logoSecundario,
			favicon: self.setTenantObj.favicon,
			logoWalletApp: self.setTenantObj.logoWalletApp,
			logoWelcomeApp: self.setTenantObj.logoWelcomeApp,
			urlLogos: stcm.const.downloads + 'tenants/',
			changes: changes
		};
		ajaxComunCallWithCallback('updateTenant', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let successTitle = pf.const.language.RSC1539;
				let successContent = pf.const.language.RSC1554;
				pf.utils.showInfoDialog(successTitle, successContent);
				window.location.href = '#!tenant';
			}
		});
	},

	clickEvents(data) {
		$('#pais').val(data.isocode);
	}
};