let NotificacionesNuevaController = {
	id: null,
	notificaciones: null,
	file: null,
	config: null,
	typeUsers: null,
	maxSize: 0,
	execute: false,
	isCopy: false,
	notification: null,

	resetData() {
		let self = this;

		self.notificaciones = null;
		self.file = null;
		self.config = null;
		self.typeUsers = null;
		self.maxSize = 0;
		self.execute = false;
		self.isCopy = false;
		self.notification = null;
	},

	setEvents() {
		let self = NotificacionesNuevaController;
		self.resetData();

		// Reducción de Header
		headerSectionHeight(0);

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC11 + ' - ' + pf.const.language.RSC8);

		// Ocultación en origen del input de adjunto
		$('#divsNotiArch').hide();

		// Opciones de header
		let jsonsubopt = {
			back: 'btn-back',
			save: 'saveNotif',
			saveExecute: 'btn-saveAndEx'
		};

		let nav = `
			<div class="row mx-0">
				${createSubOptionSave(jsonsubopt.save)}
				${createSubOptionSaveExecute(jsonsubopt.saveExecute)}
			</div>

			${createSubOptionBack(jsonsubopt.back)}
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		// Botón principal
		$('#btn-saveAndEx').addClass('main-button');

		// Botones secundarios
		$('#btn-back').addClass('secondary-button');
		$('#saveNotif').addClass('secondary-button');
		// Tamaño especial por ser botón secundario
		$('#saveNotif svg').css('width', '16px');
		$('#saveNotif svg').css('height', '16px');

		self.loadLanguage();

		// Cargar tiempos de ejecucion
		let times = '';
		for(let i = 1; i <= 60; i++) {
			times += `<option value="${i}">${i}</option>`;
		}
		$('#TiempoEntreEjecuciones').html(times);

		// Comprobar si es una copia
		let copy = sessionStorage['STCMBackEnd:isCopy'];
		if(copy == 'true') {
			let notification = sessionStorage['STCMBackEnd:editNotification'];
			self.notification = JSON.parse(notification);
			self.setInputsNotifications();
			sessionStorage['STCMBackEnd:isCopy'] = false;
		}

		// Obtener id a partir de la fecha
		self.getId();

		// País
		let countryModal = new TableCountries(0, 'newNotificacionCountry');
		$('#searchCountry').off().on('click', function() {
			countryModal.setEvents();
		});

		// Limpiar País
		$('#countryDelete').on('click', function() {
			$('#pais').val('');
			$('#countryDelete').hide();
		});

		// Abrir tabla usuarios
		let users = new TableUsers(0, 'newNotification', '', 1, 1, 1);
		$('#btn-users').click(function() {
			users.surname = false;
			self.typeUsers = 'aNotif';
			users.setEvents('tableModal');
		});
		$('#btn-users1').click(function() {
			users.surname = false;
			self.typeUsers = 'qNotif';
			users.setEvents('tableModal');
		});

		// Abrir tabla grupos
		let groups = new TableGroups(0, 'newNotification');
		$('#btn-group').click(function() {
			groups.setEvents('tableModal');
		});

		// Abrir tabla listas
		let lists = new TableLists(0, 'newNotification');
		$('#btn-list').click(function() {
			lists.setEvents('tableModal');
		});

		// Abrir tabla encuestas
		let surveys = new TableSurveys(0, 'newNotification');
		$('#btn-survey').click(function() {
			surveys.setEvents('tableModal');
		});

		$('#btn-file').click(function() {
			$('#ArchivoANotificarHidden').trigger('click');
		});

		$('#ArchivoANotificarHidden').change(function(evt) {
			self.file = evt.target.files[0];

			let inputFile = evt.target;
			let = typeSelect = $('#TipoArchivoANotificar').val();
			let = type = inputFile.files[0].type;
			let correctSyze = false;
			if(typeSelect == 'Imagen') {
				let ext = type.split('/');
				if(ext[1] == 'png' || ext[1] == 'gif' || ext[1] == 'bmp' || ext[1] == 'jpg' || ext[1] == 'jpeg') {
					correctSyze = true;
				}
			} else if(typeSelect == 'Video') {
				let ext = type.split('/');
				if(ext[1] == 'mp4' || ext[1] == 'mov' || ext[1] == 'avi') {
					correctSyze = true;
				}
			} else if(typeSelect == 'PDF') {
				let ext = type.split('/');
				if(ext[1] == 'pdf') {
					correctSyze = true;
				}
			}

			if(!correctSyze) {
				// Archivo a notificar
				let errorTitle = pf.const.language.RSC417;
				// Tipo de archivo no permitido
				let errorContent = pf.const.language.RSC507;
				pf.utils.showInfoDialog(errorTitle, errorContent);
				self.file = null;
				$('#ArchivoANotificar').val('');
			} else if(self.file.size > self.maxSize) {
				// Archivo a notificar
				let errorTitle = pf.const.language.RSC417;
				// EL tamaño del archivo supera el maáximo permitido
				let errorContent = pf.const.language.RSC439;
				pf.utils.showInfoDialog(errorTitle, errorContent);
				self.file = null;
				$('#ArchivoANotificar').val('');
			} else {
				$('#ArchivoANotificar').val(inputFile.files[0].name);
			}
		});

		// Guardar notificacion
		$('#saveNotif').click(function() {
			let objInfo = {
				accept: {
					text: pf.const.language.RSC78
				},
				cancel: {
					text: pf.const.language.RSC57
				}
			};

			let alertTitle = pf.const.language.RSC11;
			let alertText = pf.const.language.RSC441;
			pf.utils.showInfoDialogAcceptCancel(alertTitle, alertText, objInfo, function() {
				self.getInputsNotifications();
			}, function() {});
		});

		// Guardar y ejecutar notificacion
		$('#btn-saveAndEx').click(function() {
			self.execute = true;
			let objInfo = {
				accept: {
					text: pf.const.language.RSC78
				},
				cancel: {
					text: pf.const.language.RSC57
				}
			};

			let alertTitle = pf.const.language.RSC11;
			let alertText = pf.const.language.RSC441;
			pf.utils.showInfoDialogAcceptCancel(alertTitle, alertText, objInfo, function() {
				self.getInputsNotifications(true);
			}, function() {});
		});

		stcmbackend.notificaciones.sharedEvents(self);

		// Collapse
		addEventArrowTableHeader();

		// Pintar texto de label
		changeLabelsColor();

		// Ocultar cubos de basura
		$('#userDelete').hide();
		$('#groupDelete').hide();
		$('#listDelete').hide();
		$('#countryDelete').hide();
	},

	getId() {
		let self = this;

		ajaxComunCallWithCallbackOne('getIdNotifications', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				let resp = JSON.parse(ajaxReturn.resData.response);
				self.id = resp.result;
				$('#id').val(self.id);
			}
		});
	},

	clickUser(user) {
		let self = this;

		if(self.typeUsers == 'aNotif') {
			$('#UsuarioANotificar').text(user.id);
			$('#DescUsuarioANotificar').val(user.email);
			$('#userDelete').show();
		} else {
			$('#UsuarioQueNotifica').text(user.id);
			$('#DescUsuarioQueNotifica').val(user.email);
		}
	},

	clickGroup(group) {
		$('#DescGrupoANotificar').val(group.name);
		$('#GrupoANotificar').text(group.groupName);
		$('#groupDelete').show();
	},

	clickList(list) {
		$('#ListaANotificar').text(list.id);
		$('#DescListaANotificar').val(list.Descripcion);
		$('#listDelete').show();
	},

	clickSurvey(survey) {
		$('#EncuestaANotificar').text(survey.sid);
		$('#DescEncuestaANotificar').val(survey.surveyls_title);
	},

	getInputsNotifications(execute = false) {
		let self = this;

		// Obtener valores de los inputs
		let id = $('#id').val();
		let Activa;
		if($('#Activa').prop('checked')) {
			Activa = 1;
		} else {
			Activa = 0;
		}
		let Descripcion = $('#Descripcion').val().trim();
		if(Descripcion == '') {
			$('#Descripcion').addClass('is-invalid');
			$('[for="Descripcion"]').addClass('is-invalid');
			let alertTitle = pf.const.language.RSC11;
			let alertText = pf.const.language.RSC101;
			pf.utils.showInfoDialog(alertTitle, alertText);
			return false;
		} else {
			$('#Descripcion').removeClass('is-invalid');
			$('[for="Descripcion"]').removeClass('is-invalid');
		}

		// Tipo notificacion variaciones
		let TipoNotificacion;
		if($('#TipoNotificacion1:checked').val()) {
			TipoNotificacion = $('#TipoNotificacion1:checked').val();
		} else if($('#TipoNotificacion2:checked').val()) {
			TipoNotificacion = $('#TipoNotificacion2:checked').val();
		} else if($('#TipoNotificacion3:checked').val()) {
			TipoNotificacion = $('#TipoNotificacion3:checked').val();
		}
		let TiempoEntreEjecuciones, UnidadDeTiempo, NumVecesCiclica, FechaHoraEjecucionUnica, Aux01;
		switch(TipoNotificacion) {
			case '0':
				TiempoEntreEjecuciones = '';
				UnidadDeTiempo = '';
				NumVecesCiclica = '';
				FechaHoraEjecucionUnica = '';
				Activa = 0;
				Aux01 = '';
				break;
			case '1':
				TiempoEntreEjecuciones = $('#TiempoEntreEjecuciones').val();
				UnidadDeTiempo = $('#UnidadDeTiempo').val();
				NumVecesCiclica = $('#NumVecesCiclica').val();
				FechaHoraEjecucionUnica = '';
				Aux01 = '';
				break;
			case '2':
				let date = $('#FechaHoraEjecucionUnicaDate').val();
				let hours = parseInt($('#hour').val());
				let mins = parseInt($('#mins').val());
				let dateArray = date.split('-');
				let sOptAMPM;
				if(self.config.FormatoHoraServer == 24) {
					sOptAMPM = 24;
				} else {
					sOptAMPM = $('#mins').val(sOptAMPM);
				}

				let scheduleControl = false;

				if(date === '') {
					scheduleControl = true;
					$('#FechaHoraEjecucionUnicaDate').addClass('is-invalid');
					$('[for="FechaHoraEjecucionUnicaDate"]').addClass('is-invalid');
				} else {
					$('#FechaHoraEjecucionUnicaDate').removeClass('is-invalid');
					$('[for="FechaHoraEjecucionUnicaDate"]').removeClass('is-invalid');
				}

				if(hours === '' || hours < 0 || hours > 23) {
					scheduleControl = true;
					$('#hour').addClass('is-invalid');
					$('[for="hour"]').addClass('is-invalid');
				} else {
					$('#hour').removeClass('is-invalid');
					$('[for="hour"]').removeClass('is-invalid');
					if(isNaN(hours)) {
						hours = 0;
					}
					if(hours < 10) {
						hours = '0' + hours;
						$('#hour').val(hours);
					}
				}

				if(mins === '' || mins < 0 || mins > 59) {
					scheduleControl = true;
					$('#mins').addClass('is-invalid');
					$('[for="mins"]').addClass('is-invalid');
				} else {
					$('#mins').removeClass('is-invalid');
					$('[for="mins"]').removeClass('is-invalid');
					if(isNaN(mins)) {
						mins = 0;
					}
					if(mins < 10) {
						mins = '0' + mins;
						$('#mins').val(mins);
					}
				}

				if(scheduleControl) {
					let alertText = pf.const.language.RSC101;
					$.alert({
						boxWidth: '500px',
						title: '<h3 class="ma-bo-20">' + pf.const.language.RSC11 + '</h3>',
						content: alertText,
						useBootstrap: false,
						bgOpacity: null,
						theme: 'new-style',
						buttons: {
							accept: {
								text: pf.const.language.RSC132,
								btnClass: 'new-style-accept',
								action() {
									//
								}
							}
						}
					});
					return false;
				}

				FechaHoraEjecucionUnica = dateArray[2] + '/' + dateArray[1] + '/' + dateArray[0] + '#' + hours + '#' + mins + '#' + sOptAMPM;
				Aux01 = dateArray[2] + '/' + dateArray[1] + '/' + dateArray[0] + ' ' + hours + ':' + mins + ':00 ' + sOptAMPM;
				TiempoEntreEjecuciones = '';
				UnidadDeTiempo = '';
				NumVecesCiclica = '';
				break;
		}
		let EstiloNotificacion;
		if($('#EstiloNotificacion1:checked').val()) {
			EstiloNotificacion = $('#EstiloNotificacion1:checked').val();
		} else if($('#EstiloNotificacion2:checked').val()) {
			EstiloNotificacion = $('#EstiloNotificacion2:checked').val();
		}
		let UsuarioQueNotifica, DescUsuarioQueNotifica;
		if(EstiloNotificacion == 0) {
			UsuarioQueNotifica = self.config.SYSNotifUser;
			DescUsuarioQueNotifica = self.config.SYSNotifUserName;
		} else {
			UsuarioQueNotifica = $('#UsuarioQueNotifica').text();
			DescUsuarioQueNotifica = $('#DescUsuarioQueNotifica').val();

			if(UsuarioQueNotifica == '' || DescUsuarioQueNotifica == '') {
				$('#DescUsuarioQueNotifica').addClass('is-invalid');
				$('[for="DescUsuarioQueNotifica"]').addClass('is-invalid');
				let alertTitle = pf.const.language.RSC11;
				let alertText = pf.const.language.RSC101;
				pf.utils.showInfoDialog(alertTitle, alertText);
				return false;
			} else {
				$('#DescUsuarioQueNotifica').removeClass('is-invalid');
				$('[for="DescUsuarioQueNotifica"]').removeClass('is-invalid');
			}
		}

		let UsuarioANotificar = $('#UsuarioANotificar').text();
		let DescUsuarioANotificar = $('#DescUsuarioANotificar').val();
		let GrupoANotificar = $('#GrupoANotificar').text();
		let DescGrupoANotificar = $('#DescGrupoANotificar').val();
		let ListaANotificar = $('#ListaANotificar').text();
		let DescListaANotificar = $('#DescListaANotificar').val();

		// Control de destinatario para notificaciones a ejecutar
		if(execute && UsuarioANotificar == '' && GrupoANotificar == '' && ListaANotificar == '') {
			$('#DescUsuarioANotificar').addClass('is-invalid');
			$('[for="DescUsuarioANotificar"]').addClass('is-invalid');
			$('#DescGrupoANotificar').addClass('is-invalid');
			$('[for="DescGrupoANotificar"]').addClass('is-invalid');
			$('#DescListaANotificar').addClass('is-invalid');
			$('[for="DescListaANotificar"]').addClass('is-invalid');

			let alertTitle = pf.const.language.RSC11;
			let alertText = pf.const.language.RSC2609;
			pf.utils.showInfoDialog(alertTitle, alertText);
			return false;
		} else {
			$('#DescUsuarioANotificar').removeClass('is-invalid');
			$('[for="DescUsuarioANotificar"]').removeClass('is-invalid');
			$('#DescGrupoANotificar').removeClass('is-invalid');
			$('[for="DescGrupoANotificar"]').removeClass('is-invalid');
			$('#DescListaANotificar').removeClass('is-invalid');
			$('[for="DescListaANotificar"]').removeClass('is-invalid');
		}

		let MotivoNotificacion;
		if($('#MotivoNotificacion1:checked').val()) {
			MotivoNotificacion = $('#MotivoNotificacion1:checked').val();
		} else if($('#MotivoNotificacion2:checked').val()) {
			MotivoNotificacion = $('#MotivoNotificacion2:checked').val();
		} else if($('#MotivoNotificacion3:checked').val()) {
			MotivoNotificacion = $('#MotivoNotificacion3:checked').val();
		}
		let ArchivoANotificar, TipoArchivoANotificar;
		let MensajeANotificar = $('#MensajeANotificar').val();
		let EncuestaANotificar = $('#EncuestaANotificar').text();
		let DescEncuestaANotificar = $('#DescEncuestaANotificar').val();

		// Comprobar valores en funcion del motivo notificacion
		switch(MotivoNotificacion) {
			case '0':
				ArchivoANotificar = '';
				TipoArchivoANotificar = '';
				EncuestaANotificar = '';
				DescEncuestaANotificar = '';
				break;
			case '1':
				ArchivoANotificar = self.file;
				TipoArchivoANotificar = $('#TipoArchivoANotificar').val();
				EncuestaANotificar = '';
				DescEncuestaANotificar = '';
				break;
			case '2':
				ArchivoANotificar = '';
				TipoArchivoANotificar = '';
				MensajeANotificar = '';
				break;
		}
		let user = JSON.parse(sessionStorage['STCMBackEnd:user']);
		let UsuarioAlta = user.email;
		let reqName = '';
		if(execute) {
			reqName = 'setCMBPNotificationsAndExecute';
		} else {
			reqName = 'setCMBPNotifications';
		}

		let parameters = {
			excecute: self.execute,
			id: id,
			Descripcion: Descripcion,
			TipoNotificacion: TipoNotificacion,
			TiempoEntreEjecuciones: TiempoEntreEjecuciones,
			UnidadDeTiempo: UnidadDeTiempo,
			FechaHoraEjecucionUnica: FechaHoraEjecucionUnica,
			Activa: Activa,
			EstiloNotificacion: EstiloNotificacion,
			UsuarioQueNotifica: UsuarioQueNotifica,
			DescUsuarioQueNotifica: DescUsuarioQueNotifica,
			UsuarioANotificar: UsuarioANotificar,
			DescUsuarioANotificar: DescUsuarioANotificar,
			GrupoANotificar: GrupoANotificar,
			DescGrupoANotificar: DescGrupoANotificar,
			ListaANotificar: ListaANotificar,
			DescListaANotificar: DescListaANotificar,
			MotivoNotificacion: MotivoNotificacion,
			ArchivoANotificar: ArchivoANotificar,
			TipoArchivoANotificar: TipoArchivoANotificar,
			MensajeANotificar: MensajeANotificar,
			EncuestaANotificar: EncuestaANotificar,
			DescEncuestaANotificar: DescEncuestaANotificar,
			UsuarioAlta: UsuarioAlta,
			FechaAlta: '',
			UsuarioUltimaModificacion: UsuarioAlta,
			FechaUltimaModificacion: '',
			FechaUltimaEjecucion: '',
			Observaciones1: '',
			Observaciones2: '',
			Aux01: Aux01,
			Aux02: '',
			Aux03: '',
			Aux04: '',
			Aux05: '',
			NumVecesCiclica: NumVecesCiclica,
			country: $('#pais').val()
		};
		ajaxComunCallWithCallbackOne(reqName, parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let resp = JSON.parse(ajaxReturn.resData.response);
				if(resp.status === 'OK') {
					let alertTitle = pf.const.language.RSC11;
					let alertText = pf.const.language.RSC440;
					let alertBtn = pf.const.language.RSC132;
					pf.utils.showInfoDialog(alertTitle, alertText, alertBtn, function() {
						window.location.href = '#!notificaciones';
					});
				} else {
					let errorTitle = pf.const.language.RSC61;
					let errorContent = resp.result;
					if(resp.resp == 'image') {
						errorContent = pf.const.language.RSC477;
					}
					pf.utils.showInfoDialog(errorTitle, errorContent);
					if(resp.result == 'Not authorized') {
						pf.ajax.setWindowLocationIndex();
					}
				}
			}
		});
	},

	setInputsNotifications() {
		let self = NotificacionesNuevaController;

		addLoader();
		// Damos valores a los inputs
		$('#Activa').val(self.notification.Activa);
		$('#Descripcion').val(self.notification.Descripcion);

		$('.option-box-check').removeClass('option-box-check-selected');
		$('.option-box-check-2').removeClass('option-box-check-selected');

		// Tipo notificacion
		switch(parseInt(self.notification.TipoNotificacion)) {
			case 0:
				$('#TipoNotificacion1').prop('checked', true);
				$('#TipoNotificacion1').parent().addClass('option-box-check-selected');
				$('#TipoNotificacion2').prop('checked', false);
				$('#TipoNotificacion3').prop('checked', false);
				$('#ciclica').addClass('d-none');
				$('#programada').addClass('d-none');
				$('#Activa').prop('disabled', true);
				$('#Activa').prop('checked', false);
				break;
			case 1:
				$('#TipoNotificacion1').prop('checked', false);
				$('#TipoNotificacion2').prop('checked', true);
				$('#TipoNotificacion2').parent().addClass('option-box-check-selected');
				$('#TipoNotificacion3').prop('checked', false);
				$('#ciclica').removeClass('d-none');
				$('#programada').addClass('d-none');
				$('#Activa').prop('disabled', false);
				break;
			case 2:
				$('#TipoNotificacion1').prop('checked', false);
				$('#TipoNotificacion2').prop('checked', false);
				$('#TipoNotificacion3').prop('checked', true);
				$('#TipoNotificacion3').parent().addClass('option-box-check-selected');
				$('#ciclica').addClass('d-none');
				$('#programada').removeClass('d-none');
				$('#Activa').prop('disabled', false);
				break;
		}
		$('#TiempoEntreEjecuciones').val(self.notification.TiempoEntreEjecuciones);
		$('#UnidadDeTiempo').val(self.notification.UnidadDeTiempo);
		$('#NumVecesCiclica').val(self.notification.NumVecesCiclica);
		$('#NumVecesEjecutada').val(self.notification.NumVecesEjecutada);

		// Fecha Hora Ejecucion Unica
		let date = self.notification.FechaHoraEjecucionUnica.split('#');
		let dateFormat = date[0].split('/');
		$('#FechaHoraEjecucionUnicaDate').val(dateFormat[2] + '-' + dateFormat[1] + '-' + dateFormat[0]);
		$('#hour').val(date[1]);
		$('#mins').val(date[2]);
		if(date[3] == 'a.m.') {
			$('#sOptAMPM').val('a.m.');
		} else if(date[3] == 'p.m.') {
			$('#sOptAMPM').val('p.m.');
		}

		// Estilo comunicacion
		switch(parseInt(self.notification.EstiloNotificacion)) {
			case 0:
				$('#EstiloNotificacion1').prop('checked', true);
				$('#EstiloNotificacion2').prop('checked', false);
				$('#estilo').addClass('d-none');
				break;
			case 1:
				$('#EstiloNotificacion1').prop('checked', false);
				$('#EstiloNotificacion1').prop('checked', true);
				$('#estilo').removeClass('d-none');
				break;
		}

		$('#UsuarioQueNotifica').text(self.notification.UsuarioQueNotifica);
		$('#DescUsuarioQueNotifica').val(self.notification.DescUsuarioQueNotifica);
		$('#UsuarioANotificar').text(self.notification.UsuarioANotificar);
		$('#DescUsuarioANotificar').val(self.notification.DescUsuarioANotificar);
		$('#GrupoANotificar').text(self.notification.GrupoANotificar);
		$('#DescGrupoANotificar').val(self.notification.DescGrupoANotificar);
		$('#ListaANotificar').text(self.notification.ListaANotificar);
		$('#DescListaANotificar').val(self.notification.DescListaANotificar);

		// Motivo notificacion
		switch(parseInt(self.notification.MotivoNotificacion)) {
			case 0:
				$('#MotivoNotificacion1').prop('checked', true);
				$('#MotivoNotificacion1').parent().addClass('option-box-check-selected');
				$('#MotivoNotificacion2').prop('checked', false);
				$('#MotivoNotificacion3').prop('checked', false);
				$('#divsNotiMsg').removeClass('d-none');
				$('#divsNotiArch').hide();
				$('#btn-file').attr('disabled', true);
				$('#TipoArchivoANotificar').attr('disabled', true);
				$('#divsNotifSurvey').addClass('d-none');
				break;
			case 1:
				$('#MotivoNotificacion1').prop('checked', false);
				$('#MotivoNotificacion2').prop('checked', true);
				$('#MotivoNotificacion2').parent().addClass('option-box-check-selected');
				$('#MotivoNotificacion3').prop('checked', false);
				$('#divsNotiMsg').removeClass('d-none');
				$('#divsNotiArch').show();
				$('#btn-file').attr('disabled', false);
				$('#TipoArchivoANotificar').attr('disabled', false);
				$('#divsNotifSurvey').addClass('d-none');
				break;
			case 2:
				$('#MotivoNotificacion1').prop('checked', false);
				$('#MotivoNotificacion2').prop('checked', false);
				$('#MotivoNotificacion3').prop('checked', true);
				$('#MotivoNotificacion3').parent().addClass('option-box-check-selected');
				$('#divsNotiMsg').addClass('d-none');
				$('#divsNotiArch').hide();
				$('#btn-file').attr('disabled', true);
				$('#TipoArchivoANotificar').attr('disabled', true);
				$('#divsNotifSurvey').removeClass('d-none');
				break;
		}
		$('#MensajeANotificar').val(self.notification.MensajeANotificar);
		$('#EncuestaANotificar').text(self.notification.EncuestaANotificar);
		$('#DescEncuestaANotificar').val(self.notification.DescEncuestaANotificar);
		removeLoader();
	},

	loadLanguage() {
		pf.rsc.translateByTag('text');
		pf.rsc.translateByTag('placeholder');
	},

	clickEvents(data) {
		$('#pais').val(data.isocode);
		$('#countryDelete').show();
	}
};