stcmbackend.notificaciones = {
	sharedEvents(self) {
		// Vover a Notificaciones
		$('#btn-back').on('click', function() {
			window.location.href = '#!notificaciones';
		});

		// Restricciones de carácteres por tecla
		$('.ovSpecChars').off().on('keypress', function(e) {
			// Parámetros: tecla, warningTitle, warningContent y pattern si no es el general
			let result = characterRestrictionsPerKey(e.keyCode, pf.const.language.RSC375, pf.const.language.RSC1762);

			return result;
		});

		// Restricciones de carácteres por pegado
		$('.ovSpecChars').on('paste', function() {
			// Parámetros: elemento, warningTitle, warningContent y pattern si no es el general
			characterRestrictionsPerPaste($(this), pf.const.language.RSC375, pf.const.language.RSC1762);
		});

		// Collapse
		addEventArrowTableHeader();

		// Limpiar usuario a notificar
		$('#userDelete').on('click', function() {
			$('#UsuarioANotificar').text('');
			$('#DescUsuarioANotificar').val('');
			$('#userDelete').hide();
		});

		// Limpiar grupo a notificar
		$('#groupDelete').on('click', function() {
			$('#GrupoANotificar').text('');
			$('#DescGrupoANotificar').val('');
			$('#groupDelete').hide();
		});

		// Limpiar lista a notificar
		$('#listDelete').on('click', function() {
			$('#ListaANotificar').text('');
			$('#DescListaANotificar').val('');
			$('#listDelete').hide();
		});

		// Emoji picker
		$('#MensajeANotificar').emojioneArea();

		// Detectar cambio Tipo Notificacion
		$('#TipoNotificacion1').click(function() {
			$('#ciclica').addClass('d-none');
			$('#programada').addClass('d-none');
			$('#Activa').prop('disabled', true);
			$('#Activa').prop('checked', false);
			// Opciones
			$('#saveNotif').show();
			$('#btn-saveAndEx').show();

			$('.option-box-check').removeClass('option-box-check-selected');
			$(this).parent().addClass('option-box-check-selected');
		});
		$('#TipoNotificacion2').click(function() {
			$('#ciclica').removeClass('d-none');
			$('#programada').addClass('d-none');
			$('#Activa').prop('disabled', false);
			$('#Activa').prop('checked', true);
			// Opciones
			$('#saveNotif').show();
			$('#btn-saveAndEx').hide();

			$('.option-box-check').removeClass('option-box-check-selected');
			$(this).parent().addClass('option-box-check-selected');
		});
		$('#TipoNotificacion3').click(function() {
			$('#ciclica').addClass('d-none');
			$('#programada').removeClass('d-none');
			$('#Activa').prop('disabled', false);
			$('#Activa').prop('checked', true);
			// Opciones
			$('#saveNotif').show();
			$('#btn-saveAndEx').hide();

			$('.option-box-check').removeClass('option-box-check-selected');
			$(this).parent().addClass('option-box-check-selected');
		});

		// Detectar cambio Estilo comunicacion
		$('#EstiloNotificacion1').click(function() {
			$('#estilo').addClass('d-none');
		});
		$('#EstiloNotificacion2').click(function() {
			$('#estilo').removeClass('d-none');
		});

		// Detectar cambio Motivo Notificacion
		$('#MotivoNotificacion1').click(function() {
			$('#divsNotiMsg').removeClass('d-none');
			$('#divsNotiArch').hide();
			$('#btn-file').attr('disabled', true);
			$('#TipoArchivoANotificar').attr('disabled', true);
			$('#divsNotifSurvey').addClass('d-none');

			$('.option-box-check-2').removeClass('option-box-check-selected');
			$(this).parent().addClass('option-box-check-selected');
		});
		$('#MotivoNotificacion2').click(function() {
			$('#divsNotiMsg').removeClass('d-none');
			$('#divsNotiArch').show();
			$('#btn-file').attr('disabled', false);
			$('#TipoArchivoANotificar').attr('disabled', false);
			$('#divsNotifSurvey').addClass('d-none');

			$('.option-box-check-2').removeClass('option-box-check-selected');
			$(this).parent().addClass('option-box-check-selected');
		});
		$('#MotivoNotificacion3').click(function() {
			$('#divsNotiMsg').addClass('d-none');
			$('#divsNotiArch').hide();
			$('#btn-file').attr('disabled', true);
			$('#TipoArchivoANotificar').attr('disabled', true);
			$('#divsNotifSurvey').removeClass('d-none');

			$('.option-box-check-2').removeClass('option-box-check-selected');
			$(this).parent().addClass('option-box-check-selected');
		});

		// Detectar cambio de tipos de ficheros
		$('#TipoArchivoANotificar').change(function() {
			$('#ArchivoANotificar').val('');
			self.file = null;
			let type = $('#TipoArchivoANotificar').val();
			switch(type) {
				case 'PDF':
					$('#ArchivoANotificarHidden').attr('accept', 'application/pdf');
					break;
				case 'Imagen':
					$('#ArchivoANotificarHidden').attr('accept', 'image/*');
					break;
				case 'Video':
					$('#ArchivoANotificarHidden').attr('accept', 'video/*');
					break;
				default:
					break;
			}
		});

		// Valores de configuración
		self.config = JSON.parse(atob(sessionStorage.getItem('STCMBackEnd:config')));
		self.maxSize = self.config.upload_max_filesize_bytes;
		if(self.config.FormatoHoraServer == '12') {
			$('#formatH').removeClass('d-none');
			$('#FechaHoraEjecucionUnicaTime').attr('max', 12);
		}
	}
};