let PagosAutomatizadosController = {
	language: null,
	data: '',
	arrayDelMult: [],

	reset() {
		let self = this;

		self.language = pf.const.language_table;
		self.data = '';
		self.arrayDelMult = [];
	},

	setEvents() {
		let self = this;
		self.reset();

		// Reducción de Header
		headerSectionHeight(0);

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC1330);

		// Opciones de header
		let jsonsubopt = {
			new: 'new',
			export: 'export'
		};

		let nav = `
			${createSubOptionNew(jsonsubopt.new)}
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		$('#new svg').css({'width': '24px', 'height': '24px'});

		// Botón principal
		$('#new').addClass('main-button');

		self.loadLang();
		self.applyEvents();

		self.getScheduledPayment();

		// Collapse
		addEventArrowTableHeader();
	},

	loadLang() {
		pf.rsc.translateByTag('text');

		// TITLES
		$('.exportTitle').attr('title', pf.const.language.RSC47);
		$('.deleteMultTitle').attr('title', pf.const.language.RSC95);
	},

	applyEvents() {
		// Nuevo
		$('#new').on('click', function() {
			window.location.href = '#!pagos_automatizados_new';
		});
	},

	getScheduledPayment() {
		let self = this;

		ajaxComunCallWithCallback('getScheduledPayment', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				self.data = ajaxReturn.result;

				// Tabla de resultados
				self.renderData();
			}
		});
	},

	renderData() {
		let self = this;

		$('#resultTable').show();

		let table = `
			<thead>
				<tr>
					<th class="text-center" scope="col" title="">
						<div class="div-global-selection">
							<input type="checkbox" class="globalSelection">
						</div>
					</th>
					<th scope="col" title="${pf.const.language.RSC550}">${pf.const.language.RSC550}</th>
					<th scope="col" title="${pf.const.language.RSC1349}">${pf.const.language.RSC1349}</th>
					<th scope="col" title="${pf.const.language.RSC342}">${pf.const.language.RSC342}</th>
					<th scope="col" title="${pf.const.language.RSC301}">${pf.const.language.RSC301}</th>
					<th scope="col" title="${pf.const.language.RSC410}">${pf.const.language.RSC410}</th>
					<th scope="col" title="${pf.const.language.RSC412}">${pf.const.language.RSC412}</th>
					<th scope="col" title="${pf.const.language.RSC126}">${pf.const.language.RSC126}</th>
					<th scope="col" title="${pf.const.language.RSC2516}">${pf.const.language.RSC2516}</th>
				</tr>
			</thead>

			<thead class="filtersResult">
				<tr>
					<td>selector</td>
					<td>pais</td>
					<td>Intervalo</td>
					<td>UnidadDeTiempo</td>
					<td>UsuarioANotificar</td>
					<td>GrupoANotificar</td>
					<td>ListaANotificar</td>
					<td>enabled</td>
					<td>acciones</td>
				</tr>
			</thead>

			<tbody>
		`;

		// Obtener países permitidos
		let allowedCountries = JSON.parse(atob(sessionStorage['STCMBackEnd:userCountries']));
		let size = self.data.length;
		for(let i = 0; i < size; i++) {
			// Control de países permitidos
			if(self.data[i].country != '' && allowedCountries.indexOf(self.data[i].country) == -1) {
				continue;
			}

			table += `
				<tr data-id="${self.data[i].id}">
					<td class="text-center">
						<div class="div-single-selection" data-id="${self.data[i].id}">
							<input type="checkbox" class="deleteSelection">
						</div>
					</td>
					<td class="text-truncate c-pointer editRow" title="${self.data[i].country}">${self.data[i].country}</td>
					<td class="text-center c-pointer editRow" title="${self.data[i].TiempoEntreEjecuciones}">${self.data[i].TiempoEntreEjecuciones}</td>
					<td class="text-truncate c-pointer editRow" title="${self.data[i].UnidadDeTiempo}">${self.data[i].UnidadDeTiempo}</td>
					<td class="text-truncate c-pointer editRow" title="${(self.data[i].UsuarioANotificarDesc || '-')}">${(self.data[i].UsuarioANotificarDesc || '-')}</td>
					<td class="text-truncate c-pointer editRow" title="${(self.data[i].GrupoANotificarDesc || '-')}">${(self.data[i].GrupoANotificarDesc || '-')}</td>
					<td class="text-truncate c-pointer editRow" title="${(self.data[i].ListaANotificarDesc || '-')}">${(self.data[i].ListaANotificarDesc || '-')}</td>
					<td class="text-center c-pointer editRow">
						<span class="d-none">${(self.data[i].Activa == '1' ? pf.const.language.RSC120 : pf.const.language.RSC121)}</span>
						<input type="checkbox" class="activa" disabled ${(self.data[i].Activa == '1' ? 'checked' : '')}>
					</td>
					<td class="text-center">
						<div id="dropdownActions${i}" class="div-dd-actions c-pointer" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
							${stcmbackend.svg.threeDotsVertical18}
						</div>

						<div class="dropdown-menu dropdown-menu-right shadow menu-actions" aria-labelledby="dropdownActions${i}" data-id="${self.data[i].id}">
							<p class="dropdown-item editRow">
								${stcmbackend.svg.pencilWithoutColor}
								<span>${pf.const.language.RSC225}</span>
							</p>
							<p class="dropdown-item deleteRow">
								${stcmbackend.svg.trashWithoutColor}
								<span>${pf.const.language.RSC95}</span>
							</p>
						</div>
					</td>
				</tr>
			`;
		}

		table += `
			</tbody>
		`;

		$('#registers').html(table);

		// Setup - add a text input to each footer cell
		$('#registers .filtersResult td').each(function() {
			let title = $(this).text();
			let value = `<input type="text" class="form-control form-control-sm">`;

			if(title == 'enabled') {
				value = optionsSelectAllYesNo();
			} else if(title == 'selector' || title == 'acciones') {
				value = `<input type="text" class="form-control form-control-sm" disabled>`;
			}

			$(this).html(value);
		});

		let dataTable = $('#registers').DataTable({
			retrieve: true,
			language: self.language,
			pageLength: 25,
			autoWidth: false,
			columnDefs: [
				{width: '25px', orderable: false, targets: 0},
				{width: '60px', targets: 1},
				{width: '60px', targets: 2},
				{width: '60px', targets: 3},
				{width: '60px', targets: 7},
				{width: '60px', orderable: false, targets: 8}
			],
			dom: 'Bfrtip',
			buttons: [{
				extend: 'excelHtml5',
				text: pf.const.language.RSC1330,
				className: 'd-none',
				title: pf.const.language.RSC1330,
				exportOptions: {
					columns: [1, 2, 3, 4, 5, 6, 7, 8]
				},
				customize(xlsx) {
					dataTablesExcelCustomize(xlsx);
				}
			}],
			aaSorting: []
		});

		// Ocultar botones de tabla
		hideTableButtons('registers');

		// Apply the search
		applyTheSearch(dataTable, 'filtersResult');

		// Exportar tabla
		$('#export').off().on('click', function() {
			$('#resultTable .buttons-excel').trigger('click');
		});

		self.tableEvents(dataTable);

		$('#resultTable').on('draw.dt', function() {
			self.tableEvents(dataTable);
		});
	},

	tableEvents(dataTable) {
		let self = this;

		// Eventos del input global
		globalSelectionInputActions();

		// Editar Pago automatizado
		$('.editRow').off().on('click', function() {
			let id = $(this).parent().data('id');

			sessionStorage.setItem('idPagoAut', btoa(id));
			window.location.href = '#!pagos_automatizados_edit';
		});

		// Borrar Pago automatizado
		$('.deleteRow').off().on('click', function() {
			let id = $(this).parent().data('id');

			let objInfo = {
				accept: {
					text: pf.const.language.RSC95
				},
				cancel: {
					text: pf.const.language.RSC57
				}
			};

			let alertTitle = pf.const.language.RSC1330;
			let alertText = pf.const.language.RSC1347;
			pf.utils.showInfoDialogAcceptCancel(alertTitle, alertText, objInfo, function() {
				self.deleteScheduledPayment(id);
			}, function() {});
		});

		// Array de eliminado múltiple
		$('.deleteSelection').off().on('change', function() {
			let value = $(this).prop('checked');
			let id = $(this).parent().data('id');

			if(value) {
				self.arrayDelMult.push(id);
			} else {
				let index = self.arrayDelMult.indexOf(id);
				self.arrayDelMult.splice(index, 1);
			}

			// Eventos de los inputs individuales
			deleteSelectionInputActions(self.arrayDelMult);
		});

		// Función de borrado múltiple
		$('#multSelecDelete').off().on('click', function() {
			// Aviso de borrado múltiple
			let objInfo = {
				accept: {
					text: pf.const.language.RSC95
				},
				cancel: {
					text: pf.const.language.RSC57
				}
			};

			let alertTitle = pf.const.language.RSC1330;
			let alertText = pf.const.language.RSC1697;
			pf.utils.showInfoDialogAcceptCancel(alertTitle, alertText, objInfo, function() {
				self.deleteScheduledPayment();
			}, function() {});
		});
	},

	deleteScheduledPayment(id = false) {
		let self = this;

		let scheduledPayments = [];
		if(id !== false) {
			let obj = {
				id: id
			}
			scheduledPayments.push(obj);
		} else {
			let delSize = self.arrayDelMult.length;
			for(let i = 0; i < delSize; i++) {
				let obj = {
					id: self.arrayDelMult[i]
				}
				scheduledPayments.push(obj);
			}
			self.arrayDelMult = [];
		}

		let parameters = {
			scheduledPayments: JSON.stringify(scheduledPayments)
		};
		ajaxComunCallWithCallback('deleteScheduledPayment', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let successTitle = pf.const.language.RSC1330;
				let successContent = pf.const.language.RSC1348;
				pf.utils.showInfoDialog(successTitle, successContent);
				loadHTML('inc/pagos/pagos_automatizados.html', 'wrapper', PagosAutomatizadosController);
			}
		});
	}
};